/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProgramRequest extends MediaTailorRequest implements
        ToCopyableBuilder<CreateProgramRequest.Builder, CreateProgramRequest> {
    private static final SdkField<List<AdBreak>> AD_BREAKS_FIELD = SdkField
            .<List<AdBreak>> builder(MarshallingType.LIST)
            .memberName("AdBreaks")
            .getter(getter(CreateProgramRequest::adBreaks))
            .setter(setter(Builder::adBreaks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdBreaks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdBreak> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdBreak::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(CreateProgramRequest::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()).build();

    private static final SdkField<String> LIVE_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LiveSourceName").getter(getter(CreateProgramRequest::liveSourceName))
            .setter(setter(Builder::liveSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LiveSourceName").build()).build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgramName").getter(getter(CreateProgramRequest::programName)).setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ProgramName").build()).build();

    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField
            .<ScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScheduleConfiguration")
            .getter(getter(CreateProgramRequest::scheduleConfiguration)).setter(setter(Builder::scheduleConfiguration))
            .constructor(ScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build())
            .build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(CreateProgramRequest::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build())
            .build();

    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VodSourceName").getter(getter(CreateProgramRequest::vodSourceName))
            .setter(setter(Builder::vodSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()).build();

    private static final SdkField<List<AudienceMedia>> AUDIENCE_MEDIA_FIELD = SdkField
            .<List<AudienceMedia>> builder(MarshallingType.LIST)
            .memberName("AudienceMedia")
            .getter(getter(CreateProgramRequest::audienceMedia))
            .setter(setter(Builder::audienceMedia))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudienceMedia").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudienceMedia> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudienceMedia::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_BREAKS_FIELD,
            CHANNEL_NAME_FIELD, LIVE_SOURCE_NAME_FIELD, PROGRAM_NAME_FIELD, SCHEDULE_CONFIGURATION_FIELD,
            SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD, AUDIENCE_MEDIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AdBreak> adBreaks;

    private final String channelName;

    private final String liveSourceName;

    private final String programName;

    private final ScheduleConfiguration scheduleConfiguration;

    private final String sourceLocationName;

    private final String vodSourceName;

    private final List<AudienceMedia> audienceMedia;

    private CreateProgramRequest(BuilderImpl builder) {
        super(builder);
        this.adBreaks = builder.adBreaks;
        this.channelName = builder.channelName;
        this.liveSourceName = builder.liveSourceName;
        this.programName = builder.programName;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
        this.audienceMedia = builder.audienceMedia;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdBreaks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAdBreaks() {
        return adBreaks != null && !(adBreaks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ad break configuration settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdBreaks} method.
     * </p>
     * 
     * @return The ad break configuration settings.
     */
    public final List<AdBreak> adBreaks() {
        return adBreaks;
    }

    /**
     * <p>
     * The name of the channel for this Program.
     * </p>
     * 
     * @return The name of the channel for this Program.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name of the LiveSource for this Program.
     * </p>
     * 
     * @return The name of the LiveSource for this Program.
     */
    public final String liveSourceName() {
        return liveSourceName;
    }

    /**
     * <p>
     * The name of the Program.
     * </p>
     * 
     * @return The name of the Program.
     */
    public final String programName() {
        return programName;
    }

    /**
     * <p>
     * The schedule configuration settings.
     * </p>
     * 
     * @return The schedule configuration settings.
     */
    public final ScheduleConfiguration scheduleConfiguration() {
        return scheduleConfiguration;
    }

    /**
     * <p>
     * The name of the source location.
     * </p>
     * 
     * @return The name of the source location.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    /**
     * <p>
     * The name that's used to refer to a VOD source.
     * </p>
     * 
     * @return The name that's used to refer to a VOD source.
     */
    public final String vodSourceName() {
        return vodSourceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudienceMedia property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAudienceMedia() {
        return audienceMedia != null && !(audienceMedia instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of AudienceMedia defined in program.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudienceMedia} method.
     * </p>
     * 
     * @return The list of AudienceMedia defined in program.
     */
    public final List<AudienceMedia> audienceMedia() {
        return audienceMedia;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdBreaks() ? adBreaks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(liveSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(vodSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAudienceMedia() ? audienceMedia() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProgramRequest)) {
            return false;
        }
        CreateProgramRequest other = (CreateProgramRequest) obj;
        return hasAdBreaks() == other.hasAdBreaks() && Objects.equals(adBreaks(), other.adBreaks())
                && Objects.equals(channelName(), other.channelName()) && Objects.equals(liveSourceName(), other.liveSourceName())
                && Objects.equals(programName(), other.programName())
                && Objects.equals(scheduleConfiguration(), other.scheduleConfiguration())
                && Objects.equals(sourceLocationName(), other.sourceLocationName())
                && Objects.equals(vodSourceName(), other.vodSourceName()) && hasAudienceMedia() == other.hasAudienceMedia()
                && Objects.equals(audienceMedia(), other.audienceMedia());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProgramRequest").add("AdBreaks", hasAdBreaks() ? adBreaks() : null)
                .add("ChannelName", channelName()).add("LiveSourceName", liveSourceName()).add("ProgramName", programName())
                .add("ScheduleConfiguration", scheduleConfiguration()).add("SourceLocationName", sourceLocationName())
                .add("VodSourceName", vodSourceName()).add("AudienceMedia", hasAudienceMedia() ? audienceMedia() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdBreaks":
            return Optional.ofNullable(clazz.cast(adBreaks()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "LiveSourceName":
            return Optional.ofNullable(clazz.cast(liveSourceName()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        case "ScheduleConfiguration":
            return Optional.ofNullable(clazz.cast(scheduleConfiguration()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        case "VodSourceName":
            return Optional.ofNullable(clazz.cast(vodSourceName()));
        case "AudienceMedia":
            return Optional.ofNullable(clazz.cast(audienceMedia()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdBreaks", AD_BREAKS_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("LiveSourceName", LIVE_SOURCE_NAME_FIELD);
        map.put("ProgramName", PROGRAM_NAME_FIELD);
        map.put("ScheduleConfiguration", SCHEDULE_CONFIGURATION_FIELD);
        map.put("SourceLocationName", SOURCE_LOCATION_NAME_FIELD);
        map.put("VodSourceName", VOD_SOURCE_NAME_FIELD);
        map.put("AudienceMedia", AUDIENCE_MEDIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProgramRequest, T> g) {
        return obj -> g.apply((CreateProgramRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProgramRequest> {
        /**
         * <p>
         * The ad break configuration settings.
         * </p>
         * 
         * @param adBreaks
         *        The ad break configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adBreaks(Collection<AdBreak> adBreaks);

        /**
         * <p>
         * The ad break configuration settings.
         * </p>
         * 
         * @param adBreaks
         *        The ad break configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adBreaks(AdBreak... adBreaks);

        /**
         * <p>
         * The ad break configuration settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.AdBreak.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mediatailor.model.AdBreak#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.AdBreak.Builder#build()} is called immediately and
         * its result is passed to {@link #adBreaks(List<AdBreak>)}.
         * 
         * @param adBreaks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.AdBreak.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adBreaks(java.util.Collection<AdBreak>)
         */
        Builder adBreaks(Consumer<AdBreak.Builder>... adBreaks);

        /**
         * <p>
         * The name of the channel for this Program.
         * </p>
         * 
         * @param channelName
         *        The name of the channel for this Program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name of the LiveSource for this Program.
         * </p>
         * 
         * @param liveSourceName
         *        The name of the LiveSource for this Program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder liveSourceName(String liveSourceName);

        /**
         * <p>
         * The name of the Program.
         * </p>
         * 
         * @param programName
         *        The name of the Program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);

        /**
         * <p>
         * The schedule configuration settings.
         * </p>
         * 
         * @param scheduleConfiguration
         *        The schedule configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration);

        /**
         * <p>
         * The schedule configuration settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleConfiguration(ScheduleConfiguration)}.
         * 
         * @param scheduleConfiguration
         *        a consumer that will call methods on {@link ScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfiguration(ScheduleConfiguration)
         */
        default Builder scheduleConfiguration(Consumer<ScheduleConfiguration.Builder> scheduleConfiguration) {
            return scheduleConfiguration(ScheduleConfiguration.builder().applyMutation(scheduleConfiguration).build());
        }

        /**
         * <p>
         * The name of the source location.
         * </p>
         * 
         * @param sourceLocationName
         *        The name of the source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        /**
         * <p>
         * The name that's used to refer to a VOD source.
         * </p>
         * 
         * @param vodSourceName
         *        The name that's used to refer to a VOD source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vodSourceName(String vodSourceName);

        /**
         * <p>
         * The list of AudienceMedia defined in program.
         * </p>
         * 
         * @param audienceMedia
         *        The list of AudienceMedia defined in program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceMedia(Collection<AudienceMedia> audienceMedia);

        /**
         * <p>
         * The list of AudienceMedia defined in program.
         * </p>
         * 
         * @param audienceMedia
         *        The list of AudienceMedia defined in program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceMedia(AudienceMedia... audienceMedia);

        /**
         * <p>
         * The list of AudienceMedia defined in program.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.AudienceMedia.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediatailor.model.AudienceMedia#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.AudienceMedia.Builder#build()} is called immediately
         * and its result is passed to {@link #audienceMedia(List<AudienceMedia>)}.
         * 
         * @param audienceMedia
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.AudienceMedia.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audienceMedia(java.util.Collection<AudienceMedia>)
         */
        Builder audienceMedia(Consumer<AudienceMedia.Builder>... audienceMedia);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private List<AdBreak> adBreaks = DefaultSdkAutoConstructList.getInstance();

        private String channelName;

        private String liveSourceName;

        private String programName;

        private ScheduleConfiguration scheduleConfiguration;

        private String sourceLocationName;

        private String vodSourceName;

        private List<AudienceMedia> audienceMedia = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProgramRequest model) {
            super(model);
            adBreaks(model.adBreaks);
            channelName(model.channelName);
            liveSourceName(model.liveSourceName);
            programName(model.programName);
            scheduleConfiguration(model.scheduleConfiguration);
            sourceLocationName(model.sourceLocationName);
            vodSourceName(model.vodSourceName);
            audienceMedia(model.audienceMedia);
        }

        public final List<AdBreak.Builder> getAdBreaks() {
            List<AdBreak.Builder> result = ___listOfAdBreakCopier.copyToBuilder(this.adBreaks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdBreaks(Collection<AdBreak.BuilderImpl> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copyFromBuilder(adBreaks);
        }

        @Override
        public final Builder adBreaks(Collection<AdBreak> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copy(adBreaks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(AdBreak... adBreaks) {
            adBreaks(Arrays.asList(adBreaks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(Consumer<AdBreak.Builder>... adBreaks) {
            adBreaks(Stream.of(adBreaks).map(c -> AdBreak.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getLiveSourceName() {
            return liveSourceName;
        }

        public final void setLiveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
        }

        @Override
        public final Builder liveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
            return this;
        }

        public final String getProgramName() {
            return programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfiguration() {
            return scheduleConfiguration != null ? scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(ScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final String getVodSourceName() {
            return vodSourceName;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        public final List<AudienceMedia.Builder> getAudienceMedia() {
            List<AudienceMedia.Builder> result = ___listOfAudienceMediaCopier.copyToBuilder(this.audienceMedia);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudienceMedia(Collection<AudienceMedia.BuilderImpl> audienceMedia) {
            this.audienceMedia = ___listOfAudienceMediaCopier.copyFromBuilder(audienceMedia);
        }

        @Override
        public final Builder audienceMedia(Collection<AudienceMedia> audienceMedia) {
            this.audienceMedia = ___listOfAudienceMediaCopier.copy(audienceMedia);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceMedia(AudienceMedia... audienceMedia) {
            audienceMedia(Arrays.asList(audienceMedia));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceMedia(Consumer<AudienceMedia.Builder>... audienceMedia) {
            audienceMedia(Stream.of(audienceMedia).map(c -> AudienceMedia.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProgramRequest build() {
            return new CreateProgramRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
