/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Program transition configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProgramTransition implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateProgramTransition.Builder, UpdateProgramTransition> {
    private static final SdkField<Long> SCHEDULED_START_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ScheduledStartTimeMillis").getter(getter(UpdateProgramTransition::scheduledStartTimeMillis))
            .setter(setter(Builder::scheduledStartTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledStartTimeMillis").build())
            .build();

    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMillis").getter(getter(UpdateProgramTransition::durationMillis))
            .setter(setter(Builder::durationMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SCHEDULED_START_TIME_MILLIS_FIELD, DURATION_MILLIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long scheduledStartTimeMillis;

    private final Long durationMillis;

    private UpdateProgramTransition(BuilderImpl builder) {
        this.scheduledStartTimeMillis = builder.scheduledStartTimeMillis;
        this.durationMillis = builder.durationMillis;
    }

    /**
     * <p>
     * The date and time that the program is scheduled to start, in epoch milliseconds.
     * </p>
     * 
     * @return The date and time that the program is scheduled to start, in epoch milliseconds.
     */
    public final Long scheduledStartTimeMillis() {
        return scheduledStartTimeMillis;
    }

    /**
     * <p>
     * The duration of the live program in seconds.
     * </p>
     * 
     * @return The duration of the live program in seconds.
     */
    public final Long durationMillis() {
        return durationMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledStartTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(durationMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProgramTransition)) {
            return false;
        }
        UpdateProgramTransition other = (UpdateProgramTransition) obj;
        return Objects.equals(scheduledStartTimeMillis(), other.scheduledStartTimeMillis())
                && Objects.equals(durationMillis(), other.durationMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProgramTransition").add("ScheduledStartTimeMillis", scheduledStartTimeMillis())
                .add("DurationMillis", durationMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledStartTimeMillis":
            return Optional.ofNullable(clazz.cast(scheduledStartTimeMillis()));
        case "DurationMillis":
            return Optional.ofNullable(clazz.cast(durationMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScheduledStartTimeMillis", SCHEDULED_START_TIME_MILLIS_FIELD);
        map.put("DurationMillis", DURATION_MILLIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProgramTransition, T> g) {
        return obj -> g.apply((UpdateProgramTransition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateProgramTransition> {
        /**
         * <p>
         * The date and time that the program is scheduled to start, in epoch milliseconds.
         * </p>
         * 
         * @param scheduledStartTimeMillis
         *        The date and time that the program is scheduled to start, in epoch milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledStartTimeMillis(Long scheduledStartTimeMillis);

        /**
         * <p>
         * The duration of the live program in seconds.
         * </p>
         * 
         * @param durationMillis
         *        The duration of the live program in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMillis(Long durationMillis);
    }

    static final class BuilderImpl implements Builder {
        private Long scheduledStartTimeMillis;

        private Long durationMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProgramTransition model) {
            scheduledStartTimeMillis(model.scheduledStartTimeMillis);
            durationMillis(model.durationMillis);
        }

        public final Long getScheduledStartTimeMillis() {
            return scheduledStartTimeMillis;
        }

        public final void setScheduledStartTimeMillis(Long scheduledStartTimeMillis) {
            this.scheduledStartTimeMillis = scheduledStartTimeMillis;
        }

        @Override
        public final Builder scheduledStartTimeMillis(Long scheduledStartTimeMillis) {
            this.scheduledStartTimeMillis = scheduledStartTimeMillis;
            return this;
        }

        public final Long getDurationMillis() {
            return durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        @Override
        public UpdateProgramTransition build() {
            return new UpdateProgramTransition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
