/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorAsyncClient;
import software.amazon.awssdk.services.mediatailor.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse;
import software.amazon.awssdk.services.mediatailor.model.PlaybackConfiguration;

public class ListPlaybackConfigurationsPublisher
implements SdkPublisher<ListPlaybackConfigurationsResponse> {
    private final MediaTailorAsyncClient client;
    private final ListPlaybackConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPlaybackConfigurationsPublisher(MediaTailorAsyncClient client, ListPlaybackConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPlaybackConfigurationsPublisher(MediaTailorAsyncClient client, ListPlaybackConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPlaybackConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPlaybackConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PlaybackConfiguration> items() {
        Function<ListPlaybackConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPlaybackConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPlaybackConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListPlaybackConfigurationsResponse> {
        private ListPlaybackConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlaybackConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPlaybackConfigurationsResponse> nextPage(ListPlaybackConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListPlaybackConfigurationsPublisher.this.client.listPlaybackConfigurations(ListPlaybackConfigurationsPublisher.this.firstRequest);
            }
            return ListPlaybackConfigurationsPublisher.this.client.listPlaybackConfigurations((ListPlaybackConfigurationsRequest)((Object)ListPlaybackConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

