/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An AudienceMedia object contains an Audience and a list of AlternateMedia.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudienceMedia implements SdkPojo, Serializable, ToCopyableBuilder<AudienceMedia.Builder, AudienceMedia> {
    private static final SdkField<List<AlternateMedia>> ALTERNATE_MEDIA_FIELD = SdkField
            .<List<AlternateMedia>> builder(MarshallingType.LIST)
            .memberName("AlternateMedia")
            .getter(getter(AudienceMedia::alternateMedia))
            .setter(setter(Builder::alternateMedia))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateMedia").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlternateMedia> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlternateMedia::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUDIENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Audience").getter(getter(AudienceMedia::audience)).setter(setter(Builder::audience))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audience").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALTERNATE_MEDIA_FIELD,
            AUDIENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AlternateMedia> alternateMedia;

    private final String audience;

    private AudienceMedia(BuilderImpl builder) {
        this.alternateMedia = builder.alternateMedia;
        this.audience = builder.audience;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlternateMedia property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlternateMedia() {
        return alternateMedia != null && !(alternateMedia instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of AlternateMedia defined in AudienceMedia.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlternateMedia} method.
     * </p>
     * 
     * @return The list of AlternateMedia defined in AudienceMedia.
     */
    public final List<AlternateMedia> alternateMedia() {
        return alternateMedia;
    }

    /**
     * <p>
     * The Audience defined in AudienceMedia.
     * </p>
     * 
     * @return The Audience defined in AudienceMedia.
     */
    public final String audience() {
        return audience;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAlternateMedia() ? alternateMedia() : null);
        hashCode = 31 * hashCode + Objects.hashCode(audience());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceMedia)) {
            return false;
        }
        AudienceMedia other = (AudienceMedia) obj;
        return hasAlternateMedia() == other.hasAlternateMedia() && Objects.equals(alternateMedia(), other.alternateMedia())
                && Objects.equals(audience(), other.audience());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudienceMedia").add("AlternateMedia", hasAlternateMedia() ? alternateMedia() : null)
                .add("Audience", audience()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlternateMedia":
            return Optional.ofNullable(clazz.cast(alternateMedia()));
        case "Audience":
            return Optional.ofNullable(clazz.cast(audience()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AlternateMedia", ALTERNATE_MEDIA_FIELD);
        map.put("Audience", AUDIENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudienceMedia, T> g) {
        return obj -> g.apply((AudienceMedia) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudienceMedia> {
        /**
         * <p>
         * The list of AlternateMedia defined in AudienceMedia.
         * </p>
         * 
         * @param alternateMedia
         *        The list of AlternateMedia defined in AudienceMedia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateMedia(Collection<AlternateMedia> alternateMedia);

        /**
         * <p>
         * The list of AlternateMedia defined in AudienceMedia.
         * </p>
         * 
         * @param alternateMedia
         *        The list of AlternateMedia defined in AudienceMedia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateMedia(AlternateMedia... alternateMedia);

        /**
         * <p>
         * The list of AlternateMedia defined in AudienceMedia.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.AlternateMedia.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediatailor.model.AlternateMedia#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.AlternateMedia.Builder#build()} is called
         * immediately and its result is passed to {@link #alternateMedia(List<AlternateMedia>)}.
         * 
         * @param alternateMedia
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.AlternateMedia.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alternateMedia(java.util.Collection<AlternateMedia>)
         */
        Builder alternateMedia(Consumer<AlternateMedia.Builder>... alternateMedia);

        /**
         * <p>
         * The Audience defined in AudienceMedia.
         * </p>
         * 
         * @param audience
         *        The Audience defined in AudienceMedia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audience(String audience);
    }

    static final class BuilderImpl implements Builder {
        private List<AlternateMedia> alternateMedia = DefaultSdkAutoConstructList.getInstance();

        private String audience;

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceMedia model) {
            alternateMedia(model.alternateMedia);
            audience(model.audience);
        }

        public final List<AlternateMedia.Builder> getAlternateMedia() {
            List<AlternateMedia.Builder> result = ___listOfAlternateMediaCopier.copyToBuilder(this.alternateMedia);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlternateMedia(Collection<AlternateMedia.BuilderImpl> alternateMedia) {
            this.alternateMedia = ___listOfAlternateMediaCopier.copyFromBuilder(alternateMedia);
        }

        @Override
        public final Builder alternateMedia(Collection<AlternateMedia> alternateMedia) {
            this.alternateMedia = ___listOfAlternateMediaCopier.copy(alternateMedia);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateMedia(AlternateMedia... alternateMedia) {
            alternateMedia(Arrays.asList(alternateMedia));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateMedia(Consumer<AlternateMedia.Builder>... alternateMedia) {
            alternateMedia(Stream.of(alternateMedia).map(c -> AlternateMedia.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAudience() {
            return audience;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        @Override
        public AudienceMedia build() {
            return new AudienceMedia(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
