/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains settings that determine how and when that MediaTailor places prefetched ads into
 * upcoming ad breaks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrefetchConsumption implements SdkPojo, Serializable,
        ToCopyableBuilder<PrefetchConsumption.Builder, PrefetchConsumption> {
    private static final SdkField<List<AvailMatchingCriteria>> AVAIL_MATCHING_CRITERIA_FIELD = SdkField
            .<List<AvailMatchingCriteria>> builder(MarshallingType.LIST)
            .memberName("AvailMatchingCriteria")
            .getter(getter(PrefetchConsumption::availMatchingCriteria))
            .setter(setter(Builder::availMatchingCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailMatchingCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailMatchingCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailMatchingCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(PrefetchConsumption::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(PrefetchConsumption::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAIL_MATCHING_CRITERIA_FIELD,
            END_TIME_FIELD, START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AvailMatchingCriteria> availMatchingCriteria;

    private final Instant endTime;

    private final Instant startTime;

    private PrefetchConsumption(BuilderImpl builder) {
        this.availMatchingCriteria = builder.availMatchingCriteria;
        this.endTime = builder.endTime;
        this.startTime = builder.startTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailMatchingCriteria property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAvailMatchingCriteria() {
        return availMatchingCriteria != null && !(availMatchingCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you only want MediaTailor to insert prefetched ads into avails (ad breaks) that match specific dynamic
     * variables, such as <code>scte.event_id</code>, set the avail matching criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailMatchingCriteria} method.
     * </p>
     * 
     * @return If you only want MediaTailor to insert prefetched ads into avails (ad breaks) that match specific dynamic
     *         variables, such as <code>scte.event_id</code>, set the avail matching criteria.
     */
    public final List<AvailMatchingCriteria> availMatchingCriteria() {
        return availMatchingCriteria;
    }

    /**
     * <p>
     * The time when MediaTailor no longer considers the prefetched ads for use in an ad break. MediaTailor
     * automatically deletes prefetch schedules no less than seven days after the end time. If you'd like to manually
     * delete the prefetch schedule, you can call <code>DeletePrefetchSchedule</code>.
     * </p>
     * 
     * @return The time when MediaTailor no longer considers the prefetched ads for use in an ad break. MediaTailor
     *         automatically deletes prefetch schedules no less than seven days after the end time. If you'd like to
     *         manually delete the prefetch schedule, you can call <code>DeletePrefetchSchedule</code>.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The time when prefetched ads are considered for use in an ad break. If you don't specify <code>StartTime</code>,
     * the prefetched ads are available after MediaTailor retrives them from the ad decision server.
     * </p>
     * 
     * @return The time when prefetched ads are considered for use in an ad break. If you don't specify
     *         <code>StartTime</code>, the prefetched ads are available after MediaTailor retrives them from the ad
     *         decision server.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailMatchingCriteria() ? availMatchingCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefetchConsumption)) {
            return false;
        }
        PrefetchConsumption other = (PrefetchConsumption) obj;
        return hasAvailMatchingCriteria() == other.hasAvailMatchingCriteria()
                && Objects.equals(availMatchingCriteria(), other.availMatchingCriteria())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrefetchConsumption")
                .add("AvailMatchingCriteria", hasAvailMatchingCriteria() ? availMatchingCriteria() : null)
                .add("EndTime", endTime()).add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailMatchingCriteria":
            return Optional.ofNullable(clazz.cast(availMatchingCriteria()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailMatchingCriteria", AVAIL_MATCHING_CRITERIA_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrefetchConsumption, T> g) {
        return obj -> g.apply((PrefetchConsumption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrefetchConsumption> {
        /**
         * <p>
         * If you only want MediaTailor to insert prefetched ads into avails (ad breaks) that match specific dynamic
         * variables, such as <code>scte.event_id</code>, set the avail matching criteria.
         * </p>
         * 
         * @param availMatchingCriteria
         *        If you only want MediaTailor to insert prefetched ads into avails (ad breaks) that match specific
         *        dynamic variables, such as <code>scte.event_id</code>, set the avail matching criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availMatchingCriteria(Collection<AvailMatchingCriteria> availMatchingCriteria);

        /**
         * <p>
         * If you only want MediaTailor to insert prefetched ads into avails (ad breaks) that match specific dynamic
         * variables, such as <code>scte.event_id</code>, set the avail matching criteria.
         * </p>
         * 
         * @param availMatchingCriteria
         *        If you only want MediaTailor to insert prefetched ads into avails (ad breaks) that match specific
         *        dynamic variables, such as <code>scte.event_id</code>, set the avail matching criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availMatchingCriteria(AvailMatchingCriteria... availMatchingCriteria);

        /**
         * <p>
         * If you only want MediaTailor to insert prefetched ads into avails (ad breaks) that match specific dynamic
         * variables, such as <code>scte.event_id</code>, set the avail matching criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.AvailMatchingCriteria.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mediatailor.model.AvailMatchingCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.AvailMatchingCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #availMatchingCriteria(List<AvailMatchingCriteria>)}.
         * 
         * @param availMatchingCriteria
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.AvailMatchingCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availMatchingCriteria(java.util.Collection<AvailMatchingCriteria>)
         */
        Builder availMatchingCriteria(Consumer<AvailMatchingCriteria.Builder>... availMatchingCriteria);

        /**
         * <p>
         * The time when MediaTailor no longer considers the prefetched ads for use in an ad break. MediaTailor
         * automatically deletes prefetch schedules no less than seven days after the end time. If you'd like to
         * manually delete the prefetch schedule, you can call <code>DeletePrefetchSchedule</code>.
         * </p>
         * 
         * @param endTime
         *        The time when MediaTailor no longer considers the prefetched ads for use in an ad break. MediaTailor
         *        automatically deletes prefetch schedules no less than seven days after the end time. If you'd like to
         *        manually delete the prefetch schedule, you can call <code>DeletePrefetchSchedule</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The time when prefetched ads are considered for use in an ad break. If you don't specify
         * <code>StartTime</code>, the prefetched ads are available after MediaTailor retrives them from the ad decision
         * server.
         * </p>
         * 
         * @param startTime
         *        The time when prefetched ads are considered for use in an ad break. If you don't specify
         *        <code>StartTime</code>, the prefetched ads are available after MediaTailor retrives them from the ad
         *        decision server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl implements Builder {
        private List<AvailMatchingCriteria> availMatchingCriteria = DefaultSdkAutoConstructList.getInstance();

        private Instant endTime;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PrefetchConsumption model) {
            availMatchingCriteria(model.availMatchingCriteria);
            endTime(model.endTime);
            startTime(model.startTime);
        }

        public final List<AvailMatchingCriteria.Builder> getAvailMatchingCriteria() {
            List<AvailMatchingCriteria.Builder> result = ___listOfAvailMatchingCriteriaCopier
                    .copyToBuilder(this.availMatchingCriteria);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailMatchingCriteria(Collection<AvailMatchingCriteria.BuilderImpl> availMatchingCriteria) {
            this.availMatchingCriteria = ___listOfAvailMatchingCriteriaCopier.copyFromBuilder(availMatchingCriteria);
        }

        @Override
        public final Builder availMatchingCriteria(Collection<AvailMatchingCriteria> availMatchingCriteria) {
            this.availMatchingCriteria = ___listOfAvailMatchingCriteriaCopier.copy(availMatchingCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availMatchingCriteria(AvailMatchingCriteria... availMatchingCriteria) {
            availMatchingCriteria(Arrays.asList(availMatchingCriteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availMatchingCriteria(Consumer<AvailMatchingCriteria.Builder>... availMatchingCriteria) {
            availMatchingCriteria(Stream.of(availMatchingCriteria)
                    .map(c -> AvailMatchingCriteria.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public PrefetchConsumption build() {
            return new PrefetchConsumption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
