/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.AudiencesCopier;
import software.amazon.awssdk.services.mediatailor.model.ScheduleAdBreak;
import software.amazon.awssdk.services.mediatailor.model.ScheduleEntryType;
import software.amazon.awssdk.services.mediatailor.model.___listOfScheduleAdBreakCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduleEntry> {
    private static final SdkField<Long> APPROXIMATE_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateDurationSeconds").getter(ScheduleEntry.getter(ScheduleEntry::approximateDurationSeconds)).setter(ScheduleEntry.setter(Builder::approximateDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateDurationSeconds").build()}).build();
    private static final SdkField<Instant> APPROXIMATE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ApproximateStartTime").getter(ScheduleEntry.getter(ScheduleEntry::approximateStartTime)).setter(ScheduleEntry.setter(Builder::approximateStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ScheduleEntry.getter(ScheduleEntry::arn)).setter(ScheduleEntry.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(ScheduleEntry.getter(ScheduleEntry::channelName)).setter(ScheduleEntry.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> LIVE_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LiveSourceName").getter(ScheduleEntry.getter(ScheduleEntry::liveSourceName)).setter(ScheduleEntry.setter(Builder::liveSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LiveSourceName").build()}).build();
    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramName").getter(ScheduleEntry.getter(ScheduleEntry::programName)).setter(ScheduleEntry.setter(Builder::programName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgramName").build()}).build();
    private static final SdkField<List<ScheduleAdBreak>> SCHEDULE_AD_BREAKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduleAdBreaks").getter(ScheduleEntry.getter(ScheduleEntry::scheduleAdBreaks)).setter(ScheduleEntry.setter(Builder::scheduleAdBreaks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleAdBreaks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduleAdBreak::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEDULE_ENTRY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleEntryType").getter(ScheduleEntry.getter(ScheduleEntry::scheduleEntryTypeAsString)).setter(ScheduleEntry.setter(Builder::scheduleEntryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleEntryType").build()}).build();
    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLocationName").getter(ScheduleEntry.getter(ScheduleEntry::sourceLocationName)).setter(ScheduleEntry.setter(Builder::sourceLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build()}).build();
    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VodSourceName").getter(ScheduleEntry.getter(ScheduleEntry::vodSourceName)).setter(ScheduleEntry.setter(Builder::vodSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()}).build();
    private static final SdkField<List<String>> AUDIENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Audiences").getter(ScheduleEntry.getter(ScheduleEntry::audiences)).setter(ScheduleEntry.setter(Builder::audiences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audiences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROXIMATE_DURATION_SECONDS_FIELD, APPROXIMATE_START_TIME_FIELD, ARN_FIELD, CHANNEL_NAME_FIELD, LIVE_SOURCE_NAME_FIELD, PROGRAM_NAME_FIELD, SCHEDULE_AD_BREAKS_FIELD, SCHEDULE_ENTRY_TYPE_FIELD, SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD, AUDIENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduleEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long approximateDurationSeconds;
    private final Instant approximateStartTime;
    private final String arn;
    private final String channelName;
    private final String liveSourceName;
    private final String programName;
    private final List<ScheduleAdBreak> scheduleAdBreaks;
    private final String scheduleEntryType;
    private final String sourceLocationName;
    private final String vodSourceName;
    private final List<String> audiences;

    private ScheduleEntry(BuilderImpl builder) {
        this.approximateDurationSeconds = builder.approximateDurationSeconds;
        this.approximateStartTime = builder.approximateStartTime;
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.liveSourceName = builder.liveSourceName;
        this.programName = builder.programName;
        this.scheduleAdBreaks = builder.scheduleAdBreaks;
        this.scheduleEntryType = builder.scheduleEntryType;
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
        this.audiences = builder.audiences;
    }

    public final Long approximateDurationSeconds() {
        return this.approximateDurationSeconds;
    }

    public final Instant approximateStartTime() {
        return this.approximateStartTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String liveSourceName() {
        return this.liveSourceName;
    }

    public final String programName() {
        return this.programName;
    }

    public final boolean hasScheduleAdBreaks() {
        return this.scheduleAdBreaks != null && !(this.scheduleAdBreaks instanceof SdkAutoConstructList);
    }

    public final List<ScheduleAdBreak> scheduleAdBreaks() {
        return this.scheduleAdBreaks;
    }

    public final ScheduleEntryType scheduleEntryType() {
        return ScheduleEntryType.fromValue(this.scheduleEntryType);
    }

    public final String scheduleEntryTypeAsString() {
        return this.scheduleEntryType;
    }

    public final String sourceLocationName() {
        return this.sourceLocationName;
    }

    public final String vodSourceName() {
        return this.vodSourceName;
    }

    public final boolean hasAudiences() {
        return this.audiences != null && !(this.audiences instanceof SdkAutoConstructList);
    }

    public final List<String> audiences() {
        return this.audiences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.liveSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.programName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduleAdBreaks() ? this.scheduleAdBreaks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleEntryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vodSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudiences() ? this.audiences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleEntry)) {
            return false;
        }
        ScheduleEntry other = (ScheduleEntry)obj;
        return Objects.equals(this.approximateDurationSeconds(), other.approximateDurationSeconds()) && Objects.equals(this.approximateStartTime(), other.approximateStartTime()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.liveSourceName(), other.liveSourceName()) && Objects.equals(this.programName(), other.programName()) && this.hasScheduleAdBreaks() == other.hasScheduleAdBreaks() && Objects.equals(this.scheduleAdBreaks(), other.scheduleAdBreaks()) && Objects.equals(this.scheduleEntryTypeAsString(), other.scheduleEntryTypeAsString()) && Objects.equals(this.sourceLocationName(), other.sourceLocationName()) && Objects.equals(this.vodSourceName(), other.vodSourceName()) && this.hasAudiences() == other.hasAudiences() && Objects.equals(this.audiences(), other.audiences());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduleEntry").add("ApproximateDurationSeconds", (Object)this.approximateDurationSeconds()).add("ApproximateStartTime", (Object)this.approximateStartTime()).add("Arn", (Object)this.arn()).add("ChannelName", (Object)this.channelName()).add("LiveSourceName", (Object)this.liveSourceName()).add("ProgramName", (Object)this.programName()).add("ScheduleAdBreaks", this.hasScheduleAdBreaks() ? this.scheduleAdBreaks() : null).add("ScheduleEntryType", (Object)this.scheduleEntryTypeAsString()).add("SourceLocationName", (Object)this.sourceLocationName()).add("VodSourceName", (Object)this.vodSourceName()).add("Audiences", this.hasAudiences() ? this.audiences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApproximateDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.approximateDurationSeconds()));
            }
            case "ApproximateStartTime": {
                return Optional.ofNullable(clazz.cast(this.approximateStartTime()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "LiveSourceName": {
                return Optional.ofNullable(clazz.cast(this.liveSourceName()));
            }
            case "ProgramName": {
                return Optional.ofNullable(clazz.cast(this.programName()));
            }
            case "ScheduleAdBreaks": {
                return Optional.ofNullable(clazz.cast(this.scheduleAdBreaks()));
            }
            case "ScheduleEntryType": {
                return Optional.ofNullable(clazz.cast(this.scheduleEntryTypeAsString()));
            }
            case "SourceLocationName": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationName()));
            }
            case "VodSourceName": {
                return Optional.ofNullable(clazz.cast(this.vodSourceName()));
            }
            case "Audiences": {
                return Optional.ofNullable(clazz.cast(this.audiences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApproximateDurationSeconds", APPROXIMATE_DURATION_SECONDS_FIELD);
        map.put("ApproximateStartTime", APPROXIMATE_START_TIME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("LiveSourceName", LIVE_SOURCE_NAME_FIELD);
        map.put("ProgramName", PROGRAM_NAME_FIELD);
        map.put("ScheduleAdBreaks", SCHEDULE_AD_BREAKS_FIELD);
        map.put("ScheduleEntryType", SCHEDULE_ENTRY_TYPE_FIELD);
        map.put("SourceLocationName", SOURCE_LOCATION_NAME_FIELD);
        map.put("VodSourceName", VOD_SOURCE_NAME_FIELD);
        map.put("Audiences", AUDIENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduleEntry, T> g) {
        return obj -> g.apply((ScheduleEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long approximateDurationSeconds;
        private Instant approximateStartTime;
        private String arn;
        private String channelName;
        private String liveSourceName;
        private String programName;
        private List<ScheduleAdBreak> scheduleAdBreaks = DefaultSdkAutoConstructList.getInstance();
        private String scheduleEntryType;
        private String sourceLocationName;
        private String vodSourceName;
        private List<String> audiences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleEntry model) {
            this.approximateDurationSeconds(model.approximateDurationSeconds);
            this.approximateStartTime(model.approximateStartTime);
            this.arn(model.arn);
            this.channelName(model.channelName);
            this.liveSourceName(model.liveSourceName);
            this.programName(model.programName);
            this.scheduleAdBreaks(model.scheduleAdBreaks);
            this.scheduleEntryType(model.scheduleEntryType);
            this.sourceLocationName(model.sourceLocationName);
            this.vodSourceName(model.vodSourceName);
            this.audiences(model.audiences);
        }

        public final Long getApproximateDurationSeconds() {
            return this.approximateDurationSeconds;
        }

        public final void setApproximateDurationSeconds(Long approximateDurationSeconds) {
            this.approximateDurationSeconds = approximateDurationSeconds;
        }

        @Override
        public final Builder approximateDurationSeconds(Long approximateDurationSeconds) {
            this.approximateDurationSeconds = approximateDurationSeconds;
            return this;
        }

        public final Instant getApproximateStartTime() {
            return this.approximateStartTime;
        }

        public final void setApproximateStartTime(Instant approximateStartTime) {
            this.approximateStartTime = approximateStartTime;
        }

        @Override
        public final Builder approximateStartTime(Instant approximateStartTime) {
            this.approximateStartTime = approximateStartTime;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getLiveSourceName() {
            return this.liveSourceName;
        }

        public final void setLiveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
        }

        @Override
        public final Builder liveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
            return this;
        }

        public final String getProgramName() {
            return this.programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final List<ScheduleAdBreak.Builder> getScheduleAdBreaks() {
            List<ScheduleAdBreak.Builder> result = ___listOfScheduleAdBreakCopier.copyToBuilder(this.scheduleAdBreaks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduleAdBreaks(Collection<ScheduleAdBreak.BuilderImpl> scheduleAdBreaks) {
            this.scheduleAdBreaks = ___listOfScheduleAdBreakCopier.copyFromBuilder(scheduleAdBreaks);
        }

        @Override
        public final Builder scheduleAdBreaks(Collection<ScheduleAdBreak> scheduleAdBreaks) {
            this.scheduleAdBreaks = ___listOfScheduleAdBreakCopier.copy(scheduleAdBreaks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleAdBreaks(ScheduleAdBreak ... scheduleAdBreaks) {
            this.scheduleAdBreaks(Arrays.asList(scheduleAdBreaks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleAdBreaks(Consumer<ScheduleAdBreak.Builder> ... scheduleAdBreaks) {
            this.scheduleAdBreaks(Stream.of(scheduleAdBreaks).map(c -> (ScheduleAdBreak)((ScheduleAdBreak.Builder)ScheduleAdBreak.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScheduleEntryType() {
            return this.scheduleEntryType;
        }

        public final void setScheduleEntryType(String scheduleEntryType) {
            this.scheduleEntryType = scheduleEntryType;
        }

        @Override
        public final Builder scheduleEntryType(String scheduleEntryType) {
            this.scheduleEntryType = scheduleEntryType;
            return this;
        }

        @Override
        public final Builder scheduleEntryType(ScheduleEntryType scheduleEntryType) {
            this.scheduleEntryType(scheduleEntryType == null ? null : scheduleEntryType.toString());
            return this;
        }

        public final String getSourceLocationName() {
            return this.sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final String getVodSourceName() {
            return this.vodSourceName;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        public final Collection<String> getAudiences() {
            if (this.audiences instanceof SdkAutoConstructList) {
                return null;
            }
            return this.audiences;
        }

        public final void setAudiences(Collection<String> audiences) {
            this.audiences = AudiencesCopier.copy(audiences);
        }

        @Override
        public final Builder audiences(Collection<String> audiences) {
            this.audiences = AudiencesCopier.copy(audiences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audiences(String ... audiences) {
            this.audiences(Arrays.asList(audiences));
            return this;
        }

        public ScheduleEntry build() {
            return new ScheduleEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduleEntry> {
        public Builder approximateDurationSeconds(Long var1);

        public Builder approximateStartTime(Instant var1);

        public Builder arn(String var1);

        public Builder channelName(String var1);

        public Builder liveSourceName(String var1);

        public Builder programName(String var1);

        public Builder scheduleAdBreaks(Collection<ScheduleAdBreak> var1);

        public Builder scheduleAdBreaks(ScheduleAdBreak ... var1);

        public Builder scheduleAdBreaks(Consumer<ScheduleAdBreak.Builder> ... var1);

        public Builder scheduleEntryType(String var1);

        public Builder scheduleEntryType(ScheduleEntryType var1);

        public Builder sourceLocationName(String var1);

        public Builder vodSourceName(String var1);

        public Builder audiences(Collection<String> var1);

        public Builder audiences(String ... var1);
    }
}

