/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Ad break configuration parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdBreak implements SdkPojo, Serializable, ToCopyableBuilder<AdBreak.Builder, AdBreak> {
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageType").getter(getter(AdBreak::messageTypeAsString)).setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final SdkField<Long> OFFSET_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OffsetMillis").getter(getter(AdBreak::offsetMillis)).setter(setter(Builder::offsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffsetMillis").build()).build();

    private static final SdkField<SlateSource> SLATE_FIELD = SdkField.<SlateSource> builder(MarshallingType.SDK_POJO)
            .memberName("Slate").getter(getter(AdBreak::slate)).setter(setter(Builder::slate)).constructor(SlateSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slate").build()).build();

    private static final SdkField<SpliceInsertMessage> SPLICE_INSERT_MESSAGE_FIELD = SdkField
            .<SpliceInsertMessage> builder(MarshallingType.SDK_POJO).memberName("SpliceInsertMessage")
            .getter(getter(AdBreak::spliceInsertMessage)).setter(setter(Builder::spliceInsertMessage))
            .constructor(SpliceInsertMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpliceInsertMessage").build())
            .build();

    private static final SdkField<TimeSignalMessage> TIME_SIGNAL_MESSAGE_FIELD = SdkField
            .<TimeSignalMessage> builder(MarshallingType.SDK_POJO).memberName("TimeSignalMessage")
            .getter(getter(AdBreak::timeSignalMessage)).setter(setter(Builder::timeSignalMessage))
            .constructor(TimeSignalMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSignalMessage").build()).build();

    private static final SdkField<List<KeyValuePair>> AD_BREAK_METADATA_FIELD = SdkField
            .<List<KeyValuePair>> builder(MarshallingType.LIST)
            .memberName("AdBreakMetadata")
            .getter(getter(AdBreak::adBreakMetadata))
            .setter(setter(Builder::adBreakMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdBreakMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TYPE_FIELD,
            OFFSET_MILLIS_FIELD, SLATE_FIELD, SPLICE_INSERT_MESSAGE_FIELD, TIME_SIGNAL_MESSAGE_FIELD, AD_BREAK_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String messageType;

    private final Long offsetMillis;

    private final SlateSource slate;

    private final SpliceInsertMessage spliceInsertMessage;

    private final TimeSignalMessage timeSignalMessage;

    private final List<KeyValuePair> adBreakMetadata;

    private AdBreak(BuilderImpl builder) {
        this.messageType = builder.messageType;
        this.offsetMillis = builder.offsetMillis;
        this.slate = builder.slate;
        this.spliceInsertMessage = builder.spliceInsertMessage;
        this.timeSignalMessage = builder.timeSignalMessage;
        this.adBreakMetadata = builder.adBreakMetadata;
    }

    /**
     * <p>
     * The SCTE-35 ad insertion type. Accepted value: <code>SPLICE_INSERT</code>, <code>TIME_SIGNAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The SCTE-35 ad insertion type. Accepted value: <code>SPLICE_INSERT</code>, <code>TIME_SIGNAL</code>.
     * @see MessageType
     */
    public final MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The SCTE-35 ad insertion type. Accepted value: <code>SPLICE_INSERT</code>, <code>TIME_SIGNAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The SCTE-35 ad insertion type. Accepted value: <code>SPLICE_INSERT</code>, <code>TIME_SIGNAL</code>.
     * @see MessageType
     */
    public final String messageTypeAsString() {
        return messageType;
    }

    /**
     * <p>
     * How long (in milliseconds) after the beginning of the program that an ad starts. This value must fall within
     * 100ms of a segment boundary, otherwise the ad break will be skipped.
     * </p>
     * 
     * @return How long (in milliseconds) after the beginning of the program that an ad starts. This value must fall
     *         within 100ms of a segment boundary, otherwise the ad break will be skipped.
     */
    public final Long offsetMillis() {
        return offsetMillis;
    }

    /**
     * <p>
     * Ad break slate configuration.
     * </p>
     * 
     * @return Ad break slate configuration.
     */
    public final SlateSource slate() {
        return slate;
    }

    /**
     * <p>
     * This defines the SCTE-35 <code>splice_insert()</code> message inserted around the ad. For information about using
     * <code>splice_insert()</code>, see the SCTE-35 specficiaiton, section 9.7.3.1.
     * </p>
     * 
     * @return This defines the SCTE-35 <code>splice_insert()</code> message inserted around the ad. For information
     *         about using <code>splice_insert()</code>, see the SCTE-35 specficiaiton, section 9.7.3.1.
     */
    public final SpliceInsertMessage spliceInsertMessage() {
        return spliceInsertMessage;
    }

    /**
     * <p>
     * Defines the SCTE-35 <code>time_signal</code> message inserted around the ad.
     * </p>
     * <p>
     * Programs on a channel's schedule can be configured with one or more ad breaks. You can attach a
     * <code>splice_insert</code> SCTE-35 message to the ad break. This message provides basic metadata about the ad
     * break.
     * </p>
     * <p>
     * See section 9.7.4 of the 2022 SCTE-35 specification for more information.
     * </p>
     * 
     * @return Defines the SCTE-35 <code>time_signal</code> message inserted around the ad.</p>
     *         <p>
     *         Programs on a channel's schedule can be configured with one or more ad breaks. You can attach a
     *         <code>splice_insert</code> SCTE-35 message to the ad break. This message provides basic metadata about
     *         the ad break.
     *         </p>
     *         <p>
     *         See section 9.7.4 of the 2022 SCTE-35 specification for more information.
     */
    public final TimeSignalMessage timeSignalMessage() {
        return timeSignalMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdBreakMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdBreakMetadata() {
        return adBreakMetadata != null && !(adBreakMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines a list of key/value pairs that MediaTailor generates within the <code>EXT-X-ASSET</code>tag for
     * <code>SCTE35_ENHANCED</code> output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdBreakMetadata} method.
     * </p>
     * 
     * @return Defines a list of key/value pairs that MediaTailor generates within the <code>EXT-X-ASSET</code>tag for
     *         <code>SCTE35_ENHANCED</code> output.
     */
    public final List<KeyValuePair> adBreakMetadata() {
        return adBreakMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(slate());
        hashCode = 31 * hashCode + Objects.hashCode(spliceInsertMessage());
        hashCode = 31 * hashCode + Objects.hashCode(timeSignalMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdBreakMetadata() ? adBreakMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdBreak)) {
            return false;
        }
        AdBreak other = (AdBreak) obj;
        return Objects.equals(messageTypeAsString(), other.messageTypeAsString())
                && Objects.equals(offsetMillis(), other.offsetMillis()) && Objects.equals(slate(), other.slate())
                && Objects.equals(spliceInsertMessage(), other.spliceInsertMessage())
                && Objects.equals(timeSignalMessage(), other.timeSignalMessage())
                && hasAdBreakMetadata() == other.hasAdBreakMetadata()
                && Objects.equals(adBreakMetadata(), other.adBreakMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdBreak").add("MessageType", messageTypeAsString()).add("OffsetMillis", offsetMillis())
                .add("Slate", slate()).add("SpliceInsertMessage", spliceInsertMessage())
                .add("TimeSignalMessage", timeSignalMessage())
                .add("AdBreakMetadata", hasAdBreakMetadata() ? adBreakMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        case "OffsetMillis":
            return Optional.ofNullable(clazz.cast(offsetMillis()));
        case "Slate":
            return Optional.ofNullable(clazz.cast(slate()));
        case "SpliceInsertMessage":
            return Optional.ofNullable(clazz.cast(spliceInsertMessage()));
        case "TimeSignalMessage":
            return Optional.ofNullable(clazz.cast(timeSignalMessage()));
        case "AdBreakMetadata":
            return Optional.ofNullable(clazz.cast(adBreakMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MessageType", MESSAGE_TYPE_FIELD);
        map.put("OffsetMillis", OFFSET_MILLIS_FIELD);
        map.put("Slate", SLATE_FIELD);
        map.put("SpliceInsertMessage", SPLICE_INSERT_MESSAGE_FIELD);
        map.put("TimeSignalMessage", TIME_SIGNAL_MESSAGE_FIELD);
        map.put("AdBreakMetadata", AD_BREAK_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdBreak, T> g) {
        return obj -> g.apply((AdBreak) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdBreak> {
        /**
         * <p>
         * The SCTE-35 ad insertion type. Accepted value: <code>SPLICE_INSERT</code>, <code>TIME_SIGNAL</code>.
         * </p>
         * 
         * @param messageType
         *        The SCTE-35 ad insertion type. Accepted value: <code>SPLICE_INSERT</code>, <code>TIME_SIGNAL</code>.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The SCTE-35 ad insertion type. Accepted value: <code>SPLICE_INSERT</code>, <code>TIME_SIGNAL</code>.
         * </p>
         * 
         * @param messageType
         *        The SCTE-35 ad insertion type. Accepted value: <code>SPLICE_INSERT</code>, <code>TIME_SIGNAL</code>.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * <p>
         * How long (in milliseconds) after the beginning of the program that an ad starts. This value must fall within
         * 100ms of a segment boundary, otherwise the ad break will be skipped.
         * </p>
         * 
         * @param offsetMillis
         *        How long (in milliseconds) after the beginning of the program that an ad starts. This value must fall
         *        within 100ms of a segment boundary, otherwise the ad break will be skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offsetMillis(Long offsetMillis);

        /**
         * <p>
         * Ad break slate configuration.
         * </p>
         * 
         * @param slate
         *        Ad break slate configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slate(SlateSource slate);

        /**
         * <p>
         * Ad break slate configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlateSource.Builder} avoiding the need to
         * create one manually via {@link SlateSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlateSource.Builder#build()} is called immediately and its result
         * is passed to {@link #slate(SlateSource)}.
         * 
         * @param slate
         *        a consumer that will call methods on {@link SlateSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slate(SlateSource)
         */
        default Builder slate(Consumer<SlateSource.Builder> slate) {
            return slate(SlateSource.builder().applyMutation(slate).build());
        }

        /**
         * <p>
         * This defines the SCTE-35 <code>splice_insert()</code> message inserted around the ad. For information about
         * using <code>splice_insert()</code>, see the SCTE-35 specficiaiton, section 9.7.3.1.
         * </p>
         * 
         * @param spliceInsertMessage
         *        This defines the SCTE-35 <code>splice_insert()</code> message inserted around the ad. For information
         *        about using <code>splice_insert()</code>, see the SCTE-35 specficiaiton, section 9.7.3.1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spliceInsertMessage(SpliceInsertMessage spliceInsertMessage);

        /**
         * <p>
         * This defines the SCTE-35 <code>splice_insert()</code> message inserted around the ad. For information about
         * using <code>splice_insert()</code>, see the SCTE-35 specficiaiton, section 9.7.3.1.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpliceInsertMessage.Builder} avoiding the
         * need to create one manually via {@link SpliceInsertMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpliceInsertMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #spliceInsertMessage(SpliceInsertMessage)}.
         * 
         * @param spliceInsertMessage
         *        a consumer that will call methods on {@link SpliceInsertMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spliceInsertMessage(SpliceInsertMessage)
         */
        default Builder spliceInsertMessage(Consumer<SpliceInsertMessage.Builder> spliceInsertMessage) {
            return spliceInsertMessage(SpliceInsertMessage.builder().applyMutation(spliceInsertMessage).build());
        }

        /**
         * <p>
         * Defines the SCTE-35 <code>time_signal</code> message inserted around the ad.
         * </p>
         * <p>
         * Programs on a channel's schedule can be configured with one or more ad breaks. You can attach a
         * <code>splice_insert</code> SCTE-35 message to the ad break. This message provides basic metadata about the ad
         * break.
         * </p>
         * <p>
         * See section 9.7.4 of the 2022 SCTE-35 specification for more information.
         * </p>
         * 
         * @param timeSignalMessage
         *        Defines the SCTE-35 <code>time_signal</code> message inserted around the ad.</p>
         *        <p>
         *        Programs on a channel's schedule can be configured with one or more ad breaks. You can attach a
         *        <code>splice_insert</code> SCTE-35 message to the ad break. This message provides basic metadata about
         *        the ad break.
         *        </p>
         *        <p>
         *        See section 9.7.4 of the 2022 SCTE-35 specification for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSignalMessage(TimeSignalMessage timeSignalMessage);

        /**
         * <p>
         * Defines the SCTE-35 <code>time_signal</code> message inserted around the ad.
         * </p>
         * <p>
         * Programs on a channel's schedule can be configured with one or more ad breaks. You can attach a
         * <code>splice_insert</code> SCTE-35 message to the ad break. This message provides basic metadata about the ad
         * break.
         * </p>
         * <p>
         * See section 9.7.4 of the 2022 SCTE-35 specification for more information.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeSignalMessage.Builder} avoiding the
         * need to create one manually via {@link TimeSignalMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeSignalMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #timeSignalMessage(TimeSignalMessage)}.
         * 
         * @param timeSignalMessage
         *        a consumer that will call methods on {@link TimeSignalMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSignalMessage(TimeSignalMessage)
         */
        default Builder timeSignalMessage(Consumer<TimeSignalMessage.Builder> timeSignalMessage) {
            return timeSignalMessage(TimeSignalMessage.builder().applyMutation(timeSignalMessage).build());
        }

        /**
         * <p>
         * Defines a list of key/value pairs that MediaTailor generates within the <code>EXT-X-ASSET</code>tag for
         * <code>SCTE35_ENHANCED</code> output.
         * </p>
         * 
         * @param adBreakMetadata
         *        Defines a list of key/value pairs that MediaTailor generates within the <code>EXT-X-ASSET</code>tag
         *        for <code>SCTE35_ENHANCED</code> output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adBreakMetadata(Collection<KeyValuePair> adBreakMetadata);

        /**
         * <p>
         * Defines a list of key/value pairs that MediaTailor generates within the <code>EXT-X-ASSET</code>tag for
         * <code>SCTE35_ENHANCED</code> output.
         * </p>
         * 
         * @param adBreakMetadata
         *        Defines a list of key/value pairs that MediaTailor generates within the <code>EXT-X-ASSET</code>tag
         *        for <code>SCTE35_ENHANCED</code> output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adBreakMetadata(KeyValuePair... adBreakMetadata);

        /**
         * <p>
         * Defines a list of key/value pairs that MediaTailor generates within the <code>EXT-X-ASSET</code>tag for
         * <code>SCTE35_ENHANCED</code> output.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.KeyValuePair.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediatailor.model.KeyValuePair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.KeyValuePair.Builder#build()} is called immediately
         * and its result is passed to {@link #adBreakMetadata(List<KeyValuePair>)}.
         * 
         * @param adBreakMetadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.KeyValuePair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adBreakMetadata(java.util.Collection<KeyValuePair>)
         */
        Builder adBreakMetadata(Consumer<KeyValuePair.Builder>... adBreakMetadata);
    }

    static final class BuilderImpl implements Builder {
        private String messageType;

        private Long offsetMillis;

        private SlateSource slate;

        private SpliceInsertMessage spliceInsertMessage;

        private TimeSignalMessage timeSignalMessage;

        private List<KeyValuePair> adBreakMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdBreak model) {
            messageType(model.messageType);
            offsetMillis(model.offsetMillis);
            slate(model.slate);
            spliceInsertMessage(model.spliceInsertMessage);
            timeSignalMessage(model.timeSignalMessage);
            adBreakMetadata(model.adBreakMetadata);
        }

        public final String getMessageType() {
            return messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final Long getOffsetMillis() {
            return offsetMillis;
        }

        public final void setOffsetMillis(Long offsetMillis) {
            this.offsetMillis = offsetMillis;
        }

        @Override
        public final Builder offsetMillis(Long offsetMillis) {
            this.offsetMillis = offsetMillis;
            return this;
        }

        public final SlateSource.Builder getSlate() {
            return slate != null ? slate.toBuilder() : null;
        }

        public final void setSlate(SlateSource.BuilderImpl slate) {
            this.slate = slate != null ? slate.build() : null;
        }

        @Override
        public final Builder slate(SlateSource slate) {
            this.slate = slate;
            return this;
        }

        public final SpliceInsertMessage.Builder getSpliceInsertMessage() {
            return spliceInsertMessage != null ? spliceInsertMessage.toBuilder() : null;
        }

        public final void setSpliceInsertMessage(SpliceInsertMessage.BuilderImpl spliceInsertMessage) {
            this.spliceInsertMessage = spliceInsertMessage != null ? spliceInsertMessage.build() : null;
        }

        @Override
        public final Builder spliceInsertMessage(SpliceInsertMessage spliceInsertMessage) {
            this.spliceInsertMessage = spliceInsertMessage;
            return this;
        }

        public final TimeSignalMessage.Builder getTimeSignalMessage() {
            return timeSignalMessage != null ? timeSignalMessage.toBuilder() : null;
        }

        public final void setTimeSignalMessage(TimeSignalMessage.BuilderImpl timeSignalMessage) {
            this.timeSignalMessage = timeSignalMessage != null ? timeSignalMessage.build() : null;
        }

        @Override
        public final Builder timeSignalMessage(TimeSignalMessage timeSignalMessage) {
            this.timeSignalMessage = timeSignalMessage;
            return this;
        }

        public final List<KeyValuePair.Builder> getAdBreakMetadata() {
            List<KeyValuePair.Builder> result = AdBreakMetadataListCopier.copyToBuilder(this.adBreakMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdBreakMetadata(Collection<KeyValuePair.BuilderImpl> adBreakMetadata) {
            this.adBreakMetadata = AdBreakMetadataListCopier.copyFromBuilder(adBreakMetadata);
        }

        @Override
        public final Builder adBreakMetadata(Collection<KeyValuePair> adBreakMetadata) {
            this.adBreakMetadata = AdBreakMetadataListCopier.copy(adBreakMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreakMetadata(KeyValuePair... adBreakMetadata) {
            adBreakMetadata(Arrays.asList(adBreakMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreakMetadata(Consumer<KeyValuePair.Builder>... adBreakMetadata) {
            adBreakMetadata(Stream.of(adBreakMetadata).map(c -> KeyValuePair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AdBreak build() {
            return new AdBreak(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
