/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum AdsInteractionExcludeEventType {
    AD_MARKER_FOUND("AD_MARKER_FOUND"),

    NON_AD_MARKER_FOUND("NON_AD_MARKER_FOUND"),

    MAKING_ADS_REQUEST("MAKING_ADS_REQUEST"),

    MODIFIED_TARGET_URL("MODIFIED_TARGET_URL"),

    VAST_REDIRECT("VAST_REDIRECT"),

    EMPTY_VAST_RESPONSE("EMPTY_VAST_RESPONSE"),

    EMPTY_VMAP_RESPONSE("EMPTY_VMAP_RESPONSE"),

    VAST_RESPONSE("VAST_RESPONSE"),

    REDIRECTED_VAST_RESPONSE("REDIRECTED_VAST_RESPONSE"),

    FILLED_AVAIL("FILLED_AVAIL"),

    FILLED_OVERLAY_AVAIL("FILLED_OVERLAY_AVAIL"),

    BEACON_FIRED("BEACON_FIRED"),

    WARNING_NO_ADVERTISEMENTS("WARNING_NO_ADVERTISEMENTS"),

    WARNING_VPAID_AD_DROPPED("WARNING_VPAID_AD_DROPPED"),

    WARNING_URL_VARIABLE_SUBSTITUTION_FAILED("WARNING_URL_VARIABLE_SUBSTITUTION_FAILED"),

    ERROR_UNKNOWN("ERROR_UNKNOWN"),

    ERROR_UNKNOWN_HOST("ERROR_UNKNOWN_HOST"),

    ERROR_DISALLOWED_HOST("ERROR_DISALLOWED_HOST"),

    ERROR_ADS_IO("ERROR_ADS_IO"),

    ERROR_ADS_TIMEOUT("ERROR_ADS_TIMEOUT"),

    ERROR_ADS_RESPONSE_PARSE("ERROR_ADS_RESPONSE_PARSE"),

    ERROR_ADS_RESPONSE_UNKNOWN_ROOT_ELEMENT("ERROR_ADS_RESPONSE_UNKNOWN_ROOT_ELEMENT"),

    ERROR_ADS_INVALID_RESPONSE("ERROR_ADS_INVALID_RESPONSE"),

    ERROR_VAST_REDIRECT_EMPTY_RESPONSE("ERROR_VAST_REDIRECT_EMPTY_RESPONSE"),

    ERROR_VAST_REDIRECT_MULTIPLE_VAST("ERROR_VAST_REDIRECT_MULTIPLE_VAST"),

    ERROR_VAST_REDIRECT_FAILED("ERROR_VAST_REDIRECT_FAILED"),

    ERROR_VAST_MISSING_MEDIAFILES("ERROR_VAST_MISSING_MEDIAFILES"),

    ERROR_VAST_MISSING_CREATIVES("ERROR_VAST_MISSING_CREATIVES"),

    ERROR_VAST_MISSING_OVERLAYS("ERROR_VAST_MISSING_OVERLAYS"),

    ERROR_VAST_MISSING_IMPRESSION("ERROR_VAST_MISSING_IMPRESSION"),

    ERROR_VAST_INVALID_VAST_AD_TAG_URI("ERROR_VAST_INVALID_VAST_AD_TAG_URI"),

    ERROR_VAST_MULTIPLE_TRACKING_EVENTS("ERROR_VAST_MULTIPLE_TRACKING_EVENTS"),

    ERROR_VAST_MULTIPLE_LINEAR("ERROR_VAST_MULTIPLE_LINEAR"),

    ERROR_VAST_INVALID_MEDIA_FILE("ERROR_VAST_INVALID_MEDIA_FILE"),

    ERROR_FIRING_BEACON_FAILED("ERROR_FIRING_BEACON_FAILED"),

    ERROR_PERSONALIZATION_DISABLED("ERROR_PERSONALIZATION_DISABLED"),

    VOD_TIME_BASED_AVAIL_PLAN_VAST_RESPONSE_FOR_OFFSET("VOD_TIME_BASED_AVAIL_PLAN_VAST_RESPONSE_FOR_OFFSET"),

    VOD_TIME_BASED_AVAIL_PLAN_SUCCESS("VOD_TIME_BASED_AVAIL_PLAN_SUCCESS"),

    VOD_TIME_BASED_AVAIL_PLAN_WARNING_NO_ADVERTISEMENTS("VOD_TIME_BASED_AVAIL_PLAN_WARNING_NO_ADVERTISEMENTS"),

    INTERSTITIAL_VOD_SUCCESS("INTERSTITIAL_VOD_SUCCESS"),

    INTERSTITIAL_VOD_FAILURE("INTERSTITIAL_VOD_FAILURE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AdsInteractionExcludeEventType> VALUE_MAP = EnumUtils.uniqueIndex(
            AdsInteractionExcludeEventType.class, AdsInteractionExcludeEventType::toString);

    private final String value;

    private AdsInteractionExcludeEventType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AdsInteractionExcludeEventType corresponding to the value
     */
    public static AdsInteractionExcludeEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AdsInteractionExcludeEventType}s
     */
    public static Set<AdsInteractionExcludeEventType> knownValues() {
        Set<AdsInteractionExcludeEventType> knownValues = EnumSet.allOf(AdsInteractionExcludeEventType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
