/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePrefetchScheduleRequest extends MediaTailorRequest implements
        ToCopyableBuilder<CreatePrefetchScheduleRequest.Builder, CreatePrefetchScheduleRequest> {
    private static final SdkField<PrefetchConsumption> CONSUMPTION_FIELD = SdkField
            .<PrefetchConsumption> builder(MarshallingType.SDK_POJO).memberName("Consumption")
            .getter(getter(CreatePrefetchScheduleRequest::consumption)).setter(setter(Builder::consumption))
            .constructor(PrefetchConsumption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Consumption").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreatePrefetchScheduleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<String> PLAYBACK_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaybackConfigurationName").getter(getter(CreatePrefetchScheduleRequest::playbackConfigurationName))
            .setter(setter(Builder::playbackConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PlaybackConfigurationName").build())
            .build();

    private static final SdkField<PrefetchRetrieval> RETRIEVAL_FIELD = SdkField
            .<PrefetchRetrieval> builder(MarshallingType.SDK_POJO).memberName("Retrieval")
            .getter(getter(CreatePrefetchScheduleRequest::retrieval)).setter(setter(Builder::retrieval))
            .constructor(PrefetchRetrieval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retrieval").build()).build();

    private static final SdkField<RecurringPrefetchConfiguration> RECURRING_PREFETCH_CONFIGURATION_FIELD = SdkField
            .<RecurringPrefetchConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("RecurringPrefetchConfiguration")
            .getter(getter(CreatePrefetchScheduleRequest::recurringPrefetchConfiguration))
            .setter(setter(Builder::recurringPrefetchConfiguration))
            .constructor(RecurringPrefetchConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringPrefetchConfiguration")
                    .build()).build();

    private static final SdkField<String> SCHEDULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleType").getter(getter(CreatePrefetchScheduleRequest::scheduleTypeAsString))
            .setter(setter(Builder::scheduleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleType").build()).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(CreatePrefetchScheduleRequest::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMPTION_FIELD, NAME_FIELD,
            PLAYBACK_CONFIGURATION_NAME_FIELD, RETRIEVAL_FIELD, RECURRING_PREFETCH_CONFIGURATION_FIELD, SCHEDULE_TYPE_FIELD,
            STREAM_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PrefetchConsumption consumption;

    private final String name;

    private final String playbackConfigurationName;

    private final PrefetchRetrieval retrieval;

    private final RecurringPrefetchConfiguration recurringPrefetchConfiguration;

    private final String scheduleType;

    private final String streamId;

    private CreatePrefetchScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.consumption = builder.consumption;
        this.name = builder.name;
        this.playbackConfigurationName = builder.playbackConfigurationName;
        this.retrieval = builder.retrieval;
        this.recurringPrefetchConfiguration = builder.recurringPrefetchConfiguration;
        this.scheduleType = builder.scheduleType;
        this.streamId = builder.streamId;
    }

    /**
     * <p>
     * The configuration settings for how and when MediaTailor consumes prefetched ads from the ad decision server for
     * single prefetch schedules. Each consumption configuration contains an end time and an optional start time that
     * define the <i>consumption window</i>. Prefetch schedules automatically expire no earlier than seven days after
     * the end time.
     * </p>
     * 
     * @return The configuration settings for how and when MediaTailor consumes prefetched ads from the ad decision
     *         server for single prefetch schedules. Each consumption configuration contains an end time and an optional
     *         start time that define the <i>consumption window</i>. Prefetch schedules automatically expire no earlier
     *         than seven days after the end time.
     */
    public final PrefetchConsumption consumption() {
        return consumption;
    }

    /**
     * <p>
     * The name to assign to the schedule request.
     * </p>
     * 
     * @return The name to assign to the schedule request.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name to assign to the playback configuration.
     * </p>
     * 
     * @return The name to assign to the playback configuration.
     */
    public final String playbackConfigurationName() {
        return playbackConfigurationName;
    }

    /**
     * <p>
     * The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set of
     * prefetched ads will be retrieved and subsequently consumed for each ad break.
     * </p>
     * 
     * @return The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set of
     *         prefetched ads will be retrieved and subsequently consumed for each ad break.
     */
    public final PrefetchRetrieval retrieval() {
        return retrieval;
    }

    /**
     * <p>
     * The configuration that defines how and when MediaTailor performs ad prefetching in a live event.
     * </p>
     * 
     * @return The configuration that defines how and when MediaTailor performs ad prefetching in a live event.
     */
    public final RecurringPrefetchConfiguration recurringPrefetchConfiguration() {
        return recurringPrefetchConfiguration;
    }

    /**
     * <p>
     * The frequency that MediaTailor creates prefetch schedules. <code>SINGLE</code> indicates that this schedule
     * applies to one ad break. <code>RECURRING</code> indicates that MediaTailor automatically creates a schedule for
     * each ad avail in a live event.
     * </p>
     * <p>
     * For more information about the prefetch types and when you might use each, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Prefetching ads in Elemental
     * MediaTailor.</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheduleType} will
     * return {@link PrefetchScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scheduleTypeAsString}.
     * </p>
     * 
     * @return The frequency that MediaTailor creates prefetch schedules. <code>SINGLE</code> indicates that this
     *         schedule applies to one ad break. <code>RECURRING</code> indicates that MediaTailor automatically creates
     *         a schedule for each ad avail in a live event.</p>
     *         <p>
     *         For more information about the prefetch types and when you might use each, see <a
     *         href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Prefetching ads in
     *         Elemental MediaTailor.</a>
     * @see PrefetchScheduleType
     */
    public final PrefetchScheduleType scheduleType() {
        return PrefetchScheduleType.fromValue(scheduleType);
    }

    /**
     * <p>
     * The frequency that MediaTailor creates prefetch schedules. <code>SINGLE</code> indicates that this schedule
     * applies to one ad break. <code>RECURRING</code> indicates that MediaTailor automatically creates a schedule for
     * each ad avail in a live event.
     * </p>
     * <p>
     * For more information about the prefetch types and when you might use each, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Prefetching ads in Elemental
     * MediaTailor.</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheduleType} will
     * return {@link PrefetchScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scheduleTypeAsString}.
     * </p>
     * 
     * @return The frequency that MediaTailor creates prefetch schedules. <code>SINGLE</code> indicates that this
     *         schedule applies to one ad break. <code>RECURRING</code> indicates that MediaTailor automatically creates
     *         a schedule for each ad avail in a live event.</p>
     *         <p>
     *         For more information about the prefetch types and when you might use each, see <a
     *         href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Prefetching ads in
     *         Elemental MediaTailor.</a>
     * @see PrefetchScheduleType
     */
    public final String scheduleTypeAsString() {
        return scheduleType;
    }

    /**
     * <p>
     * An optional stream identifier that MediaTailor uses to prefetch ads for multiple streams that use the same
     * playback configuration. If <code>StreamId</code> is specified, MediaTailor returns all of the prefetch schedules
     * with an exact match on <code>StreamId</code>. If not specified, MediaTailor returns all of the prefetch schedules
     * for the playback configuration, regardless of <code>StreamId</code>.
     * </p>
     * 
     * @return An optional stream identifier that MediaTailor uses to prefetch ads for multiple streams that use the
     *         same playback configuration. If <code>StreamId</code> is specified, MediaTailor returns all of the
     *         prefetch schedules with an exact match on <code>StreamId</code>. If not specified, MediaTailor returns
     *         all of the prefetch schedules for the playback configuration, regardless of <code>StreamId</code>.
     */
    public final String streamId() {
        return streamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(consumption());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(playbackConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(retrieval());
        hashCode = 31 * hashCode + Objects.hashCode(recurringPrefetchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrefetchScheduleRequest)) {
            return false;
        }
        CreatePrefetchScheduleRequest other = (CreatePrefetchScheduleRequest) obj;
        return Objects.equals(consumption(), other.consumption()) && Objects.equals(name(), other.name())
                && Objects.equals(playbackConfigurationName(), other.playbackConfigurationName())
                && Objects.equals(retrieval(), other.retrieval())
                && Objects.equals(recurringPrefetchConfiguration(), other.recurringPrefetchConfiguration())
                && Objects.equals(scheduleTypeAsString(), other.scheduleTypeAsString())
                && Objects.equals(streamId(), other.streamId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePrefetchScheduleRequest").add("Consumption", consumption()).add("Name", name())
                .add("PlaybackConfigurationName", playbackConfigurationName()).add("Retrieval", retrieval())
                .add("RecurringPrefetchConfiguration", recurringPrefetchConfiguration())
                .add("ScheduleType", scheduleTypeAsString()).add("StreamId", streamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Consumption":
            return Optional.ofNullable(clazz.cast(consumption()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PlaybackConfigurationName":
            return Optional.ofNullable(clazz.cast(playbackConfigurationName()));
        case "Retrieval":
            return Optional.ofNullable(clazz.cast(retrieval()));
        case "RecurringPrefetchConfiguration":
            return Optional.ofNullable(clazz.cast(recurringPrefetchConfiguration()));
        case "ScheduleType":
            return Optional.ofNullable(clazz.cast(scheduleTypeAsString()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Consumption", CONSUMPTION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("PlaybackConfigurationName", PLAYBACK_CONFIGURATION_NAME_FIELD);
        map.put("Retrieval", RETRIEVAL_FIELD);
        map.put("RecurringPrefetchConfiguration", RECURRING_PREFETCH_CONFIGURATION_FIELD);
        map.put("ScheduleType", SCHEDULE_TYPE_FIELD);
        map.put("StreamId", STREAM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePrefetchScheduleRequest, T> g) {
        return obj -> g.apply((CreatePrefetchScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePrefetchScheduleRequest> {
        /**
         * <p>
         * The configuration settings for how and when MediaTailor consumes prefetched ads from the ad decision server
         * for single prefetch schedules. Each consumption configuration contains an end time and an optional start time
         * that define the <i>consumption window</i>. Prefetch schedules automatically expire no earlier than seven days
         * after the end time.
         * </p>
         * 
         * @param consumption
         *        The configuration settings for how and when MediaTailor consumes prefetched ads from the ad decision
         *        server for single prefetch schedules. Each consumption configuration contains an end time and an
         *        optional start time that define the <i>consumption window</i>. Prefetch schedules automatically expire
         *        no earlier than seven days after the end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumption(PrefetchConsumption consumption);

        /**
         * <p>
         * The configuration settings for how and when MediaTailor consumes prefetched ads from the ad decision server
         * for single prefetch schedules. Each consumption configuration contains an end time and an optional start time
         * that define the <i>consumption window</i>. Prefetch schedules automatically expire no earlier than seven days
         * after the end time.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrefetchConsumption.Builder} avoiding the
         * need to create one manually via {@link PrefetchConsumption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrefetchConsumption.Builder#build()} is called immediately and
         * its result is passed to {@link #consumption(PrefetchConsumption)}.
         * 
         * @param consumption
         *        a consumer that will call methods on {@link PrefetchConsumption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumption(PrefetchConsumption)
         */
        default Builder consumption(Consumer<PrefetchConsumption.Builder> consumption) {
            return consumption(PrefetchConsumption.builder().applyMutation(consumption).build());
        }

        /**
         * <p>
         * The name to assign to the schedule request.
         * </p>
         * 
         * @param name
         *        The name to assign to the schedule request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name to assign to the playback configuration.
         * </p>
         * 
         * @param playbackConfigurationName
         *        The name to assign to the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackConfigurationName(String playbackConfigurationName);

        /**
         * <p>
         * The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set of
         * prefetched ads will be retrieved and subsequently consumed for each ad break.
         * </p>
         * 
         * @param retrieval
         *        The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set
         *        of prefetched ads will be retrieved and subsequently consumed for each ad break.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieval(PrefetchRetrieval retrieval);

        /**
         * <p>
         * The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set of
         * prefetched ads will be retrieved and subsequently consumed for each ad break.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrefetchRetrieval.Builder} avoiding the
         * need to create one manually via {@link PrefetchRetrieval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrefetchRetrieval.Builder#build()} is called immediately and its
         * result is passed to {@link #retrieval(PrefetchRetrieval)}.
         * 
         * @param retrieval
         *        a consumer that will call methods on {@link PrefetchRetrieval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrieval(PrefetchRetrieval)
         */
        default Builder retrieval(Consumer<PrefetchRetrieval.Builder> retrieval) {
            return retrieval(PrefetchRetrieval.builder().applyMutation(retrieval).build());
        }

        /**
         * <p>
         * The configuration that defines how and when MediaTailor performs ad prefetching in a live event.
         * </p>
         * 
         * @param recurringPrefetchConfiguration
         *        The configuration that defines how and when MediaTailor performs ad prefetching in a live event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringPrefetchConfiguration(RecurringPrefetchConfiguration recurringPrefetchConfiguration);

        /**
         * <p>
         * The configuration that defines how and when MediaTailor performs ad prefetching in a live event.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecurringPrefetchConfiguration.Builder}
         * avoiding the need to create one manually via {@link RecurringPrefetchConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecurringPrefetchConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #recurringPrefetchConfiguration(RecurringPrefetchConfiguration)}.
         * 
         * @param recurringPrefetchConfiguration
         *        a consumer that will call methods on {@link RecurringPrefetchConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurringPrefetchConfiguration(RecurringPrefetchConfiguration)
         */
        default Builder recurringPrefetchConfiguration(
                Consumer<RecurringPrefetchConfiguration.Builder> recurringPrefetchConfiguration) {
            return recurringPrefetchConfiguration(RecurringPrefetchConfiguration.builder()
                    .applyMutation(recurringPrefetchConfiguration).build());
        }

        /**
         * <p>
         * The frequency that MediaTailor creates prefetch schedules. <code>SINGLE</code> indicates that this schedule
         * applies to one ad break. <code>RECURRING</code> indicates that MediaTailor automatically creates a schedule
         * for each ad avail in a live event.
         * </p>
         * <p>
         * For more information about the prefetch types and when you might use each, see <a
         * href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Prefetching ads in Elemental
         * MediaTailor.</a>
         * </p>
         * 
         * @param scheduleType
         *        The frequency that MediaTailor creates prefetch schedules. <code>SINGLE</code> indicates that this
         *        schedule applies to one ad break. <code>RECURRING</code> indicates that MediaTailor automatically
         *        creates a schedule for each ad avail in a live event.</p>
         *        <p>
         *        For more information about the prefetch types and when you might use each, see <a
         *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Prefetching ads in
         *        Elemental MediaTailor.</a>
         * @see PrefetchScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrefetchScheduleType
         */
        Builder scheduleType(String scheduleType);

        /**
         * <p>
         * The frequency that MediaTailor creates prefetch schedules. <code>SINGLE</code> indicates that this schedule
         * applies to one ad break. <code>RECURRING</code> indicates that MediaTailor automatically creates a schedule
         * for each ad avail in a live event.
         * </p>
         * <p>
         * For more information about the prefetch types and when you might use each, see <a
         * href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Prefetching ads in Elemental
         * MediaTailor.</a>
         * </p>
         * 
         * @param scheduleType
         *        The frequency that MediaTailor creates prefetch schedules. <code>SINGLE</code> indicates that this
         *        schedule applies to one ad break. <code>RECURRING</code> indicates that MediaTailor automatically
         *        creates a schedule for each ad avail in a live event.</p>
         *        <p>
         *        For more information about the prefetch types and when you might use each, see <a
         *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/prefetching-ads.html">Prefetching ads in
         *        Elemental MediaTailor.</a>
         * @see PrefetchScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrefetchScheduleType
         */
        Builder scheduleType(PrefetchScheduleType scheduleType);

        /**
         * <p>
         * An optional stream identifier that MediaTailor uses to prefetch ads for multiple streams that use the same
         * playback configuration. If <code>StreamId</code> is specified, MediaTailor returns all of the prefetch
         * schedules with an exact match on <code>StreamId</code>. If not specified, MediaTailor returns all of the
         * prefetch schedules for the playback configuration, regardless of <code>StreamId</code>.
         * </p>
         * 
         * @param streamId
         *        An optional stream identifier that MediaTailor uses to prefetch ads for multiple streams that use the
         *        same playback configuration. If <code>StreamId</code> is specified, MediaTailor returns all of the
         *        prefetch schedules with an exact match on <code>StreamId</code>. If not specified, MediaTailor returns
         *        all of the prefetch schedules for the playback configuration, regardless of <code>StreamId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private PrefetchConsumption consumption;

        private String name;

        private String playbackConfigurationName;

        private PrefetchRetrieval retrieval;

        private RecurringPrefetchConfiguration recurringPrefetchConfiguration;

        private String scheduleType;

        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrefetchScheduleRequest model) {
            super(model);
            consumption(model.consumption);
            name(model.name);
            playbackConfigurationName(model.playbackConfigurationName);
            retrieval(model.retrieval);
            recurringPrefetchConfiguration(model.recurringPrefetchConfiguration);
            scheduleType(model.scheduleType);
            streamId(model.streamId);
        }

        public final PrefetchConsumption.Builder getConsumption() {
            return consumption != null ? consumption.toBuilder() : null;
        }

        public final void setConsumption(PrefetchConsumption.BuilderImpl consumption) {
            this.consumption = consumption != null ? consumption.build() : null;
        }

        @Override
        public final Builder consumption(PrefetchConsumption consumption) {
            this.consumption = consumption;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlaybackConfigurationName() {
            return playbackConfigurationName;
        }

        public final void setPlaybackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
        }

        @Override
        public final Builder playbackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
            return this;
        }

        public final PrefetchRetrieval.Builder getRetrieval() {
            return retrieval != null ? retrieval.toBuilder() : null;
        }

        public final void setRetrieval(PrefetchRetrieval.BuilderImpl retrieval) {
            this.retrieval = retrieval != null ? retrieval.build() : null;
        }

        @Override
        public final Builder retrieval(PrefetchRetrieval retrieval) {
            this.retrieval = retrieval;
            return this;
        }

        public final RecurringPrefetchConfiguration.Builder getRecurringPrefetchConfiguration() {
            return recurringPrefetchConfiguration != null ? recurringPrefetchConfiguration.toBuilder() : null;
        }

        public final void setRecurringPrefetchConfiguration(
                RecurringPrefetchConfiguration.BuilderImpl recurringPrefetchConfiguration) {
            this.recurringPrefetchConfiguration = recurringPrefetchConfiguration != null ? recurringPrefetchConfiguration.build()
                    : null;
        }

        @Override
        public final Builder recurringPrefetchConfiguration(RecurringPrefetchConfiguration recurringPrefetchConfiguration) {
            this.recurringPrefetchConfiguration = recurringPrefetchConfiguration;
            return this;
        }

        public final String getScheduleType() {
            return scheduleType;
        }

        public final void setScheduleType(String scheduleType) {
            this.scheduleType = scheduleType;
        }

        @Override
        public final Builder scheduleType(String scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        @Override
        public final Builder scheduleType(PrefetchScheduleType scheduleType) {
            this.scheduleType(scheduleType == null ? null : scheduleType.toString());
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePrefetchScheduleRequest build() {
            return new CreatePrefetchScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
