/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChannelScheduleRequest extends MediaTailorRequest implements
        ToCopyableBuilder<GetChannelScheduleRequest.Builder, GetChannelScheduleRequest> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(GetChannelScheduleRequest::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()).build();

    private static final SdkField<String> DURATION_MINUTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurationMinutes").getter(getter(GetChannelScheduleRequest::durationMinutes))
            .setter(setter(Builder::durationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("durationMinutes").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetChannelScheduleRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetChannelScheduleRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> AUDIENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Audience").getter(getter(GetChannelScheduleRequest::audience)).setter(setter(Builder::audience))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("audience").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            DURATION_MINUTES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, AUDIENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelName;

    private final String durationMinutes;

    private final Integer maxResults;

    private final String nextToken;

    private final String audience;

    private GetChannelScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.durationMinutes = builder.durationMinutes;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.audience = builder.audience;
    }

    /**
     * <p>
     * The name of the channel associated with this Channel Schedule.
     * </p>
     * 
     * @return The name of the channel associated with this Channel Schedule.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The duration in minutes of the channel schedule.
     * </p>
     * 
     * @return The duration in minutes of the channel schedule.
     */
    public final String durationMinutes() {
        return durationMinutes;
    }

    /**
     * <p>
     * The maximum number of channel schedules that you want MediaTailor to return in response to the current request.
     * If there are more than <code>MaxResults</code> channel schedules, use the value of <code>NextToken</code> in the
     * response to get the next page of results.
     * </p>
     * 
     * @return The maximum number of channel schedules that you want MediaTailor to return in response to the current
     *         request. If there are more than <code>MaxResults</code> channel schedules, use the value of
     *         <code>NextToken</code> in the response to get the next page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * (Optional) If the playback configuration has more than <code>MaxResults</code> channel schedules, use
     * <code>NextToken</code> to get the second and subsequent pages of results.
     * </p>
     * <p>
     * For the first <code>GetChannelScheduleRequest</code> request, omit this value.
     * </p>
     * <p>
     * For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and
     * specify that value for <code>NextToken</code> in the request.
     * </p>
     * <p>
     * If the previous response didn't include a <code>NextToken</code> element, there are no more channel schedules to
     * get.
     * </p>
     * 
     * @return (Optional) If the playback configuration has more than <code>MaxResults</code> channel schedules, use
     *         <code>NextToken</code> to get the second and subsequent pages of results.</p>
     *         <p>
     *         For the first <code>GetChannelScheduleRequest</code> request, omit this value.
     *         </p>
     *         <p>
     *         For the second and subsequent requests, get the value of <code>NextToken</code> from the previous
     *         response and specify that value for <code>NextToken</code> in the request.
     *         </p>
     *         <p>
     *         If the previous response didn't include a <code>NextToken</code> element, there are no more channel
     *         schedules to get.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The single audience for GetChannelScheduleRequest.
     * </p>
     * 
     * @return The single audience for GetChannelScheduleRequest.
     */
    public final String audience() {
        return audience;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(durationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(audience());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChannelScheduleRequest)) {
            return false;
        }
        GetChannelScheduleRequest other = (GetChannelScheduleRequest) obj;
        return Objects.equals(channelName(), other.channelName()) && Objects.equals(durationMinutes(), other.durationMinutes())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(audience(), other.audience());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChannelScheduleRequest").add("ChannelName", channelName())
                .add("DurationMinutes", durationMinutes()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Audience", audience()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "DurationMinutes":
            return Optional.ofNullable(clazz.cast(durationMinutes()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Audience":
            return Optional.ofNullable(clazz.cast(audience()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("durationMinutes", DURATION_MINUTES_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("audience", AUDIENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetChannelScheduleRequest, T> g) {
        return obj -> g.apply((GetChannelScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetChannelScheduleRequest> {
        /**
         * <p>
         * The name of the channel associated with this Channel Schedule.
         * </p>
         * 
         * @param channelName
         *        The name of the channel associated with this Channel Schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The duration in minutes of the channel schedule.
         * </p>
         * 
         * @param durationMinutes
         *        The duration in minutes of the channel schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMinutes(String durationMinutes);

        /**
         * <p>
         * The maximum number of channel schedules that you want MediaTailor to return in response to the current
         * request. If there are more than <code>MaxResults</code> channel schedules, use the value of
         * <code>NextToken</code> in the response to get the next page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of channel schedules that you want MediaTailor to return in response to the current
         *        request. If there are more than <code>MaxResults</code> channel schedules, use the value of
         *        <code>NextToken</code> in the response to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * (Optional) If the playback configuration has more than <code>MaxResults</code> channel schedules, use
         * <code>NextToken</code> to get the second and subsequent pages of results.
         * </p>
         * <p>
         * For the first <code>GetChannelScheduleRequest</code> request, omit this value.
         * </p>
         * <p>
         * For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response
         * and specify that value for <code>NextToken</code> in the request.
         * </p>
         * <p>
         * If the previous response didn't include a <code>NextToken</code> element, there are no more channel schedules
         * to get.
         * </p>
         * 
         * @param nextToken
         *        (Optional) If the playback configuration has more than <code>MaxResults</code> channel schedules, use
         *        <code>NextToken</code> to get the second and subsequent pages of results.</p>
         *        <p>
         *        For the first <code>GetChannelScheduleRequest</code> request, omit this value.
         *        </p>
         *        <p>
         *        For the second and subsequent requests, get the value of <code>NextToken</code> from the previous
         *        response and specify that value for <code>NextToken</code> in the request.
         *        </p>
         *        <p>
         *        If the previous response didn't include a <code>NextToken</code> element, there are no more channel
         *        schedules to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The single audience for GetChannelScheduleRequest.
         * </p>
         * 
         * @param audience
         *        The single audience for GetChannelScheduleRequest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audience(String audience);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private String channelName;

        private String durationMinutes;

        private Integer maxResults;

        private String nextToken;

        private String audience;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChannelScheduleRequest model) {
            super(model);
            channelName(model.channelName);
            durationMinutes(model.durationMinutes);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            audience(model.audience);
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getDurationMinutes() {
            return durationMinutes;
        }

        public final void setDurationMinutes(String durationMinutes) {
            this.durationMinutes = durationMinutes;
        }

        @Override
        public final Builder durationMinutes(String durationMinutes) {
            this.durationMinutes = durationMinutes;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getAudience() {
            return audience;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetChannelScheduleRequest build() {
            return new GetChannelScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
