/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains settings governing when MediaTailor prefetches ads, and which dynamic variables that
 * MediaTailor includes in the request to the ad decision server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrefetchRetrieval implements SdkPojo, Serializable,
        ToCopyableBuilder<PrefetchRetrieval.Builder, PrefetchRetrieval> {
    private static final SdkField<Map<String, String>> DYNAMIC_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DynamicVariables")
            .getter(getter(PrefetchRetrieval::dynamicVariables))
            .setter(setter(Builder::dynamicVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(PrefetchRetrieval::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(PrefetchRetrieval::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> TRAFFIC_SHAPING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficShapingType").getter(getter(PrefetchRetrieval::trafficShapingTypeAsString))
            .setter(setter(Builder::trafficShapingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficShapingType").build())
            .build();

    private static final SdkField<TrafficShapingRetrievalWindow> TRAFFIC_SHAPING_RETRIEVAL_WINDOW_FIELD = SdkField
            .<TrafficShapingRetrievalWindow> builder(MarshallingType.SDK_POJO)
            .memberName("TrafficShapingRetrievalWindow")
            .getter(getter(PrefetchRetrieval::trafficShapingRetrievalWindow))
            .setter(setter(Builder::trafficShapingRetrievalWindow))
            .constructor(TrafficShapingRetrievalWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficShapingRetrievalWindow")
                    .build()).build();

    private static final SdkField<TrafficShapingTpsConfiguration> TRAFFIC_SHAPING_TPS_CONFIGURATION_FIELD = SdkField
            .<TrafficShapingTpsConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TrafficShapingTpsConfiguration")
            .getter(getter(PrefetchRetrieval::trafficShapingTpsConfiguration))
            .setter(setter(Builder::trafficShapingTpsConfiguration))
            .constructor(TrafficShapingTpsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficShapingTpsConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMIC_VARIABLES_FIELD,
            END_TIME_FIELD, START_TIME_FIELD, TRAFFIC_SHAPING_TYPE_FIELD, TRAFFIC_SHAPING_RETRIEVAL_WINDOW_FIELD,
            TRAFFIC_SHAPING_TPS_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> dynamicVariables;

    private final Instant endTime;

    private final Instant startTime;

    private final String trafficShapingType;

    private final TrafficShapingRetrievalWindow trafficShapingRetrievalWindow;

    private final TrafficShapingTpsConfiguration trafficShapingTpsConfiguration;

    private PrefetchRetrieval(BuilderImpl builder) {
        this.dynamicVariables = builder.dynamicVariables;
        this.endTime = builder.endTime;
        this.startTime = builder.startTime;
        this.trafficShapingType = builder.trafficShapingType;
        this.trafficShapingRetrievalWindow = builder.trafficShapingRetrievalWindow;
        this.trafficShapingTpsConfiguration = builder.trafficShapingTpsConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the DynamicVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDynamicVariables() {
        return dynamicVariables != null && !(dynamicVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The dynamic variables to use for substitution during prefetch requests to the ad decision server (ADS).
     * </p>
     * <p>
     * You initially configure <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html">dynamic
     * variables</a> for the ADS URL when you set up your playback configuration. When you specify
     * <code>DynamicVariables</code> for prefetch retrieval, MediaTailor includes the dynamic variables in the request
     * to the ADS.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDynamicVariables} method.
     * </p>
     * 
     * @return The dynamic variables to use for substitution during prefetch requests to the ad decision server
     *         (ADS).</p>
     *         <p>
     *         You initially configure <a
     *         href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html">dynamic variables</a> for the ADS
     *         URL when you set up your playback configuration. When you specify <code>DynamicVariables</code> for
     *         prefetch retrieval, MediaTailor includes the dynamic variables in the request to the ADS.
     */
    public final Map<String, String> dynamicVariables() {
        return dynamicVariables;
    }

    /**
     * <p>
     * The time when prefetch retrieval ends for the ad break. Prefetching will be attempted for manifest requests that
     * occur at or before this time.
     * </p>
     * 
     * @return The time when prefetch retrieval ends for the ad break. Prefetching will be attempted for manifest
     *         requests that occur at or before this time.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The time when prefetch retrievals can start for this break. Ad prefetching will be attempted for manifest
     * requests that occur at or after this time. Defaults to the current time. If not specified, the prefetch retrieval
     * starts as soon as possible.
     * </p>
     * 
     * @return The time when prefetch retrievals can start for this break. Ad prefetching will be attempted for manifest
     *         requests that occur at or after this time. Defaults to the current time. If not specified, the prefetch
     *         retrieval starts as soon as possible.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Indicates the type of traffic shaping used for prefetch traffic shaping and limiting the number of requests to
     * the ADS at one time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trafficShapingType} will return {@link TrafficShapingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #trafficShapingTypeAsString}.
     * </p>
     * 
     * @return Indicates the type of traffic shaping used for prefetch traffic shaping and limiting the number of
     *         requests to the ADS at one time.
     * @see TrafficShapingType
     */
    public final TrafficShapingType trafficShapingType() {
        return TrafficShapingType.fromValue(trafficShapingType);
    }

    /**
     * <p>
     * Indicates the type of traffic shaping used for prefetch traffic shaping and limiting the number of requests to
     * the ADS at one time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trafficShapingType} will return {@link TrafficShapingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #trafficShapingTypeAsString}.
     * </p>
     * 
     * @return Indicates the type of traffic shaping used for prefetch traffic shaping and limiting the number of
     *         requests to the ADS at one time.
     * @see TrafficShapingType
     */
    public final String trafficShapingTypeAsString() {
        return trafficShapingType;
    }

    /**
     * <p>
     * Configuration for spreading ADS traffic across a set window instead of sending ADS requests for all sessions at
     * the same time.
     * </p>
     * 
     * @return Configuration for spreading ADS traffic across a set window instead of sending ADS requests for all
     *         sessions at the same time.
     */
    public final TrafficShapingRetrievalWindow trafficShapingRetrievalWindow() {
        return trafficShapingRetrievalWindow;
    }

    /**
     * <p>
     * The configuration for TPS-based traffic shaping that limits the number of requests to the ad decision server
     * (ADS) based on transactions per second instead of time windows.
     * </p>
     * 
     * @return The configuration for TPS-based traffic shaping that limits the number of requests to the ad decision
     *         server (ADS) based on transactions per second instead of time windows.
     */
    public final TrafficShapingTpsConfiguration trafficShapingTpsConfiguration() {
        return trafficShapingTpsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDynamicVariables() ? dynamicVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(trafficShapingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trafficShapingRetrievalWindow());
        hashCode = 31 * hashCode + Objects.hashCode(trafficShapingTpsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefetchRetrieval)) {
            return false;
        }
        PrefetchRetrieval other = (PrefetchRetrieval) obj;
        return hasDynamicVariables() == other.hasDynamicVariables()
                && Objects.equals(dynamicVariables(), other.dynamicVariables()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(startTime(), other.startTime())
                && Objects.equals(trafficShapingTypeAsString(), other.trafficShapingTypeAsString())
                && Objects.equals(trafficShapingRetrievalWindow(), other.trafficShapingRetrievalWindow())
                && Objects.equals(trafficShapingTpsConfiguration(), other.trafficShapingTpsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrefetchRetrieval").add("DynamicVariables", hasDynamicVariables() ? dynamicVariables() : null)
                .add("EndTime", endTime()).add("StartTime", startTime()).add("TrafficShapingType", trafficShapingTypeAsString())
                .add("TrafficShapingRetrievalWindow", trafficShapingRetrievalWindow())
                .add("TrafficShapingTpsConfiguration", trafficShapingTpsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DynamicVariables":
            return Optional.ofNullable(clazz.cast(dynamicVariables()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "TrafficShapingType":
            return Optional.ofNullable(clazz.cast(trafficShapingTypeAsString()));
        case "TrafficShapingRetrievalWindow":
            return Optional.ofNullable(clazz.cast(trafficShapingRetrievalWindow()));
        case "TrafficShapingTpsConfiguration":
            return Optional.ofNullable(clazz.cast(trafficShapingTpsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DynamicVariables", DYNAMIC_VARIABLES_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("TrafficShapingType", TRAFFIC_SHAPING_TYPE_FIELD);
        map.put("TrafficShapingRetrievalWindow", TRAFFIC_SHAPING_RETRIEVAL_WINDOW_FIELD);
        map.put("TrafficShapingTpsConfiguration", TRAFFIC_SHAPING_TPS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrefetchRetrieval, T> g) {
        return obj -> g.apply((PrefetchRetrieval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrefetchRetrieval> {
        /**
         * <p>
         * The dynamic variables to use for substitution during prefetch requests to the ad decision server (ADS).
         * </p>
         * <p>
         * You initially configure <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html">dynamic
         * variables</a> for the ADS URL when you set up your playback configuration. When you specify
         * <code>DynamicVariables</code> for prefetch retrieval, MediaTailor includes the dynamic variables in the
         * request to the ADS.
         * </p>
         * 
         * @param dynamicVariables
         *        The dynamic variables to use for substitution during prefetch requests to the ad decision server
         *        (ADS).</p>
         *        <p>
         *        You initially configure <a
         *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables.html">dynamic variables</a> for the
         *        ADS URL when you set up your playback configuration. When you specify <code>DynamicVariables</code>
         *        for prefetch retrieval, MediaTailor includes the dynamic variables in the request to the ADS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicVariables(Map<String, String> dynamicVariables);

        /**
         * <p>
         * The time when prefetch retrieval ends for the ad break. Prefetching will be attempted for manifest requests
         * that occur at or before this time.
         * </p>
         * 
         * @param endTime
         *        The time when prefetch retrieval ends for the ad break. Prefetching will be attempted for manifest
         *        requests that occur at or before this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The time when prefetch retrievals can start for this break. Ad prefetching will be attempted for manifest
         * requests that occur at or after this time. Defaults to the current time. If not specified, the prefetch
         * retrieval starts as soon as possible.
         * </p>
         * 
         * @param startTime
         *        The time when prefetch retrievals can start for this break. Ad prefetching will be attempted for
         *        manifest requests that occur at or after this time. Defaults to the current time. If not specified,
         *        the prefetch retrieval starts as soon as possible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Indicates the type of traffic shaping used for prefetch traffic shaping and limiting the number of requests
         * to the ADS at one time.
         * </p>
         * 
         * @param trafficShapingType
         *        Indicates the type of traffic shaping used for prefetch traffic shaping and limiting the number of
         *        requests to the ADS at one time.
         * @see TrafficShapingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficShapingType
         */
        Builder trafficShapingType(String trafficShapingType);

        /**
         * <p>
         * Indicates the type of traffic shaping used for prefetch traffic shaping and limiting the number of requests
         * to the ADS at one time.
         * </p>
         * 
         * @param trafficShapingType
         *        Indicates the type of traffic shaping used for prefetch traffic shaping and limiting the number of
         *        requests to the ADS at one time.
         * @see TrafficShapingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficShapingType
         */
        Builder trafficShapingType(TrafficShapingType trafficShapingType);

        /**
         * <p>
         * Configuration for spreading ADS traffic across a set window instead of sending ADS requests for all sessions
         * at the same time.
         * </p>
         * 
         * @param trafficShapingRetrievalWindow
         *        Configuration for spreading ADS traffic across a set window instead of sending ADS requests for all
         *        sessions at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficShapingRetrievalWindow(TrafficShapingRetrievalWindow trafficShapingRetrievalWindow);

        /**
         * <p>
         * Configuration for spreading ADS traffic across a set window instead of sending ADS requests for all sessions
         * at the same time.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficShapingRetrievalWindow.Builder}
         * avoiding the need to create one manually via {@link TrafficShapingRetrievalWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficShapingRetrievalWindow.Builder#build()} is called
         * immediately and its result is passed to {@link #trafficShapingRetrievalWindow(TrafficShapingRetrievalWindow)}.
         * 
         * @param trafficShapingRetrievalWindow
         *        a consumer that will call methods on {@link TrafficShapingRetrievalWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficShapingRetrievalWindow(TrafficShapingRetrievalWindow)
         */
        default Builder trafficShapingRetrievalWindow(
                Consumer<TrafficShapingRetrievalWindow.Builder> trafficShapingRetrievalWindow) {
            return trafficShapingRetrievalWindow(TrafficShapingRetrievalWindow.builder()
                    .applyMutation(trafficShapingRetrievalWindow).build());
        }

        /**
         * <p>
         * The configuration for TPS-based traffic shaping that limits the number of requests to the ad decision server
         * (ADS) based on transactions per second instead of time windows.
         * </p>
         * 
         * @param trafficShapingTpsConfiguration
         *        The configuration for TPS-based traffic shaping that limits the number of requests to the ad decision
         *        server (ADS) based on transactions per second instead of time windows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficShapingTpsConfiguration(TrafficShapingTpsConfiguration trafficShapingTpsConfiguration);

        /**
         * <p>
         * The configuration for TPS-based traffic shaping that limits the number of requests to the ad decision server
         * (ADS) based on transactions per second instead of time windows.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficShapingTpsConfiguration.Builder}
         * avoiding the need to create one manually via {@link TrafficShapingTpsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficShapingTpsConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #trafficShapingTpsConfiguration(TrafficShapingTpsConfiguration)}.
         * 
         * @param trafficShapingTpsConfiguration
         *        a consumer that will call methods on {@link TrafficShapingTpsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficShapingTpsConfiguration(TrafficShapingTpsConfiguration)
         */
        default Builder trafficShapingTpsConfiguration(
                Consumer<TrafficShapingTpsConfiguration.Builder> trafficShapingTpsConfiguration) {
            return trafficShapingTpsConfiguration(TrafficShapingTpsConfiguration.builder()
                    .applyMutation(trafficShapingTpsConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> dynamicVariables = DefaultSdkAutoConstructMap.getInstance();

        private Instant endTime;

        private Instant startTime;

        private String trafficShapingType;

        private TrafficShapingRetrievalWindow trafficShapingRetrievalWindow;

        private TrafficShapingTpsConfiguration trafficShapingTpsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PrefetchRetrieval model) {
            dynamicVariables(model.dynamicVariables);
            endTime(model.endTime);
            startTime(model.startTime);
            trafficShapingType(model.trafficShapingType);
            trafficShapingRetrievalWindow(model.trafficShapingRetrievalWindow);
            trafficShapingTpsConfiguration(model.trafficShapingTpsConfiguration);
        }

        public final Map<String, String> getDynamicVariables() {
            if (dynamicVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return dynamicVariables;
        }

        public final void setDynamicVariables(Map<String, String> dynamicVariables) {
            this.dynamicVariables = ___mapOf__stringCopier.copy(dynamicVariables);
        }

        @Override
        public final Builder dynamicVariables(Map<String, String> dynamicVariables) {
            this.dynamicVariables = ___mapOf__stringCopier.copy(dynamicVariables);
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTrafficShapingType() {
            return trafficShapingType;
        }

        public final void setTrafficShapingType(String trafficShapingType) {
            this.trafficShapingType = trafficShapingType;
        }

        @Override
        public final Builder trafficShapingType(String trafficShapingType) {
            this.trafficShapingType = trafficShapingType;
            return this;
        }

        @Override
        public final Builder trafficShapingType(TrafficShapingType trafficShapingType) {
            this.trafficShapingType(trafficShapingType == null ? null : trafficShapingType.toString());
            return this;
        }

        public final TrafficShapingRetrievalWindow.Builder getTrafficShapingRetrievalWindow() {
            return trafficShapingRetrievalWindow != null ? trafficShapingRetrievalWindow.toBuilder() : null;
        }

        public final void setTrafficShapingRetrievalWindow(TrafficShapingRetrievalWindow.BuilderImpl trafficShapingRetrievalWindow) {
            this.trafficShapingRetrievalWindow = trafficShapingRetrievalWindow != null ? trafficShapingRetrievalWindow.build()
                    : null;
        }

        @Override
        public final Builder trafficShapingRetrievalWindow(TrafficShapingRetrievalWindow trafficShapingRetrievalWindow) {
            this.trafficShapingRetrievalWindow = trafficShapingRetrievalWindow;
            return this;
        }

        public final TrafficShapingTpsConfiguration.Builder getTrafficShapingTpsConfiguration() {
            return trafficShapingTpsConfiguration != null ? trafficShapingTpsConfiguration.toBuilder() : null;
        }

        public final void setTrafficShapingTpsConfiguration(
                TrafficShapingTpsConfiguration.BuilderImpl trafficShapingTpsConfiguration) {
            this.trafficShapingTpsConfiguration = trafficShapingTpsConfiguration != null ? trafficShapingTpsConfiguration.build()
                    : null;
        }

        @Override
        public final Builder trafficShapingTpsConfiguration(TrafficShapingTpsConfiguration trafficShapingTpsConfiguration) {
            this.trafficShapingTpsConfiguration = trafficShapingTpsConfiguration;
            return this;
        }

        @Override
        public PrefetchRetrieval build() {
            return new PrefetchRetrieval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
