/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings that determine how and when MediaTailor places prefetched ads into upcoming ad breaks for recurring
 * prefetch scedules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecurringConsumption implements SdkPojo, Serializable,
        ToCopyableBuilder<RecurringConsumption.Builder, RecurringConsumption> {
    private static final SdkField<Integer> RETRIEVED_AD_EXPIRATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetrievedAdExpirationSeconds")
            .getter(getter(RecurringConsumption::retrievedAdExpirationSeconds))
            .setter(setter(Builder::retrievedAdExpirationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievedAdExpirationSeconds")
                    .build()).build();

    private static final SdkField<List<AvailMatchingCriteria>> AVAIL_MATCHING_CRITERIA_FIELD = SdkField
            .<List<AvailMatchingCriteria>> builder(MarshallingType.LIST)
            .memberName("AvailMatchingCriteria")
            .getter(getter(RecurringConsumption::availMatchingCriteria))
            .setter(setter(Builder::availMatchingCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailMatchingCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AvailMatchingCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailMatchingCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RETRIEVED_AD_EXPIRATION_SECONDS_FIELD, AVAIL_MATCHING_CRITERIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer retrievedAdExpirationSeconds;

    private final List<AvailMatchingCriteria> availMatchingCriteria;

    private RecurringConsumption(BuilderImpl builder) {
        this.retrievedAdExpirationSeconds = builder.retrievedAdExpirationSeconds;
        this.availMatchingCriteria = builder.availMatchingCriteria;
    }

    /**
     * <p>
     * The number of seconds that an ad is available for insertion after it was prefetched.
     * </p>
     * 
     * @return The number of seconds that an ad is available for insertion after it was prefetched.
     */
    public final Integer retrievedAdExpirationSeconds() {
        return retrievedAdExpirationSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailMatchingCriteria property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAvailMatchingCriteria() {
        return availMatchingCriteria != null && !(availMatchingCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration for the dynamic variables that determine which ad breaks that MediaTailor inserts prefetched
     * ads in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailMatchingCriteria} method.
     * </p>
     * 
     * @return The configuration for the dynamic variables that determine which ad breaks that MediaTailor inserts
     *         prefetched ads in.
     */
    public final List<AvailMatchingCriteria> availMatchingCriteria() {
        return availMatchingCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retrievedAdExpirationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailMatchingCriteria() ? availMatchingCriteria() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringConsumption)) {
            return false;
        }
        RecurringConsumption other = (RecurringConsumption) obj;
        return Objects.equals(retrievedAdExpirationSeconds(), other.retrievedAdExpirationSeconds())
                && hasAvailMatchingCriteria() == other.hasAvailMatchingCriteria()
                && Objects.equals(availMatchingCriteria(), other.availMatchingCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecurringConsumption").add("RetrievedAdExpirationSeconds", retrievedAdExpirationSeconds())
                .add("AvailMatchingCriteria", hasAvailMatchingCriteria() ? availMatchingCriteria() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetrievedAdExpirationSeconds":
            return Optional.ofNullable(clazz.cast(retrievedAdExpirationSeconds()));
        case "AvailMatchingCriteria":
            return Optional.ofNullable(clazz.cast(availMatchingCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RetrievedAdExpirationSeconds", RETRIEVED_AD_EXPIRATION_SECONDS_FIELD);
        map.put("AvailMatchingCriteria", AVAIL_MATCHING_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecurringConsumption, T> g) {
        return obj -> g.apply((RecurringConsumption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecurringConsumption> {
        /**
         * <p>
         * The number of seconds that an ad is available for insertion after it was prefetched.
         * </p>
         * 
         * @param retrievedAdExpirationSeconds
         *        The number of seconds that an ad is available for insertion after it was prefetched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievedAdExpirationSeconds(Integer retrievedAdExpirationSeconds);

        /**
         * <p>
         * The configuration for the dynamic variables that determine which ad breaks that MediaTailor inserts
         * prefetched ads in.
         * </p>
         * 
         * @param availMatchingCriteria
         *        The configuration for the dynamic variables that determine which ad breaks that MediaTailor inserts
         *        prefetched ads in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availMatchingCriteria(Collection<AvailMatchingCriteria> availMatchingCriteria);

        /**
         * <p>
         * The configuration for the dynamic variables that determine which ad breaks that MediaTailor inserts
         * prefetched ads in.
         * </p>
         * 
         * @param availMatchingCriteria
         *        The configuration for the dynamic variables that determine which ad breaks that MediaTailor inserts
         *        prefetched ads in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availMatchingCriteria(AvailMatchingCriteria... availMatchingCriteria);

        /**
         * <p>
         * The configuration for the dynamic variables that determine which ad breaks that MediaTailor inserts
         * prefetched ads in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.AvailMatchingCriteria.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mediatailor.model.AvailMatchingCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.AvailMatchingCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #availMatchingCriteria(List<AvailMatchingCriteria>)}.
         * 
         * @param availMatchingCriteria
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.AvailMatchingCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availMatchingCriteria(java.util.Collection<AvailMatchingCriteria>)
         */
        Builder availMatchingCriteria(Consumer<AvailMatchingCriteria.Builder>... availMatchingCriteria);
    }

    static final class BuilderImpl implements Builder {
        private Integer retrievedAdExpirationSeconds;

        private List<AvailMatchingCriteria> availMatchingCriteria = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringConsumption model) {
            retrievedAdExpirationSeconds(model.retrievedAdExpirationSeconds);
            availMatchingCriteria(model.availMatchingCriteria);
        }

        public final Integer getRetrievedAdExpirationSeconds() {
            return retrievedAdExpirationSeconds;
        }

        public final void setRetrievedAdExpirationSeconds(Integer retrievedAdExpirationSeconds) {
            this.retrievedAdExpirationSeconds = retrievedAdExpirationSeconds;
        }

        @Override
        public final Builder retrievedAdExpirationSeconds(Integer retrievedAdExpirationSeconds) {
            this.retrievedAdExpirationSeconds = retrievedAdExpirationSeconds;
            return this;
        }

        public final List<AvailMatchingCriteria.Builder> getAvailMatchingCriteria() {
            List<AvailMatchingCriteria.Builder> result = ___listOfAvailMatchingCriteriaCopier
                    .copyToBuilder(this.availMatchingCriteria);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailMatchingCriteria(Collection<AvailMatchingCriteria.BuilderImpl> availMatchingCriteria) {
            this.availMatchingCriteria = ___listOfAvailMatchingCriteriaCopier.copyFromBuilder(availMatchingCriteria);
        }

        @Override
        public final Builder availMatchingCriteria(Collection<AvailMatchingCriteria> availMatchingCriteria) {
            this.availMatchingCriteria = ___listOfAvailMatchingCriteriaCopier.copy(availMatchingCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availMatchingCriteria(AvailMatchingCriteria... availMatchingCriteria) {
            availMatchingCriteria(Arrays.asList(availMatchingCriteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availMatchingCriteria(Consumer<AvailMatchingCriteria.Builder>... availMatchingCriteria) {
            availMatchingCriteria(Stream.of(availMatchingCriteria)
                    .map(c -> AvailMatchingCriteria.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RecurringConsumption build() {
            return new RecurringConsumption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
