/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The schedule's ad break properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleAdBreak implements SdkPojo, Serializable, ToCopyableBuilder<ScheduleAdBreak.Builder, ScheduleAdBreak> {
    private static final SdkField<Long> APPROXIMATE_DURATION_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ApproximateDurationSeconds")
            .getter(getter(ScheduleAdBreak::approximateDurationSeconds))
            .setter(setter(Builder::approximateDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateDurationSeconds").build())
            .build();

    private static final SdkField<Instant> APPROXIMATE_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ApproximateStartTime")
            .getter(getter(ScheduleAdBreak::approximateStartTime))
            .setter(setter(Builder::approximateStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(ScheduleAdBreak::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build())
            .build();

    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VodSourceName").getter(getter(ScheduleAdBreak::vodSourceName)).setter(setter(Builder::vodSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROXIMATE_DURATION_SECONDS_FIELD, APPROXIMATE_START_TIME_FIELD, SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long approximateDurationSeconds;

    private final Instant approximateStartTime;

    private final String sourceLocationName;

    private final String vodSourceName;

    private ScheduleAdBreak(BuilderImpl builder) {
        this.approximateDurationSeconds = builder.approximateDurationSeconds;
        this.approximateStartTime = builder.approximateStartTime;
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
    }

    /**
     * <p>
     * The approximate duration of the ad break, in seconds.
     * </p>
     * 
     * @return The approximate duration of the ad break, in seconds.
     */
    public final Long approximateDurationSeconds() {
        return approximateDurationSeconds;
    }

    /**
     * <p>
     * The approximate time that the ad will start playing.
     * </p>
     * 
     * @return The approximate time that the ad will start playing.
     */
    public final Instant approximateStartTime() {
        return approximateStartTime;
    }

    /**
     * <p>
     * The name of the source location containing the VOD source used for the ad break.
     * </p>
     * 
     * @return The name of the source location containing the VOD source used for the ad break.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    /**
     * <p>
     * The name of the VOD source used for the ad break.
     * </p>
     * 
     * @return The name of the VOD source used for the ad break.
     */
    public final String vodSourceName() {
        return vodSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approximateDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(approximateStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(vodSourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleAdBreak)) {
            return false;
        }
        ScheduleAdBreak other = (ScheduleAdBreak) obj;
        return Objects.equals(approximateDurationSeconds(), other.approximateDurationSeconds())
                && Objects.equals(approximateStartTime(), other.approximateStartTime())
                && Objects.equals(sourceLocationName(), other.sourceLocationName())
                && Objects.equals(vodSourceName(), other.vodSourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleAdBreak").add("ApproximateDurationSeconds", approximateDurationSeconds())
                .add("ApproximateStartTime", approximateStartTime()).add("SourceLocationName", sourceLocationName())
                .add("VodSourceName", vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApproximateDurationSeconds":
            return Optional.ofNullable(clazz.cast(approximateDurationSeconds()));
        case "ApproximateStartTime":
            return Optional.ofNullable(clazz.cast(approximateStartTime()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        case "VodSourceName":
            return Optional.ofNullable(clazz.cast(vodSourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApproximateDurationSeconds", APPROXIMATE_DURATION_SECONDS_FIELD);
        map.put("ApproximateStartTime", APPROXIMATE_START_TIME_FIELD);
        map.put("SourceLocationName", SOURCE_LOCATION_NAME_FIELD);
        map.put("VodSourceName", VOD_SOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduleAdBreak, T> g) {
        return obj -> g.apply((ScheduleAdBreak) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleAdBreak> {
        /**
         * <p>
         * The approximate duration of the ad break, in seconds.
         * </p>
         * 
         * @param approximateDurationSeconds
         *        The approximate duration of the ad break, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateDurationSeconds(Long approximateDurationSeconds);

        /**
         * <p>
         * The approximate time that the ad will start playing.
         * </p>
         * 
         * @param approximateStartTime
         *        The approximate time that the ad will start playing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateStartTime(Instant approximateStartTime);

        /**
         * <p>
         * The name of the source location containing the VOD source used for the ad break.
         * </p>
         * 
         * @param sourceLocationName
         *        The name of the source location containing the VOD source used for the ad break.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        /**
         * <p>
         * The name of the VOD source used for the ad break.
         * </p>
         * 
         * @param vodSourceName
         *        The name of the VOD source used for the ad break.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vodSourceName(String vodSourceName);
    }

    static final class BuilderImpl implements Builder {
        private Long approximateDurationSeconds;

        private Instant approximateStartTime;

        private String sourceLocationName;

        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleAdBreak model) {
            approximateDurationSeconds(model.approximateDurationSeconds);
            approximateStartTime(model.approximateStartTime);
            sourceLocationName(model.sourceLocationName);
            vodSourceName(model.vodSourceName);
        }

        public final Long getApproximateDurationSeconds() {
            return approximateDurationSeconds;
        }

        public final void setApproximateDurationSeconds(Long approximateDurationSeconds) {
            this.approximateDurationSeconds = approximateDurationSeconds;
        }

        @Override
        public final Builder approximateDurationSeconds(Long approximateDurationSeconds) {
            this.approximateDurationSeconds = approximateDurationSeconds;
            return this;
        }

        public final Instant getApproximateStartTime() {
            return approximateStartTime;
        }

        public final void setApproximateStartTime(Instant approximateStartTime) {
            this.approximateStartTime = approximateStartTime;
        }

        @Override
        public final Builder approximateStartTime(Instant approximateStartTime) {
            this.approximateStartTime = approximateStartTime;
            return this;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final String getVodSourceName() {
            return vodSourceName;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        @Override
        public ScheduleAdBreak build() {
            return new ScheduleAdBreak(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
