/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for TPS-based traffic shaping. This approach limits requests to the ad decision server (ADS) based
 * on transactions per second and concurrent users, providing more intuitive capacity management compared to time-window
 * based traffic shaping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficShapingTpsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficShapingTpsConfiguration.Builder, TrafficShapingTpsConfiguration> {
    private static final SdkField<Integer> PEAK_TPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeakTps").getter(getter(TrafficShapingTpsConfiguration::peakTps)).setter(setter(Builder::peakTps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeakTps").build()).build();

    private static final SdkField<Integer> PEAK_CONCURRENT_USERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeakConcurrentUsers").getter(getter(TrafficShapingTpsConfiguration::peakConcurrentUsers))
            .setter(setter(Builder::peakConcurrentUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeakConcurrentUsers").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEAK_TPS_FIELD,
            PEAK_CONCURRENT_USERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer peakTps;

    private final Integer peakConcurrentUsers;

    private TrafficShapingTpsConfiguration(BuilderImpl builder) {
        this.peakTps = builder.peakTps;
        this.peakConcurrentUsers = builder.peakConcurrentUsers;
    }

    /**
     * <p>
     * The maximum number of transactions per second (TPS) that your ad decision server (ADS) can handle. MediaTailor
     * uses this value along with concurrent users and headroom multiplier to calculate optimal traffic distribution and
     * prevent ADS overload.
     * </p>
     * 
     * @return The maximum number of transactions per second (TPS) that your ad decision server (ADS) can handle.
     *         MediaTailor uses this value along with concurrent users and headroom multiplier to calculate optimal
     *         traffic distribution and prevent ADS overload.
     */
    public final Integer peakTps() {
        return peakTps;
    }

    /**
     * <p>
     * The expected peak number of concurrent viewers for your content. MediaTailor uses this value along with peak TPS
     * to determine how to distribute prefetch requests across the available capacity without exceeding your ADS limits.
     * </p>
     * 
     * @return The expected peak number of concurrent viewers for your content. MediaTailor uses this value along with
     *         peak TPS to determine how to distribute prefetch requests across the available capacity without exceeding
     *         your ADS limits.
     */
    public final Integer peakConcurrentUsers() {
        return peakConcurrentUsers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(peakTps());
        hashCode = 31 * hashCode + Objects.hashCode(peakConcurrentUsers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficShapingTpsConfiguration)) {
            return false;
        }
        TrafficShapingTpsConfiguration other = (TrafficShapingTpsConfiguration) obj;
        return Objects.equals(peakTps(), other.peakTps()) && Objects.equals(peakConcurrentUsers(), other.peakConcurrentUsers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficShapingTpsConfiguration").add("PeakTps", peakTps())
                .add("PeakConcurrentUsers", peakConcurrentUsers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PeakTps":
            return Optional.ofNullable(clazz.cast(peakTps()));
        case "PeakConcurrentUsers":
            return Optional.ofNullable(clazz.cast(peakConcurrentUsers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PeakTps", PEAK_TPS_FIELD);
        map.put("PeakConcurrentUsers", PEAK_CONCURRENT_USERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrafficShapingTpsConfiguration, T> g) {
        return obj -> g.apply((TrafficShapingTpsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficShapingTpsConfiguration> {
        /**
         * <p>
         * The maximum number of transactions per second (TPS) that your ad decision server (ADS) can handle.
         * MediaTailor uses this value along with concurrent users and headroom multiplier to calculate optimal traffic
         * distribution and prevent ADS overload.
         * </p>
         * 
         * @param peakTps
         *        The maximum number of transactions per second (TPS) that your ad decision server (ADS) can handle.
         *        MediaTailor uses this value along with concurrent users and headroom multiplier to calculate optimal
         *        traffic distribution and prevent ADS overload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peakTps(Integer peakTps);

        /**
         * <p>
         * The expected peak number of concurrent viewers for your content. MediaTailor uses this value along with peak
         * TPS to determine how to distribute prefetch requests across the available capacity without exceeding your ADS
         * limits.
         * </p>
         * 
         * @param peakConcurrentUsers
         *        The expected peak number of concurrent viewers for your content. MediaTailor uses this value along
         *        with peak TPS to determine how to distribute prefetch requests across the available capacity without
         *        exceeding your ADS limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peakConcurrentUsers(Integer peakConcurrentUsers);
    }

    static final class BuilderImpl implements Builder {
        private Integer peakTps;

        private Integer peakConcurrentUsers;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficShapingTpsConfiguration model) {
            peakTps(model.peakTps);
            peakConcurrentUsers(model.peakConcurrentUsers);
        }

        public final Integer getPeakTps() {
            return peakTps;
        }

        public final void setPeakTps(Integer peakTps) {
            this.peakTps = peakTps;
        }

        @Override
        public final Builder peakTps(Integer peakTps) {
            this.peakTps = peakTps;
            return this;
        }

        public final Integer getPeakConcurrentUsers() {
            return peakConcurrentUsers;
        }

        public final void setPeakConcurrentUsers(Integer peakConcurrentUsers) {
            this.peakConcurrentUsers = peakConcurrentUsers;
        }

        @Override
        public final Builder peakConcurrentUsers(Integer peakConcurrentUsers) {
            this.peakConcurrentUsers = peakConcurrentUsers;
            return this;
        }

        @Override
        public TrafficShapingTpsConfiguration build() {
            return new TrafficShapingTpsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
