/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Program transition configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Transition implements SdkPojo, Serializable, ToCopyableBuilder<Transition.Builder, Transition> {
    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMillis").getter(getter(Transition::durationMillis)).setter(setter(Builder::durationMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()).build();

    private static final SdkField<String> RELATIVE_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelativePosition").getter(getter(Transition::relativePositionAsString))
            .setter(setter(Builder::relativePosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativePosition").build()).build();

    private static final SdkField<String> RELATIVE_PROGRAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelativeProgram").getter(getter(Transition::relativeProgram)).setter(setter(Builder::relativeProgram))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeProgram").build()).build();

    private static final SdkField<Long> SCHEDULED_START_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ScheduledStartTimeMillis").getter(getter(Transition::scheduledStartTimeMillis))
            .setter(setter(Builder::scheduledStartTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledStartTimeMillis").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Transition::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_MILLIS_FIELD,
            RELATIVE_POSITION_FIELD, RELATIVE_PROGRAM_FIELD, SCHEDULED_START_TIME_MILLIS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long durationMillis;

    private final String relativePosition;

    private final String relativeProgram;

    private final Long scheduledStartTimeMillis;

    private final String type;

    private Transition(BuilderImpl builder) {
        this.durationMillis = builder.durationMillis;
        this.relativePosition = builder.relativePosition;
        this.relativeProgram = builder.relativeProgram;
        this.scheduledStartTimeMillis = builder.scheduledStartTimeMillis;
        this.type = builder.type;
    }

    /**
     * <p>
     * The duration of the live program in seconds.
     * </p>
     * 
     * @return The duration of the live program in seconds.
     */
    public final Long durationMillis() {
        return durationMillis;
    }

    /**
     * <p>
     * The position where this program will be inserted relative to the <code>RelativePosition</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relativePosition}
     * will return {@link RelativePosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relativePositionAsString}.
     * </p>
     * 
     * @return The position where this program will be inserted relative to the <code>RelativePosition</code>.
     * @see RelativePosition
     */
    public final RelativePosition relativePosition() {
        return RelativePosition.fromValue(relativePosition);
    }

    /**
     * <p>
     * The position where this program will be inserted relative to the <code>RelativePosition</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relativePosition}
     * will return {@link RelativePosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relativePositionAsString}.
     * </p>
     * 
     * @return The position where this program will be inserted relative to the <code>RelativePosition</code>.
     * @see RelativePosition
     */
    public final String relativePositionAsString() {
        return relativePosition;
    }

    /**
     * <p>
     * The name of the program that this program will be inserted next to, as defined by <code>RelativePosition</code>.
     * </p>
     * 
     * @return The name of the program that this program will be inserted next to, as defined by
     *         <code>RelativePosition</code>.
     */
    public final String relativeProgram() {
        return relativeProgram;
    }

    /**
     * <p>
     * The date and time that the program is scheduled to start, in epoch milliseconds.
     * </p>
     * 
     * @return The date and time that the program is scheduled to start, in epoch milliseconds.
     */
    public final Long scheduledStartTimeMillis() {
        return scheduledStartTimeMillis;
    }

    /**
     * <p>
     * Defines when the program plays in the schedule. You can set the value to <code>ABSOLUTE</code> or
     * <code>RELATIVE</code>.
     * </p>
     * <p>
     * <code>ABSOLUTE</code> - The program plays at a specific wall clock time. This setting can only be used for
     * channels using the <code>LINEAR</code> <code>PlaybackMode</code>.
     * </p>
     * <p>
     * Note the following considerations when using <code>ABSOLUTE</code> transitions:
     * </p>
     * <p>
     * If the preceding program in the schedule has a duration that extends past the wall clock time, MediaTailor
     * truncates the preceding program on a common segment boundary.
     * </p>
     * <p>
     * If there are gaps in playback, MediaTailor plays the <code>FillerSlate</code> you configured for your linear
     * channel.
     * </p>
     * <p>
     * <code>RELATIVE</code> - The program is inserted into the schedule either before or after a program that you
     * specify via <code>RelativePosition</code>.
     * </p>
     * 
     * @return Defines when the program plays in the schedule. You can set the value to <code>ABSOLUTE</code> or
     *         <code>RELATIVE</code>.</p>
     *         <p>
     *         <code>ABSOLUTE</code> - The program plays at a specific wall clock time. This setting can only be used
     *         for channels using the <code>LINEAR</code> <code>PlaybackMode</code>.
     *         </p>
     *         <p>
     *         Note the following considerations when using <code>ABSOLUTE</code> transitions:
     *         </p>
     *         <p>
     *         If the preceding program in the schedule has a duration that extends past the wall clock time,
     *         MediaTailor truncates the preceding program on a common segment boundary.
     *         </p>
     *         <p>
     *         If there are gaps in playback, MediaTailor plays the <code>FillerSlate</code> you configured for your
     *         linear channel.
     *         </p>
     *         <p>
     *         <code>RELATIVE</code> - The program is inserted into the schedule either before or after a program that
     *         you specify via <code>RelativePosition</code>.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(relativePositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relativeProgram());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledStartTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transition)) {
            return false;
        }
        Transition other = (Transition) obj;
        return Objects.equals(durationMillis(), other.durationMillis())
                && Objects.equals(relativePositionAsString(), other.relativePositionAsString())
                && Objects.equals(relativeProgram(), other.relativeProgram())
                && Objects.equals(scheduledStartTimeMillis(), other.scheduledStartTimeMillis())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Transition").add("DurationMillis", durationMillis())
                .add("RelativePosition", relativePositionAsString()).add("RelativeProgram", relativeProgram())
                .add("ScheduledStartTimeMillis", scheduledStartTimeMillis()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurationMillis":
            return Optional.ofNullable(clazz.cast(durationMillis()));
        case "RelativePosition":
            return Optional.ofNullable(clazz.cast(relativePositionAsString()));
        case "RelativeProgram":
            return Optional.ofNullable(clazz.cast(relativeProgram()));
        case "ScheduledStartTimeMillis":
            return Optional.ofNullable(clazz.cast(scheduledStartTimeMillis()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DurationMillis", DURATION_MILLIS_FIELD);
        map.put("RelativePosition", RELATIVE_POSITION_FIELD);
        map.put("RelativeProgram", RELATIVE_PROGRAM_FIELD);
        map.put("ScheduledStartTimeMillis", SCHEDULED_START_TIME_MILLIS_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Transition, T> g) {
        return obj -> g.apply((Transition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Transition> {
        /**
         * <p>
         * The duration of the live program in seconds.
         * </p>
         * 
         * @param durationMillis
         *        The duration of the live program in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMillis(Long durationMillis);

        /**
         * <p>
         * The position where this program will be inserted relative to the <code>RelativePosition</code>.
         * </p>
         * 
         * @param relativePosition
         *        The position where this program will be inserted relative to the <code>RelativePosition</code>.
         * @see RelativePosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelativePosition
         */
        Builder relativePosition(String relativePosition);

        /**
         * <p>
         * The position where this program will be inserted relative to the <code>RelativePosition</code>.
         * </p>
         * 
         * @param relativePosition
         *        The position where this program will be inserted relative to the <code>RelativePosition</code>.
         * @see RelativePosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelativePosition
         */
        Builder relativePosition(RelativePosition relativePosition);

        /**
         * <p>
         * The name of the program that this program will be inserted next to, as defined by
         * <code>RelativePosition</code>.
         * </p>
         * 
         * @param relativeProgram
         *        The name of the program that this program will be inserted next to, as defined by
         *        <code>RelativePosition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativeProgram(String relativeProgram);

        /**
         * <p>
         * The date and time that the program is scheduled to start, in epoch milliseconds.
         * </p>
         * 
         * @param scheduledStartTimeMillis
         *        The date and time that the program is scheduled to start, in epoch milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledStartTimeMillis(Long scheduledStartTimeMillis);

        /**
         * <p>
         * Defines when the program plays in the schedule. You can set the value to <code>ABSOLUTE</code> or
         * <code>RELATIVE</code>.
         * </p>
         * <p>
         * <code>ABSOLUTE</code> - The program plays at a specific wall clock time. This setting can only be used for
         * channels using the <code>LINEAR</code> <code>PlaybackMode</code>.
         * </p>
         * <p>
         * Note the following considerations when using <code>ABSOLUTE</code> transitions:
         * </p>
         * <p>
         * If the preceding program in the schedule has a duration that extends past the wall clock time, MediaTailor
         * truncates the preceding program on a common segment boundary.
         * </p>
         * <p>
         * If there are gaps in playback, MediaTailor plays the <code>FillerSlate</code> you configured for your linear
         * channel.
         * </p>
         * <p>
         * <code>RELATIVE</code> - The program is inserted into the schedule either before or after a program that you
         * specify via <code>RelativePosition</code>.
         * </p>
         * 
         * @param type
         *        Defines when the program plays in the schedule. You can set the value to <code>ABSOLUTE</code> or
         *        <code>RELATIVE</code>.</p>
         *        <p>
         *        <code>ABSOLUTE</code> - The program plays at a specific wall clock time. This setting can only be used
         *        for channels using the <code>LINEAR</code> <code>PlaybackMode</code>.
         *        </p>
         *        <p>
         *        Note the following considerations when using <code>ABSOLUTE</code> transitions:
         *        </p>
         *        <p>
         *        If the preceding program in the schedule has a duration that extends past the wall clock time,
         *        MediaTailor truncates the preceding program on a common segment boundary.
         *        </p>
         *        <p>
         *        If there are gaps in playback, MediaTailor plays the <code>FillerSlate</code> you configured for your
         *        linear channel.
         *        </p>
         *        <p>
         *        <code>RELATIVE</code> - The program is inserted into the schedule either before or after a program
         *        that you specify via <code>RelativePosition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private Long durationMillis;

        private String relativePosition;

        private String relativeProgram;

        private Long scheduledStartTimeMillis;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Transition model) {
            durationMillis(model.durationMillis);
            relativePosition(model.relativePosition);
            relativeProgram(model.relativeProgram);
            scheduledStartTimeMillis(model.scheduledStartTimeMillis);
            type(model.type);
        }

        public final Long getDurationMillis() {
            return durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final String getRelativePosition() {
            return relativePosition;
        }

        public final void setRelativePosition(String relativePosition) {
            this.relativePosition = relativePosition;
        }

        @Override
        public final Builder relativePosition(String relativePosition) {
            this.relativePosition = relativePosition;
            return this;
        }

        @Override
        public final Builder relativePosition(RelativePosition relativePosition) {
            this.relativePosition(relativePosition == null ? null : relativePosition.toString());
            return this;
        }

        public final String getRelativeProgram() {
            return relativeProgram;
        }

        public final void setRelativeProgram(String relativeProgram) {
            this.relativeProgram = relativeProgram;
        }

        @Override
        public final Builder relativeProgram(String relativeProgram) {
            this.relativeProgram = relativeProgram;
            return this;
        }

        public final Long getScheduledStartTimeMillis() {
            return scheduledStartTimeMillis;
        }

        public final void setScheduledStartTimeMillis(Long scheduledStartTimeMillis) {
            this.scheduledStartTimeMillis = scheduledStartTimeMillis;
        }

        @Override
        public final Builder scheduledStartTimeMillis(Long scheduledStartTimeMillis) {
            this.scheduledStartTimeMillis = scheduledStartTimeMillis;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Transition build() {
            return new Transition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
