/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserRequest extends MemoryDbRequest implements
        ToCopyableBuilder<UpdateUserRequest.Builder, UpdateUserRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(UpdateUserRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<AuthenticationMode> AUTHENTICATION_MODE_FIELD = SdkField
            .<AuthenticationMode> builder(MarshallingType.SDK_POJO).memberName("AuthenticationMode")
            .getter(getter(UpdateUserRequest::authenticationMode)).setter(setter(Builder::authenticationMode))
            .constructor(AuthenticationMode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMode").build())
            .build();

    private static final SdkField<String> ACCESS_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessString").getter(getter(UpdateUserRequest::accessString)).setter(setter(Builder::accessString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            AUTHENTICATION_MODE_FIELD, ACCESS_STRING_FIELD));

    private final String userName;

    private final AuthenticationMode authenticationMode;

    private final String accessString;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.authenticationMode = builder.authenticationMode;
        this.accessString = builder.accessString;
    }

    /**
     * <p>
     * The name of the user
     * </p>
     * 
     * @return The name of the user
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * Denotes the user's authentication properties, such as whether it requires a password to authenticate.
     * </p>
     * 
     * @return Denotes the user's authentication properties, such as whether it requires a password to authenticate.
     */
    public final AuthenticationMode authenticationMode() {
        return authenticationMode;
    }

    /**
     * <p>
     * Access permissions string used for this user.
     * </p>
     * 
     * @return Access permissions string used for this user.
     */
    public final String accessString() {
        return accessString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMode());
        hashCode = 31 * hashCode + Objects.hashCode(accessString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(authenticationMode(), other.authenticationMode())
                && Objects.equals(accessString(), other.accessString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserRequest").add("UserName", userName()).add("AuthenticationMode", authenticationMode())
                .add("AccessString", accessString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "AuthenticationMode":
            return Optional.ofNullable(clazz.cast(authenticationMode()));
        case "AccessString":
            return Optional.ofNullable(clazz.cast(accessString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserRequest> {
        /**
         * <p>
         * The name of the user
         * </p>
         * 
         * @param userName
         *        The name of the user
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * Denotes the user's authentication properties, such as whether it requires a password to authenticate.
         * </p>
         * 
         * @param authenticationMode
         *        Denotes the user's authentication properties, such as whether it requires a password to authenticate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationMode(AuthenticationMode authenticationMode);

        /**
         * <p>
         * Denotes the user's authentication properties, such as whether it requires a password to authenticate.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationMode.Builder} avoiding the
         * need to create one manually via {@link AuthenticationMode#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuthenticationMode.Builder#build()} is called immediately and its
         * result is passed to {@link #authenticationMode(AuthenticationMode)}.
         * 
         * @param authenticationMode
         *        a consumer that will call methods on {@link AuthenticationMode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationMode(AuthenticationMode)
         */
        default Builder authenticationMode(Consumer<AuthenticationMode.Builder> authenticationMode) {
            return authenticationMode(AuthenticationMode.builder().applyMutation(authenticationMode).build());
        }

        /**
         * <p>
         * Access permissions string used for this user.
         * </p>
         * 
         * @param accessString
         *        Access permissions string used for this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessString(String accessString);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private String userName;

        private AuthenticationMode authenticationMode;

        private String accessString;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            userName(model.userName);
            authenticationMode(model.authenticationMode);
            accessString(model.accessString);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final AuthenticationMode.Builder getAuthenticationMode() {
            return authenticationMode != null ? authenticationMode.toBuilder() : null;
        }

        public final void setAuthenticationMode(AuthenticationMode.BuilderImpl authenticationMode) {
            this.authenticationMode = authenticationMode != null ? authenticationMode.build() : null;
        }

        @Override
        public final Builder authenticationMode(AuthenticationMode authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }

        public final String getAccessString() {
            return accessString;
        }

        public final void setAccessString(String accessString) {
            this.accessString = accessString;
        }

        @Override
        public final Builder accessString(String accessString) {
            this.accessString = accessString;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
