/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of updates being applied to the cluster
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterPendingUpdates implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterPendingUpdates.Builder, ClusterPendingUpdates> {
    private static final SdkField<ReshardingStatus> RESHARDING_FIELD = SdkField
            .<ReshardingStatus> builder(MarshallingType.SDK_POJO).memberName("Resharding")
            .getter(getter(ClusterPendingUpdates::resharding)).setter(setter(Builder::resharding))
            .constructor(ReshardingStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resharding").build()).build();

    private static final SdkField<ACLsUpdateStatus> AC_LS_FIELD = SdkField.<ACLsUpdateStatus> builder(MarshallingType.SDK_POJO)
            .memberName("ACLs").getter(getter(ClusterPendingUpdates::acLs)).setter(setter(Builder::acLs))
            .constructor(ACLsUpdateStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLs").build()).build();

    private static final SdkField<List<PendingModifiedServiceUpdate>> SERVICE_UPDATES_FIELD = SdkField
            .<List<PendingModifiedServiceUpdate>> builder(MarshallingType.LIST)
            .memberName("ServiceUpdates")
            .getter(getter(ClusterPendingUpdates::serviceUpdates))
            .setter(setter(Builder::serviceUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PendingModifiedServiceUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(PendingModifiedServiceUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESHARDING_FIELD, AC_LS_FIELD,
            SERVICE_UPDATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ReshardingStatus resharding;

    private final ACLsUpdateStatus acLs;

    private final List<PendingModifiedServiceUpdate> serviceUpdates;

    private ClusterPendingUpdates(BuilderImpl builder) {
        this.resharding = builder.resharding;
        this.acLs = builder.acLs;
        this.serviceUpdates = builder.serviceUpdates;
    }

    /**
     * <p>
     * The status of an online resharding operation.
     * </p>
     * 
     * @return The status of an online resharding operation.
     */
    public final ReshardingStatus resharding() {
        return resharding;
    }

    /**
     * <p>
     * A list of ACLs associated with the cluster that are being updated
     * </p>
     * 
     * @return A list of ACLs associated with the cluster that are being updated
     */
    public final ACLsUpdateStatus acLs() {
        return acLs;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceUpdates() {
        return serviceUpdates != null && !(serviceUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of service updates being applied to the cluster
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceUpdates} method.
     * </p>
     * 
     * @return A list of service updates being applied to the cluster
     */
    public final List<PendingModifiedServiceUpdate> serviceUpdates() {
        return serviceUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resharding());
        hashCode = 31 * hashCode + Objects.hashCode(acLs());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceUpdates() ? serviceUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterPendingUpdates)) {
            return false;
        }
        ClusterPendingUpdates other = (ClusterPendingUpdates) obj;
        return Objects.equals(resharding(), other.resharding()) && Objects.equals(acLs(), other.acLs())
                && hasServiceUpdates() == other.hasServiceUpdates() && Objects.equals(serviceUpdates(), other.serviceUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterPendingUpdates").add("Resharding", resharding()).add("ACLs", acLs())
                .add("ServiceUpdates", hasServiceUpdates() ? serviceUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resharding":
            return Optional.ofNullable(clazz.cast(resharding()));
        case "ACLs":
            return Optional.ofNullable(clazz.cast(acLs()));
        case "ServiceUpdates":
            return Optional.ofNullable(clazz.cast(serviceUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterPendingUpdates, T> g) {
        return obj -> g.apply((ClusterPendingUpdates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterPendingUpdates> {
        /**
         * <p>
         * The status of an online resharding operation.
         * </p>
         * 
         * @param resharding
         *        The status of an online resharding operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resharding(ReshardingStatus resharding);

        /**
         * <p>
         * The status of an online resharding operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReshardingStatus.Builder} avoiding the
         * need to create one manually via {@link ReshardingStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReshardingStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #resharding(ReshardingStatus)}.
         * 
         * @param resharding
         *        a consumer that will call methods on {@link ReshardingStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resharding(ReshardingStatus)
         */
        default Builder resharding(Consumer<ReshardingStatus.Builder> resharding) {
            return resharding(ReshardingStatus.builder().applyMutation(resharding).build());
        }

        /**
         * <p>
         * A list of ACLs associated with the cluster that are being updated
         * </p>
         * 
         * @param acLs
         *        A list of ACLs associated with the cluster that are being updated
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acLs(ACLsUpdateStatus acLs);

        /**
         * <p>
         * A list of ACLs associated with the cluster that are being updated
         * </p>
         * This is a convenience method that creates an instance of the {@link ACLsUpdateStatus.Builder} avoiding the
         * need to create one manually via {@link ACLsUpdateStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ACLsUpdateStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #acLs(ACLsUpdateStatus)}.
         * 
         * @param acLs
         *        a consumer that will call methods on {@link ACLsUpdateStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acLs(ACLsUpdateStatus)
         */
        default Builder acLs(Consumer<ACLsUpdateStatus.Builder> acLs) {
            return acLs(ACLsUpdateStatus.builder().applyMutation(acLs).build());
        }

        /**
         * <p>
         * A list of service updates being applied to the cluster
         * </p>
         * 
         * @param serviceUpdates
         *        A list of service updates being applied to the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdates(Collection<PendingModifiedServiceUpdate> serviceUpdates);

        /**
         * <p>
         * A list of service updates being applied to the cluster
         * </p>
         * 
         * @param serviceUpdates
         *        A list of service updates being applied to the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdates(PendingModifiedServiceUpdate... serviceUpdates);

        /**
         * <p>
         * A list of service updates being applied to the cluster
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <PendingModifiedServiceUpdate>.Builder} avoiding the need to create one manually via {@link List
         * <PendingModifiedServiceUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PendingModifiedServiceUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceUpdates(List<PendingModifiedServiceUpdate>)}.
         * 
         * @param serviceUpdates
         *        a consumer that will call methods on {@link List<PendingModifiedServiceUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceUpdates(List<PendingModifiedServiceUpdate>)
         */
        Builder serviceUpdates(Consumer<PendingModifiedServiceUpdate.Builder>... serviceUpdates);
    }

    static final class BuilderImpl implements Builder {
        private ReshardingStatus resharding;

        private ACLsUpdateStatus acLs;

        private List<PendingModifiedServiceUpdate> serviceUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterPendingUpdates model) {
            resharding(model.resharding);
            acLs(model.acLs);
            serviceUpdates(model.serviceUpdates);
        }

        public final ReshardingStatus.Builder getResharding() {
            return resharding != null ? resharding.toBuilder() : null;
        }

        public final void setResharding(ReshardingStatus.BuilderImpl resharding) {
            this.resharding = resharding != null ? resharding.build() : null;
        }

        @Override
        public final Builder resharding(ReshardingStatus resharding) {
            this.resharding = resharding;
            return this;
        }

        public final ACLsUpdateStatus.Builder getAcLs() {
            return acLs != null ? acLs.toBuilder() : null;
        }

        public final void setAcLs(ACLsUpdateStatus.BuilderImpl acLs) {
            this.acLs = acLs != null ? acLs.build() : null;
        }

        @Override
        public final Builder acLs(ACLsUpdateStatus acLs) {
            this.acLs = acLs;
            return this;
        }

        public final List<PendingModifiedServiceUpdate.Builder> getServiceUpdates() {
            List<PendingModifiedServiceUpdate.Builder> result = PendingModifiedServiceUpdateListCopier
                    .copyToBuilder(this.serviceUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceUpdates(Collection<PendingModifiedServiceUpdate.BuilderImpl> serviceUpdates) {
            this.serviceUpdates = PendingModifiedServiceUpdateListCopier.copyFromBuilder(serviceUpdates);
        }

        @Override
        public final Builder serviceUpdates(Collection<PendingModifiedServiceUpdate> serviceUpdates) {
            this.serviceUpdates = PendingModifiedServiceUpdateListCopier.copy(serviceUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdates(PendingModifiedServiceUpdate... serviceUpdates) {
            serviceUpdates(Arrays.asList(serviceUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdates(Consumer<PendingModifiedServiceUpdate.Builder>... serviceUpdates) {
            serviceUpdates(Stream.of(serviceUpdates).map(c -> PendingModifiedServiceUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ClusterPendingUpdates build() {
            return new ClusterPendingUpdates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
