/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an individual node within a cluster. Each node runs its own instance of the cluster's protocol-compliant
 * caching software.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Node implements SdkPojo, Serializable, ToCopyableBuilder<Node.Builder, Node> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Node::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Node::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(Node::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(Node::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("Endpoint").getter(getter(Node::endpoint)).setter(setter(Builder::endpoint))
            .constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            AVAILABILITY_ZONE_FIELD, CREATE_TIME_FIELD, ENDPOINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final String availabilityZone;

    private final Instant createTime;

    private final Endpoint endpoint;

    private Node(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.availabilityZone = builder.availabilityZone;
        this.createTime = builder.createTime;
        this.endpoint = builder.endpoint;
    }

    /**
     * <p>
     * The node identifier. A node name is a numeric identifier (0001, 0002, etc.). The combination of cluster name,
     * shard name and node name uniquely identifies every node used in a customer's Amazon account.
     * </p>
     * 
     * @return The node identifier. A node name is a numeric identifier (0001, 0002, etc.). The combination of cluster
     *         name, shard name and node name uniquely identifies every node used in a customer's Amazon account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the service update on the node
     * </p>
     * 
     * @return The status of the service update on the node
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The Availability Zone in which the node resides
     * </p>
     * 
     * @return The Availability Zone in which the node resides
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The date and time when the node was created.
     * </p>
     * 
     * @return The date and time when the node was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The hostname for connecting to this node.
     * </p>
     * 
     * @return The hostname for connecting to this node.
     */
    public final Endpoint endpoint() {
        return endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(status(), other.status())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(endpoint(), other.endpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Node").add("Name", name()).add("Status", status()).add("AvailabilityZone", availabilityZone())
                .add("CreateTime", createTime()).add("Endpoint", endpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Node> {
        /**
         * <p>
         * The node identifier. A node name is a numeric identifier (0001, 0002, etc.). The combination of cluster name,
         * shard name and node name uniquely identifies every node used in a customer's Amazon account.
         * </p>
         * 
         * @param name
         *        The node identifier. A node name is a numeric identifier (0001, 0002, etc.). The combination of
         *        cluster name, shard name and node name uniquely identifies every node used in a customer's Amazon
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the service update on the node
         * </p>
         * 
         * @param status
         *        The status of the service update on the node
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The Availability Zone in which the node resides
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the node resides
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The date and time when the node was created.
         * </p>
         * 
         * @param createTime
         *        The date and time when the node was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The hostname for connecting to this node.
         * </p>
         * 
         * @param endpoint
         *        The hostname for connecting to this node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(Endpoint endpoint);

        /**
         * <p>
         * The hostname for connecting to this node.
         * </p>
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #endpoint(Endpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(Endpoint)
         */
        default Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return endpoint(Endpoint.builder().applyMutation(endpoint).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private String availabilityZone;

        private Instant createTime;

        private Endpoint endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            name(model.name);
            status(model.status);
            availabilityZone(model.availabilityZone);
            createTime(model.createTime);
            endpoint(model.endpoint);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Endpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Node build() {
            return new Node(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
