/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEngineVersionsResponse extends MemoryDbResponse implements
        ToCopyableBuilder<DescribeEngineVersionsResponse.Builder, DescribeEngineVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEngineVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<EngineVersionInfo>> ENGINE_VERSIONS_FIELD = SdkField
            .<List<EngineVersionInfo>> builder(MarshallingType.LIST)
            .memberName("EngineVersions")
            .getter(getter(DescribeEngineVersionsResponse::engineVersions))
            .setter(setter(Builder::engineVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngineVersionInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngineVersionInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ENGINE_VERSIONS_FIELD));

    private final String nextToken;

    private final List<EngineVersionInfo> engineVersions;

    private DescribeEngineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.engineVersions = builder.engineVersions;
    }

    /**
     * <p>
     * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is
     * returned, there are more results available. The value of nextToken is a unique pagination token for each page.
     * Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
     * </p>
     * 
     * @return An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
     *         nextToken is returned, there are more results available. The value of nextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page. Keep all
     *         other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EngineVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEngineVersions() {
        return engineVersions != null && !(engineVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of engine version details. Each element in the list contains detailed information about one engine
     * version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngineVersions} method.
     * </p>
     * 
     * @return A list of engine version details. Each element in the list contains detailed information about one engine
     *         version.
     */
    public final List<EngineVersionInfo> engineVersions() {
        return engineVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEngineVersions() ? engineVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEngineVersionsResponse)) {
            return false;
        }
        DescribeEngineVersionsResponse other = (DescribeEngineVersionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasEngineVersions() == other.hasEngineVersions()
                && Objects.equals(engineVersions(), other.engineVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEngineVersionsResponse").add("NextToken", nextToken())
                .add("EngineVersions", hasEngineVersions() ? engineVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "EngineVersions":
            return Optional.ofNullable(clazz.cast(engineVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEngineVersionsResponse, T> g) {
        return obj -> g.apply((DescribeEngineVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEngineVersionsResponse> {
        /**
         * <p>
         * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
         * nextToken is returned, there are more results available. The value of nextToken is a unique pagination token
         * for each page. Make the call again using the returned token to retrieve the next page. Keep all other
         * arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
         *        nextToken is returned, there are more results available. The value of nextToken is a unique pagination
         *        token for each page. Make the call again using the returned token to retrieve the next page. Keep all
         *        other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of engine version details. Each element in the list contains detailed information about one engine
         * version.
         * </p>
         * 
         * @param engineVersions
         *        A list of engine version details. Each element in the list contains detailed information about one
         *        engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersions(Collection<EngineVersionInfo> engineVersions);

        /**
         * <p>
         * A list of engine version details. Each element in the list contains detailed information about one engine
         * version.
         * </p>
         * 
         * @param engineVersions
         *        A list of engine version details. Each element in the list contains detailed information about one
         *        engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersions(EngineVersionInfo... engineVersions);

        /**
         * <p>
         * A list of engine version details. Each element in the list contains detailed information about one engine
         * version.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EngineVersionInfo>.Builder} avoiding
         * the need to create one manually via {@link List<EngineVersionInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EngineVersionInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #engineVersions(List<EngineVersionInfo>)}.
         * 
         * @param engineVersions
         *        a consumer that will call methods on {@link List<EngineVersionInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineVersions(List<EngineVersionInfo>)
         */
        Builder engineVersions(Consumer<EngineVersionInfo.Builder>... engineVersions);
    }

    static final class BuilderImpl extends MemoryDbResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<EngineVersionInfo> engineVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEngineVersionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            engineVersions(model.engineVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EngineVersionInfo.Builder> getEngineVersions() {
            List<EngineVersionInfo.Builder> result = EngineVersionInfoListCopier.copyToBuilder(this.engineVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngineVersions(Collection<EngineVersionInfo.BuilderImpl> engineVersions) {
            this.engineVersions = EngineVersionInfoListCopier.copyFromBuilder(engineVersions);
        }

        @Override
        public final Builder engineVersions(Collection<EngineVersionInfo> engineVersions) {
            this.engineVersions = EngineVersionInfoListCopier.copy(engineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineVersions(EngineVersionInfo... engineVersions) {
            engineVersions(Arrays.asList(engineVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineVersions(Consumer<EngineVersionInfo.Builder>... engineVersions) {
            engineVersions(Stream.of(engineVersions).map(c -> EngineVersionInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEngineVersionsResponse build() {
            return new DescribeEngineVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
