/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterRequest extends MemoryDbRequest implements
        ToCopyableBuilder<UpdateClusterRequest.Builder, UpdateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(UpdateClusterRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateClusterRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(UpdateClusterRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MAINTENANCE_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceWindow").getter(getter(UpdateClusterRequest::maintenanceWindow))
            .setter(setter(Builder::maintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceWindow").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(UpdateClusterRequest::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> SNS_TOPIC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicStatus").getter(getter(UpdateClusterRequest::snsTopicStatus))
            .setter(setter(Builder::snsTopicStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicStatus").build()).build();

    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupName").getter(getter(UpdateClusterRequest::parameterGroupName))
            .setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotWindow").getter(getter(UpdateClusterRequest::snapshotWindow))
            .setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(UpdateClusterRequest::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(UpdateClusterRequest::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(UpdateClusterRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<ReplicaConfigurationRequest> REPLICA_CONFIGURATION_FIELD = SdkField
            .<ReplicaConfigurationRequest> builder(MarshallingType.SDK_POJO).memberName("ReplicaConfiguration")
            .getter(getter(UpdateClusterRequest::replicaConfiguration)).setter(setter(Builder::replicaConfiguration))
            .constructor(ReplicaConfigurationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaConfiguration").build())
            .build();

    private static final SdkField<ShardConfigurationRequest> SHARD_CONFIGURATION_FIELD = SdkField
            .<ShardConfigurationRequest> builder(MarshallingType.SDK_POJO).memberName("ShardConfiguration")
            .getter(getter(UpdateClusterRequest::shardConfiguration)).setter(setter(Builder::shardConfiguration))
            .constructor(ShardConfigurationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardConfiguration").build())
            .build();

    private static final SdkField<String> ACL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ACLName").getter(getter(UpdateClusterRequest::aclName)).setter(setter(Builder::aclName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            DESCRIPTION_FIELD, SECURITY_GROUP_IDS_FIELD, MAINTENANCE_WINDOW_FIELD, SNS_TOPIC_ARN_FIELD, SNS_TOPIC_STATUS_FIELD,
            PARAMETER_GROUP_NAME_FIELD, SNAPSHOT_WINDOW_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, NODE_TYPE_FIELD,
            ENGINE_VERSION_FIELD, REPLICA_CONFIGURATION_FIELD, SHARD_CONFIGURATION_FIELD, ACL_NAME_FIELD));

    private final String clusterName;

    private final String description;

    private final List<String> securityGroupIds;

    private final String maintenanceWindow;

    private final String snsTopicArn;

    private final String snsTopicStatus;

    private final String parameterGroupName;

    private final String snapshotWindow;

    private final Integer snapshotRetentionLimit;

    private final String nodeType;

    private final String engineVersion;

    private final ReplicaConfigurationRequest replicaConfiguration;

    private final ShardConfigurationRequest shardConfiguration;

    private final String aclName;

    private UpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.description = builder.description;
        this.securityGroupIds = builder.securityGroupIds;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.snsTopicArn = builder.snsTopicArn;
        this.snsTopicStatus = builder.snsTopicStatus;
        this.parameterGroupName = builder.parameterGroupName;
        this.snapshotWindow = builder.snapshotWindow;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.nodeType = builder.nodeType;
        this.engineVersion = builder.engineVersion;
        this.replicaConfiguration = builder.replicaConfiguration;
        this.shardConfiguration = builder.shardConfiguration;
        this.aclName = builder.aclName;
    }

    /**
     * <p>
     * The name of the cluster to update
     * </p>
     * 
     * @return The name of the cluster to update
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The description of the cluster to update
     * </p>
     * 
     * @return The description of the cluster to update
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The SecurityGroupIds to update
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The SecurityGroupIds to update
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The maintenance window to update
     * </p>
     * 
     * @return The maintenance window to update
     */
    public final String maintenanceWindow() {
        return maintenanceWindow;
    }

    /**
     * <p>
     * The SNS topic ARN to update
     * </p>
     * 
     * @return The SNS topic ARN to update
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.
     * </p>
     * 
     * @return The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.
     */
    public final String snsTopicStatus() {
        return snsTopicStatus;
    }

    /**
     * <p>
     * The name of the parameter group to update
     * </p>
     * 
     * @return The name of the parameter group to update
     */
    public final String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.
     * </p>
     * 
     * @return The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.
     */
    public final String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example, if
     * you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     * </p>
     * 
     * @return The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For
     *         example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days
     *         before being deleted.
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * A valid node type that you want to scale this cluster up or down to.
     * </p>
     * 
     * @return A valid node type that you want to scale this cluster up or down to.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you
     * cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the
     * existing cluster and create it anew with the earlier engine version.
     * </p>
     * 
     * @return The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but
     *         you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must
     *         delete the existing cluster and create it anew with the earlier engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The number of replicas that will reside in each shard
     * </p>
     * 
     * @return The number of replicas that will reside in each shard
     */
    public final ReplicaConfigurationRequest replicaConfiguration() {
        return replicaConfiguration;
    }

    /**
     * <p>
     * The number of shards in the cluster
     * </p>
     * 
     * @return The number of shards in the cluster
     */
    public final ShardConfigurationRequest shardConfiguration() {
        return shardConfiguration;
    }

    /**
     * <p>
     * The Access Control List that is associated with the cluster
     * </p>
     * 
     * @return The Access Control List that is associated with the cluster
     */
    public final String aclName() {
        return aclName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicStatus());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(replicaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(shardConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(aclName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(description(), other.description())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(maintenanceWindow(), other.maintenanceWindow())
                && Objects.equals(snsTopicArn(), other.snsTopicArn()) && Objects.equals(snsTopicStatus(), other.snsTopicStatus())
                && Objects.equals(parameterGroupName(), other.parameterGroupName())
                && Objects.equals(snapshotWindow(), other.snapshotWindow())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(nodeType(), other.nodeType()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(replicaConfiguration(), other.replicaConfiguration())
                && Objects.equals(shardConfiguration(), other.shardConfiguration()) && Objects.equals(aclName(), other.aclName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterRequest").add("ClusterName", clusterName()).add("Description", description())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("MaintenanceWindow", maintenanceWindow()).add("SnsTopicArn", snsTopicArn())
                .add("SnsTopicStatus", snsTopicStatus()).add("ParameterGroupName", parameterGroupName())
                .add("SnapshotWindow", snapshotWindow()).add("SnapshotRetentionLimit", snapshotRetentionLimit())
                .add("NodeType", nodeType()).add("EngineVersion", engineVersion())
                .add("ReplicaConfiguration", replicaConfiguration()).add("ShardConfiguration", shardConfiguration())
                .add("ACLName", aclName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "MaintenanceWindow":
            return Optional.ofNullable(clazz.cast(maintenanceWindow()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SnsTopicStatus":
            return Optional.ofNullable(clazz.cast(snsTopicStatus()));
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "ReplicaConfiguration":
            return Optional.ofNullable(clazz.cast(replicaConfiguration()));
        case "ShardConfiguration":
            return Optional.ofNullable(clazz.cast(shardConfiguration()));
        case "ACLName":
            return Optional.ofNullable(clazz.cast(aclName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterRequest, T> g) {
        return obj -> g.apply((UpdateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterRequest> {
        /**
         * <p>
         * The name of the cluster to update
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster to update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The description of the cluster to update
         * </p>
         * 
         * @param description
         *        The description of the cluster to update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The SecurityGroupIds to update
         * </p>
         * 
         * @param securityGroupIds
         *        The SecurityGroupIds to update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The SecurityGroupIds to update
         * </p>
         * 
         * @param securityGroupIds
         *        The SecurityGroupIds to update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The maintenance window to update
         * </p>
         * 
         * @param maintenanceWindow
         *        The maintenance window to update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindow(String maintenanceWindow);

        /**
         * <p>
         * The SNS topic ARN to update
         * </p>
         * 
         * @param snsTopicArn
         *        The SNS topic ARN to update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.
         * </p>
         * 
         * @param snsTopicStatus
         *        The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicStatus(String snsTopicStatus);

        /**
         * <p>
         * The name of the parameter group to update
         * </p>
         * 
         * @param parameterGroupName
         *        The name of the parameter group to update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.
         * </p>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example,
         * if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being
         * deleted.
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For
         *        example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5
         *        days before being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * A valid node type that you want to scale this cluster up or down to.
         * </p>
         * 
         * @param nodeType
         *        A valid node type that you want to scale this cluster up or down to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you
         * cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete
         * the existing cluster and create it anew with the earlier engine version.
         * </p>
         * 
         * @param engineVersion
         *        The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version,
         *        but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version,
         *        you must delete the existing cluster and create it anew with the earlier engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The number of replicas that will reside in each shard
         * </p>
         * 
         * @param replicaConfiguration
         *        The number of replicas that will reside in each shard
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaConfiguration(ReplicaConfigurationRequest replicaConfiguration);

        /**
         * <p>
         * The number of replicas that will reside in each shard
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicaConfigurationRequest.Builder}
         * avoiding the need to create one manually via {@link ReplicaConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicaConfigurationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #replicaConfiguration(ReplicaConfigurationRequest)}.
         * 
         * @param replicaConfiguration
         *        a consumer that will call methods on {@link ReplicaConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaConfiguration(ReplicaConfigurationRequest)
         */
        default Builder replicaConfiguration(Consumer<ReplicaConfigurationRequest.Builder> replicaConfiguration) {
            return replicaConfiguration(ReplicaConfigurationRequest.builder().applyMutation(replicaConfiguration).build());
        }

        /**
         * <p>
         * The number of shards in the cluster
         * </p>
         * 
         * @param shardConfiguration
         *        The number of shards in the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardConfiguration(ShardConfigurationRequest shardConfiguration);

        /**
         * <p>
         * The number of shards in the cluster
         * </p>
         * This is a convenience method that creates an instance of the {@link ShardConfigurationRequest.Builder}
         * avoiding the need to create one manually via {@link ShardConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShardConfigurationRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #shardConfiguration(ShardConfigurationRequest)}.
         * 
         * @param shardConfiguration
         *        a consumer that will call methods on {@link ShardConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shardConfiguration(ShardConfigurationRequest)
         */
        default Builder shardConfiguration(Consumer<ShardConfigurationRequest.Builder> shardConfiguration) {
            return shardConfiguration(ShardConfigurationRequest.builder().applyMutation(shardConfiguration).build());
        }

        /**
         * <p>
         * The Access Control List that is associated with the cluster
         * </p>
         * 
         * @param aclName
         *        The Access Control List that is associated with the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aclName(String aclName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String description;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String maintenanceWindow;

        private String snsTopicArn;

        private String snsTopicStatus;

        private String parameterGroupName;

        private String snapshotWindow;

        private Integer snapshotRetentionLimit;

        private String nodeType;

        private String engineVersion;

        private ReplicaConfigurationRequest replicaConfiguration;

        private ShardConfigurationRequest shardConfiguration;

        private String aclName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterRequest model) {
            super(model);
            clusterName(model.clusterName);
            description(model.description);
            securityGroupIds(model.securityGroupIds);
            maintenanceWindow(model.maintenanceWindow);
            snsTopicArn(model.snsTopicArn);
            snsTopicStatus(model.snsTopicStatus);
            parameterGroupName(model.parameterGroupName);
            snapshotWindow(model.snapshotWindow);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            nodeType(model.nodeType);
            engineVersion(model.engineVersion);
            replicaConfiguration(model.replicaConfiguration);
            shardConfiguration(model.shardConfiguration);
            aclName(model.aclName);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getMaintenanceWindow() {
            return maintenanceWindow;
        }

        public final void setMaintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
        }

        @Override
        public final Builder maintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSnsTopicStatus() {
            return snsTopicStatus;
        }

        public final void setSnsTopicStatus(String snsTopicStatus) {
            this.snsTopicStatus = snsTopicStatus;
        }

        @Override
        public final Builder snsTopicStatus(String snsTopicStatus) {
            this.snsTopicStatus = snsTopicStatus;
            return this;
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final ReplicaConfigurationRequest.Builder getReplicaConfiguration() {
            return replicaConfiguration != null ? replicaConfiguration.toBuilder() : null;
        }

        public final void setReplicaConfiguration(ReplicaConfigurationRequest.BuilderImpl replicaConfiguration) {
            this.replicaConfiguration = replicaConfiguration != null ? replicaConfiguration.build() : null;
        }

        @Override
        public final Builder replicaConfiguration(ReplicaConfigurationRequest replicaConfiguration) {
            this.replicaConfiguration = replicaConfiguration;
            return this;
        }

        public final ShardConfigurationRequest.Builder getShardConfiguration() {
            return shardConfiguration != null ? shardConfiguration.toBuilder() : null;
        }

        public final void setShardConfiguration(ShardConfigurationRequest.BuilderImpl shardConfiguration) {
            this.shardConfiguration = shardConfiguration != null ? shardConfiguration.build() : null;
        }

        @Override
        public final Builder shardConfiguration(ShardConfigurationRequest shardConfiguration) {
            this.shardConfiguration = shardConfiguration;
            return this;
        }

        public final String getAclName() {
            return aclName;
        }

        public final void setAclName(String aclName) {
            this.aclName = aclName;
        }

        @Override
        public final Builder aclName(String aclName) {
            this.aclName = aclName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterRequest build() {
            return new UpdateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
