/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of a shard in a snapshot
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShardDetail implements SdkPojo, Serializable, ToCopyableBuilder<ShardDetail.Builder, ShardDetail> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ShardDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ShardConfiguration> CONFIGURATION_FIELD = SdkField
            .<ShardConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(ShardDetail::configuration)).setter(setter(Builder::configuration))
            .constructor(ShardConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<String> SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Size")
            .getter(getter(ShardDetail::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<Instant> SNAPSHOT_CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SnapshotCreationTime").getter(getter(ShardDetail::snapshotCreationTime))
            .setter(setter(Builder::snapshotCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CONFIGURATION_FIELD, SIZE_FIELD, SNAPSHOT_CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ShardConfiguration configuration;

    private final String size;

    private final Instant snapshotCreationTime;

    private ShardDetail(BuilderImpl builder) {
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.size = builder.size;
        this.snapshotCreationTime = builder.snapshotCreationTime;
    }

    /**
     * <p>
     * The name of the shard
     * </p>
     * 
     * @return The name of the shard
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration details of the shard
     * </p>
     * 
     * @return The configuration details of the shard
     */
    public final ShardConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The size of the shard's snapshot
     * </p>
     * 
     * @return The size of the shard's snapshot
     */
    public final String size() {
        return size;
    }

    /**
     * <p>
     * The date and time that the shard's snapshot was created
     * </p>
     * 
     * @return The date and time that the shard's snapshot was created
     */
    public final Instant snapshotCreationTime() {
        return snapshotCreationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCreationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShardDetail)) {
            return false;
        }
        ShardDetail other = (ShardDetail) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(size(), other.size()) && Objects.equals(snapshotCreationTime(), other.snapshotCreationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShardDetail").add("Name", name()).add("Configuration", configuration()).add("Size", size())
                .add("SnapshotCreationTime", snapshotCreationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "SnapshotCreationTime":
            return Optional.ofNullable(clazz.cast(snapshotCreationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShardDetail, T> g) {
        return obj -> g.apply((ShardDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShardDetail> {
        /**
         * <p>
         * The name of the shard
         * </p>
         * 
         * @param name
         *        The name of the shard
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration details of the shard
         * </p>
         * 
         * @param configuration
         *        The configuration details of the shard
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ShardConfiguration configuration);

        /**
         * <p>
         * The configuration details of the shard
         * </p>
         * This is a convenience that creates an instance of the {@link ShardConfiguration.Builder} avoiding the need to
         * create one manually via {@link ShardConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ShardConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(ShardConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ShardConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ShardConfiguration)
         */
        default Builder configuration(Consumer<ShardConfiguration.Builder> configuration) {
            return configuration(ShardConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The size of the shard's snapshot
         * </p>
         * 
         * @param size
         *        The size of the shard's snapshot
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(String size);

        /**
         * <p>
         * The date and time that the shard's snapshot was created
         * </p>
         * 
         * @param snapshotCreationTime
         *        The date and time that the shard's snapshot was created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCreationTime(Instant snapshotCreationTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ShardConfiguration configuration;

        private String size;

        private Instant snapshotCreationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ShardDetail model) {
            name(model.name);
            configuration(model.configuration);
            size(model.size);
            snapshotCreationTime(model.snapshotCreationTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ShardConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ShardConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder configuration(ShardConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getSize() {
            return size;
        }

        public final void setSize(String size) {
            this.size = size;
        }

        @Override
        @Transient
        public final Builder size(String size) {
            this.size = size;
            return this;
        }

        public final Instant getSnapshotCreationTime() {
            return snapshotCreationTime;
        }

        public final void setSnapshotCreationTime(Instant snapshotCreationTime) {
            this.snapshotCreationTime = snapshotCreationTime;
        }

        @Override
        @Transient
        public final Builder snapshotCreationTime(Instant snapshotCreationTime) {
            this.snapshotCreationTime = snapshotCreationTime;
            return this;
        }

        @Override
        public ShardDetail build() {
            return new ShardDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
