/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the online resharding
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReshardingStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ReshardingStatus.Builder, ReshardingStatus> {
    private static final SdkField<SlotMigration> SLOT_MIGRATION_FIELD = SdkField
            .<SlotMigration> builder(MarshallingType.SDK_POJO).memberName("SlotMigration")
            .getter(getter(ReshardingStatus::slotMigration)).setter(setter(Builder::slotMigration))
            .constructor(SlotMigration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlotMigration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_MIGRATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SlotMigration slotMigration;

    private ReshardingStatus(BuilderImpl builder) {
        this.slotMigration = builder.slotMigration;
    }

    /**
     * <p>
     * The status of the online resharding slot migration
     * </p>
     * 
     * @return The status of the online resharding slot migration
     */
    public final SlotMigration slotMigration() {
        return slotMigration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slotMigration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReshardingStatus)) {
            return false;
        }
        ReshardingStatus other = (ReshardingStatus) obj;
        return Objects.equals(slotMigration(), other.slotMigration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReshardingStatus").add("SlotMigration", slotMigration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SlotMigration":
            return Optional.ofNullable(clazz.cast(slotMigration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReshardingStatus, T> g) {
        return obj -> g.apply((ReshardingStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReshardingStatus> {
        /**
         * <p>
         * The status of the online resharding slot migration
         * </p>
         * 
         * @param slotMigration
         *        The status of the online resharding slot migration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotMigration(SlotMigration slotMigration);

        /**
         * <p>
         * The status of the online resharding slot migration
         * </p>
         * This is a convenience method that creates an instance of the {@link SlotMigration.Builder} avoiding the need
         * to create one manually via {@link SlotMigration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlotMigration.Builder#build()} is called immediately and its
         * result is passed to {@link #slotMigration(SlotMigration)}.
         * 
         * @param slotMigration
         *        a consumer that will call methods on {@link SlotMigration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotMigration(SlotMigration)
         */
        default Builder slotMigration(Consumer<SlotMigration.Builder> slotMigration) {
            return slotMigration(SlotMigration.builder().applyMutation(slotMigration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SlotMigration slotMigration;

        private BuilderImpl() {
        }

        private BuilderImpl(ReshardingStatus model) {
            slotMigration(model.slotMigration);
        }

        public final SlotMigration.Builder getSlotMigration() {
            return slotMigration != null ? slotMigration.toBuilder() : null;
        }

        public final void setSlotMigration(SlotMigration.BuilderImpl slotMigration) {
            this.slotMigration = slotMigration != null ? slotMigration.build() : null;
        }

        @Override
        public final Builder slotMigration(SlotMigration slotMigration) {
            this.slotMigration = slotMigration;
            return this;
        }

        @Override
        public ReshardingStatus build() {
            return new ReshardingStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
