/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.memorydb.model.AclAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.AclNotFoundException;
import software.amazon.awssdk.services.memorydb.model.AclQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.ApiCallRateForCustomerExceededException;
import software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.ClusterNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ClusterQuotaForCustomerExceededException;
import software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.CopySnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.CreateAclRequest;
import software.amazon.awssdk.services.memorydb.model.CreateAclResponse;
import software.amazon.awssdk.services.memorydb.model.CreateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.CreateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.CreateParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.CreateParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.CreateUserRequest;
import software.amazon.awssdk.services.memorydb.model.CreateUserResponse;
import software.amazon.awssdk.services.memorydb.model.DefaultUserRequiredException;
import software.amazon.awssdk.services.memorydb.model.DeleteAclRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteAclResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteUserRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteUserResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse;
import software.amazon.awssdk.services.memorydb.model.DuplicateUserNameException;
import software.amazon.awssdk.services.memorydb.model.FailoverShardRequest;
import software.amazon.awssdk.services.memorydb.model.FailoverShardResponse;
import software.amazon.awssdk.services.memorydb.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.memorydb.model.InvalidAclStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidArnException;
import software.amazon.awssdk.services.memorydb.model.InvalidClusterStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidCredentialsException;
import software.amazon.awssdk.services.memorydb.model.InvalidKmsKeyException;
import software.amazon.awssdk.services.memorydb.model.InvalidNodeStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.memorydb.model.InvalidParameterGroupStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidParameterValueException;
import software.amazon.awssdk.services.memorydb.model.InvalidSnapshotStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidSubnetException;
import software.amazon.awssdk.services.memorydb.model.InvalidUserStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.ListTagsRequest;
import software.amazon.awssdk.services.memorydb.model.ListTagsResponse;
import software.amazon.awssdk.services.memorydb.model.MemoryDbException;
import software.amazon.awssdk.services.memorydb.model.NoOperationException;
import software.amazon.awssdk.services.memorydb.model.NodeQuotaForClusterExceededException;
import software.amazon.awssdk.services.memorydb.model.NodeQuotaForCustomerExceededException;
import software.amazon.awssdk.services.memorydb.model.ParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.ParameterGroupNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingRequest;
import software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingResponse;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.ReservedNodesOfferingNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.ServiceLinkedRoleNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ServiceUpdateNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ShardNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ShardsPerClusterQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.SnapshotAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.SnapshotNotFoundException;
import software.amazon.awssdk.services.memorydb.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupInUseException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupNotFoundException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.SubnetInUseException;
import software.amazon.awssdk.services.memorydb.model.SubnetNotAllowedException;
import software.amazon.awssdk.services.memorydb.model.SubnetQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.TagNotFoundException;
import software.amazon.awssdk.services.memorydb.model.TagQuotaPerResourceExceededException;
import software.amazon.awssdk.services.memorydb.model.TagResourceRequest;
import software.amazon.awssdk.services.memorydb.model.TagResourceResponse;
import software.amazon.awssdk.services.memorydb.model.TestFailoverNotAvailableException;
import software.amazon.awssdk.services.memorydb.model.UntagResourceRequest;
import software.amazon.awssdk.services.memorydb.model.UntagResourceResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateAclRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateAclResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateUserRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateUserResponse;
import software.amazon.awssdk.services.memorydb.model.UserAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.UserNotFoundException;
import software.amazon.awssdk.services.memorydb.model.UserQuotaExceededException;
import software.amazon.awssdk.services.memorydb.paginators.DescribeACLsIterable;
import software.amazon.awssdk.services.memorydb.paginators.DescribeClustersIterable;
import software.amazon.awssdk.services.memorydb.paginators.DescribeEngineVersionsIterable;
import software.amazon.awssdk.services.memorydb.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.memorydb.paginators.DescribeParameterGroupsIterable;
import software.amazon.awssdk.services.memorydb.paginators.DescribeParametersIterable;
import software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesIterable;
import software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesOfferingsIterable;
import software.amazon.awssdk.services.memorydb.paginators.DescribeServiceUpdatesIterable;
import software.amazon.awssdk.services.memorydb.paginators.DescribeSnapshotsIterable;
import software.amazon.awssdk.services.memorydb.paginators.DescribeSubnetGroupsIterable;
import software.amazon.awssdk.services.memorydb.paginators.DescribeUsersIterable;

/**
 * Service client for accessing Amazon MemoryDB. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * MemoryDB for Redis is a fully managed, Redis-compatible, in-memory database that delivers ultra-fast performance and
 * Multi-AZ durability for modern applications built using microservices architectures. MemoryDB stores the entire
 * database in-memory, enabling low latency and high throughput data access. It is compatible with Redis, a popular open
 * source data store, enabling you to leverage Redis’ flexible and friendly data structures, APIs, and commands.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MemoryDbClient extends SdkClient {
    String SERVICE_NAME = "memorydb";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "memory-db";

    /**
     * <p>
     * Apply the service update to a list of clusters supplied. For more information on service updates and applying
     * them, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates">Applying the
     * service updates</a>.
     * </p>
     *
     * @param batchUpdateClusterRequest
     * @return Result of the BatchUpdateCluster operation returned by the service.
     * @throws ServiceUpdateNotFoundException
     * @throws InvalidParameterValueException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.BatchUpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/BatchUpdateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchUpdateClusterResponse batchUpdateCluster(BatchUpdateClusterRequest batchUpdateClusterRequest)
            throws ServiceUpdateNotFoundException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Apply the service update to a list of clusters supplied. For more information on service updates and applying
     * them, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates">Applying the
     * service updates</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateClusterRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateClusterRequest#builder()}
     * </p>
     *
     * @param batchUpdateClusterRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateClusterRequest.Builder} to create a
     *        request.
     * @return Result of the BatchUpdateCluster operation returned by the service.
     * @throws ServiceUpdateNotFoundException
     * @throws InvalidParameterValueException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.BatchUpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/BatchUpdateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchUpdateClusterResponse batchUpdateCluster(Consumer<BatchUpdateClusterRequest.Builder> batchUpdateClusterRequest)
            throws ServiceUpdateNotFoundException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return batchUpdateCluster(BatchUpdateClusterRequest.builder().applyMutation(batchUpdateClusterRequest).build());
    }

    /**
     * <p>
     * Makes a copy of an existing snapshot.
     * </p>
     *
     * @param copySnapshotRequest
     * @return Result of the CopySnapshot operation returned by the service.
     * @throws SnapshotAlreadyExistsException
     * @throws SnapshotNotFoundException
     * @throws SnapshotQuotaExceededException
     * @throws InvalidSnapshotStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CopySnapshotResponse copySnapshot(CopySnapshotRequest copySnapshotRequest) throws SnapshotAlreadyExistsException,
            SnapshotNotFoundException, SnapshotQuotaExceededException, InvalidSnapshotStateException,
            ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Makes a copy of an existing snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopySnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CopySnapshotRequest#builder()}
     * </p>
     *
     * @param copySnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CopySnapshotRequest.Builder} to create a request.
     * @return Result of the CopySnapshot operation returned by the service.
     * @throws SnapshotAlreadyExistsException
     * @throws SnapshotNotFoundException
     * @throws SnapshotQuotaExceededException
     * @throws InvalidSnapshotStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CopySnapshotResponse copySnapshot(Consumer<CopySnapshotRequest.Builder> copySnapshotRequest)
            throws SnapshotAlreadyExistsException, SnapshotNotFoundException, SnapshotQuotaExceededException,
            InvalidSnapshotStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return copySnapshot(CopySnapshotRequest.builder().applyMutation(copySnapshotRequest).build());
    }

    /**
     * <p>
     * Creates an Access Control List. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     *
     * @param createAclRequest
     * @return Result of the CreateACL operation returned by the service.
     * @throws UserNotFoundException
     * @throws DuplicateUserNameException
     * @throws AclAlreadyExistsException
     * @throws DefaultUserRequiredException
     * @throws AclQuotaExceededException
     * @throws InvalidParameterValueException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAclResponse createACL(CreateAclRequest createAclRequest) throws UserNotFoundException,
            DuplicateUserNameException, AclAlreadyExistsException, DefaultUserRequiredException, AclQuotaExceededException,
            InvalidParameterValueException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Access Control List. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAclRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAclRequest#builder()}
     * </p>
     *
     * @param createAclRequest
     *        A {@link Consumer} that will call methods on {@link CreateACLRequest.Builder} to create a request.
     * @return Result of the CreateACL operation returned by the service.
     * @throws UserNotFoundException
     * @throws DuplicateUserNameException
     * @throws AclAlreadyExistsException
     * @throws DefaultUserRequiredException
     * @throws AclQuotaExceededException
     * @throws InvalidParameterValueException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateACL" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAclResponse createACL(Consumer<CreateAclRequest.Builder> createAclRequest) throws UserNotFoundException,
            DuplicateUserNameException, AclAlreadyExistsException, DefaultUserRequiredException, AclQuotaExceededException,
            InvalidParameterValueException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return createACL(CreateAclRequest.builder().applyMutation(createAclRequest).build());
    }

    /**
     * <p>
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.
     * </p>
     *
     * @param createClusterRequest
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ClusterAlreadyExistsException
     * @throws SubnetGroupNotFoundException
     * @throws ClusterQuotaForCustomerExceededException
     * @throws NodeQuotaForClusterExceededException
     * @throws NodeQuotaForCustomerExceededException
     * @throws ParameterGroupNotFoundException
     * @throws InsufficientClusterCapacityException
     * @throws InvalidVpcNetworkStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws ShardsPerClusterQuotaExceededException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws InvalidCredentialsException
     * @throws TagQuotaPerResourceExceededException
     * @throws AclNotFoundException
     * @throws InvalidAclStateException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ClusterAlreadyExistsException,
            SubnetGroupNotFoundException, ClusterQuotaForCustomerExceededException, NodeQuotaForClusterExceededException,
            NodeQuotaForCustomerExceededException, ParameterGroupNotFoundException, InsufficientClusterCapacityException,
            InvalidVpcNetworkStateException, ServiceLinkedRoleNotFoundException, ShardsPerClusterQuotaExceededException,
            InvalidParameterValueException, InvalidParameterCombinationException, InvalidCredentialsException,
            TagQuotaPerResourceExceededException, AclNotFoundException, InvalidAclStateException, AwsServiceException,
            SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterRequest.Builder} to create a request.
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ClusterAlreadyExistsException
     * @throws SubnetGroupNotFoundException
     * @throws ClusterQuotaForCustomerExceededException
     * @throws NodeQuotaForClusterExceededException
     * @throws NodeQuotaForCustomerExceededException
     * @throws ParameterGroupNotFoundException
     * @throws InsufficientClusterCapacityException
     * @throws InvalidVpcNetworkStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws ShardsPerClusterQuotaExceededException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws InvalidCredentialsException
     * @throws TagQuotaPerResourceExceededException
     * @throws AclNotFoundException
     * @throws InvalidAclStateException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest)
            throws ClusterAlreadyExistsException, SubnetGroupNotFoundException, ClusterQuotaForCustomerExceededException,
            NodeQuotaForClusterExceededException, NodeQuotaForCustomerExceededException, ParameterGroupNotFoundException,
            InsufficientClusterCapacityException, InvalidVpcNetworkStateException, ServiceLinkedRoleNotFoundException,
            ShardsPerClusterQuotaExceededException, InvalidParameterValueException, InvalidParameterCombinationException,
            InvalidCredentialsException, TagQuotaPerResourceExceededException, AclNotFoundException, InvalidAclStateException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are
     * applied to all of the nodes in any cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html">Configuring engine parameters
     * using parameter groups</a>.
     * </p>
     *
     * @param createParameterGroupRequest
     * @return Result of the CreateParameterGroup operation returned by the service.
     * @throws ParameterGroupQuotaExceededException
     * @throws ParameterGroupAlreadyExistsException
     * @throws InvalidParameterGroupStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws TagQuotaPerResourceExceededException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateParameterGroupResponse createParameterGroup(CreateParameterGroupRequest createParameterGroupRequest)
            throws ParameterGroupQuotaExceededException, ParameterGroupAlreadyExistsException,
            InvalidParameterGroupStateException, ServiceLinkedRoleNotFoundException, TagQuotaPerResourceExceededException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are
     * applied to all of the nodes in any cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html">Configuring engine parameters
     * using parameter groups</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateParameterGroupRequest#builder()}
     * </p>
     *
     * @param createParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateParameterGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateParameterGroup operation returned by the service.
     * @throws ParameterGroupQuotaExceededException
     * @throws ParameterGroupAlreadyExistsException
     * @throws InvalidParameterGroupStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws TagQuotaPerResourceExceededException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateParameterGroupResponse createParameterGroup(
            Consumer<CreateParameterGroupRequest.Builder> createParameterGroupRequest)
            throws ParameterGroupQuotaExceededException, ParameterGroupAlreadyExistsException,
            InvalidParameterGroupStateException, ServiceLinkedRoleNotFoundException, TagQuotaPerResourceExceededException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return createParameterGroup(CreateParameterGroupRequest.builder().applyMutation(createParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a copy of an entire cluster at a specific moment in time.
     * </p>
     *
     * @param createSnapshotRequest
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws SnapshotAlreadyExistsException
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws SnapshotQuotaExceededException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws InvalidParameterValueException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest)
            throws SnapshotAlreadyExistsException, ClusterNotFoundException, InvalidClusterStateException,
            SnapshotQuotaExceededException, ServiceLinkedRoleNotFoundException, InvalidParameterCombinationException,
            InvalidParameterValueException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a copy of an entire cluster at a specific moment in time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotRequest.Builder} to create a request.
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws SnapshotAlreadyExistsException
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws SnapshotQuotaExceededException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws InvalidParameterValueException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSnapshotResponse createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest)
            throws SnapshotAlreadyExistsException, ClusterNotFoundException, InvalidClusterStateException,
            SnapshotQuotaExceededException, ServiceLinkedRoleNotFoundException, InvalidParameterCombinationException,
            InvalidParameterValueException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for
     * your clusters running in an Amazon Virtual Private Cloud (VPC) environment. When you create a cluster in an
     * Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses
     * within that subnet to associate with your nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html">Subnets and subnet groups</a>.
     * </p>
     *
     * @param createSubnetGroupRequest
     * @return Result of the CreateSubnetGroup operation returned by the service.
     * @throws SubnetGroupAlreadyExistsException
     * @throws SubnetGroupQuotaExceededException
     * @throws SubnetQuotaExceededException
     * @throws InvalidSubnetException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SubnetNotAllowedException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSubnetGroupResponse createSubnetGroup(CreateSubnetGroupRequest createSubnetGroupRequest)
            throws SubnetGroupAlreadyExistsException, SubnetGroupQuotaExceededException, SubnetQuotaExceededException,
            InvalidSubnetException, ServiceLinkedRoleNotFoundException, SubnetNotAllowedException,
            TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for
     * your clusters running in an Amazon Virtual Private Cloud (VPC) environment. When you create a cluster in an
     * Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses
     * within that subnet to associate with your nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html">Subnets and subnet groups</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubnetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubnetGroupRequest.Builder} to create a request.
     * @return Result of the CreateSubnetGroup operation returned by the service.
     * @throws SubnetGroupAlreadyExistsException
     * @throws SubnetGroupQuotaExceededException
     * @throws SubnetQuotaExceededException
     * @throws InvalidSubnetException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SubnetNotAllowedException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSubnetGroupResponse createSubnetGroup(Consumer<CreateSubnetGroupRequest.Builder> createSubnetGroupRequest)
            throws SubnetGroupAlreadyExistsException, SubnetGroupQuotaExceededException, SubnetQuotaExceededException,
            InvalidSubnetException, ServiceLinkedRoleNotFoundException, SubnetNotAllowedException,
            TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException, MemoryDbException {
        return createSubnetGroup(CreateSubnetGroupRequest.builder().applyMutation(createSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Creates a MemoryDB user. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws UserAlreadyExistsException
     * @throws UserQuotaExceededException
     * @throws DuplicateUserNameException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(CreateUserRequest createUserRequest) throws UserAlreadyExistsException,
            UserQuotaExceededException, DuplicateUserNameException, InvalidParameterValueException,
            InvalidParameterCombinationException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a MemoryDB user. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserRequest.Builder} to create a request.
     * @return Result of the CreateUser operation returned by the service.
     * @throws UserAlreadyExistsException
     * @throws UserQuotaExceededException
     * @throws DuplicateUserNameException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest)
            throws UserAlreadyExistsException, UserQuotaExceededException, DuplicateUserNameException,
            InvalidParameterValueException, InvalidParameterCombinationException, TagQuotaPerResourceExceededException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     *
     * @param deleteAclRequest
     * @return Result of the DeleteACL operation returned by the service.
     * @throws AclNotFoundException
     * @throws InvalidAclStateException
     * @throws InvalidParameterValueException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteACL" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAclResponse deleteACL(DeleteAclRequest deleteAclRequest) throws AclNotFoundException, InvalidAclStateException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAclRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAclRequest#builder()}
     * </p>
     *
     * @param deleteAclRequest
     *        A {@link Consumer} that will call methods on {@link DeleteACLRequest.Builder} to create a request.
     * @return Result of the DeleteACL operation returned by the service.
     * @throws AclNotFoundException
     * @throws InvalidAclStateException
     * @throws InvalidParameterValueException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteACL" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAclResponse deleteACL(Consumer<DeleteAclRequest.Builder> deleteAclRequest) throws AclNotFoundException,
            InvalidAclStateException, InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        return deleteACL(DeleteAclRequest.builder().applyMutation(deleteAclRequest).build());
    }

    /**
     * <p>
     * Deletes a cluster. It also deletes all associated nodes and node endpoints
     * </p>
     *
     * @param deleteClusterRequest
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws SnapshotAlreadyExistsException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ClusterNotFoundException,
            InvalidClusterStateException, SnapshotAlreadyExistsException, ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cluster. It also deletes all associated nodes and node endpoints
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterRequest.Builder} to create a request.
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws SnapshotAlreadyExistsException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest)
            throws ClusterNotFoundException, InvalidClusterStateException, SnapshotAlreadyExistsException,
            ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters.
     * You cannot delete the default parameter groups in your account.
     * </p>
     *
     * @param deleteParameterGroupRequest
     * @return Result of the DeleteParameterGroup operation returned by the service.
     * @throws InvalidParameterGroupStateException
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteParameterGroupResponse deleteParameterGroup(DeleteParameterGroupRequest deleteParameterGroupRequest)
            throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters.
     * You cannot delete the default parameter groups in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteParameterGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteParameterGroup operation returned by the service.
     * @throws InvalidParameterGroupStateException
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteParameterGroupResponse deleteParameterGroup(
            Consumer<DeleteParameterGroupRequest.Builder> deleteParameterGroupRequest)
            throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return deleteParameterGroup(DeleteParameterGroupRequest.builder().applyMutation(deleteParameterGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately
     * begins deleting the snapshot; you cannot cancel or revert this operation.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return Result of the DeleteSnapshot operation returned by the service.
     * @throws SnapshotNotFoundException
     * @throws InvalidSnapshotStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws SnapshotNotFoundException,
            InvalidSnapshotStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately
     * begins deleting the snapshot; you cannot cancel or revert this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSnapshotRequest.Builder} to create a request.
     * @return Result of the DeleteSnapshot operation returned by the service.
     * @throws SnapshotNotFoundException
     * @throws InvalidSnapshotStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSnapshotResponse deleteSnapshot(Consumer<DeleteSnapshotRequest.Builder> deleteSnapshotRequest)
            throws SnapshotNotFoundException, InvalidSnapshotStateException, ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return deleteSnapshot(DeleteSnapshotRequest.builder().applyMutation(deleteSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.
     * </p>
     *
     * @param deleteSubnetGroupRequest
     * @return Result of the DeleteSubnetGroup operation returned by the service.
     * @throws SubnetGroupInUseException
     * @throws SubnetGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSubnetGroupResponse deleteSubnetGroup(DeleteSubnetGroupRequest deleteSubnetGroupRequest)
            throws SubnetGroupInUseException, SubnetGroupNotFoundException, ServiceLinkedRoleNotFoundException,
            AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubnetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSubnetGroupRequest.Builder} to create a request.
     * @return Result of the DeleteSubnetGroup operation returned by the service.
     * @throws SubnetGroupInUseException
     * @throws SubnetGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSubnetGroupResponse deleteSubnetGroup(Consumer<DeleteSubnetGroupRequest.Builder> deleteSubnetGroupRequest)
            throws SubnetGroupInUseException, SubnetGroupNotFoundException, ServiceLinkedRoleNotFoundException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return deleteSubnetGroup(DeleteSubnetGroupRequest.builder().applyMutation(deleteSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws InvalidUserStateException
     * @throws UserNotFoundException
     * @throws InvalidParameterValueException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws InvalidUserStateException,
            UserNotFoundException, InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws InvalidUserStateException
     * @throws UserNotFoundException
     * @throws InvalidParameterValueException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest)
            throws InvalidUserStateException, UserNotFoundException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, MemoryDbException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Returns a list of ACLs
     * </p>
     *
     * @param describeAcLsRequest
     * @return Result of the DescribeACLs operation returned by the service.
     * @throws AclNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeACLs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeACLs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAcLsResponse describeACLs(DescribeAcLsRequest describeAcLsRequest) throws AclNotFoundException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ACLs
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcLsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAcLsRequest#builder()}
     * </p>
     *
     * @param describeAcLsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeACLsRequest.Builder} to create a request.
     * @return Result of the DescribeACLs operation returned by the service.
     * @throws AclNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeACLs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeACLs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAcLsResponse describeACLs(Consumer<DescribeAcLsRequest.Builder> describeAcLsRequest)
            throws AclNotFoundException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return describeACLs(DescribeAcLsRequest.builder().applyMutation(describeAcLsRequest).build());
    }

    /**
     * <p>
     * Returns a list of ACLs
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeACLs(software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeACLsIterable responses = client.describeACLsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeACLsIterable responses = client.describeACLsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeACLsIterable responses = client.describeACLsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeACLs(software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest)} operation.</b>
     * </p>
     *
     * @param describeAcLsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AclNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeACLs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeACLs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeACLsIterable describeACLsPaginator(DescribeAcLsRequest describeAcLsRequest) throws AclNotFoundException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ACLs
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeACLs(software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeACLsIterable responses = client.describeACLsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeACLsIterable responses = client.describeACLsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeACLsIterable responses = client.describeACLsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeACLs(software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAcLsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAcLsRequest#builder()}
     * </p>
     *
     * @param describeAcLsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeACLsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AclNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeACLs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeACLs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeACLsIterable describeACLsPaginator(Consumer<DescribeAcLsRequest.Builder> describeAcLsRequest)
            throws AclNotFoundException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return describeACLsPaginator(DescribeAcLsRequest.builder().applyMutation(describeAcLsRequest).build());
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cluster if a cluster name is supplied.
     * </p>
     *
     * @param describeClustersRequest
     * @return Result of the DescribeClusters operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersResponse describeClusters(DescribeClustersRequest describeClustersRequest)
            throws ClusterNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cluster if a cluster name is supplied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClustersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClustersRequest#builder()}
     * </p>
     *
     * @param describeClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClustersRequest.Builder} to create a request.
     * @return Result of the DescribeClusters operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersResponse describeClusters(Consumer<DescribeClustersRequest.Builder> describeClustersRequest)
            throws ClusterNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return describeClusters(DescribeClustersRequest.builder().applyMutation(describeClustersRequest).build());
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cluster if a cluster name is supplied.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusters(software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeClustersIterable responses = client.describeClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeClustersIterable responses = client
     *             .describeClustersPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeClustersIterable responses = client.describeClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusters(software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest)} operation.</b>
     * </p>
     *
     * @param describeClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersIterable describeClustersPaginator(DescribeClustersRequest describeClustersRequest)
            throws ClusterNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cluster if a cluster name is supplied.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusters(software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeClustersIterable responses = client.describeClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeClustersIterable responses = client
     *             .describeClustersPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeClustersIterable responses = client.describeClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusters(software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClustersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClustersRequest#builder()}
     * </p>
     *
     * @param describeClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClustersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersIterable describeClustersPaginator(Consumer<DescribeClustersRequest.Builder> describeClustersRequest)
            throws ClusterNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return describeClustersPaginator(DescribeClustersRequest.builder().applyMutation(describeClustersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available Redis engine versions.
     * </p>
     *
     * @param describeEngineVersionsRequest
     * @return Result of the DescribeEngineVersions operation returned by the service.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineVersionsResponse describeEngineVersions(DescribeEngineVersionsRequest describeEngineVersionsRequest)
            throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available Redis engine versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngineVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEngineVersions operation returned by the service.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineVersionsResponse describeEngineVersions(
            Consumer<DescribeEngineVersionsRequest.Builder> describeEngineVersionsRequest)
            throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return describeEngineVersions(DescribeEngineVersionsRequest.builder().applyMutation(describeEngineVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the available Redis engine versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEngineVersions(software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeEngineVersionsIterable responses = client.describeEngineVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeEngineVersionsIterable responses = client
     *             .describeEngineVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeEngineVersionsIterable responses = client.describeEngineVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineVersions(software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEngineVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineVersionsIterable describeEngineVersionsPaginator(
            DescribeEngineVersionsRequest describeEngineVersionsRequest) throws ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available Redis engine versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEngineVersions(software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeEngineVersionsIterable responses = client.describeEngineVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeEngineVersionsIterable responses = client
     *             .describeEngineVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeEngineVersionsIterable responses = client.describeEngineVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineVersions(software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngineVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineVersionsIterable describeEngineVersionsPaginator(
            Consumer<DescribeEngineVersionsRequest.Builder> describeEngineVersionsRequest)
            throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return describeEngineVersionsPaginator(DescribeEngineVersionsRequest.builder()
                .applyMutation(describeEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a
     * particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the
     * events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if
     * necessary.
     * </p>
     *
     * @param describeEventsRequest
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest)
            throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a
     * particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the
     * events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if
     * necessary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsRequest.Builder} to create a request.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a
     * particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the
     * events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if
     * necessary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest)
            throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a
     * particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the
     * events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if
     * necessary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only
     * the descriptions for that group.
     * </p>
     *
     * @param describeParameterGroupsRequest
     * @return Result of the DescribeParameterGroups operation returned by the service.
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeParameterGroupsResponse describeParameterGroups(DescribeParameterGroupsRequest describeParameterGroupsRequest)
            throws ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only
     * the descriptions for that group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeParameterGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeParameterGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeParameterGroups operation returned by the service.
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeParameterGroupsResponse describeParameterGroups(
            Consumer<DescribeParameterGroupsRequest.Builder> describeParameterGroupsRequest)
            throws ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return describeParameterGroups(DescribeParameterGroupsRequest.builder().applyMutation(describeParameterGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only
     * the descriptions for that group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeParameterGroups(software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeParameterGroupsIterable responses = client.describeParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeParameterGroupsIterable responses = client
     *             .describeParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeParameterGroupsIterable responses = client.describeParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeParameterGroups(software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeParameterGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeParameterGroupsIterable describeParameterGroupsPaginator(
            DescribeParameterGroupsRequest describeParameterGroupsRequest) throws ParameterGroupNotFoundException,
            ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only
     * the descriptions for that group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeParameterGroups(software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeParameterGroupsIterable responses = client.describeParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeParameterGroupsIterable responses = client
     *             .describeParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeParameterGroupsIterable responses = client.describeParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeParameterGroups(software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeParameterGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeParameterGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeParameterGroupsIterable describeParameterGroupsPaginator(
            Consumer<DescribeParameterGroupsRequest.Builder> describeParameterGroupsRequest)
            throws ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return describeParameterGroupsPaginator(DescribeParameterGroupsRequest.builder()
                .applyMutation(describeParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular parameter group.
     * </p>
     *
     * @param describeParametersRequest
     * @return Result of the DescribeParameters operation returned by the service.
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeParametersResponse describeParameters(DescribeParametersRequest describeParametersRequest)
            throws ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeParametersRequest#builder()}
     * </p>
     *
     * @param describeParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeParametersRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeParameters operation returned by the service.
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeParametersResponse describeParameters(Consumer<DescribeParametersRequest.Builder> describeParametersRequest)
            throws ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return describeParameters(DescribeParametersRequest.builder().applyMutation(describeParametersRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeParameters(software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeParametersIterable responses = client.describeParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeParametersIterable responses = client
     *             .describeParametersPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeParametersIterable responses = client.describeParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeParameters(software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeParametersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeParametersIterable describeParametersPaginator(DescribeParametersRequest describeParametersRequest)
            throws ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeParameters(software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeParametersIterable responses = client.describeParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeParametersIterable responses = client
     *             .describeParametersPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeParametersIterable responses = client.describeParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeParameters(software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeParametersRequest#builder()}
     * </p>
     *
     * @param describeParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeParametersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeParametersIterable describeParametersPaginator(
            Consumer<DescribeParametersRequest.Builder> describeParametersRequest) throws ParameterGroupNotFoundException,
            ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return describeParametersPaginator(DescribeParametersRequest.builder().applyMutation(describeParametersRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved nodes for this account, or about a specified reserved node.
     * </p>
     *
     * @param describeReservedNodesRequest
     * @return Result of the DescribeReservedNodes operation returned by the service.
     * @throws ReservedNodeNotFoundException
     *         The requested node does not exist.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeReservedNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeReservedNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodesResponse describeReservedNodes(DescribeReservedNodesRequest describeReservedNodesRequest)
            throws ReservedNodeNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reserved nodes for this account, or about a specified reserved node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReservedNodesRequest#builder()}
     * </p>
     *
     * @param describeReservedNodesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedNodesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeReservedNodes operation returned by the service.
     * @throws ReservedNodeNotFoundException
     *         The requested node does not exist.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeReservedNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeReservedNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodesResponse describeReservedNodes(
            Consumer<DescribeReservedNodesRequest.Builder> describeReservedNodesRequest) throws ReservedNodeNotFoundException,
            ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return describeReservedNodes(DescribeReservedNodesRequest.builder().applyMutation(describeReservedNodesRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved nodes for this account, or about a specified reserved node.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodes(software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesIterable responses = client.describeReservedNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesIterable responses = client
     *             .describeReservedNodesPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesIterable responses = client.describeReservedNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodes(software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedNodesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedNodeNotFoundException
     *         The requested node does not exist.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeReservedNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeReservedNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodesIterable describeReservedNodesPaginator(DescribeReservedNodesRequest describeReservedNodesRequest)
            throws ReservedNodeNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reserved nodes for this account, or about a specified reserved node.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodes(software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesIterable responses = client.describeReservedNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesIterable responses = client
     *             .describeReservedNodesPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesIterable responses = client.describeReservedNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodes(software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReservedNodesRequest#builder()}
     * </p>
     *
     * @param describeReservedNodesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedNodesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedNodeNotFoundException
     *         The requested node does not exist.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeReservedNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeReservedNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodesIterable describeReservedNodesPaginator(
            Consumer<DescribeReservedNodesRequest.Builder> describeReservedNodesRequest) throws ReservedNodeNotFoundException,
            ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return describeReservedNodesPaginator(DescribeReservedNodesRequest.builder().applyMutation(describeReservedNodesRequest)
                .build());
    }

    /**
     * <p>
     * Lists available reserved node offerings.
     * </p>
     *
     * @param describeReservedNodesOfferingsRequest
     * @return Result of the DescribeReservedNodesOfferings operation returned by the service.
     * @throws ReservedNodesOfferingNotFoundException
     *         The requested node offering does not exist.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeReservedNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeReservedNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodesOfferingsResponse describeReservedNodesOfferings(
            DescribeReservedNodesOfferingsRequest describeReservedNodesOfferingsRequest)
            throws ReservedNodesOfferingNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available reserved node offerings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodesOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedNodesOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedNodesOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedNodesOfferingsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeReservedNodesOfferings operation returned by the service.
     * @throws ReservedNodesOfferingNotFoundException
     *         The requested node offering does not exist.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeReservedNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeReservedNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodesOfferingsResponse describeReservedNodesOfferings(
            Consumer<DescribeReservedNodesOfferingsRequest.Builder> describeReservedNodesOfferingsRequest)
            throws ReservedNodesOfferingNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return describeReservedNodesOfferings(DescribeReservedNodesOfferingsRequest.builder()
                .applyMutation(describeReservedNodesOfferingsRequest).build());
    }

    /**
     * <p>
     * Lists available reserved node offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodesOfferings(software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesOfferingsIterable responses = client.describeReservedNodesOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesOfferingsIterable responses = client
     *             .describeReservedNodesOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesOfferingsIterable responses = client.describeReservedNodesOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodesOfferings(software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedNodesOfferingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedNodesOfferingNotFoundException
     *         The requested node offering does not exist.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeReservedNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeReservedNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodesOfferingsIterable describeReservedNodesOfferingsPaginator(
            DescribeReservedNodesOfferingsRequest describeReservedNodesOfferingsRequest)
            throws ReservedNodesOfferingNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available reserved node offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodesOfferings(software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesOfferingsIterable responses = client.describeReservedNodesOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesOfferingsIterable responses = client
     *             .describeReservedNodesOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeReservedNodesOfferingsIterable responses = client.describeReservedNodesOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodesOfferings(software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodesOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedNodesOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedNodesOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedNodesOfferingsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedNodesOfferingNotFoundException
     *         The requested node offering does not exist.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeReservedNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeReservedNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodesOfferingsIterable describeReservedNodesOfferingsPaginator(
            Consumer<DescribeReservedNodesOfferingsRequest.Builder> describeReservedNodesOfferingsRequest)
            throws ReservedNodesOfferingNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return describeReservedNodesOfferingsPaginator(DescribeReservedNodesOfferingsRequest.builder()
                .applyMutation(describeReservedNodesOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     *
     * @param describeServiceUpdatesRequest
     * @return Result of the DescribeServiceUpdates operation returned by the service.
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeServiceUpdatesResponse describeServiceUpdates(DescribeServiceUpdatesRequest describeServiceUpdatesRequest)
            throws InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceUpdatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeServiceUpdatesRequest#builder()}
     * </p>
     *
     * @param describeServiceUpdatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeServiceUpdatesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeServiceUpdates operation returned by the service.
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeServiceUpdatesResponse describeServiceUpdates(
            Consumer<DescribeServiceUpdatesRequest.Builder> describeServiceUpdatesRequest) throws InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return describeServiceUpdates(DescribeServiceUpdatesRequest.builder().applyMutation(describeServiceUpdatesRequest)
                .build());
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeServiceUpdates(software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeServiceUpdatesIterable responses = client.describeServiceUpdatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeServiceUpdatesIterable responses = client
     *             .describeServiceUpdatesPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeServiceUpdatesIterable responses = client.describeServiceUpdatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeServiceUpdates(software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeServiceUpdatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeServiceUpdatesIterable describeServiceUpdatesPaginator(
            DescribeServiceUpdatesRequest describeServiceUpdatesRequest) throws InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeServiceUpdates(software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeServiceUpdatesIterable responses = client.describeServiceUpdatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeServiceUpdatesIterable responses = client
     *             .describeServiceUpdatesPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeServiceUpdatesIterable responses = client.describeServiceUpdatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeServiceUpdates(software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceUpdatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeServiceUpdatesRequest#builder()}
     * </p>
     *
     * @param describeServiceUpdatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeServiceUpdatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeServiceUpdatesIterable describeServiceUpdatesPaginator(
            Consumer<DescribeServiceUpdatesRequest.Builder> describeServiceUpdatesRequest) throws InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return describeServiceUpdatesPaginator(DescribeServiceUpdatesRequest.builder()
                .applyMutation(describeServiceUpdatesRequest).build());
    }

    /**
     * <p>
     * Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can
     * optionally describe a single snapshot, or just the snapshots associated with a particular cluster.
     * </p>
     *
     * @param describeSnapshotsRequest
     * @return Result of the DescribeSnapshots operation returned by the service.
     * @throws SnapshotNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSnapshotsResponse describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest)
            throws SnapshotNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can
     * optionally describe a single snapshot, or just the snapshots associated with a particular cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSnapshotsRequest.Builder} to create a request.
     * @return Result of the DescribeSnapshots operation returned by the service.
     * @throws SnapshotNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSnapshotsResponse describeSnapshots(Consumer<DescribeSnapshotsRequest.Builder> describeSnapshotsRequest)
            throws SnapshotNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return describeSnapshots(DescribeSnapshotsRequest.builder().applyMutation(describeSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can
     * optionally describe a single snapshot, or just the snapshots associated with a particular cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshots(software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeSnapshotsIterable responses = client.describeSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeSnapshotsIterable responses = client
     *             .describeSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeSnapshotsIterable responses = client.describeSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshots(software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSnapshotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SnapshotNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSnapshotsIterable describeSnapshotsPaginator(DescribeSnapshotsRequest describeSnapshotsRequest)
            throws SnapshotNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can
     * optionally describe a single snapshot, or just the snapshots associated with a particular cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshots(software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeSnapshotsIterable responses = client.describeSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeSnapshotsIterable responses = client
     *             .describeSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeSnapshotsIterable responses = client.describeSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshots(software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSnapshotsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SnapshotNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSnapshotsIterable describeSnapshotsPaginator(
            Consumer<DescribeSnapshotsRequest.Builder> describeSnapshotsRequest) throws SnapshotNotFoundException,
            ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return describeSnapshotsPaginator(DescribeSnapshotsRequest.builder().applyMutation(describeSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the
     * description of that group.
     * </p>
     *
     * @param describeSubnetGroupsRequest
     * @return Result of the DescribeSubnetGroups operation returned by the service.
     * @throws SubnetGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSubnetGroupsResponse describeSubnetGroups(DescribeSubnetGroupsRequest describeSubnetGroupsRequest)
            throws SubnetGroupNotFoundException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the
     * description of that group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSubnetGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSubnetGroups operation returned by the service.
     * @throws SubnetGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSubnetGroupsResponse describeSubnetGroups(
            Consumer<DescribeSubnetGroupsRequest.Builder> describeSubnetGroupsRequest) throws SubnetGroupNotFoundException,
            ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        return describeSubnetGroups(DescribeSubnetGroupsRequest.builder().applyMutation(describeSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the
     * description of that group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSubnetGroups(software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeSubnetGroupsIterable responses = client.describeSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeSubnetGroupsIterable responses = client
     *             .describeSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeSubnetGroupsIterable responses = client.describeSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSubnetGroups(software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSubnetGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SubnetGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSubnetGroupsIterable describeSubnetGroupsPaginator(DescribeSubnetGroupsRequest describeSubnetGroupsRequest)
            throws SubnetGroupNotFoundException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the
     * description of that group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSubnetGroups(software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeSubnetGroupsIterable responses = client.describeSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeSubnetGroupsIterable responses = client
     *             .describeSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeSubnetGroupsIterable responses = client.describeSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSubnetGroups(software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSubnetGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SubnetGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSubnetGroupsIterable describeSubnetGroupsPaginator(
            Consumer<DescribeSubnetGroupsRequest.Builder> describeSubnetGroupsRequest) throws SubnetGroupNotFoundException,
            ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        return describeSubnetGroupsPaginator(DescribeSubnetGroupsRequest.builder().applyMutation(describeSubnetGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     *
     * @param describeUsersRequest
     * @return Result of the DescribeUsers operation returned by the service.
     * @throws UserNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersResponse describeUsers(DescribeUsersRequest describeUsersRequest) throws UserNotFoundException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsersRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUsersRequest#builder()}
     * </p>
     *
     * @param describeUsersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUsersRequest.Builder} to create a request.
     * @return Result of the DescribeUsers operation returned by the service.
     * @throws UserNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersResponse describeUsers(Consumer<DescribeUsersRequest.Builder> describeUsersRequest)
            throws UserNotFoundException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return describeUsers(DescribeUsersRequest.builder().applyMutation(describeUsersRequest).build());
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeUsers(software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeUsersIterable responses = client.describeUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeUsersIterable responses = client.describeUsersPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeUsersIterable responses = client.describeUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUsers(software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest)} operation.</b>
     * </p>
     *
     * @param describeUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UserNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersIterable describeUsersPaginator(DescribeUsersRequest describeUsersRequest) throws UserNotFoundException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeUsers(software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeUsersIterable responses = client.describeUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.memorydb.paginators.DescribeUsersIterable responses = client.describeUsersPaginator(request);
     *     for (software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.memorydb.paginators.DescribeUsersIterable responses = client.describeUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUsers(software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsersRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUsersRequest#builder()}
     * </p>
     *
     * @param describeUsersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUsersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UserNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersIterable describeUsersPaginator(Consumer<DescribeUsersRequest.Builder> describeUsersRequest)
            throws UserNotFoundException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return describeUsersPaginator(DescribeUsersRequest.builder().applyMutation(describeUsersRequest).build());
    }

    /**
     * <p>
     * Used to failover a shard. This API is designed for testing the behavior of your application in case of MemoryDB
     * failover. It is not designed to be used as a production-level tool for initiating a failover to overcome a
     * problem you may have with the cluster. Moreover, in certain conditions such as large scale operational events,
     * Amazon may block this API.
     * </p>
     *
     * @param failoverShardRequest
     * @return Result of the FailoverShard operation returned by the service.
     * @throws ApiCallRateForCustomerExceededException
     * @throws InvalidClusterStateException
     * @throws ShardNotFoundException
     * @throws ClusterNotFoundException
     * @throws TestFailoverNotAvailableException
     * @throws InvalidKmsKeyException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.FailoverShard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/FailoverShard" target="_top">AWS API
     *      Documentation</a>
     */
    default FailoverShardResponse failoverShard(FailoverShardRequest failoverShardRequest)
            throws ApiCallRateForCustomerExceededException, InvalidClusterStateException, ShardNotFoundException,
            ClusterNotFoundException, TestFailoverNotAvailableException, InvalidKmsKeyException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to failover a shard. This API is designed for testing the behavior of your application in case of MemoryDB
     * failover. It is not designed to be used as a production-level tool for initiating a failover to overcome a
     * problem you may have with the cluster. Moreover, in certain conditions such as large scale operational events,
     * Amazon may block this API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FailoverShardRequest.Builder} avoiding the need to
     * create one manually via {@link FailoverShardRequest#builder()}
     * </p>
     *
     * @param failoverShardRequest
     *        A {@link Consumer} that will call methods on {@link FailoverShardRequest.Builder} to create a request.
     * @return Result of the FailoverShard operation returned by the service.
     * @throws ApiCallRateForCustomerExceededException
     * @throws InvalidClusterStateException
     * @throws ShardNotFoundException
     * @throws ClusterNotFoundException
     * @throws TestFailoverNotAvailableException
     * @throws InvalidKmsKeyException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.FailoverShard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/FailoverShard" target="_top">AWS API
     *      Documentation</a>
     */
    default FailoverShardResponse failoverShard(Consumer<FailoverShardRequest.Builder> failoverShardRequest)
            throws ApiCallRateForCustomerExceededException, InvalidClusterStateException, ShardNotFoundException,
            ClusterNotFoundException, TestFailoverNotAvailableException, InvalidKmsKeyException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return failoverShard(FailoverShardRequest.builder().applyMutation(failoverShardRequest).build());
    }

    /**
     * <p>
     * Lists all available node types that you can scale to from your cluster's current node type. When you use the
     * UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types
     * returned by this operation.
     * </p>
     *
     * @param listAllowedNodeTypeUpdatesRequest
     * @return Result of the ListAllowedNodeTypeUpdates operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws InvalidParameterValueException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.ListAllowedNodeTypeUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListAllowedNodeTypeUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAllowedNodeTypeUpdatesResponse listAllowedNodeTypeUpdates(
            ListAllowedNodeTypeUpdatesRequest listAllowedNodeTypeUpdatesRequest) throws ClusterNotFoundException,
            ServiceLinkedRoleNotFoundException, InvalidParameterCombinationException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all available node types that you can scale to from your cluster's current node type. When you use the
     * UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types
     * returned by this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAllowedNodeTypeUpdatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAllowedNodeTypeUpdatesRequest#builder()}
     * </p>
     *
     * @param listAllowedNodeTypeUpdatesRequest
     *        A {@link Consumer} that will call methods on {@link ListAllowedNodeTypeUpdatesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAllowedNodeTypeUpdates operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws InvalidParameterValueException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.ListAllowedNodeTypeUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListAllowedNodeTypeUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAllowedNodeTypeUpdatesResponse listAllowedNodeTypeUpdates(
            Consumer<ListAllowedNodeTypeUpdatesRequest.Builder> listAllowedNodeTypeUpdatesRequest)
            throws ClusterNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterCombinationException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        return listAllowedNodeTypeUpdates(ListAllowedNodeTypeUpdatesRequest.builder()
                .applyMutation(listAllowedNodeTypeUpdatesRequest).build());
    }

    /**
     * <p>
     * Lists all tags currently on a named resource. A tag is a key-value pair where the key and value are
     * case-sensitive. You can use tags to categorize and track your MemoryDB resources. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html">Tagging your MemoryDB
     * resources</a>
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws ParameterGroupNotFoundException
     * @throws SubnetGroupNotFoundException
     * @throws SnapshotNotFoundException
     * @throws InvalidArnException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws UserNotFoundException
     * @throws AclNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ClusterNotFoundException,
            InvalidClusterStateException, ParameterGroupNotFoundException, SubnetGroupNotFoundException,
            SnapshotNotFoundException, InvalidArnException, ServiceLinkedRoleNotFoundException, UserNotFoundException,
            AclNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags currently on a named resource. A tag is a key-value pair where the key and value are
     * case-sensitive. You can use tags to categorize and track your MemoryDB resources. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html">Tagging your MemoryDB
     * resources</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     * @return Result of the ListTags operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws ParameterGroupNotFoundException
     * @throws SubnetGroupNotFoundException
     * @throws SnapshotNotFoundException
     * @throws InvalidArnException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws UserNotFoundException
     * @throws AclNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) throws ClusterNotFoundException,
            InvalidClusterStateException, ParameterGroupNotFoundException, SubnetGroupNotFoundException,
            SnapshotNotFoundException, InvalidArnException, ServiceLinkedRoleNotFoundException, UserNotFoundException,
            AclNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Allows you to purchase a reserved node offering. Reserved nodes are not eligible for cancellation and are
     * non-refundable.
     * </p>
     *
     * @param purchaseReservedNodesOfferingRequest
     * @return Result of the PurchaseReservedNodesOffering operation returned by the service.
     * @throws ReservedNodesOfferingNotFoundException
     *         The requested node offering does not exist.
     * @throws ReservedNodeAlreadyExistsException
     *         You already have a reservation with the given identifier.
     * @throws ReservedNodeQuotaExceededException
     *         The request cannot be processed because it would exceed the user's node quota.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws TagQuotaPerResourceExceededException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.PurchaseReservedNodesOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/PurchaseReservedNodesOffering"
     *      target="_top">AWS API Documentation</a>
     */
    default PurchaseReservedNodesOfferingResponse purchaseReservedNodesOffering(
            PurchaseReservedNodesOfferingRequest purchaseReservedNodesOfferingRequest)
            throws ReservedNodesOfferingNotFoundException, ReservedNodeAlreadyExistsException,
            ReservedNodeQuotaExceededException, ServiceLinkedRoleNotFoundException, TagQuotaPerResourceExceededException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to purchase a reserved node offering. Reserved nodes are not eligible for cancellation and are
     * non-refundable.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseReservedNodesOfferingRequest.Builder}
     * avoiding the need to create one manually via {@link PurchaseReservedNodesOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseReservedNodesOfferingRequest
     *        A {@link Consumer} that will call methods on {@link PurchaseReservedNodesOfferingRequest.Builder} to
     *        create a request.
     * @return Result of the PurchaseReservedNodesOffering operation returned by the service.
     * @throws ReservedNodesOfferingNotFoundException
     *         The requested node offering does not exist.
     * @throws ReservedNodeAlreadyExistsException
     *         You already have a reservation with the given identifier.
     * @throws ReservedNodeQuotaExceededException
     *         The request cannot be processed because it would exceed the user's node quota.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws TagQuotaPerResourceExceededException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.PurchaseReservedNodesOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/PurchaseReservedNodesOffering"
     *      target="_top">AWS API Documentation</a>
     */
    default PurchaseReservedNodesOfferingResponse purchaseReservedNodesOffering(
            Consumer<PurchaseReservedNodesOfferingRequest.Builder> purchaseReservedNodesOfferingRequest)
            throws ReservedNodesOfferingNotFoundException, ReservedNodeAlreadyExistsException,
            ReservedNodeQuotaExceededException, ServiceLinkedRoleNotFoundException, TagQuotaPerResourceExceededException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return purchaseReservedNodesOffering(PurchaseReservedNodesOfferingRequest.builder()
                .applyMutation(purchaseReservedNodesOfferingRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters of a parameter group to the engine or system default value. You can reset specific
     * parameters by submitting a list of parameter names. To reset the entire parameter group, specify the
     * AllParameters and ParameterGroupName parameters.
     * </p>
     *
     * @param resetParameterGroupRequest
     * @return Result of the ResetParameterGroup operation returned by the service.
     * @throws InvalidParameterGroupStateException
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.ResetParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ResetParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default ResetParameterGroupResponse resetParameterGroup(ResetParameterGroupRequest resetParameterGroupRequest)
            throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a parameter group to the engine or system default value. You can reset specific
     * parameters by submitting a list of parameter names. To reset the entire parameter group, specify the
     * AllParameters and ParameterGroupName parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ResetParameterGroupRequest#builder()}
     * </p>
     *
     * @param resetParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ResetParameterGroupRequest.Builder} to create a
     *        request.
     * @return Result of the ResetParameterGroup operation returned by the service.
     * @throws InvalidParameterGroupStateException
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.ResetParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ResetParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default ResetParameterGroupResponse resetParameterGroup(
            Consumer<ResetParameterGroupRequest.Builder> resetParameterGroupRequest) throws InvalidParameterGroupStateException,
            ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return resetParameterGroup(ResetParameterGroupRequest.builder().applyMutation(resetParameterGroupRequest).build());
    }

    /**
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all
     * nodes in the cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html">Resource-level
     * permissions</a>.
     * </p>
     * <p>
     * For example, you can use cost-allocation tags to your MemoryDB resources, Amazon generates a cost allocation
     * report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply
     * tags that represent business categories (such as cost centers, application names, or owners) to organize your
     * costs across multiple services. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html">Using Cost Allocation Tags</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws ParameterGroupNotFoundException
     * @throws SubnetGroupNotFoundException
     * @throws InvalidClusterStateException
     * @throws SnapshotNotFoundException
     * @throws UserNotFoundException
     * @throws AclNotFoundException
     * @throws TagQuotaPerResourceExceededException
     * @throws InvalidArnException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ClusterNotFoundException,
            ParameterGroupNotFoundException, SubnetGroupNotFoundException, InvalidClusterStateException,
            SnapshotNotFoundException, UserNotFoundException, AclNotFoundException, TagQuotaPerResourceExceededException,
            InvalidArnException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all
     * nodes in the cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html">Resource-level
     * permissions</a>.
     * </p>
     * <p>
     * For example, you can use cost-allocation tags to your MemoryDB resources, Amazon generates a cost allocation
     * report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply
     * tags that represent business categories (such as cost centers, application names, or owners) to organize your
     * costs across multiple services. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html">Using Cost Allocation Tags</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws ParameterGroupNotFoundException
     * @throws SubnetGroupNotFoundException
     * @throws InvalidClusterStateException
     * @throws SnapshotNotFoundException
     * @throws UserNotFoundException
     * @throws AclNotFoundException
     * @throws TagQuotaPerResourceExceededException
     * @throws InvalidArnException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ClusterNotFoundException, ParameterGroupNotFoundException, SubnetGroupNotFoundException,
            InvalidClusterStateException, SnapshotNotFoundException, UserNotFoundException, AclNotFoundException,
            TagQuotaPerResourceExceededException, InvalidArnException, ServiceLinkedRoleNotFoundException, AwsServiceException,
            SdkClientException, MemoryDbException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Use this operation to remove tags on a resource
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws ParameterGroupNotFoundException
     * @throws SubnetGroupNotFoundException
     * @throws SnapshotNotFoundException
     * @throws InvalidArnException
     * @throws TagNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws UserNotFoundException
     * @throws AclNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ClusterNotFoundException,
            InvalidClusterStateException, ParameterGroupNotFoundException, SubnetGroupNotFoundException,
            SnapshotNotFoundException, InvalidArnException, TagNotFoundException, ServiceLinkedRoleNotFoundException,
            UserNotFoundException, AclNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to remove tags on a resource
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws ParameterGroupNotFoundException
     * @throws SubnetGroupNotFoundException
     * @throws SnapshotNotFoundException
     * @throws InvalidArnException
     * @throws TagNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws UserNotFoundException
     * @throws AclNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ClusterNotFoundException, InvalidClusterStateException, ParameterGroupNotFoundException,
            SubnetGroupNotFoundException, SnapshotNotFoundException, InvalidArnException, TagNotFoundException,
            ServiceLinkedRoleNotFoundException, UserNotFoundException, AclNotFoundException, AwsServiceException,
            SdkClientException, MemoryDbException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Changes the list of users that belong to the Access Control List.
     * </p>
     *
     * @param updateAclRequest
     * @return Result of the UpdateACL operation returned by the service.
     * @throws AclNotFoundException
     * @throws UserNotFoundException
     * @throws DuplicateUserNameException
     * @throws DefaultUserRequiredException
     * @throws InvalidAclStateException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateACL" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAclResponse updateACL(UpdateAclRequest updateAclRequest) throws AclNotFoundException, UserNotFoundException,
            DuplicateUserNameException, DefaultUserRequiredException, InvalidAclStateException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the list of users that belong to the Access Control List.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAclRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAclRequest#builder()}
     * </p>
     *
     * @param updateAclRequest
     *        A {@link Consumer} that will call methods on {@link UpdateACLRequest.Builder} to create a request.
     * @return Result of the UpdateACL operation returned by the service.
     * @throws AclNotFoundException
     * @throws UserNotFoundException
     * @throws DuplicateUserNameException
     * @throws DefaultUserRequiredException
     * @throws InvalidAclStateException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateACL" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAclResponse updateACL(Consumer<UpdateAclRequest.Builder> updateAclRequest) throws AclNotFoundException,
            UserNotFoundException, DuplicateUserNameException, DefaultUserRequiredException, InvalidAclStateException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return updateACL(UpdateAclRequest.builder().applyMutation(updateAclRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration
     * settings by specifying the settings and the new values.
     * </p>
     *
     * @param updateClusterRequest
     * @return Result of the UpdateCluster operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws InvalidNodeStateException
     * @throws ParameterGroupNotFoundException
     * @throws InvalidVpcNetworkStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidKmsKeyException
     * @throws NodeQuotaForClusterExceededException
     * @throws ClusterQuotaForCustomerExceededException
     * @throws ShardsPerClusterQuotaExceededException
     * @throws NodeQuotaForCustomerExceededException
     * @throws NoOperationException
     * @throws InvalidAclStateException
     * @throws AclNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws ClusterNotFoundException,
            InvalidClusterStateException, InvalidNodeStateException, ParameterGroupNotFoundException,
            InvalidVpcNetworkStateException, ServiceLinkedRoleNotFoundException, InvalidKmsKeyException,
            NodeQuotaForClusterExceededException, ClusterQuotaForCustomerExceededException,
            ShardsPerClusterQuotaExceededException, NodeQuotaForCustomerExceededException, NoOperationException,
            InvalidAclStateException, AclNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration
     * settings by specifying the settings and the new values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateClusterRequest#builder()}
     * </p>
     *
     * @param updateClusterRequest
     *        A {@link Consumer} that will call methods on {@link UpdateClusterRequest.Builder} to create a request.
     * @return Result of the UpdateCluster operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws InvalidNodeStateException
     * @throws ParameterGroupNotFoundException
     * @throws InvalidVpcNetworkStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidKmsKeyException
     * @throws NodeQuotaForClusterExceededException
     * @throws ClusterQuotaForCustomerExceededException
     * @throws ShardsPerClusterQuotaExceededException
     * @throws NodeQuotaForCustomerExceededException
     * @throws NoOperationException
     * @throws InvalidAclStateException
     * @throws AclNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateClusterResponse updateCluster(Consumer<UpdateClusterRequest.Builder> updateClusterRequest)
            throws ClusterNotFoundException, InvalidClusterStateException, InvalidNodeStateException,
            ParameterGroupNotFoundException, InvalidVpcNetworkStateException, ServiceLinkedRoleNotFoundException,
            InvalidKmsKeyException, NodeQuotaForClusterExceededException, ClusterQuotaForCustomerExceededException,
            ShardsPerClusterQuotaExceededException, NodeQuotaForCustomerExceededException, NoOperationException,
            InvalidAclStateException, AclNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        return updateCluster(UpdateClusterRequest.builder().applyMutation(updateClusterRequest).build());
    }

    /**
     * <p>
     * Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting
     * a list parameter name and value pairs.
     * </p>
     *
     * @param updateParameterGroupRequest
     * @return Result of the UpdateParameterGroup operation returned by the service.
     * @throws ParameterGroupNotFoundException
     * @throws InvalidParameterGroupStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateParameterGroupResponse updateParameterGroup(UpdateParameterGroupRequest updateParameterGroupRequest)
            throws ParameterGroupNotFoundException, InvalidParameterGroupStateException, ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting
     * a list parameter name and value pairs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateParameterGroupRequest#builder()}
     * </p>
     *
     * @param updateParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateParameterGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateParameterGroup operation returned by the service.
     * @throws ParameterGroupNotFoundException
     * @throws InvalidParameterGroupStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateParameterGroupResponse updateParameterGroup(
            Consumer<UpdateParameterGroupRequest.Builder> updateParameterGroupRequest) throws ParameterGroupNotFoundException,
            InvalidParameterGroupStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        return updateParameterGroup(UpdateParameterGroupRequest.builder().applyMutation(updateParameterGroupRequest).build());
    }

    /**
     * <p>
     * Updates a subnet group. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html">Updating a subnet
     * group</a>
     * </p>
     *
     * @param updateSubnetGroupRequest
     * @return Result of the UpdateSubnetGroup operation returned by the service.
     * @throws SubnetGroupNotFoundException
     * @throws SubnetQuotaExceededException
     * @throws SubnetInUseException
     * @throws InvalidSubnetException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SubnetNotAllowedException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSubnetGroupResponse updateSubnetGroup(UpdateSubnetGroupRequest updateSubnetGroupRequest)
            throws SubnetGroupNotFoundException, SubnetQuotaExceededException, SubnetInUseException, InvalidSubnetException,
            ServiceLinkedRoleNotFoundException, SubnetNotAllowedException, AwsServiceException, SdkClientException,
            MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a subnet group. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html">Updating a subnet
     * group</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubnetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSubnetGroupRequest#builder()}
     * </p>
     *
     * @param updateSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSubnetGroupRequest.Builder} to create a request.
     * @return Result of the UpdateSubnetGroup operation returned by the service.
     * @throws SubnetGroupNotFoundException
     * @throws SubnetQuotaExceededException
     * @throws SubnetInUseException
     * @throws InvalidSubnetException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SubnetNotAllowedException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSubnetGroupResponse updateSubnetGroup(Consumer<UpdateSubnetGroupRequest.Builder> updateSubnetGroupRequest)
            throws SubnetGroupNotFoundException, SubnetQuotaExceededException, SubnetInUseException, InvalidSubnetException,
            ServiceLinkedRoleNotFoundException, SubnetNotAllowedException, AwsServiceException, SdkClientException,
            MemoryDbException {
        return updateSubnetGroup(UpdateSubnetGroupRequest.builder().applyMutation(updateSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Changes user password(s) and/or access string.
     * </p>
     *
     * @param updateUserRequest
     * @return Result of the UpdateUser operation returned by the service.
     * @throws UserNotFoundException
     * @throws InvalidUserStateException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws UserNotFoundException,
            InvalidUserStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException,
            SdkClientException, MemoryDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes user password(s) and/or access string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserRequest.Builder} to create a request.
     * @return Result of the UpdateUser operation returned by the service.
     * @throws UserNotFoundException
     * @throws InvalidUserStateException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) throws UserNotFoundException,
            InvalidUserStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException,
            SdkClientException, MemoryDbException {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    /**
     * Create a {@link MemoryDbClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MemoryDbClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MemoryDbClient}.
     */
    static MemoryDbClientBuilder builder() {
        return new DefaultMemoryDbClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
