/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.memorydb.internal.MemoryDbServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.memorydb.model.AclAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.AclNotFoundException;
import software.amazon.awssdk.services.memorydb.model.AclQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.ApiCallRateForCustomerExceededException;
import software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.BatchUpdateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.ClusterNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ClusterQuotaForCustomerExceededException;
import software.amazon.awssdk.services.memorydb.model.CopySnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.CopySnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.CreateAclRequest;
import software.amazon.awssdk.services.memorydb.model.CreateAclResponse;
import software.amazon.awssdk.services.memorydb.model.CreateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.CreateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.CreateParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.CreateParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.CreateSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.CreateUserRequest;
import software.amazon.awssdk.services.memorydb.model.CreateUserResponse;
import software.amazon.awssdk.services.memorydb.model.DefaultUserRequiredException;
import software.amazon.awssdk.services.memorydb.model.DeleteAclRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteAclResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteClusterRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteClusterResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.DeleteUserRequest;
import software.amazon.awssdk.services.memorydb.model.DeleteUserResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeAcLsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeClustersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeClustersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeEngineVersionsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeEventsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeEventsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParameterGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeParametersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeParametersResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesOfferingsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.DescribeUsersRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeUsersResponse;
import software.amazon.awssdk.services.memorydb.model.DuplicateUserNameException;
import software.amazon.awssdk.services.memorydb.model.FailoverShardRequest;
import software.amazon.awssdk.services.memorydb.model.FailoverShardResponse;
import software.amazon.awssdk.services.memorydb.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.memorydb.model.InvalidAclStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidArnException;
import software.amazon.awssdk.services.memorydb.model.InvalidClusterStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidCredentialsException;
import software.amazon.awssdk.services.memorydb.model.InvalidKmsKeyException;
import software.amazon.awssdk.services.memorydb.model.InvalidNodeStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.memorydb.model.InvalidParameterGroupStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidParameterValueException;
import software.amazon.awssdk.services.memorydb.model.InvalidSnapshotStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidSubnetException;
import software.amazon.awssdk.services.memorydb.model.InvalidUserStateException;
import software.amazon.awssdk.services.memorydb.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.ListAllowedNodeTypeUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.ListTagsRequest;
import software.amazon.awssdk.services.memorydb.model.ListTagsResponse;
import software.amazon.awssdk.services.memorydb.model.MemoryDbException;
import software.amazon.awssdk.services.memorydb.model.NoOperationException;
import software.amazon.awssdk.services.memorydb.model.NodeQuotaForClusterExceededException;
import software.amazon.awssdk.services.memorydb.model.NodeQuotaForCustomerExceededException;
import software.amazon.awssdk.services.memorydb.model.ParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.ParameterGroupNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingRequest;
import software.amazon.awssdk.services.memorydb.model.PurchaseReservedNodesOfferingResponse;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ReservedNodeQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.ReservedNodesOfferingNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ResetParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.ResetParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.ServiceLinkedRoleNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ServiceUpdateNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ShardNotFoundException;
import software.amazon.awssdk.services.memorydb.model.ShardsPerClusterQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.SnapshotAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.SnapshotNotFoundException;
import software.amazon.awssdk.services.memorydb.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupInUseException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupNotFoundException;
import software.amazon.awssdk.services.memorydb.model.SubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.SubnetInUseException;
import software.amazon.awssdk.services.memorydb.model.SubnetNotAllowedException;
import software.amazon.awssdk.services.memorydb.model.SubnetQuotaExceededException;
import software.amazon.awssdk.services.memorydb.model.TagNotFoundException;
import software.amazon.awssdk.services.memorydb.model.TagQuotaPerResourceExceededException;
import software.amazon.awssdk.services.memorydb.model.TagResourceRequest;
import software.amazon.awssdk.services.memorydb.model.TagResourceResponse;
import software.amazon.awssdk.services.memorydb.model.TestFailoverNotAvailableException;
import software.amazon.awssdk.services.memorydb.model.UntagResourceRequest;
import software.amazon.awssdk.services.memorydb.model.UntagResourceResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateAclRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateAclResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateClusterRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateClusterResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateParameterGroupResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateSubnetGroupResponse;
import software.amazon.awssdk.services.memorydb.model.UpdateUserRequest;
import software.amazon.awssdk.services.memorydb.model.UpdateUserResponse;
import software.amazon.awssdk.services.memorydb.model.UserAlreadyExistsException;
import software.amazon.awssdk.services.memorydb.model.UserNotFoundException;
import software.amazon.awssdk.services.memorydb.model.UserQuotaExceededException;
import software.amazon.awssdk.services.memorydb.transform.BatchUpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateAclRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteAclRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeAcLsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeParametersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeReservedNodesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeReservedNodesRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeServiceUpdatesRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.DescribeUsersRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.FailoverShardRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.ListAllowedNodeTypeUpdatesRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.PurchaseReservedNodesOfferingRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.ResetParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateAclRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.memorydb.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link MemoryDbClient}.
 *
 * @see MemoryDbClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultMemoryDbClient implements MemoryDbClient {
    private static final Logger log = Logger.loggerFor(DefaultMemoryDbClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMemoryDbClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Apply the service update to a list of clusters supplied. For more information on service updates and applying
     * them, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates">Applying the
     * service updates</a>.
     * </p>
     *
     * @param batchUpdateClusterRequest
     * @return Result of the BatchUpdateCluster operation returned by the service.
     * @throws ServiceUpdateNotFoundException
     * @throws InvalidParameterValueException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.BatchUpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/BatchUpdateCluster" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchUpdateClusterResponse batchUpdateCluster(BatchUpdateClusterRequest batchUpdateClusterRequest)
            throws ServiceUpdateNotFoundException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchUpdateClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchUpdateClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdateClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchUpdateClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateCluster");

            return clientHandler.execute(new ClientExecutionParams<BatchUpdateClusterRequest, BatchUpdateClusterResponse>()
                    .withOperationName("BatchUpdateCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchUpdateClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchUpdateClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Makes a copy of an existing snapshot.
     * </p>
     *
     * @param copySnapshotRequest
     * @return Result of the CopySnapshot operation returned by the service.
     * @throws SnapshotAlreadyExistsException
     * @throws SnapshotNotFoundException
     * @throws SnapshotQuotaExceededException
     * @throws InvalidSnapshotStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CopySnapshotResponse copySnapshot(CopySnapshotRequest copySnapshotRequest) throws SnapshotAlreadyExistsException,
            SnapshotNotFoundException, SnapshotQuotaExceededException, InvalidSnapshotStateException,
            ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CopySnapshotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CopySnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copySnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copySnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopySnapshot");

            return clientHandler.execute(new ClientExecutionParams<CopySnapshotRequest, CopySnapshotResponse>()
                    .withOperationName("CopySnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(copySnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopySnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Access Control List. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     *
     * @param createAclRequest
     * @return Result of the CreateACL operation returned by the service.
     * @throws UserNotFoundException
     * @throws DuplicateUserNameException
     * @throws AclAlreadyExistsException
     * @throws DefaultUserRequiredException
     * @throws AclQuotaExceededException
     * @throws InvalidParameterValueException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateACL" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAclResponse createACL(CreateAclRequest createAclRequest) throws UserNotFoundException,
            DuplicateUserNameException, AclAlreadyExistsException, DefaultUserRequiredException, AclQuotaExceededException,
            InvalidParameterValueException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAclResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAclResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateACL");

            return clientHandler.execute(new ClientExecutionParams<CreateAclRequest, CreateAclResponse>()
                    .withOperationName("CreateACL").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createAclRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAclRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.
     * </p>
     *
     * @param createClusterRequest
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ClusterAlreadyExistsException
     * @throws SubnetGroupNotFoundException
     * @throws ClusterQuotaForCustomerExceededException
     * @throws NodeQuotaForClusterExceededException
     * @throws NodeQuotaForCustomerExceededException
     * @throws ParameterGroupNotFoundException
     * @throws InsufficientClusterCapacityException
     * @throws InvalidVpcNetworkStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws ShardsPerClusterQuotaExceededException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws InvalidCredentialsException
     * @throws TagQuotaPerResourceExceededException
     * @throws AclNotFoundException
     * @throws InvalidAclStateException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ClusterAlreadyExistsException,
            SubnetGroupNotFoundException, ClusterQuotaForCustomerExceededException, NodeQuotaForClusterExceededException,
            NodeQuotaForCustomerExceededException, ParameterGroupNotFoundException, InsufficientClusterCapacityException,
            InvalidVpcNetworkStateException, ServiceLinkedRoleNotFoundException, ShardsPerClusterQuotaExceededException,
            InvalidParameterValueException, InvalidParameterCombinationException, InvalidCredentialsException,
            TagQuotaPerResourceExceededException, AclNotFoundException, InvalidAclStateException, AwsServiceException,
            SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCluster");

            return clientHandler.execute(new ClientExecutionParams<CreateClusterRequest, CreateClusterResponse>()
                    .withOperationName("CreateCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are
     * applied to all of the nodes in any cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html">Configuring engine parameters
     * using parameter groups</a>.
     * </p>
     *
     * @param createParameterGroupRequest
     * @return Result of the CreateParameterGroup operation returned by the service.
     * @throws ParameterGroupQuotaExceededException
     * @throws ParameterGroupAlreadyExistsException
     * @throws InvalidParameterGroupStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws TagQuotaPerResourceExceededException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateParameterGroupResponse createParameterGroup(CreateParameterGroupRequest createParameterGroupRequest)
            throws ParameterGroupQuotaExceededException, ParameterGroupAlreadyExistsException,
            InvalidParameterGroupStateException, ServiceLinkedRoleNotFoundException, TagQuotaPerResourceExceededException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateParameterGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateParameterGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateParameterGroupRequest, CreateParameterGroupResponse>()
                    .withOperationName("CreateParameterGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createParameterGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a copy of an entire cluster at a specific moment in time.
     * </p>
     *
     * @param createSnapshotRequest
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws SnapshotAlreadyExistsException
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws SnapshotQuotaExceededException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws InvalidParameterValueException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest)
            throws SnapshotAlreadyExistsException, ClusterNotFoundException, InvalidClusterStateException,
            SnapshotQuotaExceededException, ServiceLinkedRoleNotFoundException, InvalidParameterCombinationException,
            InvalidParameterValueException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshot");

            return clientHandler.execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                    .withOperationName("CreateSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for
     * your clusters running in an Amazon Virtual Private Cloud (VPC) environment. When you create a cluster in an
     * Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses
     * within that subnet to associate with your nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html">Subnets and subnet groups</a>.
     * </p>
     *
     * @param createSubnetGroupRequest
     * @return Result of the CreateSubnetGroup operation returned by the service.
     * @throws SubnetGroupAlreadyExistsException
     * @throws SubnetGroupQuotaExceededException
     * @throws SubnetQuotaExceededException
     * @throws InvalidSubnetException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SubnetNotAllowedException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateSubnetGroupResponse createSubnetGroup(CreateSubnetGroupRequest createSubnetGroupRequest)
            throws SubnetGroupAlreadyExistsException, SubnetGroupQuotaExceededException, SubnetQuotaExceededException,
            InvalidSubnetException, ServiceLinkedRoleNotFoundException, SubnetNotAllowedException,
            TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSubnetGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSubnetGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateSubnetGroupRequest, CreateSubnetGroupResponse>()
                    .withOperationName("CreateSubnetGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSubnetGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a MemoryDB user. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws UserAlreadyExistsException
     * @throws UserQuotaExceededException
     * @throws DuplicateUserNameException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws TagQuotaPerResourceExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws UserAlreadyExistsException,
            UserQuotaExceededException, DuplicateUserNameException, InvalidParameterValueException,
            InvalidParameterCombinationException, TagQuotaPerResourceExceededException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");

            return clientHandler.execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>()
                    .withOperationName("CreateUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access
     * Contol Lists (ACLs)</a>.
     * </p>
     *
     * @param deleteAclRequest
     * @return Result of the DeleteACL operation returned by the service.
     * @throws AclNotFoundException
     * @throws InvalidAclStateException
     * @throws InvalidParameterValueException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteACL" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAclResponse deleteACL(DeleteAclRequest deleteAclRequest) throws AclNotFoundException, InvalidAclStateException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAclResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAclResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteACL");

            return clientHandler.execute(new ClientExecutionParams<DeleteAclRequest, DeleteAclResponse>()
                    .withOperationName("DeleteACL").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteAclRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAclRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a cluster. It also deletes all associated nodes and node endpoints
     * </p>
     * <note>
     * <p>
     * <code>CreateSnapshot</code> permission is required to create a final snapshot. Without this permission, the API
     * call will fail with an <code>Access Denied</code> exception.
     * </p>
     * </note>
     *
     * @param deleteClusterRequest
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws SnapshotAlreadyExistsException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ClusterNotFoundException,
            InvalidClusterStateException, SnapshotAlreadyExistsException, ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCluster");

            return clientHandler.execute(new ClientExecutionParams<DeleteClusterRequest, DeleteClusterResponse>()
                    .withOperationName("DeleteCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters.
     * You cannot delete the default parameter groups in your account.
     * </p>
     *
     * @param deleteParameterGroupRequest
     * @return Result of the DeleteParameterGroup operation returned by the service.
     * @throws InvalidParameterGroupStateException
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteParameterGroupResponse deleteParameterGroup(DeleteParameterGroupRequest deleteParameterGroupRequest)
            throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteParameterGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteParameterGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteParameterGroupRequest, DeleteParameterGroupResponse>()
                    .withOperationName("DeleteParameterGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteParameterGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately
     * begins deleting the snapshot; you cannot cancel or revert this operation.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return Result of the DeleteSnapshot operation returned by the service.
     * @throws SnapshotNotFoundException
     * @throws InvalidSnapshotStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws SnapshotNotFoundException,
            InvalidSnapshotStateException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshot");

            return clientHandler.execute(new ClientExecutionParams<DeleteSnapshotRequest, DeleteSnapshotResponse>()
                    .withOperationName("DeleteSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.
     * </p>
     *
     * @param deleteSubnetGroupRequest
     * @return Result of the DeleteSubnetGroup operation returned by the service.
     * @throws SubnetGroupInUseException
     * @throws SubnetGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteSubnetGroupResponse deleteSubnetGroup(DeleteSubnetGroupRequest deleteSubnetGroupRequest)
            throws SubnetGroupInUseException, SubnetGroupNotFoundException, ServiceLinkedRoleNotFoundException,
            AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSubnetGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSubnetGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteSubnetGroupRequest, DeleteSubnetGroupResponse>()
                    .withOperationName("DeleteSubnetGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSubnetGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws InvalidUserStateException
     * @throws UserNotFoundException
     * @throws InvalidParameterValueException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws InvalidUserStateException,
            UserNotFoundException, InvalidParameterValueException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");

            return clientHandler.execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>()
                    .withOperationName("DeleteUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of ACLs
     * </p>
     *
     * @param describeAcLsRequest
     * @return Result of the DescribeACLs operation returned by the service.
     * @throws AclNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeACLs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeACLs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeAcLsResponse describeACLs(DescribeAcLsRequest describeAcLsRequest) throws AclNotFoundException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAcLsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAcLsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAcLsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAcLsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeACLs");

            return clientHandler.execute(new ClientExecutionParams<DescribeAcLsRequest, DescribeAcLsResponse>()
                    .withOperationName("DescribeACLs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAcLsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAcLsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific
     * cluster if a cluster name is supplied.
     * </p>
     *
     * @param describeClustersRequest
     * @return Result of the DescribeClusters operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeClustersResponse describeClusters(DescribeClustersRequest describeClustersRequest)
            throws ClusterNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeClustersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeClustersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClustersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClusters");

            return clientHandler.execute(new ClientExecutionParams<DescribeClustersRequest, DescribeClustersResponse>()
                    .withOperationName("DescribeClusters").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeClustersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeClustersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the available Redis OSS engine versions.
     * </p>
     *
     * @param describeEngineVersionsRequest
     * @return Result of the DescribeEngineVersions operation returned by the service.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEngineVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEngineVersionsResponse describeEngineVersions(DescribeEngineVersionsRequest describeEngineVersionsRequest)
            throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEngineVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEngineVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEngineVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEngineVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEngineVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEngineVersionsRequest, DescribeEngineVersionsResponse>()
                            .withOperationName("DescribeEngineVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeEngineVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEngineVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a
     * particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the
     * events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if
     * necessary.
     * </p>
     *
     * @param describeEventsRequest
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest)
            throws ServiceLinkedRoleNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEventsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEvents");

            return clientHandler.execute(new ClientExecutionParams<DescribeEventsRequest, DescribeEventsResponse>()
                    .withOperationName("DescribeEvents").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeEventsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only
     * the descriptions for that group.
     * </p>
     *
     * @param describeParameterGroupsRequest
     * @return Result of the DescribeParameterGroups operation returned by the service.
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeParameterGroupsResponse describeParameterGroups(DescribeParameterGroupsRequest describeParameterGroupsRequest)
            throws ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeParameterGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeParameterGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeParameterGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeParameterGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeParameterGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeParameterGroupsRequest, DescribeParameterGroupsResponse>()
                            .withOperationName("DescribeParameterGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeParameterGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeParameterGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular parameter group.
     * </p>
     *
     * @param describeParametersRequest
     * @return Result of the DescribeParameters operation returned by the service.
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameters" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeParametersResponse describeParameters(DescribeParametersRequest describeParametersRequest)
            throws ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeParametersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeParametersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeParameters");

            return clientHandler.execute(new ClientExecutionParams<DescribeParametersRequest, DescribeParametersResponse>()
                    .withOperationName("DescribeParameters").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeParametersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about reserved nodes for this account, or about a specified reserved node.
     * </p>
     *
     * @param describeReservedNodesRequest
     * @return Result of the DescribeReservedNodes operation returned by the service.
     * @throws ReservedNodeNotFoundException
     *         The requested node does not exist.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeReservedNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeReservedNodes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReservedNodesResponse describeReservedNodes(DescribeReservedNodesRequest describeReservedNodesRequest)
            throws ReservedNodeNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReservedNodesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeReservedNodesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservedNodesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReservedNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedNodes");

            return clientHandler.execute(new ClientExecutionParams<DescribeReservedNodesRequest, DescribeReservedNodesResponse>()
                    .withOperationName("DescribeReservedNodes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeReservedNodesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeReservedNodesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists available reserved node offerings.
     * </p>
     *
     * @param describeReservedNodesOfferingsRequest
     * @return Result of the DescribeReservedNodesOfferings operation returned by the service.
     * @throws ReservedNodesOfferingNotFoundException
     *         The requested node offering does not exist.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeReservedNodesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeReservedNodesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReservedNodesOfferingsResponse describeReservedNodesOfferings(
            DescribeReservedNodesOfferingsRequest describeReservedNodesOfferingsRequest)
            throws ReservedNodesOfferingNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReservedNodesOfferingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeReservedNodesOfferingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservedNodesOfferingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReservedNodesOfferingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedNodesOfferings");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedNodesOfferingsRequest, DescribeReservedNodesOfferingsResponse>()
                            .withOperationName("DescribeReservedNodesOfferings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeReservedNodesOfferingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReservedNodesOfferingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns details of the service updates
     * </p>
     *
     * @param describeServiceUpdatesRequest
     * @return Result of the DescribeServiceUpdates operation returned by the service.
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeServiceUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeServiceUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeServiceUpdatesResponse describeServiceUpdates(DescribeServiceUpdatesRequest describeServiceUpdatesRequest)
            throws InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeServiceUpdatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeServiceUpdatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeServiceUpdatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeServiceUpdatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeServiceUpdates");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeServiceUpdatesRequest, DescribeServiceUpdatesResponse>()
                            .withOperationName("DescribeServiceUpdates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeServiceUpdatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeServiceUpdatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can
     * optionally describe a single snapshot, or just the snapshots associated with a particular cluster.
     * </p>
     *
     * @param describeSnapshotsRequest
     * @return Result of the DescribeSnapshots operation returned by the service.
     * @throws SnapshotNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeSnapshotsResponse describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest)
            throws SnapshotNotFoundException, ServiceLinkedRoleNotFoundException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeSnapshotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSnapshots");

            return clientHandler.execute(new ClientExecutionParams<DescribeSnapshotsRequest, DescribeSnapshotsResponse>()
                    .withOperationName("DescribeSnapshots").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeSnapshotsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSnapshotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the
     * description of that group.
     * </p>
     *
     * @param describeSubnetGroupsRequest
     * @return Result of the DescribeSubnetGroups operation returned by the service.
     * @throws SubnetGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeSubnetGroupsResponse describeSubnetGroups(DescribeSubnetGroupsRequest describeSubnetGroupsRequest)
            throws SubnetGroupNotFoundException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSubnetGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSubnetGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSubnetGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSubnetGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSubnetGroups");

            return clientHandler.execute(new ClientExecutionParams<DescribeSubnetGroupsRequest, DescribeSubnetGroupsResponse>()
                    .withOperationName("DescribeSubnetGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeSubnetGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSubnetGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of users.
     * </p>
     *
     * @param describeUsersRequest
     * @return Result of the DescribeUsers operation returned by the service.
     * @throws UserNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeUsersResponse describeUsers(DescribeUsersRequest describeUsersRequest) throws UserNotFoundException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeUsersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUsers");

            return clientHandler.execute(new ClientExecutionParams<DescribeUsersRequest, DescribeUsersResponse>()
                    .withOperationName("DescribeUsers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeUsersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeUsersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Used to failover a shard. This API is designed for testing the behavior of your application in case of MemoryDB
     * failover. It is not designed to be used as a production-level tool for initiating a failover to overcome a
     * problem you may have with the cluster. Moreover, in certain conditions such as large scale operational events,
     * Amazon may block this API.
     * </p>
     *
     * @param failoverShardRequest
     * @return Result of the FailoverShard operation returned by the service.
     * @throws ApiCallRateForCustomerExceededException
     * @throws InvalidClusterStateException
     * @throws ShardNotFoundException
     * @throws ClusterNotFoundException
     * @throws TestFailoverNotAvailableException
     * @throws InvalidKmsKeyException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.FailoverShard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/FailoverShard" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public FailoverShardResponse failoverShard(FailoverShardRequest failoverShardRequest)
            throws ApiCallRateForCustomerExceededException, InvalidClusterStateException, ShardNotFoundException,
            ClusterNotFoundException, TestFailoverNotAvailableException, InvalidKmsKeyException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<FailoverShardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                FailoverShardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(failoverShardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, failoverShardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FailoverShard");

            return clientHandler.execute(new ClientExecutionParams<FailoverShardRequest, FailoverShardResponse>()
                    .withOperationName("FailoverShard").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(failoverShardRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new FailoverShardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all available node types that you can scale to from your cluster's current node type. When you use the
     * UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types
     * returned by this operation.
     * </p>
     *
     * @param listAllowedNodeTypeUpdatesRequest
     * @return Result of the ListAllowedNodeTypeUpdates operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterCombinationException
     * @throws InvalidParameterValueException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.ListAllowedNodeTypeUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListAllowedNodeTypeUpdates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAllowedNodeTypeUpdatesResponse listAllowedNodeTypeUpdates(
            ListAllowedNodeTypeUpdatesRequest listAllowedNodeTypeUpdatesRequest) throws ClusterNotFoundException,
            ServiceLinkedRoleNotFoundException, InvalidParameterCombinationException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAllowedNodeTypeUpdatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAllowedNodeTypeUpdatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAllowedNodeTypeUpdatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAllowedNodeTypeUpdatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAllowedNodeTypeUpdates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAllowedNodeTypeUpdatesRequest, ListAllowedNodeTypeUpdatesResponse>()
                            .withOperationName("ListAllowedNodeTypeUpdates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAllowedNodeTypeUpdatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAllowedNodeTypeUpdatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all tags currently on a named resource. A tag is a key-value pair where the key and value are
     * case-sensitive. You can use tags to categorize and track your MemoryDB resources. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html">Tagging your MemoryDB
     * resources</a>
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws ParameterGroupNotFoundException
     * @throws SubnetGroupNotFoundException
     * @throws SnapshotNotFoundException
     * @throws InvalidArnException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws UserNotFoundException
     * @throws AclNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ClusterNotFoundException,
            InvalidClusterStateException, ParameterGroupNotFoundException, SubnetGroupNotFoundException,
            SnapshotNotFoundException, InvalidArnException, ServiceLinkedRoleNotFoundException, UserNotFoundException,
            AclNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTags");

            return clientHandler.execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>()
                    .withOperationName("ListTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows you to purchase a reserved node offering. Reserved nodes are not eligible for cancellation and are
     * non-refundable.
     * </p>
     *
     * @param purchaseReservedNodesOfferingRequest
     * @return Result of the PurchaseReservedNodesOffering operation returned by the service.
     * @throws ReservedNodesOfferingNotFoundException
     *         The requested node offering does not exist.
     * @throws ReservedNodeAlreadyExistsException
     *         You already have a reservation with the given identifier.
     * @throws ReservedNodeQuotaExceededException
     *         The request cannot be processed because it would exceed the user's node quota.
     * @throws ServiceLinkedRoleNotFoundException
     * @throws TagQuotaPerResourceExceededException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.PurchaseReservedNodesOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/PurchaseReservedNodesOffering"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PurchaseReservedNodesOfferingResponse purchaseReservedNodesOffering(
            PurchaseReservedNodesOfferingRequest purchaseReservedNodesOfferingRequest)
            throws ReservedNodesOfferingNotFoundException, ReservedNodeAlreadyExistsException,
            ReservedNodeQuotaExceededException, ServiceLinkedRoleNotFoundException, TagQuotaPerResourceExceededException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PurchaseReservedNodesOfferingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PurchaseReservedNodesOfferingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(purchaseReservedNodesOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                purchaseReservedNodesOfferingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseReservedNodesOffering");

            return clientHandler
                    .execute(new ClientExecutionParams<PurchaseReservedNodesOfferingRequest, PurchaseReservedNodesOfferingResponse>()
                            .withOperationName("PurchaseReservedNodesOffering").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(purchaseReservedNodesOfferingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PurchaseReservedNodesOfferingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the parameters of a parameter group to the engine or system default value. You can reset specific
     * parameters by submitting a list of parameter names. To reset the entire parameter group, specify the
     * AllParameters and ParameterGroupName parameters.
     * </p>
     *
     * @param resetParameterGroupRequest
     * @return Result of the ResetParameterGroup operation returned by the service.
     * @throws InvalidParameterGroupStateException
     * @throws ParameterGroupNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.ResetParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ResetParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ResetParameterGroupResponse resetParameterGroup(ResetParameterGroupRequest resetParameterGroupRequest)
            throws InvalidParameterGroupStateException, ParameterGroupNotFoundException, ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResetParameterGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ResetParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resetParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetParameterGroup");

            return clientHandler.execute(new ClientExecutionParams<ResetParameterGroupRequest, ResetParameterGroupResponse>()
                    .withOperationName("ResetParameterGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(resetParameterGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ResetParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track
     * all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all
     * nodes in the cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html">Resource-level
     * permissions</a>.
     * </p>
     * <p>
     * For example, you can use cost-allocation tags to your MemoryDB resources, Amazon generates a cost allocation
     * report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply
     * tags that represent business categories (such as cost centers, application names, or owners) to organize your
     * costs across multiple services. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html">Using Cost Allocation Tags</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws ParameterGroupNotFoundException
     * @throws SubnetGroupNotFoundException
     * @throws InvalidClusterStateException
     * @throws SnapshotNotFoundException
     * @throws UserNotFoundException
     * @throws AclNotFoundException
     * @throws TagQuotaPerResourceExceededException
     * @throws InvalidArnException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ClusterNotFoundException,
            ParameterGroupNotFoundException, SubnetGroupNotFoundException, InvalidClusterStateException,
            SnapshotNotFoundException, UserNotFoundException, AclNotFoundException, TagQuotaPerResourceExceededException,
            InvalidArnException, ServiceLinkedRoleNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this operation to remove tags on a resource
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws ParameterGroupNotFoundException
     * @throws SubnetGroupNotFoundException
     * @throws SnapshotNotFoundException
     * @throws InvalidArnException
     * @throws TagNotFoundException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws UserNotFoundException
     * @throws AclNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ClusterNotFoundException,
            InvalidClusterStateException, ParameterGroupNotFoundException, SubnetGroupNotFoundException,
            SnapshotNotFoundException, InvalidArnException, TagNotFoundException, ServiceLinkedRoleNotFoundException,
            UserNotFoundException, AclNotFoundException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the list of users that belong to the Access Control List.
     * </p>
     *
     * @param updateAclRequest
     * @return Result of the UpdateACL operation returned by the service.
     * @throws AclNotFoundException
     * @throws UserNotFoundException
     * @throws DuplicateUserNameException
     * @throws DefaultUserRequiredException
     * @throws InvalidAclStateException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateACL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateACL" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAclResponse updateACL(UpdateAclRequest updateAclRequest) throws AclNotFoundException, UserNotFoundException,
            DuplicateUserNameException, DefaultUserRequiredException, InvalidAclStateException, InvalidParameterValueException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAclResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAclResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAclRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateACL");

            return clientHandler.execute(new ClientExecutionParams<UpdateAclRequest, UpdateAclResponse>()
                    .withOperationName("UpdateACL").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateAclRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAclRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration
     * settings by specifying the settings and the new values.
     * </p>
     *
     * @param updateClusterRequest
     * @return Result of the UpdateCluster operation returned by the service.
     * @throws ClusterNotFoundException
     * @throws InvalidClusterStateException
     * @throws InvalidNodeStateException
     * @throws ParameterGroupNotFoundException
     * @throws InvalidVpcNetworkStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidKmsKeyException
     * @throws NodeQuotaForClusterExceededException
     * @throws ClusterQuotaForCustomerExceededException
     * @throws ShardsPerClusterQuotaExceededException
     * @throws NodeQuotaForCustomerExceededException
     * @throws NoOperationException
     * @throws InvalidAclStateException
     * @throws AclNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws ClusterNotFoundException,
            InvalidClusterStateException, InvalidNodeStateException, ParameterGroupNotFoundException,
            InvalidVpcNetworkStateException, ServiceLinkedRoleNotFoundException, InvalidKmsKeyException,
            NodeQuotaForClusterExceededException, ClusterQuotaForCustomerExceededException,
            ShardsPerClusterQuotaExceededException, NodeQuotaForCustomerExceededException, NoOperationException,
            InvalidAclStateException, AclNotFoundException, InvalidParameterValueException, InvalidParameterCombinationException,
            AwsServiceException, SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCluster");

            return clientHandler.execute(new ClientExecutionParams<UpdateClusterRequest, UpdateClusterResponse>()
                    .withOperationName("UpdateCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting
     * a list parameter name and value pairs.
     * </p>
     *
     * @param updateParameterGroupRequest
     * @return Result of the UpdateParameterGroup operation returned by the service.
     * @throws ParameterGroupNotFoundException
     * @throws InvalidParameterGroupStateException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateParameterGroupResponse updateParameterGroup(UpdateParameterGroupRequest updateParameterGroupRequest)
            throws ParameterGroupNotFoundException, InvalidParameterGroupStateException, ServiceLinkedRoleNotFoundException,
            InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateParameterGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateParameterGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateParameterGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateParameterGroupRequest, UpdateParameterGroupResponse>()
                    .withOperationName("UpdateParameterGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateParameterGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateParameterGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a subnet group. For more information, see <a
     * href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html">Updating a subnet
     * group</a>
     * </p>
     *
     * @param updateSubnetGroupRequest
     * @return Result of the UpdateSubnetGroup operation returned by the service.
     * @throws SubnetGroupNotFoundException
     * @throws SubnetQuotaExceededException
     * @throws SubnetInUseException
     * @throws InvalidSubnetException
     * @throws ServiceLinkedRoleNotFoundException
     * @throws SubnetNotAllowedException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateSubnetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateSubnetGroupResponse updateSubnetGroup(UpdateSubnetGroupRequest updateSubnetGroupRequest)
            throws SubnetGroupNotFoundException, SubnetQuotaExceededException, SubnetInUseException, InvalidSubnetException,
            ServiceLinkedRoleNotFoundException, SubnetNotAllowedException, AwsServiceException, SdkClientException,
            MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSubnetGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSubnetGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateSubnetGroupRequest, UpdateSubnetGroupResponse>()
                    .withOperationName("UpdateSubnetGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateSubnetGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes user password(s) and/or access string.
     * </p>
     *
     * @param updateUserRequest
     * @return Result of the UpdateUser operation returned by the service.
     * @throws UserNotFoundException
     * @throws InvalidUserStateException
     * @throws InvalidParameterValueException
     * @throws InvalidParameterCombinationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MemoryDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MemoryDbClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws UserNotFoundException,
            InvalidUserStateException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException,
            SdkClientException, MemoryDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MemoryDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUser");

            return clientHandler.execute(new ClientExecutionParams<UpdateUserRequest, UpdateUserResponse>()
                    .withOperationName("UpdateUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        MemoryDbServiceClientConfigurationBuilder serviceConfigBuilder = new MemoryDbServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(MemoryDbException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ACLNotFoundFault")
                                .exceptionBuilderSupplier(AclNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetGroupNotFoundFault")
                                .exceptionBuilderSupplier(SubnetGroupNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetGroupQuotaExceededFault")
                                .exceptionBuilderSupplier(SubnetGroupQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterGroupAlreadyExistsFault")
                                .exceptionBuilderSupplier(ParameterGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetInUse")
                                .exceptionBuilderSupplier(SubnetInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNodesOfferingNotFoundFault")
                                .exceptionBuilderSupplier(ReservedNodesOfferingNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotAlreadyExistsFault")
                                .exceptionBuilderSupplier(SnapshotAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotQuotaExceededFault")
                                .exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidARNFault")
                                .exceptionBuilderSupplier(InvalidArnException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TestFailoverNotAvailableFault")
                                .exceptionBuilderSupplier(TestFailoverNotAvailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ACLQuotaExceededFault")
                                .exceptionBuilderSupplier(AclQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DefaultUserRequired")
                                .exceptionBuilderSupplier(DefaultUserRequiredException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NodeQuotaForCustomerExceededFault")
                                .exceptionBuilderSupplier(NodeQuotaForCustomerExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserAlreadyExistsFault")
                                .exceptionBuilderSupplier(UserAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidKMSKeyFault")
                                .exceptionBuilderSupplier(InvalidKmsKeyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateUserNameFault")
                                .exceptionBuilderSupplier(DuplicateUserNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidACLStateFault")
                                .exceptionBuilderSupplier(InvalidAclStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetNotAllowedFault")
                                .exceptionBuilderSupplier(SubnetNotAllowedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagNotFoundFault")
                                .exceptionBuilderSupplier(TagNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault")
                                .exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterQuotaForCustomerExceededFault")
                                .exceptionBuilderSupplier(ClusterQuotaForCustomerExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterGroupStateFault")
                                .exceptionBuilderSupplier(InvalidParameterGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterGroupNotFoundFault")
                                .exceptionBuilderSupplier(ParameterGroupNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceLinkedRoleNotFoundFault")
                                .exceptionBuilderSupplier(ServiceLinkedRoleNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("APICallRateForCustomerExceededFault")
                                .exceptionBuilderSupplier(ApiCallRateForCustomerExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NodeQuotaForClusterExceededFault")
                                .exceptionBuilderSupplier(NodeQuotaForClusterExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterGroupQuotaExceededFault")
                                .exceptionBuilderSupplier(ParameterGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUpdateNotFoundFault")
                                .exceptionBuilderSupplier(ServiceUpdateNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserNotFoundFault")
                                .exceptionBuilderSupplier(UserNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetQuotaExceededFault")
                                .exceptionBuilderSupplier(SubnetQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceededFault")
                                .exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterNotFoundFault")
                                .exceptionBuilderSupplier(ClusterNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSnapshotStateFault")
                                .exceptionBuilderSupplier(InvalidSnapshotStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNodeStateFault")
                                .exceptionBuilderSupplier(InvalidNodeStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ShardsPerClusterQuotaExceededFault")
                                .exceptionBuilderSupplier(ShardsPerClusterQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCredentialsException")
                                .exceptionBuilderSupplier(InvalidCredentialsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExistsFault")
                                .exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNodeNotFoundFault")
                                .exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                                .exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUserStateFault")
                                .exceptionBuilderSupplier(InvalidUserStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotNotFoundFault")
                                .exceptionBuilderSupplier(SnapshotNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidClusterStateFault")
                                .exceptionBuilderSupplier(InvalidClusterStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ACLAlreadyExistsFault")
                                .exceptionBuilderSupplier(AclAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientClusterCapacityFault")
                                .exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UserQuotaExceededFault")
                                .exceptionBuilderSupplier(UserQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagQuotaPerResourceExceeded")
                                .exceptionBuilderSupplier(TagQuotaPerResourceExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetGroupInUseFault")
                                .exceptionBuilderSupplier(SubnetGroupInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnet")
                                .exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterAlreadyExistsFault")
                                .exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoOperationFault")
                                .exceptionBuilderSupplier(NoOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ShardNotFoundFault")
                                .exceptionBuilderSupplier(ShardNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetGroupAlreadyExistsFault")
                                .exceptionBuilderSupplier(SubnetGroupAlreadyExistsException::builder).httpStatusCode(400).build());
    }

    @Override
    public final MemoryDbServiceClientConfiguration serviceClientConfiguration() {
        return new MemoryDbServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
