/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of cluster configuration options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterConfiguration.Builder, ClusterConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ClusterConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ClusterConfiguration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(ClusterConfiguration::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(ClusterConfiguration::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ClusterConfiguration::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> MAINTENANCE_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceWindow").getter(getter(ClusterConfiguration::maintenanceWindow))
            .setter(setter(Builder::maintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceWindow").build()).build();

    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(ClusterConfiguration::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(ClusterConfiguration::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupName").getter(getter(ClusterConfiguration::parameterGroupName))
            .setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<String> SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetGroupName").getter(getter(ClusterConfiguration::subnetGroupName))
            .setter(setter(Builder::subnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupName").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(ClusterConfiguration::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(ClusterConfiguration::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotWindow").getter(getter(ClusterConfiguration::snapshotWindow))
            .setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<Integer> NUM_SHARDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumShards").getter(getter(ClusterConfiguration::numShards)).setter(setter(Builder::numShards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumShards").build()).build();

    private static final SdkField<List<ShardDetail>> SHARDS_FIELD = SdkField
            .<List<ShardDetail>> builder(MarshallingType.LIST)
            .memberName("Shards")
            .getter(getter(ClusterConfiguration::shards))
            .setter(setter(Builder::shards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ShardDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ShardDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, MAINTENANCE_WINDOW_FIELD, TOPIC_ARN_FIELD, PORT_FIELD,
            PARAMETER_GROUP_NAME_FIELD, SUBNET_GROUP_NAME_FIELD, VPC_ID_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD,
            SNAPSHOT_WINDOW_FIELD, NUM_SHARDS_FIELD, SHARDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String nodeType;

    private final String engine;

    private final String engineVersion;

    private final String maintenanceWindow;

    private final String topicArn;

    private final Integer port;

    private final String parameterGroupName;

    private final String subnetGroupName;

    private final String vpcId;

    private final Integer snapshotRetentionLimit;

    private final String snapshotWindow;

    private final Integer numShards;

    private final List<ShardDetail> shards;

    private ClusterConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.nodeType = builder.nodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.topicArn = builder.topicArn;
        this.port = builder.port;
        this.parameterGroupName = builder.parameterGroupName;
        this.subnetGroupName = builder.subnetGroupName;
        this.vpcId = builder.vpcId;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.numShards = builder.numShards;
        this.shards = builder.shards;
    }

    /**
     * <p>
     * The name of the cluster
     * </p>
     * 
     * @return The name of the cluster
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the cluster configuration
     * </p>
     * 
     * @return The description of the cluster configuration
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The node type used for the cluster
     * </p>
     * 
     * @return The node type used for the cluster
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The configuration for the Redis OSS or Valkey engine used by the cluster.
     * </p>
     * 
     * @return The configuration for the Redis OSS or Valkey engine used by the cluster.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The engine version used by the cluster
     * </p>
     * 
     * @return The engine version used by the cluster
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The specified maintenance window for the cluster
     * </p>
     * 
     * @return The specified maintenance window for the cluster
     */
    public final String maintenanceWindow() {
        return maintenanceWindow;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SNS notification topic for the cluster
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SNS notification topic for the cluster
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The port used by the cluster
     * </p>
     * 
     * @return The port used by the cluster
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The name of parameter group used by the cluster
     * </p>
     * 
     * @return The name of parameter group used by the cluster
     */
    public final String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * <p>
     * The name of the subnet group used by the cluster
     * </p>
     * 
     * @return The name of the subnet group used by the cluster
     */
    public final String subnetGroupName() {
        return subnetGroupName;
    }

    /**
     * <p>
     * The ID of the VPC the cluster belongs to
     * </p>
     * 
     * @return The ID of the VPC the cluster belongs to
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The snapshot retention limit set by the cluster
     * </p>
     * 
     * @return The snapshot retention limit set by the cluster
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The snapshot window set by the cluster
     * </p>
     * 
     * @return The snapshot window set by the cluster
     */
    public final String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * The number of shards in the cluster
     * </p>
     * 
     * @return The number of shards in the cluster
     */
    public final Integer numShards() {
        return numShards;
    }

    /**
     * For responses, this returns true if the service returned a value for the Shards property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasShards() {
        return shards != null && !(shards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of shards in the cluster
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShards} method.
     * </p>
     * 
     * @return The list of shards in the cluster
     */
    public final List<ShardDetail> shards() {
        return shards;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(subnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(numShards());
        hashCode = 31 * hashCode + Objects.hashCode(hasShards() ? shards() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterConfiguration)) {
            return false;
        }
        ClusterConfiguration other = (ClusterConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(nodeType(), other.nodeType()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(topicArn(), other.topicArn())
                && Objects.equals(port(), other.port()) && Objects.equals(parameterGroupName(), other.parameterGroupName())
                && Objects.equals(subnetGroupName(), other.subnetGroupName()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(snapshotWindow(), other.snapshotWindow()) && Objects.equals(numShards(), other.numShards())
                && hasShards() == other.hasShards() && Objects.equals(shards(), other.shards());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterConfiguration").add("Name", name()).add("Description", description())
                .add("NodeType", nodeType()).add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("MaintenanceWindow", maintenanceWindow()).add("TopicArn", topicArn()).add("Port", port())
                .add("ParameterGroupName", parameterGroupName()).add("SubnetGroupName", subnetGroupName()).add("VpcId", vpcId())
                .add("SnapshotRetentionLimit", snapshotRetentionLimit()).add("SnapshotWindow", snapshotWindow())
                .add("NumShards", numShards()).add("Shards", hasShards() ? shards() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "MaintenanceWindow":
            return Optional.ofNullable(clazz.cast(maintenanceWindow()));
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "SubnetGroupName":
            return Optional.ofNullable(clazz.cast(subnetGroupName()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "NumShards":
            return Optional.ofNullable(clazz.cast(numShards()));
        case "Shards":
            return Optional.ofNullable(clazz.cast(shards()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterConfiguration, T> g) {
        return obj -> g.apply((ClusterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterConfiguration> {
        /**
         * <p>
         * The name of the cluster
         * </p>
         * 
         * @param name
         *        The name of the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the cluster configuration
         * </p>
         * 
         * @param description
         *        The description of the cluster configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The node type used for the cluster
         * </p>
         * 
         * @param nodeType
         *        The node type used for the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The configuration for the Redis OSS or Valkey engine used by the cluster.
         * </p>
         * 
         * @param engine
         *        The configuration for the Redis OSS or Valkey engine used by the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The engine version used by the cluster
         * </p>
         * 
         * @param engineVersion
         *        The engine version used by the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The specified maintenance window for the cluster
         * </p>
         * 
         * @param maintenanceWindow
         *        The specified maintenance window for the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindow(String maintenanceWindow);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SNS notification topic for the cluster
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) of the SNS notification topic for the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The port used by the cluster
         * </p>
         * 
         * @param port
         *        The port used by the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The name of parameter group used by the cluster
         * </p>
         * 
         * @param parameterGroupName
         *        The name of parameter group used by the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * The name of the subnet group used by the cluster
         * </p>
         * 
         * @param subnetGroupName
         *        The name of the subnet group used by the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroupName(String subnetGroupName);

        /**
         * <p>
         * The ID of the VPC the cluster belongs to
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC the cluster belongs to
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The snapshot retention limit set by the cluster
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The snapshot retention limit set by the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The snapshot window set by the cluster
         * </p>
         * 
         * @param snapshotWindow
         *        The snapshot window set by the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * The number of shards in the cluster
         * </p>
         * 
         * @param numShards
         *        The number of shards in the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numShards(Integer numShards);

        /**
         * <p>
         * The list of shards in the cluster
         * </p>
         * 
         * @param shards
         *        The list of shards in the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Collection<ShardDetail> shards);

        /**
         * <p>
         * The list of shards in the cluster
         * </p>
         * 
         * @param shards
         *        The list of shards in the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(ShardDetail... shards);

        /**
         * <p>
         * The list of shards in the cluster
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.ShardDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.memorydb.model.ShardDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.ShardDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #shards(List<ShardDetail>)}.
         * 
         * @param shards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.ShardDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shards(java.util.Collection<ShardDetail>)
         */
        Builder shards(Consumer<ShardDetail.Builder>... shards);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String nodeType;

        private String engine;

        private String engineVersion;

        private String maintenanceWindow;

        private String topicArn;

        private Integer port;

        private String parameterGroupName;

        private String subnetGroupName;

        private String vpcId;

        private Integer snapshotRetentionLimit;

        private String snapshotWindow;

        private Integer numShards;

        private List<ShardDetail> shards = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterConfiguration model) {
            name(model.name);
            description(model.description);
            nodeType(model.nodeType);
            engine(model.engine);
            engineVersion(model.engineVersion);
            maintenanceWindow(model.maintenanceWindow);
            topicArn(model.topicArn);
            port(model.port);
            parameterGroupName(model.parameterGroupName);
            subnetGroupName(model.subnetGroupName);
            vpcId(model.vpcId);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            snapshotWindow(model.snapshotWindow);
            numShards(model.numShards);
            shards(model.shards);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getMaintenanceWindow() {
            return maintenanceWindow;
        }

        public final void setMaintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
        }

        @Override
        public final Builder maintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getTopicArn() {
            return topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final String getSubnetGroupName() {
            return subnetGroupName;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final Integer getNumShards() {
            return numShards;
        }

        public final void setNumShards(Integer numShards) {
            this.numShards = numShards;
        }

        @Override
        public final Builder numShards(Integer numShards) {
            this.numShards = numShards;
            return this;
        }

        public final List<ShardDetail.Builder> getShards() {
            List<ShardDetail.Builder> result = ShardDetailsCopier.copyToBuilder(this.shards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShards(Collection<ShardDetail.BuilderImpl> shards) {
            this.shards = ShardDetailsCopier.copyFromBuilder(shards);
        }

        @Override
        public final Builder shards(Collection<ShardDetail> shards) {
            this.shards = ShardDetailsCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(ShardDetail... shards) {
            shards(Arrays.asList(shards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Consumer<ShardDetail.Builder>... shards) {
            shards(Stream.of(shards).map(c -> ShardDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ClusterConfiguration build() {
            return new ClusterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
