/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterRequest extends MemoryDbRequest implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(CreateClusterRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(CreateClusterRequest::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupName").getter(getter(CreateClusterRequest::parameterGroupName))
            .setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateClusterRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> NUM_SHARDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumShards").getter(getter(CreateClusterRequest::numShards)).setter(setter(Builder::numShards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumShards").build()).build();

    private static final SdkField<Integer> NUM_REPLICAS_PER_SHARD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumReplicasPerShard").getter(getter(CreateClusterRequest::numReplicasPerShard))
            .setter(setter(Builder::numReplicasPerShard))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumReplicasPerShard").build())
            .build();

    private static final SdkField<String> SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetGroupName").getter(getter(CreateClusterRequest::subnetGroupName))
            .setter(setter(Builder::subnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupName").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateClusterRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MAINTENANCE_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceWindow").getter(getter(CreateClusterRequest::maintenanceWindow))
            .setter(setter(Builder::maintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceWindow").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(CreateClusterRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(CreateClusterRequest::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<Boolean> TLS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TLSEnabled").getter(getter(CreateClusterRequest::tlsEnabled)).setter(setter(Builder::tlsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSEnabled").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateClusterRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<String>> SNAPSHOT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SnapshotArns")
            .getter(getter(CreateClusterRequest::snapshotArns))
            .setter(setter(Builder::snapshotArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotName").getter(getter(CreateClusterRequest::snapshotName)).setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()).build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(CreateClusterRequest::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotWindow").getter(getter(CreateClusterRequest::snapshotWindow))
            .setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<String> ACL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ACLName").getter(getter(CreateClusterRequest::aclName)).setter(setter(Builder::aclName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLName").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateClusterRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreateClusterRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(CreateClusterRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<Boolean> DATA_TIERING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DataTiering").getter(getter(CreateClusterRequest::dataTiering)).setter(setter(Builder::dataTiering))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTiering").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NODE_TYPE_FIELD, PARAMETER_GROUP_NAME_FIELD, DESCRIPTION_FIELD, NUM_SHARDS_FIELD, NUM_REPLICAS_PER_SHARD_FIELD,
            SUBNET_GROUP_NAME_FIELD, SECURITY_GROUP_IDS_FIELD, MAINTENANCE_WINDOW_FIELD, PORT_FIELD, SNS_TOPIC_ARN_FIELD,
            TLS_ENABLED_FIELD, KMS_KEY_ID_FIELD, SNAPSHOT_ARNS_FIELD, SNAPSHOT_NAME_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD,
            TAGS_FIELD, SNAPSHOT_WINDOW_FIELD, ACL_NAME_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD, DATA_TIERING_FIELD));

    private final String clusterName;

    private final String nodeType;

    private final String parameterGroupName;

    private final String description;

    private final Integer numShards;

    private final Integer numReplicasPerShard;

    private final String subnetGroupName;

    private final List<String> securityGroupIds;

    private final String maintenanceWindow;

    private final Integer port;

    private final String snsTopicArn;

    private final Boolean tlsEnabled;

    private final String kmsKeyId;

    private final List<String> snapshotArns;

    private final String snapshotName;

    private final Integer snapshotRetentionLimit;

    private final List<Tag> tags;

    private final String snapshotWindow;

    private final String aclName;

    private final String engine;

    private final String engineVersion;

    private final Boolean autoMinorVersionUpgrade;

    private final Boolean dataTiering;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodeType = builder.nodeType;
        this.parameterGroupName = builder.parameterGroupName;
        this.description = builder.description;
        this.numShards = builder.numShards;
        this.numReplicasPerShard = builder.numReplicasPerShard;
        this.subnetGroupName = builder.subnetGroupName;
        this.securityGroupIds = builder.securityGroupIds;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.port = builder.port;
        this.snsTopicArn = builder.snsTopicArn;
        this.tlsEnabled = builder.tlsEnabled;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotArns = builder.snapshotArns;
        this.snapshotName = builder.snapshotName;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.tags = builder.tags;
        this.snapshotWindow = builder.snapshotWindow;
        this.aclName = builder.aclName;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.dataTiering = builder.dataTiering;
    }

    /**
     * <p>
     * The name of the cluster. This value must be unique as it also serves as the cluster identifier.
     * </p>
     * 
     * @return The name of the cluster. This value must be unique as it also serves as the cluster identifier.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The compute and memory capacity of the nodes in the cluster.
     * </p>
     * 
     * @return The compute and memory capacity of the nodes in the cluster.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The name of the parameter group associated with the cluster.
     * </p>
     * 
     * @return The name of the parameter group associated with the cluster.
     */
    public final String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * <p>
     * An optional description of the cluster.
     * </p>
     * 
     * @return An optional description of the cluster.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The number of shards the cluster will contain. The default value is 1.
     * </p>
     * 
     * @return The number of shards the cluster will contain. The default value is 1.
     */
    public final Integer numShards() {
        return numShards;
    }

    /**
     * <p>
     * The number of replicas to apply to each shard. The default value is 1. The maximum is 5.
     * </p>
     * 
     * @return The number of replicas to apply to each shard. The default value is 1. The maximum is 5.
     */
    public final Integer numReplicasPerShard() {
        return numReplicasPerShard;
    }

    /**
     * <p>
     * The name of the subnet group to be used for the cluster.
     * </p>
     * 
     * @return The name of the subnet group to be used for the cluster.
     */
    public final String subnetGroupName() {
        return subnetGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security group names to associate with this cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of security group names to associate with this cluster.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * <p>
     * Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * </p>
     * 
     * @return Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period.</p>
     *         <p>
     *         Valid values for <code>ddd</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sun</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tue</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>wed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>thu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sat</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>sun:23:00-mon:01:30</code>
     */
    public final String maintenanceWindow() {
        return maintenanceWindow;
    }

    /**
     * <p>
     * The port number on which each of the nodes accepts connections.
     * </p>
     * 
     * @return The port number on which each of the nodes accepts connections.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are
     * sent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
     *         notifications are sent.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * A flag to enable in-transit encryption on the cluster.
     * </p>
     * 
     * @return A flag to enable in-transit encryption on the cluster.
     */
    public final Boolean tlsEnabled() {
        return tlsEnabled;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt the cluster.
     * </p>
     * 
     * @return The ID of the KMS key used to encrypt the cluster.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnapshotArns() {
        return snapshotArns != null && !(snapshotArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The
     * snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any
     * commas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotArns} method.
     * </p>
     * 
     * @return A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3.
     *         The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot
     *         contain any commas.
     */
    public final List<String> snapshotArns() {
        return snapshotArns;
    }

    /**
     * <p>
     * The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring
     * while the new cluster is being created.
     * </p>
     * 
     * @return The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to
     *         restoring while the new cluster is being created.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set
     * SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     * </p>
     * 
     * @return The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if
     *         you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being
     *         deleted.
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey,
     * Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey,
     * Value=mySecondKeyValue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey,
     *         Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue
     *         Key=mySecondKey, Value=mySecondKeyValue.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.
     * </p>
     * <p>
     * Example: 05:00-09:00
     * </p>
     * <p>
     * If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.
     * </p>
     * 
     * @return The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.</p>
     *         <p>
     *         Example: 05:00-09:00
     *         </p>
     *         <p>
     *         If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.
     */
    public final String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * The name of the Access Control List to associate with the cluster.
     * </p>
     * 
     * @return The name of the Access Control List to associate with the cluster.
     */
    public final String aclName() {
        return aclName;
    }

    /**
     * <p>
     * The name of the engine to be used for the nodes in this cluster. The value must be set to either Redis or Valkey.
     * </p>
     * 
     * @return The name of the engine to be used for the nodes in this cluster. The value must be set to either Redis or
     *         Valkey.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the engine to be used for the cluster.
     * </p>
     * 
     * @return The version number of the engine to be used for the cluster.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * When set to true, the cluster will automatically receive minor engine version upgrades after launch.
     * </p>
     * 
     * @return When set to true, the cluster will automatically receive minor engine version upgrades after launch.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must
     * be set when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
     * </p>
     * 
     * @return Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This
     *         parameter must be set when using r6gd nodes. For more information, see <a
     *         href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
     */
    public final Boolean dataTiering() {
        return dataTiering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(numShards());
        hashCode = 31 * hashCode + Objects.hashCode(numReplicasPerShard());
        hashCode = 31 * hashCode + Objects.hashCode(subnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(tlsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotArns() ? snapshotArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(aclName());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(dataTiering());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(parameterGroupName(), other.parameterGroupName())
                && Objects.equals(description(), other.description()) && Objects.equals(numShards(), other.numShards())
                && Objects.equals(numReplicasPerShard(), other.numReplicasPerShard())
                && Objects.equals(subnetGroupName(), other.subnetGroupName())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(port(), other.port())
                && Objects.equals(snsTopicArn(), other.snsTopicArn()) && Objects.equals(tlsEnabled(), other.tlsEnabled())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasSnapshotArns() == other.hasSnapshotArns()
                && Objects.equals(snapshotArns(), other.snapshotArns()) && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(snapshotWindow(), other.snapshotWindow())
                && Objects.equals(aclName(), other.aclName()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(dataTiering(), other.dataTiering());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterRequest").add("ClusterName", clusterName()).add("NodeType", nodeType())
                .add("ParameterGroupName", parameterGroupName()).add("Description", description()).add("NumShards", numShards())
                .add("NumReplicasPerShard", numReplicasPerShard()).add("SubnetGroupName", subnetGroupName())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("MaintenanceWindow", maintenanceWindow()).add("Port", port()).add("SnsTopicArn", snsTopicArn())
                .add("TLSEnabled", tlsEnabled()).add("KmsKeyId", kmsKeyId())
                .add("SnapshotArns", hasSnapshotArns() ? snapshotArns() : null).add("SnapshotName", snapshotName())
                .add("SnapshotRetentionLimit", snapshotRetentionLimit()).add("Tags", hasTags() ? tags() : null)
                .add("SnapshotWindow", snapshotWindow()).add("ACLName", aclName()).add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("DataTiering", dataTiering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "NumShards":
            return Optional.ofNullable(clazz.cast(numShards()));
        case "NumReplicasPerShard":
            return Optional.ofNullable(clazz.cast(numReplicasPerShard()));
        case "SubnetGroupName":
            return Optional.ofNullable(clazz.cast(subnetGroupName()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "MaintenanceWindow":
            return Optional.ofNullable(clazz.cast(maintenanceWindow()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "TLSEnabled":
            return Optional.ofNullable(clazz.cast(tlsEnabled()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "SnapshotArns":
            return Optional.ofNullable(clazz.cast(snapshotArns()));
        case "SnapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "ACLName":
            return Optional.ofNullable(clazz.cast(aclName()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "DataTiering":
            return Optional.ofNullable(clazz.cast(dataTiering()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         * <p>
         * The name of the cluster. This value must be unique as it also serves as the cluster identifier.
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster. This value must be unique as it also serves as the cluster identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The compute and memory capacity of the nodes in the cluster.
         * </p>
         * 
         * @param nodeType
         *        The compute and memory capacity of the nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The name of the parameter group associated with the cluster.
         * </p>
         * 
         * @param parameterGroupName
         *        The name of the parameter group associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * An optional description of the cluster.
         * </p>
         * 
         * @param description
         *        An optional description of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The number of shards the cluster will contain. The default value is 1.
         * </p>
         * 
         * @param numShards
         *        The number of shards the cluster will contain. The default value is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numShards(Integer numShards);

        /**
         * <p>
         * The number of replicas to apply to each shard. The default value is 1. The maximum is 5.
         * </p>
         * 
         * @param numReplicasPerShard
         *        The number of replicas to apply to each shard. The default value is 1. The maximum is 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numReplicasPerShard(Integer numReplicasPerShard);

        /**
         * <p>
         * The name of the subnet group to be used for the cluster.
         * </p>
         * 
         * @param subnetGroupName
         *        The name of the subnet group to be used for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroupName(String subnetGroupName);

        /**
         * <p>
         * A list of security group names to associate with this cluster.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of security group names to associate with this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of security group names to associate with this cluster.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of security group names to associate with this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
         * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period.
         * </p>
         * <p>
         * Valid values for <code>ddd</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sun</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tue</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>wed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>thu</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fri</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sat</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>sun:23:00-mon:01:30</code>
         * </p>
         * 
         * @param maintenanceWindow
         *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified
         *        as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a
         *        60 minute period.</p>
         *        <p>
         *        Valid values for <code>ddd</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sun</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tue</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>wed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>thu</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fri</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sat</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>sun:23:00-mon:01:30</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindow(String maintenanceWindow);

        /**
         * <p>
         * The port number on which each of the nodes accepts connections.
         * </p>
         * 
         * @param port
         *        The port number on which each of the nodes accepts connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications
         * are sent.
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
         *        notifications are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * A flag to enable in-transit encryption on the cluster.
         * </p>
         * 
         * @param tlsEnabled
         *        A flag to enable in-transit encryption on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsEnabled(Boolean tlsEnabled);

        /**
         * <p>
         * The ID of the KMS key used to encrypt the cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key used to encrypt the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The
         * snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any
         * commas.
         * </p>
         * 
         * @param snapshotArns
         *        A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon
         *        S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN
         *        cannot contain any commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArns(Collection<String> snapshotArns);

        /**
         * <p>
         * A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The
         * snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any
         * commas.
         * </p>
         * 
         * @param snapshotArns
         *        A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon
         *        S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN
         *        cannot contain any commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArns(String... snapshotArns);

        /**
         * <p>
         * The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to
         * restoring while the new cluster is being created.
         * </p>
         * 
         * @param snapshotName
         *        The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to
         *        restoring while the new cluster is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you
         * set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which MemoryDB retains automatic snapshots before deleting them. For example,
         *        if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before
         *        being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey,
         * Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue
         * Key=mySecondKey, Value=mySecondKeyValue.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey,
         *        Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue
         *        Key=mySecondKey, Value=mySecondKeyValue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey,
         * Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue
         * Key=mySecondKey, Value=mySecondKeyValue.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey,
         *        Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue
         *        Key=mySecondKey, Value=mySecondKeyValue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey,
         * Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue
         * Key=mySecondKey, Value=mySecondKeyValue.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.memorydb.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.
         * </p>
         * <p>
         * Example: 05:00-09:00
         * </p>
         * <p>
         * If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.
         * </p>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.</p>
         *        <p>
         *        Example: 05:00-09:00
         *        </p>
         *        <p>
         *        If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * The name of the Access Control List to associate with the cluster.
         * </p>
         * 
         * @param aclName
         *        The name of the Access Control List to associate with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aclName(String aclName);

        /**
         * <p>
         * The name of the engine to be used for the nodes in this cluster. The value must be set to either Redis or
         * Valkey.
         * </p>
         * 
         * @param engine
         *        The name of the engine to be used for the nodes in this cluster. The value must be set to either Redis
         *        or Valkey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the engine to be used for the cluster.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the engine to be used for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * When set to true, the cluster will automatically receive minor engine version upgrades after launch.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        When set to true, the cluster will automatically receive minor engine version upgrades after launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter
         * must be set when using r6gd nodes. For more information, see <a
         * href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
         * </p>
         * 
         * @param dataTiering
         *        Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This
         *        parameter must be set when using r6gd nodes. For more information, see <a
         *        href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTiering(Boolean dataTiering);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String nodeType;

        private String parameterGroupName;

        private String description;

        private Integer numShards;

        private Integer numReplicasPerShard;

        private String subnetGroupName;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String maintenanceWindow;

        private Integer port;

        private String snsTopicArn;

        private Boolean tlsEnabled;

        private String kmsKeyId;

        private List<String> snapshotArns = DefaultSdkAutoConstructList.getInstance();

        private String snapshotName;

        private Integer snapshotRetentionLimit;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String snapshotWindow;

        private String aclName;

        private String engine;

        private String engineVersion;

        private Boolean autoMinorVersionUpgrade;

        private Boolean dataTiering;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            clusterName(model.clusterName);
            nodeType(model.nodeType);
            parameterGroupName(model.parameterGroupName);
            description(model.description);
            numShards(model.numShards);
            numReplicasPerShard(model.numReplicasPerShard);
            subnetGroupName(model.subnetGroupName);
            securityGroupIds(model.securityGroupIds);
            maintenanceWindow(model.maintenanceWindow);
            port(model.port);
            snsTopicArn(model.snsTopicArn);
            tlsEnabled(model.tlsEnabled);
            kmsKeyId(model.kmsKeyId);
            snapshotArns(model.snapshotArns);
            snapshotName(model.snapshotName);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            tags(model.tags);
            snapshotWindow(model.snapshotWindow);
            aclName(model.aclName);
            engine(model.engine);
            engineVersion(model.engineVersion);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            dataTiering(model.dataTiering);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getNumShards() {
            return numShards;
        }

        public final void setNumShards(Integer numShards) {
            this.numShards = numShards;
        }

        @Override
        public final Builder numShards(Integer numShards) {
            this.numShards = numShards;
            return this;
        }

        public final Integer getNumReplicasPerShard() {
            return numReplicasPerShard;
        }

        public final void setNumReplicasPerShard(Integer numReplicasPerShard) {
            this.numReplicasPerShard = numReplicasPerShard;
        }

        @Override
        public final Builder numReplicasPerShard(Integer numReplicasPerShard) {
            this.numReplicasPerShard = numReplicasPerShard;
            return this;
        }

        public final String getSubnetGroupName() {
            return subnetGroupName;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getMaintenanceWindow() {
            return maintenanceWindow;
        }

        public final void setMaintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
        }

        @Override
        public final Builder maintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final Boolean getTlsEnabled() {
            return tlsEnabled;
        }

        public final void setTlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
        }

        @Override
        public final Builder tlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getSnapshotArns() {
            if (snapshotArns instanceof SdkAutoConstructList) {
                return null;
            }
            return snapshotArns;
        }

        public final void setSnapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
        }

        @Override
        public final Builder snapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArns(String... snapshotArns) {
            snapshotArns(Arrays.asList(snapshotArns));
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final String getAclName() {
            return aclName;
        }

        public final void setAclName(String aclName) {
            this.aclName = aclName;
        }

        @Override
        public final Builder aclName(String aclName) {
            this.aclName = aclName;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Boolean getDataTiering() {
            return dataTiering;
        }

        public final void setDataTiering(Boolean dataTiering) {
            this.dataTiering = dataTiering;
        }

        @Override
        public final Builder dataTiering(Boolean dataTiering) {
            this.dataTiering = dataTiering;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
