/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateClusterRequest extends MemoryDbRequest implements
        ToCopyableBuilder<BatchUpdateClusterRequest.Builder, BatchUpdateClusterRequest> {
    private static final SdkField<List<String>> CLUSTER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ClusterNames")
            .getter(getter(BatchUpdateClusterRequest::clusterNames))
            .setter(setter(Builder::clusterNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ServiceUpdateRequest> SERVICE_UPDATE_FIELD = SdkField
            .<ServiceUpdateRequest> builder(MarshallingType.SDK_POJO).memberName("ServiceUpdate")
            .getter(getter(BatchUpdateClusterRequest::serviceUpdate)).setter(setter(Builder::serviceUpdate))
            .constructor(ServiceUpdateRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAMES_FIELD,
            SERVICE_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClusterNames", CLUSTER_NAMES_FIELD);
                    put("ServiceUpdate", SERVICE_UPDATE_FIELD);
                }
            });

    private final List<String> clusterNames;

    private final ServiceUpdateRequest serviceUpdate;

    private BatchUpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterNames = builder.clusterNames;
        this.serviceUpdate = builder.serviceUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterNames() {
        return clusterNames != null && !(clusterNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cluster names to apply the updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterNames} method.
     * </p>
     * 
     * @return The cluster names to apply the updates.
     */
    public final List<String> clusterNames() {
        return clusterNames;
    }

    /**
     * <p>
     * The unique ID of the service update
     * </p>
     * 
     * @return The unique ID of the service update
     */
    public final ServiceUpdateRequest serviceUpdate() {
        return serviceUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterNames() ? clusterNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateClusterRequest)) {
            return false;
        }
        BatchUpdateClusterRequest other = (BatchUpdateClusterRequest) obj;
        return hasClusterNames() == other.hasClusterNames() && Objects.equals(clusterNames(), other.clusterNames())
                && Objects.equals(serviceUpdate(), other.serviceUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateClusterRequest").add("ClusterNames", hasClusterNames() ? clusterNames() : null)
                .add("ServiceUpdate", serviceUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterNames":
            return Optional.ofNullable(clazz.cast(clusterNames()));
        case "ServiceUpdate":
            return Optional.ofNullable(clazz.cast(serviceUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateClusterRequest, T> g) {
        return obj -> g.apply((BatchUpdateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateClusterRequest> {
        /**
         * <p>
         * The cluster names to apply the updates.
         * </p>
         * 
         * @param clusterNames
         *        The cluster names to apply the updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNames(Collection<String> clusterNames);

        /**
         * <p>
         * The cluster names to apply the updates.
         * </p>
         * 
         * @param clusterNames
         *        The cluster names to apply the updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNames(String... clusterNames);

        /**
         * <p>
         * The unique ID of the service update
         * </p>
         * 
         * @param serviceUpdate
         *        The unique ID of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdate(ServiceUpdateRequest serviceUpdate);

        /**
         * <p>
         * The unique ID of the service update
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceUpdateRequest.Builder} avoiding
         * the need to create one manually via {@link ServiceUpdateRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceUpdateRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceUpdate(ServiceUpdateRequest)}.
         * 
         * @param serviceUpdate
         *        a consumer that will call methods on {@link ServiceUpdateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceUpdate(ServiceUpdateRequest)
         */
        default Builder serviceUpdate(Consumer<ServiceUpdateRequest.Builder> serviceUpdate) {
            return serviceUpdate(ServiceUpdateRequest.builder().applyMutation(serviceUpdate).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private List<String> clusterNames = DefaultSdkAutoConstructList.getInstance();

        private ServiceUpdateRequest serviceUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateClusterRequest model) {
            super(model);
            clusterNames(model.clusterNames);
            serviceUpdate(model.serviceUpdate);
        }

        public final Collection<String> getClusterNames() {
            if (clusterNames instanceof SdkAutoConstructList) {
                return null;
            }
            return clusterNames;
        }

        public final void setClusterNames(Collection<String> clusterNames) {
            this.clusterNames = ClusterNameListCopier.copy(clusterNames);
        }

        @Override
        public final Builder clusterNames(Collection<String> clusterNames) {
            this.clusterNames = ClusterNameListCopier.copy(clusterNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNames(String... clusterNames) {
            clusterNames(Arrays.asList(clusterNames));
            return this;
        }

        public final ServiceUpdateRequest.Builder getServiceUpdate() {
            return serviceUpdate != null ? serviceUpdate.toBuilder() : null;
        }

        public final void setServiceUpdate(ServiceUpdateRequest.BuilderImpl serviceUpdate) {
            this.serviceUpdate = serviceUpdate != null ? serviceUpdate.build() : null;
        }

        @Override
        public final Builder serviceUpdate(ServiceUpdateRequest serviceUpdate) {
            this.serviceUpdate = serviceUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateClusterRequest build() {
            return new BatchUpdateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
