/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedNodesOfferingsResponse extends MemoryDbResponse implements
        ToCopyableBuilder<DescribeReservedNodesOfferingsResponse.Builder, DescribeReservedNodesOfferingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeReservedNodesOfferingsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ReservedNodesOffering>> RESERVED_NODES_OFFERINGS_FIELD = SdkField
            .<List<ReservedNodesOffering>> builder(MarshallingType.LIST)
            .memberName("ReservedNodesOfferings")
            .getter(getter(DescribeReservedNodesOfferingsResponse::reservedNodesOfferings))
            .setter(setter(Builder::reservedNodesOfferings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodesOfferings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReservedNodesOffering> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedNodesOffering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESERVED_NODES_OFFERINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("ReservedNodesOfferings", RESERVED_NODES_OFFERINGS_FIELD);
                }
            });

    private final String nextToken;

    private final List<ReservedNodesOffering> reservedNodesOfferings;

    private DescribeReservedNodesOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedNodesOfferings = builder.reservedNodesOfferings;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by MaxRecords.
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by MaxRecords.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedNodesOfferings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReservedNodesOfferings() {
        return reservedNodesOfferings != null && !(reservedNodesOfferings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists available reserved node offerings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedNodesOfferings} method.
     * </p>
     * 
     * @return Lists available reserved node offerings.
     */
    public final List<ReservedNodesOffering> reservedNodesOfferings() {
        return reservedNodesOfferings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasReservedNodesOfferings() ? reservedNodesOfferings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodesOfferingsResponse)) {
            return false;
        }
        DescribeReservedNodesOfferingsResponse other = (DescribeReservedNodesOfferingsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasReservedNodesOfferings() == other.hasReservedNodesOfferings()
                && Objects.equals(reservedNodesOfferings(), other.reservedNodesOfferings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservedNodesOfferingsResponse").add("NextToken", nextToken())
                .add("ReservedNodesOfferings", hasReservedNodesOfferings() ? reservedNodesOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ReservedNodesOfferings":
            return Optional.ofNullable(clazz.cast(reservedNodesOfferings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedNodesOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedNodesOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedNodesOfferingsResponse> {
        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by MaxRecords.
         * </p>
         * 
         * @param nextToken
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by MaxRecords.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Lists available reserved node offerings.
         * </p>
         * 
         * @param reservedNodesOfferings
         *        Lists available reserved node offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodesOfferings(Collection<ReservedNodesOffering> reservedNodesOfferings);

        /**
         * <p>
         * Lists available reserved node offerings.
         * </p>
         * 
         * @param reservedNodesOfferings
         *        Lists available reserved node offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodesOfferings(ReservedNodesOffering... reservedNodesOfferings);

        /**
         * <p>
         * Lists available reserved node offerings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.ReservedNodesOffering.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.memorydb.model.ReservedNodesOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.ReservedNodesOffering.Builder#build()} is called
         * immediately and its result is passed to {@link #reservedNodesOfferings(List<ReservedNodesOffering>)}.
         * 
         * @param reservedNodesOfferings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.ReservedNodesOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedNodesOfferings(java.util.Collection<ReservedNodesOffering>)
         */
        Builder reservedNodesOfferings(Consumer<ReservedNodesOffering.Builder>... reservedNodesOfferings);
    }

    static final class BuilderImpl extends MemoryDbResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ReservedNodesOffering> reservedNodesOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodesOfferingsResponse model) {
            super(model);
            nextToken(model.nextToken);
            reservedNodesOfferings(model.reservedNodesOfferings);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservedNodesOffering.Builder> getReservedNodesOfferings() {
            List<ReservedNodesOffering.Builder> result = ReservedNodesOfferingListCopier
                    .copyToBuilder(this.reservedNodesOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedNodesOfferings(Collection<ReservedNodesOffering.BuilderImpl> reservedNodesOfferings) {
            this.reservedNodesOfferings = ReservedNodesOfferingListCopier.copyFromBuilder(reservedNodesOfferings);
        }

        @Override
        public final Builder reservedNodesOfferings(Collection<ReservedNodesOffering> reservedNodesOfferings) {
            this.reservedNodesOfferings = ReservedNodesOfferingListCopier.copy(reservedNodesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodesOfferings(ReservedNodesOffering... reservedNodesOfferings) {
            reservedNodesOfferings(Arrays.asList(reservedNodesOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodesOfferings(Consumer<ReservedNodesOffering.Builder>... reservedNodesOfferings) {
            reservedNodesOfferings(Stream.of(reservedNodesOfferings)
                    .map(c -> ReservedNodesOffering.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedNodesOfferingsResponse build() {
            return new DescribeReservedNodesOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
