/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServiceUpdatesRequest extends MemoryDbRequest implements
        ToCopyableBuilder<DescribeServiceUpdatesRequest.Builder, DescribeServiceUpdatesRequest> {
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceUpdateName").getter(getter(DescribeServiceUpdatesRequest::serviceUpdateName))
            .setter(setter(Builder::serviceUpdateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()).build();

    private static final SdkField<List<String>> CLUSTER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ClusterNames")
            .getter(getter(DescribeServiceUpdatesRequest::clusterNames))
            .setter(setter(Builder::clusterNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Status")
            .getter(getter(DescribeServiceUpdatesRequest::statusAsStrings))
            .setter(setter(Builder::statusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeServiceUpdatesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeServiceUpdatesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_UPDATE_NAME_FIELD,
            CLUSTER_NAMES_FIELD, STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ServiceUpdateName", SERVICE_UPDATE_NAME_FIELD);
                    put("ClusterNames", CLUSTER_NAMES_FIELD);
                    put("Status", STATUS_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final String serviceUpdateName;

    private final List<String> clusterNames;

    private final List<String> status;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeServiceUpdatesRequest(BuilderImpl builder) {
        super(builder);
        this.serviceUpdateName = builder.serviceUpdateName;
        this.clusterNames = builder.clusterNames;
        this.status = builder.status;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique ID of the service update to describe.
     * </p>
     * 
     * @return The unique ID of the service update to describe.
     */
    public final String serviceUpdateName() {
        return serviceUpdateName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterNames() {
        return clusterNames != null && !(clusterNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of cluster names to identify service updates to apply
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterNames} method.
     * </p>
     * 
     * @return The list of cluster names to identify service updates to apply
     */
    public final List<String> clusterNames() {
        return clusterNames;
    }

    /**
     * <p>
     * The status(es) of the service updates to filter on
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return The status(es) of the service updates to filter on
     */
    public final List<ServiceUpdateStatus> status() {
        return ServiceUpdateStatusListCopier.copyStringToEnum(status);
    }

    /**
     * For responses, this returns true if the service returned a value for the Status property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatus() {
        return status != null && !(status instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status(es) of the service updates to filter on
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return The status(es) of the service updates to filter on
     */
    public final List<String> statusAsStrings() {
        return status;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified MaxResults
     * value, a token is included in the response so that the remaining results can be retrieved.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         MaxResults value, a token is included in the response so that the remaining results can be retrieved.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is
     * returned, there are more results available. The value of nextToken is a unique pagination token for each page.
     * Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
     * </p>
     * 
     * @return An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
     *         nextToken is returned, there are more results available. The value of nextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page. Keep all
     *         other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterNames() ? clusterNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatus() ? statusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceUpdatesRequest)) {
            return false;
        }
        DescribeServiceUpdatesRequest other = (DescribeServiceUpdatesRequest) obj;
        return Objects.equals(serviceUpdateName(), other.serviceUpdateName()) && hasClusterNames() == other.hasClusterNames()
                && Objects.equals(clusterNames(), other.clusterNames()) && hasStatus() == other.hasStatus()
                && Objects.equals(statusAsStrings(), other.statusAsStrings()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeServiceUpdatesRequest").add("ServiceUpdateName", serviceUpdateName())
                .add("ClusterNames", hasClusterNames() ? clusterNames() : null)
                .add("Status", hasStatus() ? statusAsStrings() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceUpdateName":
            return Optional.ofNullable(clazz.cast(serviceUpdateName()));
        case "ClusterNames":
            return Optional.ofNullable(clazz.cast(clusterNames()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsStrings()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceUpdatesRequest, T> g) {
        return obj -> g.apply((DescribeServiceUpdatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeServiceUpdatesRequest> {
        /**
         * <p>
         * The unique ID of the service update to describe.
         * </p>
         * 
         * @param serviceUpdateName
         *        The unique ID of the service update to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateName(String serviceUpdateName);

        /**
         * <p>
         * The list of cluster names to identify service updates to apply
         * </p>
         * 
         * @param clusterNames
         *        The list of cluster names to identify service updates to apply
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNames(Collection<String> clusterNames);

        /**
         * <p>
         * The list of cluster names to identify service updates to apply
         * </p>
         * 
         * @param clusterNames
         *        The list of cluster names to identify service updates to apply
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNames(String... clusterNames);

        /**
         * <p>
         * The status(es) of the service updates to filter on
         * </p>
         * 
         * @param status
         *        The status(es) of the service updates to filter on
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(Collection<String> status);

        /**
         * <p>
         * The status(es) of the service updates to filter on
         * </p>
         * 
         * @param status
         *        The status(es) of the service updates to filter on
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(String... status);

        /**
         * <p>
         * The status(es) of the service updates to filter on
         * </p>
         * 
         * @param status
         *        The status(es) of the service updates to filter on
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Collection<ServiceUpdateStatus> status);

        /**
         * <p>
         * The status(es) of the service updates to filter on
         * </p>
         * 
         * @param status
         *        The status(es) of the service updates to filter on
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ServiceUpdateStatus... status);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified MaxResults
         * value, a token is included in the response so that the remaining results can be retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        MaxResults value, a token is included in the response so that the remaining results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
         * nextToken is returned, there are more results available. The value of nextToken is a unique pagination token
         * for each page. Make the call again using the returned token to retrieve the next page. Keep all other
         * arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
         *        nextToken is returned, there are more results available. The value of nextToken is a unique pagination
         *        token for each page. Make the call again using the returned token to retrieve the next page. Keep all
         *        other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private String serviceUpdateName;

        private List<String> clusterNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> status = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceUpdatesRequest model) {
            super(model);
            serviceUpdateName(model.serviceUpdateName);
            clusterNames(model.clusterNames);
            statusWithStrings(model.status);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getServiceUpdateName() {
            return serviceUpdateName;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final Collection<String> getClusterNames() {
            if (clusterNames instanceof SdkAutoConstructList) {
                return null;
            }
            return clusterNames;
        }

        public final void setClusterNames(Collection<String> clusterNames) {
            this.clusterNames = ClusterNameListCopier.copy(clusterNames);
        }

        @Override
        public final Builder clusterNames(Collection<String> clusterNames) {
            this.clusterNames = ClusterNameListCopier.copy(clusterNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNames(String... clusterNames) {
            clusterNames(Arrays.asList(clusterNames));
            return this;
        }

        public final Collection<String> getStatus() {
            if (status instanceof SdkAutoConstructList) {
                return null;
            }
            return status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = ServiceUpdateStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = ServiceUpdateStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String... status) {
            statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<ServiceUpdateStatus> status) {
            this.status = ServiceUpdateStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(ServiceUpdateStatus... status) {
            status(Arrays.asList(status));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServiceUpdatesRequest build() {
            return new DescribeServiceUpdatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
