/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseReservedNodesOfferingResponse extends MemoryDbResponse implements
        ToCopyableBuilder<PurchaseReservedNodesOfferingResponse.Builder, PurchaseReservedNodesOfferingResponse> {
    private static final SdkField<ReservedNode> RESERVED_NODE_FIELD = SdkField.<ReservedNode> builder(MarshallingType.SDK_POJO)
            .memberName("ReservedNode").getter(getter(PurchaseReservedNodesOfferingResponse::reservedNode))
            .setter(setter(Builder::reservedNode)).constructor(ReservedNode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_NODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ReservedNode", RESERVED_NODE_FIELD);
                }
            });

    private final ReservedNode reservedNode;

    private PurchaseReservedNodesOfferingResponse(BuilderImpl builder) {
        super(builder);
        this.reservedNode = builder.reservedNode;
    }

    /**
     * <p>
     * Represents the output of a <code>PurchaseReservedNodesOffering</code> operation.
     * </p>
     * 
     * @return Represents the output of a <code>PurchaseReservedNodesOffering</code> operation.
     */
    public final ReservedNode reservedNode() {
        return reservedNode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedNode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedNodesOfferingResponse)) {
            return false;
        }
        PurchaseReservedNodesOfferingResponse other = (PurchaseReservedNodesOfferingResponse) obj;
        return Objects.equals(reservedNode(), other.reservedNode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseReservedNodesOfferingResponse").add("ReservedNode", reservedNode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedNode":
            return Optional.ofNullable(clazz.cast(reservedNode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedNodesOfferingResponse, T> g) {
        return obj -> g.apply((PurchaseReservedNodesOfferingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PurchaseReservedNodesOfferingResponse> {
        /**
         * <p>
         * Represents the output of a <code>PurchaseReservedNodesOffering</code> operation.
         * </p>
         * 
         * @param reservedNode
         *        Represents the output of a <code>PurchaseReservedNodesOffering</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNode(ReservedNode reservedNode);

        /**
         * <p>
         * Represents the output of a <code>PurchaseReservedNodesOffering</code> operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReservedNode.Builder} avoiding the need
         * to create one manually via {@link ReservedNode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservedNode.Builder#build()} is called immediately and its
         * result is passed to {@link #reservedNode(ReservedNode)}.
         * 
         * @param reservedNode
         *        a consumer that will call methods on {@link ReservedNode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedNode(ReservedNode)
         */
        default Builder reservedNode(Consumer<ReservedNode.Builder> reservedNode) {
            return reservedNode(ReservedNode.builder().applyMutation(reservedNode).build());
        }
    }

    static final class BuilderImpl extends MemoryDbResponse.BuilderImpl implements Builder {
        private ReservedNode reservedNode;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedNodesOfferingResponse model) {
            super(model);
            reservedNode(model.reservedNode);
        }

        public final ReservedNode.Builder getReservedNode() {
            return reservedNode != null ? reservedNode.toBuilder() : null;
        }

        public final void setReservedNode(ReservedNode.BuilderImpl reservedNode) {
            this.reservedNode = reservedNode != null ? reservedNode.build() : null;
        }

        @Override
        public final Builder reservedNode(ReservedNode reservedNode) {
            this.reservedNode = reservedNode;
            return this;
        }

        @Override
        public PurchaseReservedNodesOfferingResponse build() {
            return new PurchaseReservedNodesOfferingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
