/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventsResponse extends MemoryDbResponse implements
        ToCopyableBuilder<DescribeEventsResponse.Builder, DescribeEventsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Event>> EVENTS_FIELD = SdkField
            .<List<Event>> builder(MarshallingType.LIST)
            .memberName("Events")
            .getter(getter(DescribeEventsResponse::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Event> builder(MarshallingType.SDK_POJO)
                                            .constructor(Event::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXT_TOKEN_FIELD, EVENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("Events", EVENTS_FIELD);
                }
            });

    private final String nextToken;

    private final List<Event> events;

    private DescribeEventsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.events = builder.events;
    }

    /**
     * <p>
     * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is
     * returned, there are more results available. The value of nextToken is a unique pagination token for each page.
     * Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
     * </p>
     * 
     * @return An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
     *         nextToken is returned, there are more results available. The value of nextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page. Keep all
     *         other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of events. Each element in the list contains detailed information about one event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return A list of events. Each element in the list contains detailed information about one event.
     */
    public final List<Event> events() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsResponse)) {
            return false;
        }
        DescribeEventsResponse other = (DescribeEventsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasEvents() == other.hasEvents()
                && Objects.equals(events(), other.events());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEventsResponse").add("NextToken", nextToken())
                .add("Events", hasEvents() ? events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Events":
            return Optional.ofNullable(clazz.cast(events()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventsResponse, T> g) {
        return obj -> g.apply((DescribeEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventsResponse> {
        /**
         * <p>
         * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
         * nextToken is returned, there are more results available. The value of nextToken is a unique pagination token
         * for each page. Make the call again using the returned token to retrieve the next page. Keep all other
         * arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
         *        nextToken is returned, there are more results available. The value of nextToken is a unique pagination
         *        token for each page. Make the call again using the returned token to retrieve the next page. Keep all
         *        other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of events. Each element in the list contains detailed information about one event.
         * </p>
         * 
         * @param events
         *        A list of events. Each element in the list contains detailed information about one event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<Event> events);

        /**
         * <p>
         * A list of events. Each element in the list contains detailed information about one event.
         * </p>
         * 
         * @param events
         *        A list of events. Each element in the list contains detailed information about one event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Event... events);

        /**
         * <p>
         * A list of events. Each element in the list contains detailed information about one event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.Event.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.memorydb.model.Event#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.Event.Builder#build()} is called immediately and its
         * result is passed to {@link #events(List<Event>)}.
         * 
         * @param events
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.Event.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(java.util.Collection<Event>)
         */
        Builder events(Consumer<Event.Builder>... events);
    }

    static final class BuilderImpl extends MemoryDbResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Event> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsResponse model) {
            super(model);
            nextToken(model.nextToken);
            events(model.events);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Event.Builder> getEvents() {
            List<Event.Builder> result = EventListCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<Event.BuilderImpl> events) {
            this.events = EventListCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<Event> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<Event.Builder>... events) {
            events(Stream.of(events).map(c -> Event.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEventsResponse build() {
            return new DescribeEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
