/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateClusterResponse extends MemoryDbResponse implements
        ToCopyableBuilder<BatchUpdateClusterResponse.Builder, BatchUpdateClusterResponse> {
    private static final SdkField<List<Cluster>> PROCESSED_CLUSTERS_FIELD = SdkField
            .<List<Cluster>> builder(MarshallingType.LIST)
            .memberName("ProcessedClusters")
            .getter(getter(BatchUpdateClusterResponse::processedClusters))
            .setter(setter(Builder::processedClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Cluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(Cluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedCluster>> UNPROCESSED_CLUSTERS_FIELD = SdkField
            .<List<UnprocessedCluster>> builder(MarshallingType.LIST)
            .memberName("UnprocessedClusters")
            .getter(getter(BatchUpdateClusterResponse::unprocessedClusters))
            .setter(setter(Builder::unprocessedClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSED_CLUSTERS_FIELD,
            UNPROCESSED_CLUSTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ProcessedClusters", PROCESSED_CLUSTERS_FIELD);
                    put("UnprocessedClusters", UNPROCESSED_CLUSTERS_FIELD);
                }
            });

    private final List<Cluster> processedClusters;

    private final List<UnprocessedCluster> unprocessedClusters;

    private BatchUpdateClusterResponse(BuilderImpl builder) {
        super(builder);
        this.processedClusters = builder.processedClusters;
        this.unprocessedClusters = builder.unprocessedClusters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessedClusters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProcessedClusters() {
        return processedClusters != null && !(processedClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of clusters that have been updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessedClusters} method.
     * </p>
     * 
     * @return The list of clusters that have been updated.
     */
    public final List<Cluster> processedClusters() {
        return processedClusters;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedClusters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedClusters() {
        return unprocessedClusters != null && !(unprocessedClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of clusters where updates have not been applied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedClusters} method.
     * </p>
     * 
     * @return The list of clusters where updates have not been applied.
     */
    public final List<UnprocessedCluster> unprocessedClusters() {
        return unprocessedClusters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessedClusters() ? processedClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedClusters() ? unprocessedClusters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateClusterResponse)) {
            return false;
        }
        BatchUpdateClusterResponse other = (BatchUpdateClusterResponse) obj;
        return hasProcessedClusters() == other.hasProcessedClusters()
                && Objects.equals(processedClusters(), other.processedClusters())
                && hasUnprocessedClusters() == other.hasUnprocessedClusters()
                && Objects.equals(unprocessedClusters(), other.unprocessedClusters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateClusterResponse")
                .add("ProcessedClusters", hasProcessedClusters() ? processedClusters() : null)
                .add("UnprocessedClusters", hasUnprocessedClusters() ? unprocessedClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessedClusters":
            return Optional.ofNullable(clazz.cast(processedClusters()));
        case "UnprocessedClusters":
            return Optional.ofNullable(clazz.cast(unprocessedClusters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateClusterResponse, T> g) {
        return obj -> g.apply((BatchUpdateClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateClusterResponse> {
        /**
         * <p>
         * The list of clusters that have been updated.
         * </p>
         * 
         * @param processedClusters
         *        The list of clusters that have been updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedClusters(Collection<Cluster> processedClusters);

        /**
         * <p>
         * The list of clusters that have been updated.
         * </p>
         * 
         * @param processedClusters
         *        The list of clusters that have been updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedClusters(Cluster... processedClusters);

        /**
         * <p>
         * The list of clusters that have been updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.Cluster.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.memorydb.model.Cluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.Cluster.Builder#build()} is called immediately and its
         * result is passed to {@link #processedClusters(List<Cluster>)}.
         * 
         * @param processedClusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.Cluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processedClusters(java.util.Collection<Cluster>)
         */
        Builder processedClusters(Consumer<Cluster.Builder>... processedClusters);

        /**
         * <p>
         * The list of clusters where updates have not been applied.
         * </p>
         * 
         * @param unprocessedClusters
         *        The list of clusters where updates have not been applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedClusters(Collection<UnprocessedCluster> unprocessedClusters);

        /**
         * <p>
         * The list of clusters where updates have not been applied.
         * </p>
         * 
         * @param unprocessedClusters
         *        The list of clusters where updates have not been applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedClusters(UnprocessedCluster... unprocessedClusters);

        /**
         * <p>
         * The list of clusters where updates have not been applied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.UnprocessedCluster.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.memorydb.model.UnprocessedCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.UnprocessedCluster.Builder#build()} is called
         * immediately and its result is passed to {@link #unprocessedClusters(List<UnprocessedCluster>)}.
         * 
         * @param unprocessedClusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.UnprocessedCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedClusters(java.util.Collection<UnprocessedCluster>)
         */
        Builder unprocessedClusters(Consumer<UnprocessedCluster.Builder>... unprocessedClusters);
    }

    static final class BuilderImpl extends MemoryDbResponse.BuilderImpl implements Builder {
        private List<Cluster> processedClusters = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedCluster> unprocessedClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateClusterResponse model) {
            super(model);
            processedClusters(model.processedClusters);
            unprocessedClusters(model.unprocessedClusters);
        }

        public final List<Cluster.Builder> getProcessedClusters() {
            List<Cluster.Builder> result = ClusterListCopier.copyToBuilder(this.processedClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessedClusters(Collection<Cluster.BuilderImpl> processedClusters) {
            this.processedClusters = ClusterListCopier.copyFromBuilder(processedClusters);
        }

        @Override
        public final Builder processedClusters(Collection<Cluster> processedClusters) {
            this.processedClusters = ClusterListCopier.copy(processedClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedClusters(Cluster... processedClusters) {
            processedClusters(Arrays.asList(processedClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedClusters(Consumer<Cluster.Builder>... processedClusters) {
            processedClusters(Stream.of(processedClusters).map(c -> Cluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedCluster.Builder> getUnprocessedClusters() {
            List<UnprocessedCluster.Builder> result = UnprocessedClusterListCopier.copyToBuilder(this.unprocessedClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedClusters(Collection<UnprocessedCluster.BuilderImpl> unprocessedClusters) {
            this.unprocessedClusters = UnprocessedClusterListCopier.copyFromBuilder(unprocessedClusters);
        }

        @Override
        public final Builder unprocessedClusters(Collection<UnprocessedCluster> unprocessedClusters) {
            this.unprocessedClusters = UnprocessedClusterListCopier.copy(unprocessedClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedClusters(UnprocessedCluster... unprocessedClusters) {
            unprocessedClusters(Arrays.asList(unprocessedClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedClusters(Consumer<UnprocessedCluster.Builder>... unprocessedClusters) {
            unprocessedClusters(Stream.of(unprocessedClusters).map(c -> UnprocessedCluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateClusterResponse build() {
            return new BatchUpdateClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
