/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains all of the attributes of a specific cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cluster implements SdkPojo, Serializable, ToCopyableBuilder<Cluster.Builder, Cluster> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Cluster::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Cluster::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Cluster::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ClusterPendingUpdates> PENDING_UPDATES_FIELD = SdkField
            .<ClusterPendingUpdates> builder(MarshallingType.SDK_POJO).memberName("PendingUpdates")
            .getter(getter(Cluster::pendingUpdates)).setter(setter(Builder::pendingUpdates))
            .constructor(ClusterPendingUpdates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingUpdates").build()).build();

    private static final SdkField<String> MULTI_REGION_CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MultiRegionClusterName").getter(getter(Cluster::multiRegionClusterName))
            .setter(setter(Builder::multiRegionClusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusterName").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_SHARDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfShards").getter(getter(Cluster::numberOfShards)).setter(setter(Builder::numberOfShards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfShards").build()).build();

    private static final SdkField<List<Shard>> SHARDS_FIELD = SdkField
            .<List<Shard>> builder(MarshallingType.LIST)
            .memberName("Shards")
            .getter(getter(Cluster::shards))
            .setter(setter(Builder::shards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Shard> builder(MarshallingType.SDK_POJO)
                                            .constructor(Shard::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityMode").getter(getter(Cluster::availabilityModeAsString))
            .setter(setter(Builder::availabilityMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityMode").build()).build();

    private static final SdkField<Endpoint> CLUSTER_ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("ClusterEndpoint").getter(getter(Cluster::clusterEndpoint)).setter(setter(Builder::clusterEndpoint))
            .constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEndpoint").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(Cluster::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(Cluster::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(Cluster::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> ENGINE_PATCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnginePatchVersion").getter(getter(Cluster::enginePatchVersion))
            .setter(setter(Builder::enginePatchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnginePatchVersion").build())
            .build();

    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupName").getter(getter(Cluster::parameterGroupName))
            .setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<String> PARAMETER_GROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupStatus").getter(getter(Cluster::parameterGroupStatus))
            .setter(setter(Builder::parameterGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupStatus").build())
            .build();

    private static final SdkField<List<SecurityGroupMembership>> SECURITY_GROUPS_FIELD = SdkField
            .<List<SecurityGroupMembership>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(Cluster::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetGroupName").getter(getter(Cluster::subnetGroupName)).setter(setter(Builder::subnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupName").build()).build();

    private static final SdkField<Boolean> TLS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TLSEnabled").getter(getter(Cluster::tlsEnabled)).setter(setter(Builder::tlsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSEnabled").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(Cluster::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(Cluster::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(Cluster::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> SNS_TOPIC_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicStatus").getter(getter(Cluster::snsTopicStatus)).setter(setter(Builder::snsTopicStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicStatus").build()).build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(Cluster::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> MAINTENANCE_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceWindow").getter(getter(Cluster::maintenanceWindow))
            .setter(setter(Builder::maintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceWindow").build()).build();

    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotWindow").getter(getter(Cluster::snapshotWindow)).setter(setter(Builder::snapshotWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()).build();

    private static final SdkField<String> ACL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ACLName").getter(getter(Cluster::aclName)).setter(setter(Builder::aclName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLName").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(Cluster::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> DATA_TIERING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTiering").getter(getter(Cluster::dataTieringAsString)).setter(setter(Builder::dataTiering))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTiering").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            STATUS_FIELD, PENDING_UPDATES_FIELD, MULTI_REGION_CLUSTER_NAME_FIELD, NUMBER_OF_SHARDS_FIELD, SHARDS_FIELD,
            AVAILABILITY_MODE_FIELD, CLUSTER_ENDPOINT_FIELD, NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD,
            ENGINE_PATCH_VERSION_FIELD, PARAMETER_GROUP_NAME_FIELD, PARAMETER_GROUP_STATUS_FIELD, SECURITY_GROUPS_FIELD,
            SUBNET_GROUP_NAME_FIELD, TLS_ENABLED_FIELD, KMS_KEY_ID_FIELD, ARN_FIELD, SNS_TOPIC_ARN_FIELD, SNS_TOPIC_STATUS_FIELD,
            SNAPSHOT_RETENTION_LIMIT_FIELD, MAINTENANCE_WINDOW_FIELD, SNAPSHOT_WINDOW_FIELD, ACL_NAME_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD, DATA_TIERING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Name", NAME_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("Status", STATUS_FIELD);
                    put("PendingUpdates", PENDING_UPDATES_FIELD);
                    put("MultiRegionClusterName", MULTI_REGION_CLUSTER_NAME_FIELD);
                    put("NumberOfShards", NUMBER_OF_SHARDS_FIELD);
                    put("Shards", SHARDS_FIELD);
                    put("AvailabilityMode", AVAILABILITY_MODE_FIELD);
                    put("ClusterEndpoint", CLUSTER_ENDPOINT_FIELD);
                    put("NodeType", NODE_TYPE_FIELD);
                    put("Engine", ENGINE_FIELD);
                    put("EngineVersion", ENGINE_VERSION_FIELD);
                    put("EnginePatchVersion", ENGINE_PATCH_VERSION_FIELD);
                    put("ParameterGroupName", PARAMETER_GROUP_NAME_FIELD);
                    put("ParameterGroupStatus", PARAMETER_GROUP_STATUS_FIELD);
                    put("SecurityGroups", SECURITY_GROUPS_FIELD);
                    put("SubnetGroupName", SUBNET_GROUP_NAME_FIELD);
                    put("TLSEnabled", TLS_ENABLED_FIELD);
                    put("KmsKeyId", KMS_KEY_ID_FIELD);
                    put("ARN", ARN_FIELD);
                    put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
                    put("SnsTopicStatus", SNS_TOPIC_STATUS_FIELD);
                    put("SnapshotRetentionLimit", SNAPSHOT_RETENTION_LIMIT_FIELD);
                    put("MaintenanceWindow", MAINTENANCE_WINDOW_FIELD);
                    put("SnapshotWindow", SNAPSHOT_WINDOW_FIELD);
                    put("ACLName", ACL_NAME_FIELD);
                    put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
                    put("DataTiering", DATA_TIERING_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String status;

    private final ClusterPendingUpdates pendingUpdates;

    private final String multiRegionClusterName;

    private final Integer numberOfShards;

    private final List<Shard> shards;

    private final String availabilityMode;

    private final Endpoint clusterEndpoint;

    private final String nodeType;

    private final String engine;

    private final String engineVersion;

    private final String enginePatchVersion;

    private final String parameterGroupName;

    private final String parameterGroupStatus;

    private final List<SecurityGroupMembership> securityGroups;

    private final String subnetGroupName;

    private final Boolean tlsEnabled;

    private final String kmsKeyId;

    private final String arn;

    private final String snsTopicArn;

    private final String snsTopicStatus;

    private final Integer snapshotRetentionLimit;

    private final String maintenanceWindow;

    private final String snapshotWindow;

    private final String aclName;

    private final Boolean autoMinorVersionUpgrade;

    private final String dataTiering;

    private Cluster(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.pendingUpdates = builder.pendingUpdates;
        this.multiRegionClusterName = builder.multiRegionClusterName;
        this.numberOfShards = builder.numberOfShards;
        this.shards = builder.shards;
        this.availabilityMode = builder.availabilityMode;
        this.clusterEndpoint = builder.clusterEndpoint;
        this.nodeType = builder.nodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.enginePatchVersion = builder.enginePatchVersion;
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterGroupStatus = builder.parameterGroupStatus;
        this.securityGroups = builder.securityGroups;
        this.subnetGroupName = builder.subnetGroupName;
        this.tlsEnabled = builder.tlsEnabled;
        this.kmsKeyId = builder.kmsKeyId;
        this.arn = builder.arn;
        this.snsTopicArn = builder.snsTopicArn;
        this.snsTopicStatus = builder.snsTopicStatus;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.snapshotWindow = builder.snapshotWindow;
        this.aclName = builder.aclName;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.dataTiering = builder.dataTiering;
    }

    /**
     * <p>
     * The user-supplied name of the cluster. This identifier is a unique key that identifies a cluster.
     * </p>
     * 
     * @return The user-supplied name of the cluster. This identifier is a unique key that identifies a cluster.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the cluster
     * </p>
     * 
     * @return A description of the cluster
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the cluster. For example, Available, Updating, Creating.
     * </p>
     * 
     * @return The status of the cluster. For example, Available, Updating, Creating.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * A group of settings that are currently being applied.
     * </p>
     * 
     * @return A group of settings that are currently being applied.
     */
    public final ClusterPendingUpdates pendingUpdates() {
        return pendingUpdates;
    }

    /**
     * <p>
     * The name of the multi-Region cluster that this cluster belongs to.
     * </p>
     * 
     * @return The name of the multi-Region cluster that this cluster belongs to.
     */
    public final String multiRegionClusterName() {
        return multiRegionClusterName;
    }

    /**
     * <p>
     * The number of shards in the cluster
     * </p>
     * 
     * @return The number of shards in the cluster
     */
    public final Integer numberOfShards() {
        return numberOfShards;
    }

    /**
     * For responses, this returns true if the service returned a value for the Shards property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasShards() {
        return shards != null && !(shards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of shards that are members of the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShards} method.
     * </p>
     * 
     * @return A list of shards that are members of the cluster.
     */
    public final List<Shard> shards() {
        return shards;
    }

    /**
     * <p>
     * Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #availabilityMode}
     * will return {@link AZStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #availabilityModeAsString}.
     * </p>
     * 
     * @return Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).
     * @see AZStatus
     */
    public final AZStatus availabilityMode() {
        return AZStatus.fromValue(availabilityMode);
    }

    /**
     * <p>
     * Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #availabilityMode}
     * will return {@link AZStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #availabilityModeAsString}.
     * </p>
     * 
     * @return Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).
     * @see AZStatus
     */
    public final String availabilityModeAsString() {
        return availabilityMode;
    }

    /**
     * <p>
     * The cluster's configuration endpoint
     * </p>
     * 
     * @return The cluster's configuration endpoint
     */
    public final Endpoint clusterEndpoint() {
        return clusterEndpoint;
    }

    /**
     * <p>
     * The cluster's node type
     * </p>
     * 
     * @return The cluster's node type
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The name of the engine used by the cluster.
     * </p>
     * 
     * @return The name of the engine used by the cluster.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The Redis OSS engine version used by the cluster
     * </p>
     * 
     * @return The Redis OSS engine version used by the cluster
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The Redis OSS engine patch version used by the cluster
     * </p>
     * 
     * @return The Redis OSS engine patch version used by the cluster
     */
    public final String enginePatchVersion() {
        return enginePatchVersion;
    }

    /**
     * <p>
     * The name of the parameter group used by the cluster
     * </p>
     * 
     * @return The name of the parameter group used by the cluster
     */
    public final String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * <p>
     * The status of the parameter group used by the cluster, for example 'active' or 'applying'.
     * </p>
     * 
     * @return The status of the parameter group used by the cluster, for example 'active' or 'applying'.
     */
    public final String parameterGroupStatus() {
        return parameterGroupStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security groups used by the cluster
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return A list of security groups used by the cluster
     */
    public final List<SecurityGroupMembership> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The name of the subnet group used by the cluster
     * </p>
     * 
     * @return The name of the subnet group used by the cluster
     */
    public final String subnetGroupName() {
        return subnetGroupName;
    }

    /**
     * <p>
     * A flag to indicate if In-transit encryption is enabled
     * </p>
     * 
     * @return A flag to indicate if In-transit encryption is enabled
     */
    public final Boolean tlsEnabled() {
        return tlsEnabled;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt the cluster
     * </p>
     * 
     * @return The ID of the KMS key used to encrypt the cluster
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cluster.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SNS notification topic
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SNS notification topic
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The SNS topic must be in Active status to receive notifications
     * </p>
     * 
     * @return The SNS topic must be in Active status to receive notifications
     */
    public final String snsTopicStatus() {
        return snsTopicStatus;
    }

    /**
     * <p>
     * The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set
     * SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     * </p>
     * 
     * @return The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if
     *         you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being
     *         deleted.
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * 
     * @return Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period.
     */
    public final String maintenanceWindow() {
        return maintenanceWindow;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard. Example:
     * 05:00-09:00 If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.
     * </p>
     * 
     * @return The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.
     *         Example: 05:00-09:00 If you do not specify this parameter, MemoryDB automatically chooses an appropriate
     *         time range.
     */
    public final String snapshotWindow() {
        return snapshotWindow;
    }

    /**
     * <p>
     * The name of the Access Control List associated with this cluster.
     * </p>
     * 
     * @return The name of the Access Control List associated with this cluster.
     */
    public final String aclName() {
        return aclName;
    }

    /**
     * <p>
     * When set to true, the cluster will automatically receive minor engine version upgrades after launch.
     * </p>
     * 
     * @return When set to true, the cluster will automatically receive minor engine version upgrades after launch.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must
     * be set when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataTiering} will
     * return {@link DataTieringStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTieringAsString}.
     * </p>
     * 
     * @return Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This
     *         parameter must be set when using r6gd nodes. For more information, see <a
     *         href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
     * @see DataTieringStatus
     */
    public final DataTieringStatus dataTiering() {
        return DataTieringStatus.fromValue(dataTiering);
    }

    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must
     * be set when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataTiering} will
     * return {@link DataTieringStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTieringAsString}.
     * </p>
     * 
     * @return Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This
     *         parameter must be set when using r6gd nodes. For more information, see <a
     *         href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
     * @see DataTieringStatus
     */
    public final String dataTieringAsString() {
        return dataTiering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(pendingUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionClusterName());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfShards());
        hashCode = 31 * hashCode + Objects.hashCode(hasShards() ? shards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(enginePatchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(tlsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicStatus());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(aclName());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(dataTieringAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(status(), other.status()) && Objects.equals(pendingUpdates(), other.pendingUpdates())
                && Objects.equals(multiRegionClusterName(), other.multiRegionClusterName())
                && Objects.equals(numberOfShards(), other.numberOfShards()) && hasShards() == other.hasShards()
                && Objects.equals(shards(), other.shards())
                && Objects.equals(availabilityModeAsString(), other.availabilityModeAsString())
                && Objects.equals(clusterEndpoint(), other.clusterEndpoint()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(enginePatchVersion(), other.enginePatchVersion())
                && Objects.equals(parameterGroupName(), other.parameterGroupName())
                && Objects.equals(parameterGroupStatus(), other.parameterGroupStatus())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(subnetGroupName(), other.subnetGroupName()) && Objects.equals(tlsEnabled(), other.tlsEnabled())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(snsTopicArn(), other.snsTopicArn()) && Objects.equals(snsTopicStatus(), other.snsTopicStatus())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(maintenanceWindow(), other.maintenanceWindow())
                && Objects.equals(snapshotWindow(), other.snapshotWindow()) && Objects.equals(aclName(), other.aclName())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(dataTieringAsString(), other.dataTieringAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Cluster").add("Name", name()).add("Description", description()).add("Status", status())
                .add("PendingUpdates", pendingUpdates()).add("MultiRegionClusterName", multiRegionClusterName())
                .add("NumberOfShards", numberOfShards()).add("Shards", hasShards() ? shards() : null)
                .add("AvailabilityMode", availabilityModeAsString()).add("ClusterEndpoint", clusterEndpoint())
                .add("NodeType", nodeType()).add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("EnginePatchVersion", enginePatchVersion()).add("ParameterGroupName", parameterGroupName())
                .add("ParameterGroupStatus", parameterGroupStatus())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("SubnetGroupName", subnetGroupName())
                .add("TLSEnabled", tlsEnabled()).add("KmsKeyId", kmsKeyId()).add("ARN", arn()).add("SnsTopicArn", snsTopicArn())
                .add("SnsTopicStatus", snsTopicStatus()).add("SnapshotRetentionLimit", snapshotRetentionLimit())
                .add("MaintenanceWindow", maintenanceWindow()).add("SnapshotWindow", snapshotWindow()).add("ACLName", aclName())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade()).add("DataTiering", dataTieringAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "PendingUpdates":
            return Optional.ofNullable(clazz.cast(pendingUpdates()));
        case "MultiRegionClusterName":
            return Optional.ofNullable(clazz.cast(multiRegionClusterName()));
        case "NumberOfShards":
            return Optional.ofNullable(clazz.cast(numberOfShards()));
        case "Shards":
            return Optional.ofNullable(clazz.cast(shards()));
        case "AvailabilityMode":
            return Optional.ofNullable(clazz.cast(availabilityModeAsString()));
        case "ClusterEndpoint":
            return Optional.ofNullable(clazz.cast(clusterEndpoint()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "EnginePatchVersion":
            return Optional.ofNullable(clazz.cast(enginePatchVersion()));
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "ParameterGroupStatus":
            return Optional.ofNullable(clazz.cast(parameterGroupStatus()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SubnetGroupName":
            return Optional.ofNullable(clazz.cast(subnetGroupName()));
        case "TLSEnabled":
            return Optional.ofNullable(clazz.cast(tlsEnabled()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SnsTopicStatus":
            return Optional.ofNullable(clazz.cast(snsTopicStatus()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "MaintenanceWindow":
            return Optional.ofNullable(clazz.cast(maintenanceWindow()));
        case "SnapshotWindow":
            return Optional.ofNullable(clazz.cast(snapshotWindow()));
        case "ACLName":
            return Optional.ofNullable(clazz.cast(aclName()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "DataTiering":
            return Optional.ofNullable(clazz.cast(dataTieringAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cluster> {
        /**
         * <p>
         * The user-supplied name of the cluster. This identifier is a unique key that identifies a cluster.
         * </p>
         * 
         * @param name
         *        The user-supplied name of the cluster. This identifier is a unique key that identifies a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the cluster
         * </p>
         * 
         * @param description
         *        A description of the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the cluster. For example, Available, Updating, Creating.
         * </p>
         * 
         * @param status
         *        The status of the cluster. For example, Available, Updating, Creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A group of settings that are currently being applied.
         * </p>
         * 
         * @param pendingUpdates
         *        A group of settings that are currently being applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingUpdates(ClusterPendingUpdates pendingUpdates);

        /**
         * <p>
         * A group of settings that are currently being applied.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterPendingUpdates.Builder} avoiding
         * the need to create one manually via {@link ClusterPendingUpdates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterPendingUpdates.Builder#build()} is called immediately and
         * its result is passed to {@link #pendingUpdates(ClusterPendingUpdates)}.
         * 
         * @param pendingUpdates
         *        a consumer that will call methods on {@link ClusterPendingUpdates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingUpdates(ClusterPendingUpdates)
         */
        default Builder pendingUpdates(Consumer<ClusterPendingUpdates.Builder> pendingUpdates) {
            return pendingUpdates(ClusterPendingUpdates.builder().applyMutation(pendingUpdates).build());
        }

        /**
         * <p>
         * The name of the multi-Region cluster that this cluster belongs to.
         * </p>
         * 
         * @param multiRegionClusterName
         *        The name of the multi-Region cluster that this cluster belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionClusterName(String multiRegionClusterName);

        /**
         * <p>
         * The number of shards in the cluster
         * </p>
         * 
         * @param numberOfShards
         *        The number of shards in the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfShards(Integer numberOfShards);

        /**
         * <p>
         * A list of shards that are members of the cluster.
         * </p>
         * 
         * @param shards
         *        A list of shards that are members of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Collection<Shard> shards);

        /**
         * <p>
         * A list of shards that are members of the cluster.
         * </p>
         * 
         * @param shards
         *        A list of shards that are members of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Shard... shards);

        /**
         * <p>
         * A list of shards that are members of the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.Shard.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.memorydb.model.Shard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.Shard.Builder#build()} is called immediately and its
         * result is passed to {@link #shards(List<Shard>)}.
         * 
         * @param shards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.Shard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shards(java.util.Collection<Shard>)
         */
        Builder shards(Consumer<Shard.Builder>... shards);

        /**
         * <p>
         * Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).
         * </p>
         * 
         * @param availabilityMode
         *        Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).
         * @see AZStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AZStatus
         */
        Builder availabilityMode(String availabilityMode);

        /**
         * <p>
         * Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).
         * </p>
         * 
         * @param availabilityMode
         *        Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).
         * @see AZStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AZStatus
         */
        Builder availabilityMode(AZStatus availabilityMode);

        /**
         * <p>
         * The cluster's configuration endpoint
         * </p>
         * 
         * @param clusterEndpoint
         *        The cluster's configuration endpoint
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterEndpoint(Endpoint clusterEndpoint);

        /**
         * <p>
         * The cluster's configuration endpoint
         * </p>
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #clusterEndpoint(Endpoint)}.
         * 
         * @param clusterEndpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterEndpoint(Endpoint)
         */
        default Builder clusterEndpoint(Consumer<Endpoint.Builder> clusterEndpoint) {
            return clusterEndpoint(Endpoint.builder().applyMutation(clusterEndpoint).build());
        }

        /**
         * <p>
         * The cluster's node type
         * </p>
         * 
         * @param nodeType
         *        The cluster's node type
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The name of the engine used by the cluster.
         * </p>
         * 
         * @param engine
         *        The name of the engine used by the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The Redis OSS engine version used by the cluster
         * </p>
         * 
         * @param engineVersion
         *        The Redis OSS engine version used by the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The Redis OSS engine patch version used by the cluster
         * </p>
         * 
         * @param enginePatchVersion
         *        The Redis OSS engine patch version used by the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enginePatchVersion(String enginePatchVersion);

        /**
         * <p>
         * The name of the parameter group used by the cluster
         * </p>
         * 
         * @param parameterGroupName
         *        The name of the parameter group used by the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * The status of the parameter group used by the cluster, for example 'active' or 'applying'.
         * </p>
         * 
         * @param parameterGroupStatus
         *        The status of the parameter group used by the cluster, for example 'active' or 'applying'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupStatus(String parameterGroupStatus);

        /**
         * <p>
         * A list of security groups used by the cluster
         * </p>
         * 
         * @param securityGroups
         *        A list of security groups used by the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<SecurityGroupMembership> securityGroups);

        /**
         * <p>
         * A list of security groups used by the cluster
         * </p>
         * 
         * @param securityGroups
         *        A list of security groups used by the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(SecurityGroupMembership... securityGroups);

        /**
         * <p>
         * A list of security groups used by the cluster
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership.Builder#build()} is called
         * immediately and its result is passed to {@link #securityGroups(List<SecurityGroupMembership>)}.
         * 
         * @param securityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroups(java.util.Collection<SecurityGroupMembership>)
         */
        Builder securityGroups(Consumer<SecurityGroupMembership.Builder>... securityGroups);

        /**
         * <p>
         * The name of the subnet group used by the cluster
         * </p>
         * 
         * @param subnetGroupName
         *        The name of the subnet group used by the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroupName(String subnetGroupName);

        /**
         * <p>
         * A flag to indicate if In-transit encryption is enabled
         * </p>
         * 
         * @param tlsEnabled
         *        A flag to indicate if In-transit encryption is enabled
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsEnabled(Boolean tlsEnabled);

        /**
         * <p>
         * The ID of the KMS key used to encrypt the cluster
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key used to encrypt the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cluster.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SNS notification topic
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon Resource Name (ARN) of the SNS notification topic
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The SNS topic must be in Active status to receive notifications
         * </p>
         * 
         * @param snsTopicStatus
         *        The SNS topic must be in Active status to receive notifications
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicStatus(String snsTopicStatus);

        /**
         * <p>
         * The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you
         * set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The number of days for which MemoryDB retains automatic snapshots before deleting them. For example,
         *        if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before
         *        being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
         * range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
         * period.
         * </p>
         * 
         * @param maintenanceWindow
         *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified
         *        as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a
         *        60 minute period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindow(String maintenanceWindow);

        /**
         * <p>
         * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard. Example:
         * 05:00-09:00 If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.
         * </p>
         * 
         * @param snapshotWindow
         *        The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.
         *        Example: 05:00-09:00 If you do not specify this parameter, MemoryDB automatically chooses an
         *        appropriate time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotWindow(String snapshotWindow);

        /**
         * <p>
         * The name of the Access Control List associated with this cluster.
         * </p>
         * 
         * @param aclName
         *        The name of the Access Control List associated with this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aclName(String aclName);

        /**
         * <p>
         * When set to true, the cluster will automatically receive minor engine version upgrades after launch.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        When set to true, the cluster will automatically receive minor engine version upgrades after launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter
         * must be set when using r6gd nodes. For more information, see <a
         * href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
         * </p>
         * 
         * @param dataTiering
         *        Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This
         *        parameter must be set when using r6gd nodes. For more information, see <a
         *        href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
         * @see DataTieringStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTieringStatus
         */
        Builder dataTiering(String dataTiering);

        /**
         * <p>
         * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter
         * must be set when using r6gd nodes. For more information, see <a
         * href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
         * </p>
         * 
         * @param dataTiering
         *        Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This
         *        parameter must be set when using r6gd nodes. For more information, see <a
         *        href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
         * @see DataTieringStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTieringStatus
         */
        Builder dataTiering(DataTieringStatus dataTiering);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String status;

        private ClusterPendingUpdates pendingUpdates;

        private String multiRegionClusterName;

        private Integer numberOfShards;

        private List<Shard> shards = DefaultSdkAutoConstructList.getInstance();

        private String availabilityMode;

        private Endpoint clusterEndpoint;

        private String nodeType;

        private String engine;

        private String engineVersion;

        private String enginePatchVersion;

        private String parameterGroupName;

        private String parameterGroupStatus;

        private List<SecurityGroupMembership> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String subnetGroupName;

        private Boolean tlsEnabled;

        private String kmsKeyId;

        private String arn;

        private String snsTopicArn;

        private String snsTopicStatus;

        private Integer snapshotRetentionLimit;

        private String maintenanceWindow;

        private String snapshotWindow;

        private String aclName;

        private Boolean autoMinorVersionUpgrade;

        private String dataTiering;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            name(model.name);
            description(model.description);
            status(model.status);
            pendingUpdates(model.pendingUpdates);
            multiRegionClusterName(model.multiRegionClusterName);
            numberOfShards(model.numberOfShards);
            shards(model.shards);
            availabilityMode(model.availabilityMode);
            clusterEndpoint(model.clusterEndpoint);
            nodeType(model.nodeType);
            engine(model.engine);
            engineVersion(model.engineVersion);
            enginePatchVersion(model.enginePatchVersion);
            parameterGroupName(model.parameterGroupName);
            parameterGroupStatus(model.parameterGroupStatus);
            securityGroups(model.securityGroups);
            subnetGroupName(model.subnetGroupName);
            tlsEnabled(model.tlsEnabled);
            kmsKeyId(model.kmsKeyId);
            arn(model.arn);
            snsTopicArn(model.snsTopicArn);
            snsTopicStatus(model.snsTopicStatus);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            maintenanceWindow(model.maintenanceWindow);
            snapshotWindow(model.snapshotWindow);
            aclName(model.aclName);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            dataTiering(model.dataTiering);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final ClusterPendingUpdates.Builder getPendingUpdates() {
            return pendingUpdates != null ? pendingUpdates.toBuilder() : null;
        }

        public final void setPendingUpdates(ClusterPendingUpdates.BuilderImpl pendingUpdates) {
            this.pendingUpdates = pendingUpdates != null ? pendingUpdates.build() : null;
        }

        @Override
        public final Builder pendingUpdates(ClusterPendingUpdates pendingUpdates) {
            this.pendingUpdates = pendingUpdates;
            return this;
        }

        public final String getMultiRegionClusterName() {
            return multiRegionClusterName;
        }

        public final void setMultiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
        }

        @Override
        public final Builder multiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
            return this;
        }

        public final Integer getNumberOfShards() {
            return numberOfShards;
        }

        public final void setNumberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
        }

        @Override
        public final Builder numberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
            return this;
        }

        public final List<Shard.Builder> getShards() {
            List<Shard.Builder> result = ShardListCopier.copyToBuilder(this.shards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShards(Collection<Shard.BuilderImpl> shards) {
            this.shards = ShardListCopier.copyFromBuilder(shards);
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard... shards) {
            shards(Arrays.asList(shards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Consumer<Shard.Builder>... shards) {
            shards(Stream.of(shards).map(c -> Shard.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAvailabilityMode() {
            return availabilityMode;
        }

        public final void setAvailabilityMode(String availabilityMode) {
            this.availabilityMode = availabilityMode;
        }

        @Override
        public final Builder availabilityMode(String availabilityMode) {
            this.availabilityMode = availabilityMode;
            return this;
        }

        @Override
        public final Builder availabilityMode(AZStatus availabilityMode) {
            this.availabilityMode(availabilityMode == null ? null : availabilityMode.toString());
            return this;
        }

        public final Endpoint.Builder getClusterEndpoint() {
            return clusterEndpoint != null ? clusterEndpoint.toBuilder() : null;
        }

        public final void setClusterEndpoint(Endpoint.BuilderImpl clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint != null ? clusterEndpoint.build() : null;
        }

        @Override
        public final Builder clusterEndpoint(Endpoint clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEnginePatchVersion() {
            return enginePatchVersion;
        }

        public final void setEnginePatchVersion(String enginePatchVersion) {
            this.enginePatchVersion = enginePatchVersion;
        }

        @Override
        public final Builder enginePatchVersion(String enginePatchVersion) {
            this.enginePatchVersion = enginePatchVersion;
            return this;
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final String getParameterGroupStatus() {
            return parameterGroupStatus;
        }

        public final void setParameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
        }

        @Override
        public final Builder parameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
            return this;
        }

        public final List<SecurityGroupMembership.Builder> getSecurityGroups() {
            List<SecurityGroupMembership.Builder> result = SecurityGroupMembershipListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<SecurityGroupMembership.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroupMembership> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroupMembership... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroupMembership.Builder>... securityGroups) {
            securityGroups(Stream.of(securityGroups).map(c -> SecurityGroupMembership.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSubnetGroupName() {
            return subnetGroupName;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final Boolean getTlsEnabled() {
            return tlsEnabled;
        }

        public final void setTlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
        }

        @Override
        public final Builder tlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSnsTopicStatus() {
            return snsTopicStatus;
        }

        public final void setSnsTopicStatus(String snsTopicStatus) {
            this.snsTopicStatus = snsTopicStatus;
        }

        @Override
        public final Builder snsTopicStatus(String snsTopicStatus) {
            this.snsTopicStatus = snsTopicStatus;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getMaintenanceWindow() {
            return maintenanceWindow;
        }

        public final void setMaintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
        }

        @Override
        public final Builder maintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getSnapshotWindow() {
            return snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final String getAclName() {
            return aclName;
        }

        public final void setAclName(String aclName) {
            this.aclName = aclName;
        }

        @Override
        public final Builder aclName(String aclName) {
            this.aclName = aclName;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getDataTiering() {
            return dataTiering;
        }

        public final void setDataTiering(String dataTiering) {
            this.dataTiering = dataTiering;
        }

        @Override
        public final Builder dataTiering(String dataTiering) {
            this.dataTiering = dataTiering;
            return this;
        }

        @Override
        public final Builder dataTiering(DataTieringStatus dataTiering) {
            this.dataTiering(dataTiering == null ? null : dataTiering.toString());
            return this;
        }

        @Override
        public Cluster build() {
            return new Cluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
