/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteClusterRequest extends MemoryDbRequest implements
        ToCopyableBuilder<DeleteClusterRequest.Builder, DeleteClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(DeleteClusterRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> MULTI_REGION_CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MultiRegionClusterName").getter(getter(DeleteClusterRequest::multiRegionClusterName))
            .setter(setter(Builder::multiRegionClusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusterName").build())
            .build();

    private static final SdkField<String> FINAL_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FinalSnapshotName").getter(getter(DeleteClusterRequest::finalSnapshotName))
            .setter(setter(Builder::finalSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalSnapshotName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            MULTI_REGION_CLUSTER_NAME_FIELD, FINAL_SNAPSHOT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClusterName", CLUSTER_NAME_FIELD);
                    put("MultiRegionClusterName", MULTI_REGION_CLUSTER_NAME_FIELD);
                    put("FinalSnapshotName", FINAL_SNAPSHOT_NAME_FIELD);
                }
            });

    private final String clusterName;

    private final String multiRegionClusterName;

    private final String finalSnapshotName;

    private DeleteClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.multiRegionClusterName = builder.multiRegionClusterName;
        this.finalSnapshotName = builder.finalSnapshotName;
    }

    /**
     * <p>
     * The name of the cluster to be deleted
     * </p>
     * 
     * @return The name of the cluster to be deleted
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the multi-Region cluster to be deleted.
     * </p>
     * 
     * @return The name of the multi-Region cluster to be deleted.
     */
    public final String multiRegionClusterName() {
        return multiRegionClusterName;
    }

    /**
     * <p>
     * The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot.
     * MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.
     * </p>
     * 
     * @return The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot.
     *         MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.
     */
    public final String finalSnapshotName() {
        return finalSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionClusterName());
        hashCode = 31 * hashCode + Objects.hashCode(finalSnapshotName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClusterRequest)) {
            return false;
        }
        DeleteClusterRequest other = (DeleteClusterRequest) obj;
        return Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(multiRegionClusterName(), other.multiRegionClusterName())
                && Objects.equals(finalSnapshotName(), other.finalSnapshotName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteClusterRequest").add("ClusterName", clusterName())
                .add("MultiRegionClusterName", multiRegionClusterName()).add("FinalSnapshotName", finalSnapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "MultiRegionClusterName":
            return Optional.ofNullable(clazz.cast(multiRegionClusterName()));
        case "FinalSnapshotName":
            return Optional.ofNullable(clazz.cast(finalSnapshotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteClusterRequest, T> g) {
        return obj -> g.apply((DeleteClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteClusterRequest> {
        /**
         * <p>
         * The name of the cluster to be deleted
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster to be deleted
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the multi-Region cluster to be deleted.
         * </p>
         * 
         * @param multiRegionClusterName
         *        The name of the multi-Region cluster to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionClusterName(String multiRegionClusterName);

        /**
         * <p>
         * The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot.
         * MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.
         * </p>
         * 
         * @param finalSnapshotName
         *        The user-supplied name of a final cluster snapshot. This is the unique name that identifies the
         *        snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalSnapshotName(String finalSnapshotName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String multiRegionClusterName;

        private String finalSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClusterRequest model) {
            super(model);
            clusterName(model.clusterName);
            multiRegionClusterName(model.multiRegionClusterName);
            finalSnapshotName(model.finalSnapshotName);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getMultiRegionClusterName() {
            return multiRegionClusterName;
        }

        public final void setMultiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
        }

        @Override
        public final Builder multiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
            return this;
        }

        public final String getFinalSnapshotName() {
            return finalSnapshotName;
        }

        public final void setFinalSnapshotName(String finalSnapshotName) {
            this.finalSnapshotName = finalSnapshotName;
        }

        @Override
        public final Builder finalSnapshotName(String finalSnapshotName) {
            this.finalSnapshotName = finalSnapshotName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteClusterRequest build() {
            return new DeleteClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
