/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMultiRegionClustersRequest extends MemoryDbRequest implements
        ToCopyableBuilder<DescribeMultiRegionClustersRequest.Builder, DescribeMultiRegionClustersRequest> {
    private static final SdkField<String> MULTI_REGION_CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MultiRegionClusterName").getter(getter(DescribeMultiRegionClustersRequest::multiRegionClusterName))
            .setter(setter(Builder::multiRegionClusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusterName").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeMultiRegionClustersRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeMultiRegionClustersRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Boolean> SHOW_CLUSTER_DETAILS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowClusterDetails").getter(getter(DescribeMultiRegionClustersRequest::showClusterDetails))
            .setter(setter(Builder::showClusterDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowClusterDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MULTI_REGION_CLUSTER_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SHOW_CLUSTER_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MultiRegionClusterName", MULTI_REGION_CLUSTER_NAME_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("ShowClusterDetails", SHOW_CLUSTER_DETAILS_FIELD);
                }
            });

    private final String multiRegionClusterName;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean showClusterDetails;

    private DescribeMultiRegionClustersRequest(BuilderImpl builder) {
        super(builder);
        this.multiRegionClusterName = builder.multiRegionClusterName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.showClusterDetails = builder.showClusterDetails;
    }

    /**
     * <p>
     * The name of a specific multi-Region cluster to describe.
     * </p>
     * 
     * @return The name of a specific multi-Region cluster to describe.
     */
    public final String multiRegionClusterName() {
        return multiRegionClusterName;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to specify where to start paginating.
     * </p>
     * 
     * @return A token to specify where to start paginating.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Details about the multi-Region cluster.
     * </p>
     * 
     * @return Details about the multi-Region cluster.
     */
    public final Boolean showClusterDetails() {
        return showClusterDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionClusterName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(showClusterDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMultiRegionClustersRequest)) {
            return false;
        }
        DescribeMultiRegionClustersRequest other = (DescribeMultiRegionClustersRequest) obj;
        return Objects.equals(multiRegionClusterName(), other.multiRegionClusterName())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(showClusterDetails(), other.showClusterDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMultiRegionClustersRequest").add("MultiRegionClusterName", multiRegionClusterName())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("ShowClusterDetails", showClusterDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiRegionClusterName":
            return Optional.ofNullable(clazz.cast(multiRegionClusterName()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ShowClusterDetails":
            return Optional.ofNullable(clazz.cast(showClusterDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMultiRegionClustersRequest, T> g) {
        return obj -> g.apply((DescribeMultiRegionClustersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMultiRegionClustersRequest> {
        /**
         * <p>
         * The name of a specific multi-Region cluster to describe.
         * </p>
         * 
         * @param multiRegionClusterName
         *        The name of a specific multi-Region cluster to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionClusterName(String multiRegionClusterName);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to specify where to start paginating.
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start paginating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Details about the multi-Region cluster.
         * </p>
         * 
         * @param showClusterDetails
         *        Details about the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showClusterDetails(Boolean showClusterDetails);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private String multiRegionClusterName;

        private Integer maxResults;

        private String nextToken;

        private Boolean showClusterDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMultiRegionClustersRequest model) {
            super(model);
            multiRegionClusterName(model.multiRegionClusterName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            showClusterDetails(model.showClusterDetails);
        }

        public final String getMultiRegionClusterName() {
            return multiRegionClusterName;
        }

        public final void setMultiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
        }

        @Override
        public final Builder multiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getShowClusterDetails() {
            return showClusterDetails;
        }

        public final void setShowClusterDetails(Boolean showClusterDetails) {
            this.showClusterDetails = showClusterDetails;
        }

        @Override
        public final Builder showClusterDetails(Boolean showClusterDetails) {
            this.showClusterDetails = showClusterDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMultiRegionClustersRequest build() {
            return new DescribeMultiRegionClustersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
