/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMultiRegionClustersResponse extends MemoryDbResponse implements
        ToCopyableBuilder<DescribeMultiRegionClustersResponse.Builder, DescribeMultiRegionClustersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeMultiRegionClustersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<MultiRegionCluster>> MULTI_REGION_CLUSTERS_FIELD = SdkField
            .<List<MultiRegionCluster>> builder(MarshallingType.LIST)
            .memberName("MultiRegionClusters")
            .getter(getter(DescribeMultiRegionClustersResponse::multiRegionClusters))
            .setter(setter(Builder::multiRegionClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MultiRegionCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(MultiRegionCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MULTI_REGION_CLUSTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("MultiRegionClusters", MULTI_REGION_CLUSTERS_FIELD);
                }
            });

    private final String nextToken;

    private final List<MultiRegionCluster> multiRegionClusters;

    private DescribeMultiRegionClustersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.multiRegionClusters = builder.multiRegionClusters;
    }

    /**
     * <p>
     * A token to use to retrieve the next page of results.
     * </p>
     * 
     * @return A token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MultiRegionClusters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMultiRegionClusters() {
        return multiRegionClusters != null && !(multiRegionClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of multi-Region clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMultiRegionClusters} method.
     * </p>
     * 
     * @return A list of multi-Region clusters.
     */
    public final List<MultiRegionCluster> multiRegionClusters() {
        return multiRegionClusters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasMultiRegionClusters() ? multiRegionClusters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMultiRegionClustersResponse)) {
            return false;
        }
        DescribeMultiRegionClustersResponse other = (DescribeMultiRegionClustersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasMultiRegionClusters() == other.hasMultiRegionClusters()
                && Objects.equals(multiRegionClusters(), other.multiRegionClusters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMultiRegionClustersResponse").add("NextToken", nextToken())
                .add("MultiRegionClusters", hasMultiRegionClusters() ? multiRegionClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MultiRegionClusters":
            return Optional.ofNullable(clazz.cast(multiRegionClusters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMultiRegionClustersResponse, T> g) {
        return obj -> g.apply((DescribeMultiRegionClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMultiRegionClustersResponse> {
        /**
         * <p>
         * A token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of multi-Region clusters.
         * </p>
         * 
         * @param multiRegionClusters
         *        A list of multi-Region clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionClusters(Collection<MultiRegionCluster> multiRegionClusters);

        /**
         * <p>
         * A list of multi-Region clusters.
         * </p>
         * 
         * @param multiRegionClusters
         *        A list of multi-Region clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionClusters(MultiRegionCluster... multiRegionClusters);

        /**
         * <p>
         * A list of multi-Region clusters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.MultiRegionCluster.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.memorydb.model.MultiRegionCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.MultiRegionCluster.Builder#build()} is called
         * immediately and its result is passed to {@link #multiRegionClusters(List<MultiRegionCluster>)}.
         * 
         * @param multiRegionClusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.MultiRegionCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiRegionClusters(java.util.Collection<MultiRegionCluster>)
         */
        Builder multiRegionClusters(Consumer<MultiRegionCluster.Builder>... multiRegionClusters);
    }

    static final class BuilderImpl extends MemoryDbResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<MultiRegionCluster> multiRegionClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMultiRegionClustersResponse model) {
            super(model);
            nextToken(model.nextToken);
            multiRegionClusters(model.multiRegionClusters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MultiRegionCluster.Builder> getMultiRegionClusters() {
            List<MultiRegionCluster.Builder> result = MultiRegionClusterListCopier.copyToBuilder(this.multiRegionClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiRegionClusters(Collection<MultiRegionCluster.BuilderImpl> multiRegionClusters) {
            this.multiRegionClusters = MultiRegionClusterListCopier.copyFromBuilder(multiRegionClusters);
        }

        @Override
        public final Builder multiRegionClusters(Collection<MultiRegionCluster> multiRegionClusters) {
            this.multiRegionClusters = MultiRegionClusterListCopier.copy(multiRegionClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiRegionClusters(MultiRegionCluster... multiRegionClusters) {
            multiRegionClusters(Arrays.asList(multiRegionClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiRegionClusters(Consumer<MultiRegionCluster.Builder>... multiRegionClusters) {
            multiRegionClusters(Stream.of(multiRegionClusters).map(c -> MultiRegionCluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeMultiRegionClustersResponse build() {
            return new DescribeMultiRegionClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
