/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAllowedNodeTypeUpdatesResponse extends MemoryDbResponse implements
        ToCopyableBuilder<ListAllowedNodeTypeUpdatesResponse.Builder, ListAllowedNodeTypeUpdatesResponse> {
    private static final SdkField<List<String>> SCALE_UP_NODE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ScaleUpNodeTypes")
            .getter(getter(ListAllowedNodeTypeUpdatesResponse::scaleUpNodeTypes))
            .setter(setter(Builder::scaleUpNodeTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleUpNodeTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SCALE_DOWN_NODE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ScaleDownNodeTypes")
            .getter(getter(ListAllowedNodeTypeUpdatesResponse::scaleDownNodeTypes))
            .setter(setter(Builder::scaleDownNodeTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleDownNodeTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALE_UP_NODE_TYPES_FIELD,
            SCALE_DOWN_NODE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ScaleUpNodeTypes", SCALE_UP_NODE_TYPES_FIELD);
                    put("ScaleDownNodeTypes", SCALE_DOWN_NODE_TYPES_FIELD);
                }
            });

    private final List<String> scaleUpNodeTypes;

    private final List<String> scaleDownNodeTypes;

    private ListAllowedNodeTypeUpdatesResponse(BuilderImpl builder) {
        super(builder);
        this.scaleUpNodeTypes = builder.scaleUpNodeTypes;
        this.scaleDownNodeTypes = builder.scaleDownNodeTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScaleUpNodeTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScaleUpNodeTypes() {
        return scaleUpNodeTypes != null && !(scaleUpNodeTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list node types which you can use to scale up your cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScaleUpNodeTypes} method.
     * </p>
     * 
     * @return A list node types which you can use to scale up your cluster.
     */
    public final List<String> scaleUpNodeTypes() {
        return scaleUpNodeTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScaleDownNodeTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScaleDownNodeTypes() {
        return scaleDownNodeTypes != null && !(scaleDownNodeTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list node types which you can use to scale down your cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScaleDownNodeTypes} method.
     * </p>
     * 
     * @return A list node types which you can use to scale down your cluster.
     */
    public final List<String> scaleDownNodeTypes() {
        return scaleDownNodeTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScaleUpNodeTypes() ? scaleUpNodeTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScaleDownNodeTypes() ? scaleDownNodeTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAllowedNodeTypeUpdatesResponse)) {
            return false;
        }
        ListAllowedNodeTypeUpdatesResponse other = (ListAllowedNodeTypeUpdatesResponse) obj;
        return hasScaleUpNodeTypes() == other.hasScaleUpNodeTypes()
                && Objects.equals(scaleUpNodeTypes(), other.scaleUpNodeTypes())
                && hasScaleDownNodeTypes() == other.hasScaleDownNodeTypes()
                && Objects.equals(scaleDownNodeTypes(), other.scaleDownNodeTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAllowedNodeTypeUpdatesResponse")
                .add("ScaleUpNodeTypes", hasScaleUpNodeTypes() ? scaleUpNodeTypes() : null)
                .add("ScaleDownNodeTypes", hasScaleDownNodeTypes() ? scaleDownNodeTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScaleUpNodeTypes":
            return Optional.ofNullable(clazz.cast(scaleUpNodeTypes()));
        case "ScaleDownNodeTypes":
            return Optional.ofNullable(clazz.cast(scaleDownNodeTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAllowedNodeTypeUpdatesResponse, T> g) {
        return obj -> g.apply((ListAllowedNodeTypeUpdatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAllowedNodeTypeUpdatesResponse> {
        /**
         * <p>
         * A list node types which you can use to scale up your cluster.
         * </p>
         * 
         * @param scaleUpNodeTypes
         *        A list node types which you can use to scale up your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleUpNodeTypes(Collection<String> scaleUpNodeTypes);

        /**
         * <p>
         * A list node types which you can use to scale up your cluster.
         * </p>
         * 
         * @param scaleUpNodeTypes
         *        A list node types which you can use to scale up your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleUpNodeTypes(String... scaleUpNodeTypes);

        /**
         * <p>
         * A list node types which you can use to scale down your cluster.
         * </p>
         * 
         * @param scaleDownNodeTypes
         *        A list node types which you can use to scale down your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleDownNodeTypes(Collection<String> scaleDownNodeTypes);

        /**
         * <p>
         * A list node types which you can use to scale down your cluster.
         * </p>
         * 
         * @param scaleDownNodeTypes
         *        A list node types which you can use to scale down your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleDownNodeTypes(String... scaleDownNodeTypes);
    }

    static final class BuilderImpl extends MemoryDbResponse.BuilderImpl implements Builder {
        private List<String> scaleUpNodeTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> scaleDownNodeTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAllowedNodeTypeUpdatesResponse model) {
            super(model);
            scaleUpNodeTypes(model.scaleUpNodeTypes);
            scaleDownNodeTypes(model.scaleDownNodeTypes);
        }

        public final Collection<String> getScaleUpNodeTypes() {
            if (scaleUpNodeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return scaleUpNodeTypes;
        }

        public final void setScaleUpNodeTypes(Collection<String> scaleUpNodeTypes) {
            this.scaleUpNodeTypes = NodeTypeListCopier.copy(scaleUpNodeTypes);
        }

        @Override
        public final Builder scaleUpNodeTypes(Collection<String> scaleUpNodeTypes) {
            this.scaleUpNodeTypes = NodeTypeListCopier.copy(scaleUpNodeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scaleUpNodeTypes(String... scaleUpNodeTypes) {
            scaleUpNodeTypes(Arrays.asList(scaleUpNodeTypes));
            return this;
        }

        public final Collection<String> getScaleDownNodeTypes() {
            if (scaleDownNodeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return scaleDownNodeTypes;
        }

        public final void setScaleDownNodeTypes(Collection<String> scaleDownNodeTypes) {
            this.scaleDownNodeTypes = NodeTypeListCopier.copy(scaleDownNodeTypes);
        }

        @Override
        public final Builder scaleDownNodeTypes(Collection<String> scaleDownNodeTypes) {
            this.scaleDownNodeTypes = NodeTypeListCopier.copy(scaleDownNodeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scaleDownNodeTypes(String... scaleDownNodeTypes) {
            scaleDownNodeTypes(Arrays.asList(scaleDownNodeTypes));
            return this;
        }

        @Override
        public ListAllowedNodeTypeUpdatesResponse build() {
            return new ListAllowedNodeTypeUpdatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
