/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMultiRegionClusterRequest extends MemoryDbRequest implements
        ToCopyableBuilder<UpdateMultiRegionClusterRequest.Builder, UpdateMultiRegionClusterRequest> {
    private static final SdkField<String> MULTI_REGION_CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MultiRegionClusterName").getter(getter(UpdateMultiRegionClusterRequest::multiRegionClusterName))
            .setter(setter(Builder::multiRegionClusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusterName").build())
            .build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(UpdateMultiRegionClusterRequest::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateMultiRegionClusterRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(UpdateMultiRegionClusterRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<ShardConfigurationRequest> SHARD_CONFIGURATION_FIELD = SdkField
            .<ShardConfigurationRequest> builder(MarshallingType.SDK_POJO).memberName("ShardConfiguration")
            .getter(getter(UpdateMultiRegionClusterRequest::shardConfiguration)).setter(setter(Builder::shardConfiguration))
            .constructor(ShardConfigurationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardConfiguration").build())
            .build();

    private static final SdkField<String> MULTI_REGION_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MultiRegionParameterGroupName")
            .getter(getter(UpdateMultiRegionClusterRequest::multiRegionParameterGroupName))
            .setter(setter(Builder::multiRegionParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionParameterGroupName")
                    .build()).build();

    private static final SdkField<String> UPDATE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateStrategy").getter(getter(UpdateMultiRegionClusterRequest::updateStrategyAsString))
            .setter(setter(Builder::updateStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MULTI_REGION_CLUSTER_NAME_FIELD, NODE_TYPE_FIELD, DESCRIPTION_FIELD, ENGINE_VERSION_FIELD, SHARD_CONFIGURATION_FIELD,
            MULTI_REGION_PARAMETER_GROUP_NAME_FIELD, UPDATE_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MultiRegionClusterName", MULTI_REGION_CLUSTER_NAME_FIELD);
                    put("NodeType", NODE_TYPE_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("EngineVersion", ENGINE_VERSION_FIELD);
                    put("ShardConfiguration", SHARD_CONFIGURATION_FIELD);
                    put("MultiRegionParameterGroupName", MULTI_REGION_PARAMETER_GROUP_NAME_FIELD);
                    put("UpdateStrategy", UPDATE_STRATEGY_FIELD);
                }
            });

    private final String multiRegionClusterName;

    private final String nodeType;

    private final String description;

    private final String engineVersion;

    private final ShardConfigurationRequest shardConfiguration;

    private final String multiRegionParameterGroupName;

    private final String updateStrategy;

    private UpdateMultiRegionClusterRequest(BuilderImpl builder) {
        super(builder);
        this.multiRegionClusterName = builder.multiRegionClusterName;
        this.nodeType = builder.nodeType;
        this.description = builder.description;
        this.engineVersion = builder.engineVersion;
        this.shardConfiguration = builder.shardConfiguration;
        this.multiRegionParameterGroupName = builder.multiRegionParameterGroupName;
        this.updateStrategy = builder.updateStrategy;
    }

    /**
     * <p>
     * The name of the multi-Region cluster to be updated.
     * </p>
     * 
     * @return The name of the multi-Region cluster to be updated.
     */
    public final String multiRegionClusterName() {
        return multiRegionClusterName;
    }

    /**
     * <p>
     * The new node type to be used for the multi-Region cluster.
     * </p>
     * 
     * @return The new node type to be used for the multi-Region cluster.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * A new description for the multi-Region cluster.
     * </p>
     * 
     * @return A new description for the multi-Region cluster.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The new engine version to be used for the multi-Region cluster.
     * </p>
     * 
     * @return The new engine version to be used for the multi-Region cluster.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * Returns the value of the ShardConfiguration property for this object.
     * 
     * @return The value of the ShardConfiguration property for this object.
     */
    public final ShardConfigurationRequest shardConfiguration() {
        return shardConfiguration;
    }

    /**
     * <p>
     * The new multi-Region parameter group to be associated with the cluster.
     * </p>
     * 
     * @return The new multi-Region parameter group to be associated with the cluster.
     */
    public final String multiRegionParameterGroupName() {
        return multiRegionParameterGroupName;
    }

    /**
     * <p>
     * Whether to force the update even if it may cause data loss.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStrategy}
     * will return {@link UpdateStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateStrategyAsString}.
     * </p>
     * 
     * @return Whether to force the update even if it may cause data loss.
     * @see UpdateStrategy
     */
    public final UpdateStrategy updateStrategy() {
        return UpdateStrategy.fromValue(updateStrategy);
    }

    /**
     * <p>
     * Whether to force the update even if it may cause data loss.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStrategy}
     * will return {@link UpdateStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateStrategyAsString}.
     * </p>
     * 
     * @return Whether to force the update even if it may cause data loss.
     * @see UpdateStrategy
     */
    public final String updateStrategyAsString() {
        return updateStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionClusterName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(shardConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(updateStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMultiRegionClusterRequest)) {
            return false;
        }
        UpdateMultiRegionClusterRequest other = (UpdateMultiRegionClusterRequest) obj;
        return Objects.equals(multiRegionClusterName(), other.multiRegionClusterName())
                && Objects.equals(nodeType(), other.nodeType()) && Objects.equals(description(), other.description())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(shardConfiguration(), other.shardConfiguration())
                && Objects.equals(multiRegionParameterGroupName(), other.multiRegionParameterGroupName())
                && Objects.equals(updateStrategyAsString(), other.updateStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMultiRegionClusterRequest").add("MultiRegionClusterName", multiRegionClusterName())
                .add("NodeType", nodeType()).add("Description", description()).add("EngineVersion", engineVersion())
                .add("ShardConfiguration", shardConfiguration())
                .add("MultiRegionParameterGroupName", multiRegionParameterGroupName())
                .add("UpdateStrategy", updateStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiRegionClusterName":
            return Optional.ofNullable(clazz.cast(multiRegionClusterName()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "ShardConfiguration":
            return Optional.ofNullable(clazz.cast(shardConfiguration()));
        case "MultiRegionParameterGroupName":
            return Optional.ofNullable(clazz.cast(multiRegionParameterGroupName()));
        case "UpdateStrategy":
            return Optional.ofNullable(clazz.cast(updateStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMultiRegionClusterRequest, T> g) {
        return obj -> g.apply((UpdateMultiRegionClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMultiRegionClusterRequest> {
        /**
         * <p>
         * The name of the multi-Region cluster to be updated.
         * </p>
         * 
         * @param multiRegionClusterName
         *        The name of the multi-Region cluster to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionClusterName(String multiRegionClusterName);

        /**
         * <p>
         * The new node type to be used for the multi-Region cluster.
         * </p>
         * 
         * @param nodeType
         *        The new node type to be used for the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * A new description for the multi-Region cluster.
         * </p>
         * 
         * @param description
         *        A new description for the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The new engine version to be used for the multi-Region cluster.
         * </p>
         * 
         * @param engineVersion
         *        The new engine version to be used for the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * Sets the value of the ShardConfiguration property for this object.
         *
         * @param shardConfiguration
         *        The new value for the ShardConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardConfiguration(ShardConfigurationRequest shardConfiguration);

        /**
         * Sets the value of the ShardConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ShardConfigurationRequest.Builder}
         * avoiding the need to create one manually via {@link ShardConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShardConfigurationRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #shardConfiguration(ShardConfigurationRequest)}.
         * 
         * @param shardConfiguration
         *        a consumer that will call methods on {@link ShardConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shardConfiguration(ShardConfigurationRequest)
         */
        default Builder shardConfiguration(Consumer<ShardConfigurationRequest.Builder> shardConfiguration) {
            return shardConfiguration(ShardConfigurationRequest.builder().applyMutation(shardConfiguration).build());
        }

        /**
         * <p>
         * The new multi-Region parameter group to be associated with the cluster.
         * </p>
         * 
         * @param multiRegionParameterGroupName
         *        The new multi-Region parameter group to be associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionParameterGroupName(String multiRegionParameterGroupName);

        /**
         * <p>
         * Whether to force the update even if it may cause data loss.
         * </p>
         * 
         * @param updateStrategy
         *        Whether to force the update even if it may cause data loss.
         * @see UpdateStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateStrategy
         */
        Builder updateStrategy(String updateStrategy);

        /**
         * <p>
         * Whether to force the update even if it may cause data loss.
         * </p>
         * 
         * @param updateStrategy
         *        Whether to force the update even if it may cause data loss.
         * @see UpdateStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateStrategy
         */
        Builder updateStrategy(UpdateStrategy updateStrategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private String multiRegionClusterName;

        private String nodeType;

        private String description;

        private String engineVersion;

        private ShardConfigurationRequest shardConfiguration;

        private String multiRegionParameterGroupName;

        private String updateStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMultiRegionClusterRequest model) {
            super(model);
            multiRegionClusterName(model.multiRegionClusterName);
            nodeType(model.nodeType);
            description(model.description);
            engineVersion(model.engineVersion);
            shardConfiguration(model.shardConfiguration);
            multiRegionParameterGroupName(model.multiRegionParameterGroupName);
            updateStrategy(model.updateStrategy);
        }

        public final String getMultiRegionClusterName() {
            return multiRegionClusterName;
        }

        public final void setMultiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
        }

        @Override
        public final Builder multiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final ShardConfigurationRequest.Builder getShardConfiguration() {
            return shardConfiguration != null ? shardConfiguration.toBuilder() : null;
        }

        public final void setShardConfiguration(ShardConfigurationRequest.BuilderImpl shardConfiguration) {
            this.shardConfiguration = shardConfiguration != null ? shardConfiguration.build() : null;
        }

        @Override
        public final Builder shardConfiguration(ShardConfigurationRequest shardConfiguration) {
            this.shardConfiguration = shardConfiguration;
            return this;
        }

        public final String getMultiRegionParameterGroupName() {
            return multiRegionParameterGroupName;
        }

        public final void setMultiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
        }

        @Override
        public final Builder multiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
            return this;
        }

        public final String getUpdateStrategy() {
            return updateStrategy;
        }

        public final void setUpdateStrategy(String updateStrategy) {
            this.updateStrategy = updateStrategy;
        }

        @Override
        public final Builder updateStrategy(String updateStrategy) {
            this.updateStrategy = updateStrategy;
            return this;
        }

        @Override
        public final Builder updateStrategy(UpdateStrategy updateStrategy) {
            this.updateStrategy(updateStrategy == null ? null : updateStrategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMultiRegionClusterRequest build() {
            return new UpdateMultiRegionClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
