/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.ShardDetail;
import software.amazon.awssdk.services.memorydb.model.ShardDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ClusterConfiguration.getter(ClusterConfiguration::name)).setter(ClusterConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ClusterConfiguration.getter(ClusterConfiguration::description)).setter(ClusterConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(ClusterConfiguration.getter(ClusterConfiguration::nodeType)).setter(ClusterConfiguration.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(ClusterConfiguration.getter(ClusterConfiguration::engine)).setter(ClusterConfiguration.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(ClusterConfiguration.getter(ClusterConfiguration::engineVersion)).setter(ClusterConfiguration.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceWindow").getter(ClusterConfiguration.getter(ClusterConfiguration::maintenanceWindow)).setter(ClusterConfiguration.setter(Builder::maintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceWindow").build()}).build();
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(ClusterConfiguration.getter(ClusterConfiguration::topicArn)).setter(ClusterConfiguration.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(ClusterConfiguration.getter(ClusterConfiguration::port)).setter(ClusterConfiguration.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterGroupName").getter(ClusterConfiguration.getter(ClusterConfiguration::parameterGroupName)).setter(ClusterConfiguration.setter(Builder::parameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build()}).build();
    private static final SdkField<String> SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetGroupName").getter(ClusterConfiguration.getter(ClusterConfiguration::subnetGroupName)).setter(ClusterConfiguration.setter(Builder::subnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupName").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(ClusterConfiguration.getter(ClusterConfiguration::vpcId)).setter(ClusterConfiguration.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SnapshotRetentionLimit").getter(ClusterConfiguration.getter(ClusterConfiguration::snapshotRetentionLimit)).setter(ClusterConfiguration.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotWindow").getter(ClusterConfiguration.getter(ClusterConfiguration::snapshotWindow)).setter(ClusterConfiguration.setter(Builder::snapshotWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()}).build();
    private static final SdkField<Integer> NUM_SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumShards").getter(ClusterConfiguration.getter(ClusterConfiguration::numShards)).setter(ClusterConfiguration.setter(Builder::numShards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumShards").build()}).build();
    private static final SdkField<List<ShardDetail>> SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Shards").getter(ClusterConfiguration.getter(ClusterConfiguration::shards)).setter(ClusterConfiguration.setter(Builder::shards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ShardDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MULTI_REGION_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiRegionParameterGroupName").getter(ClusterConfiguration.getter(ClusterConfiguration::multiRegionParameterGroupName)).setter(ClusterConfiguration.setter(Builder::multiRegionParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionParameterGroupName").build()}).build();
    private static final SdkField<String> MULTI_REGION_CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiRegionClusterName").getter(ClusterConfiguration.getter(ClusterConfiguration::multiRegionClusterName)).setter(ClusterConfiguration.setter(Builder::multiRegionClusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusterName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, MAINTENANCE_WINDOW_FIELD, TOPIC_ARN_FIELD, PORT_FIELD, PARAMETER_GROUP_NAME_FIELD, SUBNET_GROUP_NAME_FIELD, VPC_ID_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, NUM_SHARDS_FIELD, SHARDS_FIELD, MULTI_REGION_PARAMETER_GROUP_NAME_FIELD, MULTI_REGION_CLUSTER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("NodeType", NODE_TYPE_FIELD);
            this.put("Engine", ENGINE_FIELD);
            this.put("EngineVersion", ENGINE_VERSION_FIELD);
            this.put("MaintenanceWindow", MAINTENANCE_WINDOW_FIELD);
            this.put("TopicArn", TOPIC_ARN_FIELD);
            this.put("Port", PORT_FIELD);
            this.put("ParameterGroupName", PARAMETER_GROUP_NAME_FIELD);
            this.put("SubnetGroupName", SUBNET_GROUP_NAME_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("SnapshotRetentionLimit", SNAPSHOT_RETENTION_LIMIT_FIELD);
            this.put("SnapshotWindow", SNAPSHOT_WINDOW_FIELD);
            this.put("NumShards", NUM_SHARDS_FIELD);
            this.put("Shards", SHARDS_FIELD);
            this.put("MultiRegionParameterGroupName", MULTI_REGION_PARAMETER_GROUP_NAME_FIELD);
            this.put("MultiRegionClusterName", MULTI_REGION_CLUSTER_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String nodeType;
    private final String engine;
    private final String engineVersion;
    private final String maintenanceWindow;
    private final String topicArn;
    private final Integer port;
    private final String parameterGroupName;
    private final String subnetGroupName;
    private final String vpcId;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final Integer numShards;
    private final List<ShardDetail> shards;
    private final String multiRegionParameterGroupName;
    private final String multiRegionClusterName;

    private ClusterConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.nodeType = builder.nodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.topicArn = builder.topicArn;
        this.port = builder.port;
        this.parameterGroupName = builder.parameterGroupName;
        this.subnetGroupName = builder.subnetGroupName;
        this.vpcId = builder.vpcId;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.numShards = builder.numShards;
        this.shards = builder.shards;
        this.multiRegionParameterGroupName = builder.multiRegionParameterGroupName;
        this.multiRegionClusterName = builder.multiRegionClusterName;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final Integer port() {
        return this.port;
    }

    public final String parameterGroupName() {
        return this.parameterGroupName;
    }

    public final String subnetGroupName() {
        return this.subnetGroupName;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public final String snapshotWindow() {
        return this.snapshotWindow;
    }

    public final Integer numShards() {
        return this.numShards;
    }

    public final boolean hasShards() {
        return this.shards != null && !(this.shards instanceof SdkAutoConstructList);
    }

    public final List<ShardDetail> shards() {
        return this.shards;
    }

    public final String multiRegionParameterGroupName() {
        return this.multiRegionParameterGroupName;
    }

    public final String multiRegionClusterName() {
        return this.multiRegionClusterName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.numShards());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShards() ? this.shards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionClusterName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterConfiguration)) {
            return false;
        }
        ClusterConfiguration other = (ClusterConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.parameterGroupName(), other.parameterGroupName()) && Objects.equals(this.subnetGroupName(), other.subnetGroupName()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.numShards(), other.numShards()) && this.hasShards() == other.hasShards() && Objects.equals(this.shards(), other.shards()) && Objects.equals(this.multiRegionParameterGroupName(), other.multiRegionParameterGroupName()) && Objects.equals(this.multiRegionClusterName(), other.multiRegionClusterName());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterConfiguration").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("NodeType", (Object)this.nodeType()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("MaintenanceWindow", (Object)this.maintenanceWindow()).add("TopicArn", (Object)this.topicArn()).add("Port", (Object)this.port()).add("ParameterGroupName", (Object)this.parameterGroupName()).add("SubnetGroupName", (Object)this.subnetGroupName()).add("VpcId", (Object)this.vpcId()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("NumShards", (Object)this.numShards()).add("Shards", this.hasShards() ? this.shards() : null).add("MultiRegionParameterGroupName", (Object)this.multiRegionParameterGroupName()).add("MultiRegionClusterName", (Object)this.multiRegionClusterName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "MaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindow()));
            }
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "ParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupName()));
            }
            case "SubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.subnetGroupName()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.ofNullable(clazz.cast(this.snapshotWindow()));
            }
            case "NumShards": {
                return Optional.ofNullable(clazz.cast(this.numShards()));
            }
            case "Shards": {
                return Optional.ofNullable(clazz.cast(this.shards()));
            }
            case "MultiRegionParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.multiRegionParameterGroupName()));
            }
            case "MultiRegionClusterName": {
                return Optional.ofNullable(clazz.cast(this.multiRegionClusterName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClusterConfiguration, T> g) {
        return obj -> g.apply((ClusterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String nodeType;
        private String engine;
        private String engineVersion;
        private String maintenanceWindow;
        private String topicArn;
        private Integer port;
        private String parameterGroupName;
        private String subnetGroupName;
        private String vpcId;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private Integer numShards;
        private List<ShardDetail> shards = DefaultSdkAutoConstructList.getInstance();
        private String multiRegionParameterGroupName;
        private String multiRegionClusterName;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterConfiguration model) {
            this.name(model.name);
            this.description(model.description);
            this.nodeType(model.nodeType);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.maintenanceWindow(model.maintenanceWindow);
            this.topicArn(model.topicArn);
            this.port(model.port);
            this.parameterGroupName(model.parameterGroupName);
            this.subnetGroupName(model.subnetGroupName);
            this.vpcId(model.vpcId);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.numShards(model.numShards);
            this.shards(model.shards);
            this.multiRegionParameterGroupName(model.multiRegionParameterGroupName);
            this.multiRegionClusterName(model.multiRegionClusterName);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getMaintenanceWindow() {
            return this.maintenanceWindow;
        }

        public final void setMaintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
        }

        @Override
        public final Builder maintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final String getSubnetGroupName() {
            return this.subnetGroupName;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final Integer getNumShards() {
            return this.numShards;
        }

        public final void setNumShards(Integer numShards) {
            this.numShards = numShards;
        }

        @Override
        public final Builder numShards(Integer numShards) {
            this.numShards = numShards;
            return this;
        }

        public final List<ShardDetail.Builder> getShards() {
            List<ShardDetail.Builder> result = ShardDetailsCopier.copyToBuilder(this.shards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShards(Collection<ShardDetail.BuilderImpl> shards) {
            this.shards = ShardDetailsCopier.copyFromBuilder(shards);
        }

        @Override
        public final Builder shards(Collection<ShardDetail> shards) {
            this.shards = ShardDetailsCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(ShardDetail ... shards) {
            this.shards(Arrays.asList(shards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Consumer<ShardDetail.Builder> ... shards) {
            this.shards(Stream.of(shards).map(c -> (ShardDetail)((ShardDetail.Builder)ShardDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMultiRegionParameterGroupName() {
            return this.multiRegionParameterGroupName;
        }

        public final void setMultiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
        }

        @Override
        public final Builder multiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
            return this;
        }

        public final String getMultiRegionClusterName() {
            return this.multiRegionClusterName;
        }

        public final void setMultiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
        }

        @Override
        public final Builder multiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
            return this;
        }

        public ClusterConfiguration build() {
            return new ClusterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterConfiguration> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder nodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder maintenanceWindow(String var1);

        public Builder topicArn(String var1);

        public Builder port(Integer var1);

        public Builder parameterGroupName(String var1);

        public Builder subnetGroupName(String var1);

        public Builder vpcId(String var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder numShards(Integer var1);

        public Builder shards(Collection<ShardDetail> var1);

        public Builder shards(ShardDetail ... var1);

        public Builder shards(Consumer<ShardDetail.Builder> ... var1);

        public Builder multiRegionParameterGroupName(String var1);

        public Builder multiRegionClusterName(String var1);
    }
}

