/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAcLsResponse extends MemoryDbResponse implements
        ToCopyableBuilder<DescribeAcLsResponse.Builder, DescribeAcLsResponse> {
    private static final SdkField<List<ACL>> AC_LS_FIELD = SdkField
            .<List<ACL>> builder(MarshallingType.LIST)
            .memberName("ACLs")
            .getter(getter(DescribeAcLsResponse::acLs))
            .setter(setter(Builder::acLs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ACL> builder(MarshallingType.SDK_POJO)
                                            .constructor(ACL::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAcLsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AC_LS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ACL> acLs;

    private final String nextToken;

    private DescribeAcLsResponse(BuilderImpl builder) {
        super(builder);
        this.acLs = builder.acLs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ACLs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAcLs() {
        return acLs != null && !(acLs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of ACLs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcLs} method.
     * </p>
     * 
     * @return The list of ACLs.
     */
    public final List<ACL> acLs() {
        return acLs;
    }

    /**
     * <p>
     * If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token
     * for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments
     * unchanged.
     * </p>
     * 
     * @return If nextToken is returned, there are more results available. The value of nextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page. Keep all
     *         other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAcLs() ? acLs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcLsResponse)) {
            return false;
        }
        DescribeAcLsResponse other = (DescribeAcLsResponse) obj;
        return hasAcLs() == other.hasAcLs() && Objects.equals(acLs(), other.acLs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAcLsResponse").add("ACLs", hasAcLs() ? acLs() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ACLs":
            return Optional.ofNullable(clazz.cast(acLs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ACLs", AC_LS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAcLsResponse, T> g) {
        return obj -> g.apply((DescribeAcLsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAcLsResponse> {
        /**
         * <p>
         * The list of ACLs.
         * </p>
         * 
         * @param acLs
         *        The list of ACLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acLs(Collection<ACL> acLs);

        /**
         * <p>
         * The list of ACLs.
         * </p>
         * 
         * @param acLs
         *        The list of ACLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acLs(ACL... acLs);

        /**
         * <p>
         * The list of ACLs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.ACL.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.memorydb.model.ACL#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.ACL.Builder#build()} is called immediately and its
         * result is passed to {@link #acLs(List<ACL>)}.
         * 
         * @param acLs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.ACL.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acLs(java.util.Collection<ACL>)
         */
        Builder acLs(Consumer<ACL.Builder>... acLs);

        /**
         * <p>
         * If nextToken is returned, there are more results available. The value of nextToken is a unique pagination
         * token for each page. Make the call again using the returned token to retrieve the next page. Keep all other
         * arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        If nextToken is returned, there are more results available. The value of nextToken is a unique
         *        pagination token for each page. Make the call again using the returned token to retrieve the next
         *        page. Keep all other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MemoryDbResponse.BuilderImpl implements Builder {
        private List<ACL> acLs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAcLsResponse model) {
            super(model);
            acLs(model.acLs);
            nextToken(model.nextToken);
        }

        public final List<ACL.Builder> getAcLs() {
            List<ACL.Builder> result = ACLListCopier.copyToBuilder(this.acLs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAcLs(Collection<ACL.BuilderImpl> acLs) {
            this.acLs = ACLListCopier.copyFromBuilder(acLs);
        }

        @Override
        public final Builder acLs(Collection<ACL> acLs) {
            this.acLs = ACLListCopier.copy(acLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acLs(ACL... acLs) {
            acLs(Arrays.asList(acLs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acLs(Consumer<ACL.Builder>... acLs) {
            acLs(Stream.of(acLs).map(c -> ACL.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAcLsResponse build() {
            return new DescribeAcLsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
