/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMultiRegionClusterRequest extends MemoryDbRequest implements
        ToCopyableBuilder<CreateMultiRegionClusterRequest.Builder, CreateMultiRegionClusterRequest> {
    private static final SdkField<String> MULTI_REGION_CLUSTER_NAME_SUFFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MultiRegionClusterNameSuffix")
            .getter(getter(CreateMultiRegionClusterRequest::multiRegionClusterNameSuffix))
            .setter(setter(Builder::multiRegionClusterNameSuffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusterNameSuffix")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateMultiRegionClusterRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateMultiRegionClusterRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreateMultiRegionClusterRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(CreateMultiRegionClusterRequest::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<String> MULTI_REGION_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MultiRegionParameterGroupName")
            .getter(getter(CreateMultiRegionClusterRequest::multiRegionParameterGroupName))
            .setter(setter(Builder::multiRegionParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionParameterGroupName")
                    .build()).build();

    private static final SdkField<Integer> NUM_SHARDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumShards").getter(getter(CreateMultiRegionClusterRequest::numShards))
            .setter(setter(Builder::numShards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumShards").build()).build();

    private static final SdkField<Boolean> TLS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TLSEnabled").getter(getter(CreateMultiRegionClusterRequest::tlsEnabled))
            .setter(setter(Builder::tlsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSEnabled").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMultiRegionClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MULTI_REGION_CLUSTER_NAME_SUFFIX_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, NODE_TYPE_FIELD,
            MULTI_REGION_PARAMETER_GROUP_NAME_FIELD, NUM_SHARDS_FIELD, TLS_ENABLED_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String multiRegionClusterNameSuffix;

    private final String description;

    private final String engine;

    private final String engineVersion;

    private final String nodeType;

    private final String multiRegionParameterGroupName;

    private final Integer numShards;

    private final Boolean tlsEnabled;

    private final List<Tag> tags;

    private CreateMultiRegionClusterRequest(BuilderImpl builder) {
        super(builder);
        this.multiRegionClusterNameSuffix = builder.multiRegionClusterNameSuffix;
        this.description = builder.description;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.nodeType = builder.nodeType;
        this.multiRegionParameterGroupName = builder.multiRegionParameterGroupName;
        this.numShards = builder.numShards;
        this.tlsEnabled = builder.tlsEnabled;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A suffix to be added to the multi-Region cluster name.
     * </p>
     * 
     * @return A suffix to be added to the multi-Region cluster name.
     */
    public final String multiRegionClusterNameSuffix() {
        return multiRegionClusterNameSuffix;
    }

    /**
     * <p>
     * A description for the multi-Region cluster.
     * </p>
     * 
     * @return A description for the multi-Region cluster.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the engine to be used for the multi-Region cluster.
     * </p>
     * 
     * @return The name of the engine to be used for the multi-Region cluster.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version of the engine to be used for the multi-Region cluster.
     * </p>
     * 
     * @return The version of the engine to be used for the multi-Region cluster.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The node type to be used for the multi-Region cluster.
     * </p>
     * 
     * @return The node type to be used for the multi-Region cluster.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The name of the multi-Region parameter group to be associated with the cluster.
     * </p>
     * 
     * @return The name of the multi-Region parameter group to be associated with the cluster.
     */
    public final String multiRegionParameterGroupName() {
        return multiRegionParameterGroupName;
    }

    /**
     * <p>
     * The number of shards for the multi-Region cluster.
     * </p>
     * 
     * @return The number of shards for the multi-Region cluster.
     */
    public final Integer numShards() {
        return numShards;
    }

    /**
     * <p>
     * Whether to enable TLS encryption for the multi-Region cluster.
     * </p>
     * 
     * @return Whether to enable TLS encryption for the multi-Region cluster.
     */
    public final Boolean tlsEnabled() {
        return tlsEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to be applied to the multi-Region cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to be applied to the multi-Region cluster.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionClusterNameSuffix());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(numShards());
        hashCode = 31 * hashCode + Objects.hashCode(tlsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiRegionClusterRequest)) {
            return false;
        }
        CreateMultiRegionClusterRequest other = (CreateMultiRegionClusterRequest) obj;
        return Objects.equals(multiRegionClusterNameSuffix(), other.multiRegionClusterNameSuffix())
                && Objects.equals(description(), other.description()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(multiRegionParameterGroupName(), other.multiRegionParameterGroupName())
                && Objects.equals(numShards(), other.numShards()) && Objects.equals(tlsEnabled(), other.tlsEnabled())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMultiRegionClusterRequest")
                .add("MultiRegionClusterNameSuffix", multiRegionClusterNameSuffix()).add("Description", description())
                .add("Engine", engine()).add("EngineVersion", engineVersion()).add("NodeType", nodeType())
                .add("MultiRegionParameterGroupName", multiRegionParameterGroupName()).add("NumShards", numShards())
                .add("TLSEnabled", tlsEnabled()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiRegionClusterNameSuffix":
            return Optional.ofNullable(clazz.cast(multiRegionClusterNameSuffix()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "MultiRegionParameterGroupName":
            return Optional.ofNullable(clazz.cast(multiRegionParameterGroupName()));
        case "NumShards":
            return Optional.ofNullable(clazz.cast(numShards()));
        case "TLSEnabled":
            return Optional.ofNullable(clazz.cast(tlsEnabled()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MultiRegionClusterNameSuffix", MULTI_REGION_CLUSTER_NAME_SUFFIX_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("MultiRegionParameterGroupName", MULTI_REGION_PARAMETER_GROUP_NAME_FIELD);
        map.put("NumShards", NUM_SHARDS_FIELD);
        map.put("TLSEnabled", TLS_ENABLED_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMultiRegionClusterRequest, T> g) {
        return obj -> g.apply((CreateMultiRegionClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMultiRegionClusterRequest> {
        /**
         * <p>
         * A suffix to be added to the multi-Region cluster name.
         * </p>
         * 
         * @param multiRegionClusterNameSuffix
         *        A suffix to be added to the multi-Region cluster name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionClusterNameSuffix(String multiRegionClusterNameSuffix);

        /**
         * <p>
         * A description for the multi-Region cluster.
         * </p>
         * 
         * @param description
         *        A description for the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the engine to be used for the multi-Region cluster.
         * </p>
         * 
         * @param engine
         *        The name of the engine to be used for the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version of the engine to be used for the multi-Region cluster.
         * </p>
         * 
         * @param engineVersion
         *        The version of the engine to be used for the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The node type to be used for the multi-Region cluster.
         * </p>
         * 
         * @param nodeType
         *        The node type to be used for the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The name of the multi-Region parameter group to be associated with the cluster.
         * </p>
         * 
         * @param multiRegionParameterGroupName
         *        The name of the multi-Region parameter group to be associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionParameterGroupName(String multiRegionParameterGroupName);

        /**
         * <p>
         * The number of shards for the multi-Region cluster.
         * </p>
         * 
         * @param numShards
         *        The number of shards for the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numShards(Integer numShards);

        /**
         * <p>
         * Whether to enable TLS encryption for the multi-Region cluster.
         * </p>
         * 
         * @param tlsEnabled
         *        Whether to enable TLS encryption for the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsEnabled(Boolean tlsEnabled);

        /**
         * <p>
         * A list of tags to be applied to the multi-Region cluster.
         * </p>
         * 
         * @param tags
         *        A list of tags to be applied to the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to be applied to the multi-Region cluster.
         * </p>
         * 
         * @param tags
         *        A list of tags to be applied to the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to be applied to the multi-Region cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.memorydb.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private String multiRegionClusterNameSuffix;

        private String description;

        private String engine;

        private String engineVersion;

        private String nodeType;

        private String multiRegionParameterGroupName;

        private Integer numShards;

        private Boolean tlsEnabled;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultiRegionClusterRequest model) {
            super(model);
            multiRegionClusterNameSuffix(model.multiRegionClusterNameSuffix);
            description(model.description);
            engine(model.engine);
            engineVersion(model.engineVersion);
            nodeType(model.nodeType);
            multiRegionParameterGroupName(model.multiRegionParameterGroupName);
            numShards(model.numShards);
            tlsEnabled(model.tlsEnabled);
            tags(model.tags);
        }

        public final String getMultiRegionClusterNameSuffix() {
            return multiRegionClusterNameSuffix;
        }

        public final void setMultiRegionClusterNameSuffix(String multiRegionClusterNameSuffix) {
            this.multiRegionClusterNameSuffix = multiRegionClusterNameSuffix;
        }

        @Override
        public final Builder multiRegionClusterNameSuffix(String multiRegionClusterNameSuffix) {
            this.multiRegionClusterNameSuffix = multiRegionClusterNameSuffix;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getMultiRegionParameterGroupName() {
            return multiRegionParameterGroupName;
        }

        public final void setMultiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
        }

        @Override
        public final Builder multiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
            return this;
        }

        public final Integer getNumShards() {
            return numShards;
        }

        public final void setNumShards(Integer numShards) {
            this.numShards = numShards;
        }

        @Override
        public final Builder numShards(Integer numShards) {
            this.numShards = numShards;
            return this;
        }

        public final Boolean getTlsEnabled() {
            return tlsEnabled;
        }

        public final void setTlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
        }

        @Override
        public final Builder tlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMultiRegionClusterRequest build() {
            return new CreateMultiRegionClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
