/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAclRequest extends MemoryDbRequest implements
        ToCopyableBuilder<UpdateAclRequest.Builder, UpdateAclRequest> {
    private static final SdkField<String> ACL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ACLName").getter(getter(UpdateAclRequest::aclName)).setter(setter(Builder::aclName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLName").build()).build();

    private static final SdkField<List<String>> USER_NAMES_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserNamesToAdd")
            .getter(getter(UpdateAclRequest::userNamesToAdd))
            .setter(setter(Builder::userNamesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNamesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USER_NAMES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserNamesToRemove")
            .getter(getter(UpdateAclRequest::userNamesToRemove))
            .setter(setter(Builder::userNamesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNamesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACL_NAME_FIELD,
            USER_NAMES_TO_ADD_FIELD, USER_NAMES_TO_REMOVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String aclName;

    private final List<String> userNamesToAdd;

    private final List<String> userNamesToRemove;

    private UpdateAclRequest(BuilderImpl builder) {
        super(builder);
        this.aclName = builder.aclName;
        this.userNamesToAdd = builder.userNamesToAdd;
        this.userNamesToRemove = builder.userNamesToRemove;
    }

    /**
     * <p>
     * The name of the Access Control List.
     * </p>
     * 
     * @return The name of the Access Control List.
     */
    public final String aclName() {
        return aclName;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserNamesToAdd property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserNamesToAdd() {
        return userNamesToAdd != null && !(userNamesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of users to add to the Access Control List.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserNamesToAdd} method.
     * </p>
     * 
     * @return The list of users to add to the Access Control List.
     */
    public final List<String> userNamesToAdd() {
        return userNamesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserNamesToRemove property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserNamesToRemove() {
        return userNamesToRemove != null && !(userNamesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of users to remove from the Access Control List.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserNamesToRemove} method.
     * </p>
     * 
     * @return The list of users to remove from the Access Control List.
     */
    public final List<String> userNamesToRemove() {
        return userNamesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aclName());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserNamesToAdd() ? userNamesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserNamesToRemove() ? userNamesToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAclRequest)) {
            return false;
        }
        UpdateAclRequest other = (UpdateAclRequest) obj;
        return Objects.equals(aclName(), other.aclName()) && hasUserNamesToAdd() == other.hasUserNamesToAdd()
                && Objects.equals(userNamesToAdd(), other.userNamesToAdd())
                && hasUserNamesToRemove() == other.hasUserNamesToRemove()
                && Objects.equals(userNamesToRemove(), other.userNamesToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAclRequest").add("ACLName", aclName())
                .add("UserNamesToAdd", hasUserNamesToAdd() ? userNamesToAdd() : null)
                .add("UserNamesToRemove", hasUserNamesToRemove() ? userNamesToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ACLName":
            return Optional.ofNullable(clazz.cast(aclName()));
        case "UserNamesToAdd":
            return Optional.ofNullable(clazz.cast(userNamesToAdd()));
        case "UserNamesToRemove":
            return Optional.ofNullable(clazz.cast(userNamesToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ACLName", ACL_NAME_FIELD);
        map.put("UserNamesToAdd", USER_NAMES_TO_ADD_FIELD);
        map.put("UserNamesToRemove", USER_NAMES_TO_REMOVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAclRequest, T> g) {
        return obj -> g.apply((UpdateAclRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAclRequest> {
        /**
         * <p>
         * The name of the Access Control List.
         * </p>
         * 
         * @param aclName
         *        The name of the Access Control List.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aclName(String aclName);

        /**
         * <p>
         * The list of users to add to the Access Control List.
         * </p>
         * 
         * @param userNamesToAdd
         *        The list of users to add to the Access Control List.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNamesToAdd(Collection<String> userNamesToAdd);

        /**
         * <p>
         * The list of users to add to the Access Control List.
         * </p>
         * 
         * @param userNamesToAdd
         *        The list of users to add to the Access Control List.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNamesToAdd(String... userNamesToAdd);

        /**
         * <p>
         * The list of users to remove from the Access Control List.
         * </p>
         * 
         * @param userNamesToRemove
         *        The list of users to remove from the Access Control List.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNamesToRemove(Collection<String> userNamesToRemove);

        /**
         * <p>
         * The list of users to remove from the Access Control List.
         * </p>
         * 
         * @param userNamesToRemove
         *        The list of users to remove from the Access Control List.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNamesToRemove(String... userNamesToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private String aclName;

        private List<String> userNamesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> userNamesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAclRequest model) {
            super(model);
            aclName(model.aclName);
            userNamesToAdd(model.userNamesToAdd);
            userNamesToRemove(model.userNamesToRemove);
        }

        public final String getAclName() {
            return aclName;
        }

        public final void setAclName(String aclName) {
            this.aclName = aclName;
        }

        @Override
        public final Builder aclName(String aclName) {
            this.aclName = aclName;
            return this;
        }

        public final Collection<String> getUserNamesToAdd() {
            if (userNamesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return userNamesToAdd;
        }

        public final void setUserNamesToAdd(Collection<String> userNamesToAdd) {
            this.userNamesToAdd = UserNameListInputCopier.copy(userNamesToAdd);
        }

        @Override
        public final Builder userNamesToAdd(Collection<String> userNamesToAdd) {
            this.userNamesToAdd = UserNameListInputCopier.copy(userNamesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userNamesToAdd(String... userNamesToAdd) {
            userNamesToAdd(Arrays.asList(userNamesToAdd));
            return this;
        }

        public final Collection<String> getUserNamesToRemove() {
            if (userNamesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return userNamesToRemove;
        }

        public final void setUserNamesToRemove(Collection<String> userNamesToRemove) {
            this.userNamesToRemove = UserNameListInputCopier.copy(userNamesToRemove);
        }

        @Override
        public final Builder userNamesToRemove(Collection<String> userNamesToRemove) {
            this.userNamesToRemove = UserNameListInputCopier.copy(userNamesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userNamesToRemove(String... userNamesToRemove) {
            userNamesToRemove(Arrays.asList(userNamesToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAclRequest build() {
            return new UpdateAclRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
