/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Access Control List. You can authenticate users with Access Contol Lists. ACLs enable you to control cluster
 * access by grouping users. These Access control lists are designed as a way to organize access to clusters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ACL implements SdkPojo, Serializable, ToCopyableBuilder<ACL.Builder, ACL> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ACL::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ACL::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> USER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserNames")
            .getter(getter(ACL::userNames))
            .setter(setter(Builder::userNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MINIMUM_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinimumEngineVersion").getter(getter(ACL::minimumEngineVersion))
            .setter(setter(Builder::minimumEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumEngineVersion").build())
            .build();

    private static final SdkField<ACLPendingChanges> PENDING_CHANGES_FIELD = SdkField
            .<ACLPendingChanges> builder(MarshallingType.SDK_POJO).memberName("PendingChanges")
            .getter(getter(ACL::pendingChanges)).setter(setter(Builder::pendingChanges)).constructor(ACLPendingChanges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingChanges").build()).build();

    private static final SdkField<List<String>> CLUSTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Clusters")
            .getter(getter(ACL::clusters))
            .setter(setter(Builder::clusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Clusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(ACL::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            USER_NAMES_FIELD, MINIMUM_ENGINE_VERSION_FIELD, PENDING_CHANGES_FIELD, CLUSTERS_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final List<String> userNames;

    private final String minimumEngineVersion;

    private final ACLPendingChanges pendingChanges;

    private final List<String> clusters;

    private final String arn;

    private ACL(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.userNames = builder.userNames;
        this.minimumEngineVersion = builder.minimumEngineVersion;
        this.pendingChanges = builder.pendingChanges;
        this.clusters = builder.clusters;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The name of the Access Control List
     * </p>
     * 
     * @return The name of the Access Control List
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Indicates ACL status. Can be "creating", "active", "modifying", "deleting".
     * </p>
     * 
     * @return Indicates ACL status. Can be "creating", "active", "modifying", "deleting".
     */
    public final String status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserNames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUserNames() {
        return userNames != null && !(userNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user names that belong to the ACL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserNames} method.
     * </p>
     * 
     * @return The list of user names that belong to the ACL.
     */
    public final List<String> userNames() {
        return userNames;
    }

    /**
     * <p>
     * The minimum engine version supported for the ACL
     * </p>
     * 
     * @return The minimum engine version supported for the ACL
     */
    public final String minimumEngineVersion() {
        return minimumEngineVersion;
    }

    /**
     * <p>
     * A list of updates being applied to the ACL.
     * </p>
     * 
     * @return A list of updates being applied to the ACL.
     */
    public final ACLPendingChanges pendingChanges() {
        return pendingChanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the Clusters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClusters() {
        return clusters != null && !(clusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of clusters associated with the ACL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusters} method.
     * </p>
     * 
     * @return A list of clusters associated with the ACL.
     */
    public final List<String> clusters() {
        return clusters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ACL
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ACL
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserNames() ? userNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minimumEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(pendingChanges());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusters() ? clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ACL)) {
            return false;
        }
        ACL other = (ACL) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(status(), other.status())
                && hasUserNames() == other.hasUserNames() && Objects.equals(userNames(), other.userNames())
                && Objects.equals(minimumEngineVersion(), other.minimumEngineVersion())
                && Objects.equals(pendingChanges(), other.pendingChanges()) && hasClusters() == other.hasClusters()
                && Objects.equals(clusters(), other.clusters()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ACL").add("Name", name()).add("Status", status())
                .add("UserNames", hasUserNames() ? userNames() : null).add("MinimumEngineVersion", minimumEngineVersion())
                .add("PendingChanges", pendingChanges()).add("Clusters", hasClusters() ? clusters() : null).add("ARN", arn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "UserNames":
            return Optional.ofNullable(clazz.cast(userNames()));
        case "MinimumEngineVersion":
            return Optional.ofNullable(clazz.cast(minimumEngineVersion()));
        case "PendingChanges":
            return Optional.ofNullable(clazz.cast(pendingChanges()));
        case "Clusters":
            return Optional.ofNullable(clazz.cast(clusters()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("UserNames", USER_NAMES_FIELD);
        map.put("MinimumEngineVersion", MINIMUM_ENGINE_VERSION_FIELD);
        map.put("PendingChanges", PENDING_CHANGES_FIELD);
        map.put("Clusters", CLUSTERS_FIELD);
        map.put("ARN", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ACL, T> g) {
        return obj -> g.apply((ACL) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ACL> {
        /**
         * <p>
         * The name of the Access Control List
         * </p>
         * 
         * @param name
         *        The name of the Access Control List
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates ACL status. Can be "creating", "active", "modifying", "deleting".
         * </p>
         * 
         * @param status
         *        Indicates ACL status. Can be "creating", "active", "modifying", "deleting".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The list of user names that belong to the ACL.
         * </p>
         * 
         * @param userNames
         *        The list of user names that belong to the ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNames(Collection<String> userNames);

        /**
         * <p>
         * The list of user names that belong to the ACL.
         * </p>
         * 
         * @param userNames
         *        The list of user names that belong to the ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNames(String... userNames);

        /**
         * <p>
         * The minimum engine version supported for the ACL
         * </p>
         * 
         * @param minimumEngineVersion
         *        The minimum engine version supported for the ACL
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumEngineVersion(String minimumEngineVersion);

        /**
         * <p>
         * A list of updates being applied to the ACL.
         * </p>
         * 
         * @param pendingChanges
         *        A list of updates being applied to the ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingChanges(ACLPendingChanges pendingChanges);

        /**
         * <p>
         * A list of updates being applied to the ACL.
         * </p>
         * This is a convenience method that creates an instance of the {@link ACLPendingChanges.Builder} avoiding the
         * need to create one manually via {@link ACLPendingChanges#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ACLPendingChanges.Builder#build()} is called immediately and its
         * result is passed to {@link #pendingChanges(ACLPendingChanges)}.
         * 
         * @param pendingChanges
         *        a consumer that will call methods on {@link ACLPendingChanges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingChanges(ACLPendingChanges)
         */
        default Builder pendingChanges(Consumer<ACLPendingChanges.Builder> pendingChanges) {
            return pendingChanges(ACLPendingChanges.builder().applyMutation(pendingChanges).build());
        }

        /**
         * <p>
         * A list of clusters associated with the ACL.
         * </p>
         * 
         * @param clusters
         *        A list of clusters associated with the ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Collection<String> clusters);

        /**
         * <p>
         * A list of clusters associated with the ACL.
         * </p>
         * 
         * @param clusters
         *        A list of clusters associated with the ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(String... clusters);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ACL
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the ACL
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private List<String> userNames = DefaultSdkAutoConstructList.getInstance();

        private String minimumEngineVersion;

        private ACLPendingChanges pendingChanges;

        private List<String> clusters = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ACL model) {
            name(model.name);
            status(model.status);
            userNames(model.userNames);
            minimumEngineVersion(model.minimumEngineVersion);
            pendingChanges(model.pendingChanges);
            clusters(model.clusters);
            arn(model.arn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Collection<String> getUserNames() {
            if (userNames instanceof SdkAutoConstructList) {
                return null;
            }
            return userNames;
        }

        public final void setUserNames(Collection<String> userNames) {
            this.userNames = UserNameListCopier.copy(userNames);
        }

        @Override
        public final Builder userNames(Collection<String> userNames) {
            this.userNames = UserNameListCopier.copy(userNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userNames(String... userNames) {
            userNames(Arrays.asList(userNames));
            return this;
        }

        public final String getMinimumEngineVersion() {
            return minimumEngineVersion;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public final ACLPendingChanges.Builder getPendingChanges() {
            return pendingChanges != null ? pendingChanges.toBuilder() : null;
        }

        public final void setPendingChanges(ACLPendingChanges.BuilderImpl pendingChanges) {
            this.pendingChanges = pendingChanges != null ? pendingChanges.build() : null;
        }

        @Override
        public final Builder pendingChanges(ACLPendingChanges pendingChanges) {
            this.pendingChanges = pendingChanges;
            return this;
        }

        public final Collection<String> getClusters() {
            if (clusters instanceof SdkAutoConstructList) {
                return null;
            }
            return clusters;
        }

        public final void setClusters(Collection<String> clusters) {
            this.clusters = ACLClusterNameListCopier.copy(clusters);
        }

        @Override
        public final Builder clusters(Collection<String> clusters) {
            this.clusters = ACLClusterNameListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(String... clusters) {
            clusters(Arrays.asList(clusters));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public ACL build() {
            return new ACL(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
