/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeParameterGroupsResponse extends MemoryDbResponse implements
        ToCopyableBuilder<DescribeParameterGroupsResponse.Builder, DescribeParameterGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeParameterGroupsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ParameterGroup>> PARAMETER_GROUPS_FIELD = SdkField
            .<List<ParameterGroup>> builder(MarshallingType.LIST)
            .memberName("ParameterGroups")
            .getter(getter(DescribeParameterGroupsResponse::parameterGroups))
            .setter(setter(Builder::parameterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PARAMETER_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ParameterGroup> parameterGroups;

    private DescribeParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.parameterGroups = builder.parameterGroups;
    }

    /**
     * <p>
     * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is
     * returned, there are more results available. The value of nextToken is a unique pagination token for each page.
     * Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
     * </p>
     * 
     * @return An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
     *         nextToken is returned, there are more results available. The value of nextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page. Keep all
     *         other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterGroups() {
        return parameterGroups != null && !(parameterGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameter groups. Each element in the list contains detailed information about one parameter group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterGroups} method.
     * </p>
     * 
     * @return A list of parameter groups. Each element in the list contains detailed information about one parameter
     *         group.
     */
    public final List<ParameterGroup> parameterGroups() {
        return parameterGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterGroups() ? parameterGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParameterGroupsResponse)) {
            return false;
        }
        DescribeParameterGroupsResponse other = (DescribeParameterGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasParameterGroups() == other.hasParameterGroups()
                && Objects.equals(parameterGroups(), other.parameterGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeParameterGroupsResponse").add("NextToken", nextToken())
                .add("ParameterGroups", hasParameterGroups() ? parameterGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ParameterGroups":
            return Optional.ofNullable(clazz.cast(parameterGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ParameterGroups", PARAMETER_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeParameterGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeParameterGroupsResponse> {
        /**
         * <p>
         * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
         * nextToken is returned, there are more results available. The value of nextToken is a unique pagination token
         * for each page. Make the call again using the returned token to retrieve the next page. Keep all other
         * arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
         *        nextToken is returned, there are more results available. The value of nextToken is a unique pagination
         *        token for each page. Make the call again using the returned token to retrieve the next page. Keep all
         *        other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of parameter groups. Each element in the list contains detailed information about one parameter group.
         * </p>
         * 
         * @param parameterGroups
         *        A list of parameter groups. Each element in the list contains detailed information about one parameter
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroups(Collection<ParameterGroup> parameterGroups);

        /**
         * <p>
         * A list of parameter groups. Each element in the list contains detailed information about one parameter group.
         * </p>
         * 
         * @param parameterGroups
         *        A list of parameter groups. Each element in the list contains detailed information about one parameter
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroups(ParameterGroup... parameterGroups);

        /**
         * <p>
         * A list of parameter groups. Each element in the list contains detailed information about one parameter group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.ParameterGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.memorydb.model.ParameterGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.ParameterGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #parameterGroups(List<ParameterGroup>)}.
         * 
         * @param parameterGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.ParameterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterGroups(java.util.Collection<ParameterGroup>)
         */
        Builder parameterGroups(Consumer<ParameterGroup.Builder>... parameterGroups);
    }

    static final class BuilderImpl extends MemoryDbResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ParameterGroup> parameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParameterGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            parameterGroups(model.parameterGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ParameterGroup.Builder> getParameterGroups() {
            List<ParameterGroup.Builder> result = ParameterGroupListCopier.copyToBuilder(this.parameterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterGroups(Collection<ParameterGroup.BuilderImpl> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copyFromBuilder(parameterGroups);
        }

        @Override
        public final Builder parameterGroups(Collection<ParameterGroup> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copy(parameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(ParameterGroup... parameterGroups) {
            parameterGroups(Arrays.asList(parameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(Consumer<ParameterGroup.Builder>... parameterGroups) {
            parameterGroups(Stream.of(parameterGroups).map(c -> ParameterGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeParameterGroupsResponse build() {
            return new DescribeParameterGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
