/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a copy of an entire cluster as of the time when the snapshot was taken.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Snapshot implements SdkPojo, Serializable, ToCopyableBuilder<Snapshot.Builder, Snapshot> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Snapshot::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Snapshot::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(Snapshot::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(Snapshot::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(Snapshot::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<ClusterConfiguration> CLUSTER_CONFIGURATION_FIELD = SdkField
            .<ClusterConfiguration> builder(MarshallingType.SDK_POJO).memberName("ClusterConfiguration")
            .getter(getter(Snapshot::clusterConfiguration)).setter(setter(Builder::clusterConfiguration))
            .constructor(ClusterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterConfiguration").build())
            .build();

    private static final SdkField<String> DATA_TIERING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTiering").getter(getter(Snapshot::dataTieringAsString)).setter(setter(Builder::dataTiering))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTiering").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            SOURCE_FIELD, KMS_KEY_ID_FIELD, ARN_FIELD, CLUSTER_CONFIGURATION_FIELD, DATA_TIERING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final String source;

    private final String kmsKeyId;

    private final String arn;

    private final ClusterConfiguration clusterConfiguration;

    private final String dataTiering;

    private Snapshot(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.source = builder.source;
        this.kmsKeyId = builder.kmsKeyId;
        this.arn = builder.arn;
        this.clusterConfiguration = builder.clusterConfiguration;
        this.dataTiering = builder.dataTiering;
    }

    /**
     * <p>
     * The name of the snapshot
     * </p>
     * 
     * @return The name of the snapshot
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.
     * </p>
     * 
     * @return The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Indicates whether the snapshot is from an automatic backup (automated) or was created manually (manual).
     * </p>
     * 
     * @return Indicates whether the snapshot is from an automatic backup (automated) or was created manually (manual).
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt the snapshot.
     * </p>
     * 
     * @return The ID of the KMS key used to encrypt the snapshot.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the snapshot.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the snapshot.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The configuration of the cluster from which the snapshot was taken
     * </p>
     * 
     * @return The configuration of the cluster from which the snapshot was taken
     */
    public final ClusterConfiguration clusterConfiguration() {
        return clusterConfiguration;
    }

    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must
     * be set when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataTiering} will
     * return {@link DataTieringStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTieringAsString}.
     * </p>
     * 
     * @return Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This
     *         parameter must be set when using r6gd nodes. For more information, see <a
     *         href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
     * @see DataTieringStatus
     */
    public final DataTieringStatus dataTiering() {
        return DataTieringStatus.fromValue(dataTiering);
    }

    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must
     * be set when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataTiering} will
     * return {@link DataTieringStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTieringAsString}.
     * </p>
     * 
     * @return Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This
     *         parameter must be set when using r6gd nodes. For more information, see <a
     *         href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
     * @see DataTieringStatus
     */
    public final String dataTieringAsString() {
        return dataTiering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataTieringAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(status(), other.status())
                && Objects.equals(source(), other.source()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(arn(), other.arn()) && Objects.equals(clusterConfiguration(), other.clusterConfiguration())
                && Objects.equals(dataTieringAsString(), other.dataTieringAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Snapshot").add("Name", name()).add("Status", status()).add("Source", source())
                .add("KmsKeyId", kmsKeyId()).add("ARN", arn()).add("ClusterConfiguration", clusterConfiguration())
                .add("DataTiering", dataTieringAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ClusterConfiguration":
            return Optional.ofNullable(clazz.cast(clusterConfiguration()));
        case "DataTiering":
            return Optional.ofNullable(clazz.cast(dataTieringAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("ClusterConfiguration", CLUSTER_CONFIGURATION_FIELD);
        map.put("DataTiering", DATA_TIERING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Snapshot, T> g) {
        return obj -> g.apply((Snapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Snapshot> {
        /**
         * <p>
         * The name of the snapshot
         * </p>
         * 
         * @param name
         *        The name of the snapshot
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.
         * </p>
         * 
         * @param status
         *        The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates whether the snapshot is from an automatic backup (automated) or was created manually (manual).
         * </p>
         * 
         * @param source
         *        Indicates whether the snapshot is from an automatic backup (automated) or was created manually
         *        (manual).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The ID of the KMS key used to encrypt the snapshot.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the KMS key used to encrypt the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the snapshot.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The configuration of the cluster from which the snapshot was taken
         * </p>
         * 
         * @param clusterConfiguration
         *        The configuration of the cluster from which the snapshot was taken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterConfiguration(ClusterConfiguration clusterConfiguration);

        /**
         * <p>
         * The configuration of the cluster from which the snapshot was taken
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterConfiguration.Builder} avoiding
         * the need to create one manually via {@link ClusterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #clusterConfiguration(ClusterConfiguration)}.
         * 
         * @param clusterConfiguration
         *        a consumer that will call methods on {@link ClusterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterConfiguration(ClusterConfiguration)
         */
        default Builder clusterConfiguration(Consumer<ClusterConfiguration.Builder> clusterConfiguration) {
            return clusterConfiguration(ClusterConfiguration.builder().applyMutation(clusterConfiguration).build());
        }

        /**
         * <p>
         * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter
         * must be set when using r6gd nodes. For more information, see <a
         * href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
         * </p>
         * 
         * @param dataTiering
         *        Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This
         *        parameter must be set when using r6gd nodes. For more information, see <a
         *        href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
         * @see DataTieringStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTieringStatus
         */
        Builder dataTiering(String dataTiering);

        /**
         * <p>
         * Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter
         * must be set when using r6gd nodes. For more information, see <a
         * href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
         * </p>
         * 
         * @param dataTiering
         *        Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This
         *        parameter must be set when using r6gd nodes. For more information, see <a
         *        href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.
         * @see DataTieringStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTieringStatus
         */
        Builder dataTiering(DataTieringStatus dataTiering);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private String source;

        private String kmsKeyId;

        private String arn;

        private ClusterConfiguration clusterConfiguration;

        private String dataTiering;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            name(model.name);
            status(model.status);
            source(model.source);
            kmsKeyId(model.kmsKeyId);
            arn(model.arn);
            clusterConfiguration(model.clusterConfiguration);
            dataTiering(model.dataTiering);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ClusterConfiguration.Builder getClusterConfiguration() {
            return clusterConfiguration != null ? clusterConfiguration.toBuilder() : null;
        }

        public final void setClusterConfiguration(ClusterConfiguration.BuilderImpl clusterConfiguration) {
            this.clusterConfiguration = clusterConfiguration != null ? clusterConfiguration.build() : null;
        }

        @Override
        public final Builder clusterConfiguration(ClusterConfiguration clusterConfiguration) {
            this.clusterConfiguration = clusterConfiguration;
            return this;
        }

        public final String getDataTiering() {
            return dataTiering;
        }

        public final void setDataTiering(String dataTiering) {
            this.dataTiering = dataTiering;
        }

        @Override
        public final Builder dataTiering(String dataTiering) {
            this.dataTiering = dataTiering;
            return this;
        }

        @Override
        public final Builder dataTiering(DataTieringStatus dataTiering) {
            this.dataTiering(dataTiering == null ? null : dataTiering.toString());
            return this;
        }

        @Override
        public Snapshot build() {
            return new Snapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
