/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Update action that has yet to be processed for the corresponding apply/stop request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingModifiedServiceUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingModifiedServiceUpdate.Builder, PendingModifiedServiceUpdate> {
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceUpdateName").getter(getter(PendingModifiedServiceUpdate::serviceUpdateName))
            .setter(setter(Builder::serviceUpdateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PendingModifiedServiceUpdate::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_UPDATE_NAME_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceUpdateName;

    private final String status;

    private PendingModifiedServiceUpdate(BuilderImpl builder) {
        this.serviceUpdateName = builder.serviceUpdateName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique ID of the service update
     * </p>
     * 
     * @return The unique ID of the service update
     */
    public final String serviceUpdateName() {
        return serviceUpdateName;
    }

    /**
     * <p>
     * The status of the service update
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service update
     * @see ServiceUpdateStatus
     */
    public final ServiceUpdateStatus status() {
        return ServiceUpdateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the service update
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service update
     * @see ServiceUpdateStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingModifiedServiceUpdate)) {
            return false;
        }
        PendingModifiedServiceUpdate other = (PendingModifiedServiceUpdate) obj;
        return Objects.equals(serviceUpdateName(), other.serviceUpdateName())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PendingModifiedServiceUpdate").add("ServiceUpdateName", serviceUpdateName())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceUpdateName":
            return Optional.ofNullable(clazz.cast(serviceUpdateName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceUpdateName", SERVICE_UPDATE_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PendingModifiedServiceUpdate, T> g) {
        return obj -> g.apply((PendingModifiedServiceUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingModifiedServiceUpdate> {
        /**
         * <p>
         * The unique ID of the service update
         * </p>
         * 
         * @param serviceUpdateName
         *        The unique ID of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateName(String serviceUpdateName);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param status
         *        The status of the service update
         * @see ServiceUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceUpdateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param status
         *        The status of the service update
         * @see ServiceUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceUpdateStatus
         */
        Builder status(ServiceUpdateStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String serviceUpdateName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingModifiedServiceUpdate model) {
            serviceUpdateName(model.serviceUpdateName);
            status(model.status);
        }

        public final String getServiceUpdateName() {
            return serviceUpdateName;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceUpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public PendingModifiedServiceUpdate build() {
            return new PendingModifiedServiceUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
