/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteMultiRegionClusterResponse extends MemoryDbResponse implements
        ToCopyableBuilder<DeleteMultiRegionClusterResponse.Builder, DeleteMultiRegionClusterResponse> {
    private static final SdkField<MultiRegionCluster> MULTI_REGION_CLUSTER_FIELD = SdkField
            .<MultiRegionCluster> builder(MarshallingType.SDK_POJO).memberName("MultiRegionCluster")
            .getter(getter(DeleteMultiRegionClusterResponse::multiRegionCluster)).setter(setter(Builder::multiRegionCluster))
            .constructor(MultiRegionCluster::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionCluster").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTI_REGION_CLUSTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MultiRegionCluster multiRegionCluster;

    private DeleteMultiRegionClusterResponse(BuilderImpl builder) {
        super(builder);
        this.multiRegionCluster = builder.multiRegionCluster;
    }

    /**
     * <p>
     * Details about the deleted multi-Region cluster.
     * </p>
     * 
     * @return Details about the deleted multi-Region cluster.
     */
    public final MultiRegionCluster multiRegionCluster() {
        return multiRegionCluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionCluster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMultiRegionClusterResponse)) {
            return false;
        }
        DeleteMultiRegionClusterResponse other = (DeleteMultiRegionClusterResponse) obj;
        return Objects.equals(multiRegionCluster(), other.multiRegionCluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteMultiRegionClusterResponse").add("MultiRegionCluster", multiRegionCluster()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiRegionCluster":
            return Optional.ofNullable(clazz.cast(multiRegionCluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MultiRegionCluster", MULTI_REGION_CLUSTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteMultiRegionClusterResponse, T> g) {
        return obj -> g.apply((DeleteMultiRegionClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteMultiRegionClusterResponse> {
        /**
         * <p>
         * Details about the deleted multi-Region cluster.
         * </p>
         * 
         * @param multiRegionCluster
         *        Details about the deleted multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionCluster(MultiRegionCluster multiRegionCluster);

        /**
         * <p>
         * Details about the deleted multi-Region cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link MultiRegionCluster.Builder} avoiding the
         * need to create one manually via {@link MultiRegionCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiRegionCluster.Builder#build()} is called immediately and its
         * result is passed to {@link #multiRegionCluster(MultiRegionCluster)}.
         * 
         * @param multiRegionCluster
         *        a consumer that will call methods on {@link MultiRegionCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiRegionCluster(MultiRegionCluster)
         */
        default Builder multiRegionCluster(Consumer<MultiRegionCluster.Builder> multiRegionCluster) {
            return multiRegionCluster(MultiRegionCluster.builder().applyMutation(multiRegionCluster).build());
        }
    }

    static final class BuilderImpl extends MemoryDbResponse.BuilderImpl implements Builder {
        private MultiRegionCluster multiRegionCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMultiRegionClusterResponse model) {
            super(model);
            multiRegionCluster(model.multiRegionCluster);
        }

        public final MultiRegionCluster.Builder getMultiRegionCluster() {
            return multiRegionCluster != null ? multiRegionCluster.toBuilder() : null;
        }

        public final void setMultiRegionCluster(MultiRegionCluster.BuilderImpl multiRegionCluster) {
            this.multiRegionCluster = multiRegionCluster != null ? multiRegionCluster.build() : null;
        }

        @Override
        public final Builder multiRegionCluster(MultiRegionCluster multiRegionCluster) {
            this.multiRegionCluster = multiRegionCluster;
            return this;
        }

        @Override
        public DeleteMultiRegionClusterResponse build() {
            return new DeleteMultiRegionClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
