/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEngineVersionsRequest extends MemoryDbRequest implements
        ToCopyableBuilder<DescribeEngineVersionsRequest.Builder, DescribeEngineVersionsRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DescribeEngineVersionsRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DescribeEngineVersionsRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupFamily").getter(getter(DescribeEngineVersionsRequest::parameterGroupFamily))
            .setter(setter(Builder::parameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupFamily").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeEngineVersionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEngineVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Boolean> DEFAULT_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultOnly").getter(getter(DescribeEngineVersionsRequest::defaultOnly))
            .setter(setter(Builder::defaultOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            ENGINE_VERSION_FIELD, PARAMETER_GROUP_FAMILY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, DEFAULT_ONLY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String engine;

    private final String engineVersion;

    private final String parameterGroupFamily;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean defaultOnly;

    private DescribeEngineVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.parameterGroupFamily = builder.parameterGroupFamily;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.defaultOnly = builder.defaultOnly;
    }

    /**
     * <p>
     * The name of the engine for which to list available versions.
     * </p>
     * 
     * @return The name of the engine for which to list available versions.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The Redis OSS engine version
     * </p>
     * 
     * @return The Redis OSS engine version
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of a specific parameter group family to return details for.
     * </p>
     * 
     * @return The name of a specific parameter group family to return details for.
     */
    public final String parameterGroupFamily() {
        return parameterGroupFamily;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified MaxResults
     * value, a token is included in the response so that the remaining results can be retrieved.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         MaxResults value, a token is included in the response so that the remaining results can be retrieved.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is
     * returned, there are more results available. The value of nextToken is a unique pagination token for each page.
     * Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
     * </p>
     * 
     * @return An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
     *         nextToken is returned, there are more results available. The value of nextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page. Keep all
     *         other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * If true, specifies that only the default version of the specified engine or engine and major version combination
     * is to be returned.
     * </p>
     * 
     * @return If true, specifies that only the default version of the specified engine or engine and major version
     *         combination is to be returned.
     */
    public final Boolean defaultOnly() {
        return defaultOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEngineVersionsRequest)) {
            return false;
        }
        DescribeEngineVersionsRequest other = (DescribeEngineVersionsRequest) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(parameterGroupFamily(), other.parameterGroupFamily())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(defaultOnly(), other.defaultOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEngineVersionsRequest").add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("ParameterGroupFamily", parameterGroupFamily()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("DefaultOnly", defaultOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "ParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(parameterGroupFamily()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DefaultOnly":
            return Optional.ofNullable(clazz.cast(defaultOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("ParameterGroupFamily", PARAMETER_GROUP_FAMILY_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DefaultOnly", DEFAULT_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEngineVersionsRequest, T> g) {
        return obj -> g.apply((DescribeEngineVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MemoryDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEngineVersionsRequest> {
        /**
         * <p>
         * The name of the engine for which to list available versions.
         * </p>
         * 
         * @param engine
         *        The name of the engine for which to list available versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The Redis OSS engine version
         * </p>
         * 
         * @param engineVersion
         *        The Redis OSS engine version
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of a specific parameter group family to return details for.
         * </p>
         * 
         * @param parameterGroupFamily
         *        The name of a specific parameter group family to return details for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupFamily(String parameterGroupFamily);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified MaxResults
         * value, a token is included in the response so that the remaining results can be retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        MaxResults value, a token is included in the response so that the remaining results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
         * nextToken is returned, there are more results available. The value of nextToken is a unique pagination token
         * for each page. Make the call again using the returned token to retrieve the next page. Keep all other
         * arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        An optional argument to pass in case the total number of records exceeds the value of MaxResults. If
         *        nextToken is returned, there are more results available. The value of nextToken is a unique pagination
         *        token for each page. Make the call again using the returned token to retrieve the next page. Keep all
         *        other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * If true, specifies that only the default version of the specified engine or engine and major version
         * combination is to be returned.
         * </p>
         * 
         * @param defaultOnly
         *        If true, specifies that only the default version of the specified engine or engine and major version
         *        combination is to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOnly(Boolean defaultOnly);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MemoryDbRequest.BuilderImpl implements Builder {
        private String engine;

        private String engineVersion;

        private String parameterGroupFamily;

        private Integer maxResults;

        private String nextToken;

        private Boolean defaultOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEngineVersionsRequest model) {
            super(model);
            engine(model.engine);
            engineVersion(model.engineVersion);
            parameterGroupFamily(model.parameterGroupFamily);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            defaultOnly(model.defaultOnly);
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getParameterGroupFamily() {
            return parameterGroupFamily;
        }

        public final void setParameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
        }

        @Override
        public final Builder parameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getDefaultOnly() {
            return defaultOnly;
        }

        public final void setDefaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
        }

        @Override
        public final Builder defaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEngineVersionsRequest build() {
            return new DescribeEngineVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
