/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to configure the number of replicas in a shard
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaConfigurationRequest.Builder, ReplicaConfigurationRequest> {
    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReplicaCount").getter(getter(ReplicaConfigurationRequest::replicaCount))
            .setter(setter(Builder::replicaCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICA_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer replicaCount;

    private ReplicaConfigurationRequest(BuilderImpl builder) {
        this.replicaCount = builder.replicaCount;
    }

    /**
     * <p>
     * The number of replicas to scale up or down to
     * </p>
     * 
     * @return The number of replicas to scale up or down to
     */
    public final Integer replicaCount() {
        return replicaCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicaCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaConfigurationRequest)) {
            return false;
        }
        ReplicaConfigurationRequest other = (ReplicaConfigurationRequest) obj;
        return Objects.equals(replicaCount(), other.replicaCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicaConfigurationRequest").add("ReplicaCount", replicaCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicaCount":
            return Optional.ofNullable(clazz.cast(replicaCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicaCount", REPLICA_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicaConfigurationRequest, T> g) {
        return obj -> g.apply((ReplicaConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaConfigurationRequest> {
        /**
         * <p>
         * The number of replicas to scale up or down to
         * </p>
         * 
         * @param replicaCount
         *        The number of replicas to scale up or down to
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaCount(Integer replicaCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer replicaCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaConfigurationRequest model) {
            replicaCount(model.replicaCount);
        }

        public final Integer getReplicaCount() {
            return replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        @Override
        public ReplicaConfigurationRequest build() {
            return new ReplicaConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
