/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a multi-Region cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiRegionCluster implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiRegionCluster.Builder, MultiRegionCluster> {
    private static final SdkField<String> MULTI_REGION_CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MultiRegionClusterName").getter(getter(MultiRegionCluster::multiRegionClusterName))
            .setter(setter(Builder::multiRegionClusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusterName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(MultiRegionCluster::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MultiRegionCluster::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(MultiRegionCluster::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(MultiRegionCluster::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(MultiRegionCluster::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Integer> NUMBER_OF_SHARDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfShards").getter(getter(MultiRegionCluster::numberOfShards))
            .setter(setter(Builder::numberOfShards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfShards").build()).build();

    private static final SdkField<List<RegionalCluster>> CLUSTERS_FIELD = SdkField
            .<List<RegionalCluster>> builder(MarshallingType.LIST)
            .memberName("Clusters")
            .getter(getter(MultiRegionCluster::clusters))
            .setter(setter(Builder::clusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Clusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegionalCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegionalCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MULTI_REGION_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MultiRegionParameterGroupName")
            .getter(getter(MultiRegionCluster::multiRegionParameterGroupName))
            .setter(setter(Builder::multiRegionParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionParameterGroupName")
                    .build()).build();

    private static final SdkField<Boolean> TLS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TLSEnabled").getter(getter(MultiRegionCluster::tlsEnabled)).setter(setter(Builder::tlsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSEnabled").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(MultiRegionCluster::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MULTI_REGION_CLUSTER_NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, NODE_TYPE_FIELD, ENGINE_FIELD,
            ENGINE_VERSION_FIELD, NUMBER_OF_SHARDS_FIELD, CLUSTERS_FIELD, MULTI_REGION_PARAMETER_GROUP_NAME_FIELD,
            TLS_ENABLED_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String multiRegionClusterName;

    private final String description;

    private final String status;

    private final String nodeType;

    private final String engine;

    private final String engineVersion;

    private final Integer numberOfShards;

    private final List<RegionalCluster> clusters;

    private final String multiRegionParameterGroupName;

    private final Boolean tlsEnabled;

    private final String arn;

    private MultiRegionCluster(BuilderImpl builder) {
        this.multiRegionClusterName = builder.multiRegionClusterName;
        this.description = builder.description;
        this.status = builder.status;
        this.nodeType = builder.nodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.numberOfShards = builder.numberOfShards;
        this.clusters = builder.clusters;
        this.multiRegionParameterGroupName = builder.multiRegionParameterGroupName;
        this.tlsEnabled = builder.tlsEnabled;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The name of the multi-Region cluster.
     * </p>
     * 
     * @return The name of the multi-Region cluster.
     */
    public final String multiRegionClusterName() {
        return multiRegionClusterName;
    }

    /**
     * <p>
     * The description of the multi-Region cluster.
     * </p>
     * 
     * @return The description of the multi-Region cluster.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the multi-Region cluster.
     * </p>
     * 
     * @return The current status of the multi-Region cluster.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The node type used by the multi-Region cluster.
     * </p>
     * 
     * @return The node type used by the multi-Region cluster.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The name of the engine used by the multi-Region cluster.
     * </p>
     * 
     * @return The name of the engine used by the multi-Region cluster.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version of the engine used by the multi-Region cluster.
     * </p>
     * 
     * @return The version of the engine used by the multi-Region cluster.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The number of shards in the multi-Region cluster.
     * </p>
     * 
     * @return The number of shards in the multi-Region cluster.
     */
    public final Integer numberOfShards() {
        return numberOfShards;
    }

    /**
     * For responses, this returns true if the service returned a value for the Clusters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClusters() {
        return clusters != null && !(clusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The clusters in this multi-Region cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusters} method.
     * </p>
     * 
     * @return The clusters in this multi-Region cluster.
     */
    public final List<RegionalCluster> clusters() {
        return clusters;
    }

    /**
     * <p>
     * The name of the multi-Region parameter group associated with the cluster.
     * </p>
     * 
     * @return The name of the multi-Region parameter group associated with the cluster.
     */
    public final String multiRegionParameterGroupName() {
        return multiRegionParameterGroupName;
    }

    /**
     * <p>
     * Indiciates if the multi-Region cluster is TLS enabled.
     * </p>
     * 
     * @return Indiciates if the multi-Region cluster is TLS enabled.
     */
    public final Boolean tlsEnabled() {
        return tlsEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the multi-Region cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the multi-Region cluster.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionClusterName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfShards());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusters() ? clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(tlsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiRegionCluster)) {
            return false;
        }
        MultiRegionCluster other = (MultiRegionCluster) obj;
        return Objects.equals(multiRegionClusterName(), other.multiRegionClusterName())
                && Objects.equals(description(), other.description()) && Objects.equals(status(), other.status())
                && Objects.equals(nodeType(), other.nodeType()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(numberOfShards(), other.numberOfShards()) && hasClusters() == other.hasClusters()
                && Objects.equals(clusters(), other.clusters())
                && Objects.equals(multiRegionParameterGroupName(), other.multiRegionParameterGroupName())
                && Objects.equals(tlsEnabled(), other.tlsEnabled()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiRegionCluster").add("MultiRegionClusterName", multiRegionClusterName())
                .add("Description", description()).add("Status", status()).add("NodeType", nodeType()).add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("NumberOfShards", numberOfShards())
                .add("Clusters", hasClusters() ? clusters() : null)
                .add("MultiRegionParameterGroupName", multiRegionParameterGroupName()).add("TLSEnabled", tlsEnabled())
                .add("ARN", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiRegionClusterName":
            return Optional.ofNullable(clazz.cast(multiRegionClusterName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "NumberOfShards":
            return Optional.ofNullable(clazz.cast(numberOfShards()));
        case "Clusters":
            return Optional.ofNullable(clazz.cast(clusters()));
        case "MultiRegionParameterGroupName":
            return Optional.ofNullable(clazz.cast(multiRegionParameterGroupName()));
        case "TLSEnabled":
            return Optional.ofNullable(clazz.cast(tlsEnabled()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MultiRegionClusterName", MULTI_REGION_CLUSTER_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("NumberOfShards", NUMBER_OF_SHARDS_FIELD);
        map.put("Clusters", CLUSTERS_FIELD);
        map.put("MultiRegionParameterGroupName", MULTI_REGION_PARAMETER_GROUP_NAME_FIELD);
        map.put("TLSEnabled", TLS_ENABLED_FIELD);
        map.put("ARN", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiRegionCluster, T> g) {
        return obj -> g.apply((MultiRegionCluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiRegionCluster> {
        /**
         * <p>
         * The name of the multi-Region cluster.
         * </p>
         * 
         * @param multiRegionClusterName
         *        The name of the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionClusterName(String multiRegionClusterName);

        /**
         * <p>
         * The description of the multi-Region cluster.
         * </p>
         * 
         * @param description
         *        The description of the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the multi-Region cluster.
         * </p>
         * 
         * @param status
         *        The current status of the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The node type used by the multi-Region cluster.
         * </p>
         * 
         * @param nodeType
         *        The node type used by the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The name of the engine used by the multi-Region cluster.
         * </p>
         * 
         * @param engine
         *        The name of the engine used by the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version of the engine used by the multi-Region cluster.
         * </p>
         * 
         * @param engineVersion
         *        The version of the engine used by the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The number of shards in the multi-Region cluster.
         * </p>
         * 
         * @param numberOfShards
         *        The number of shards in the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfShards(Integer numberOfShards);

        /**
         * <p>
         * The clusters in this multi-Region cluster.
         * </p>
         * 
         * @param clusters
         *        The clusters in this multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Collection<RegionalCluster> clusters);

        /**
         * <p>
         * The clusters in this multi-Region cluster.
         * </p>
         * 
         * @param clusters
         *        The clusters in this multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(RegionalCluster... clusters);

        /**
         * <p>
         * The clusters in this multi-Region cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.memorydb.model.RegionalCluster.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.memorydb.model.RegionalCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.memorydb.model.RegionalCluster.Builder#build()} is called immediately
         * and its result is passed to {@link #clusters(List<RegionalCluster>)}.
         * 
         * @param clusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.memorydb.model.RegionalCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusters(java.util.Collection<RegionalCluster>)
         */
        Builder clusters(Consumer<RegionalCluster.Builder>... clusters);

        /**
         * <p>
         * The name of the multi-Region parameter group associated with the cluster.
         * </p>
         * 
         * @param multiRegionParameterGroupName
         *        The name of the multi-Region parameter group associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionParameterGroupName(String multiRegionParameterGroupName);

        /**
         * <p>
         * Indiciates if the multi-Region cluster is TLS enabled.
         * </p>
         * 
         * @param tlsEnabled
         *        Indiciates if the multi-Region cluster is TLS enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsEnabled(Boolean tlsEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the multi-Region cluster.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the multi-Region cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String multiRegionClusterName;

        private String description;

        private String status;

        private String nodeType;

        private String engine;

        private String engineVersion;

        private Integer numberOfShards;

        private List<RegionalCluster> clusters = DefaultSdkAutoConstructList.getInstance();

        private String multiRegionParameterGroupName;

        private Boolean tlsEnabled;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiRegionCluster model) {
            multiRegionClusterName(model.multiRegionClusterName);
            description(model.description);
            status(model.status);
            nodeType(model.nodeType);
            engine(model.engine);
            engineVersion(model.engineVersion);
            numberOfShards(model.numberOfShards);
            clusters(model.clusters);
            multiRegionParameterGroupName(model.multiRegionParameterGroupName);
            tlsEnabled(model.tlsEnabled);
            arn(model.arn);
        }

        public final String getMultiRegionClusterName() {
            return multiRegionClusterName;
        }

        public final void setMultiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
        }

        @Override
        public final Builder multiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getNumberOfShards() {
            return numberOfShards;
        }

        public final void setNumberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
        }

        @Override
        public final Builder numberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
            return this;
        }

        public final List<RegionalCluster.Builder> getClusters() {
            List<RegionalCluster.Builder> result = RegionalClusterListCopier.copyToBuilder(this.clusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusters(Collection<RegionalCluster.BuilderImpl> clusters) {
            this.clusters = RegionalClusterListCopier.copyFromBuilder(clusters);
        }

        @Override
        public final Builder clusters(Collection<RegionalCluster> clusters) {
            this.clusters = RegionalClusterListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(RegionalCluster... clusters) {
            clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Consumer<RegionalCluster.Builder>... clusters) {
            clusters(Stream.of(clusters).map(c -> RegionalCluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMultiRegionParameterGroupName() {
            return multiRegionParameterGroupName;
        }

        public final void setMultiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
        }

        @Override
        public final Builder multiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
            return this;
        }

        public final Boolean getTlsEnabled() {
            return tlsEnabled;
        }

        public final void setTlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
        }

        @Override
        public final Builder tlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public MultiRegionCluster build() {
            return new MultiRegionCluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
